/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.util.configuration.TemplateUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.oa4mp.delegation.server.OA2Scopes;

public class ScopeTemplateUtil {
    static Collection<String> basicScopes = OA2Scopes.ScopeUtil.getBasicScopes();

    public static Collection<String> doCompareTemplates(Collection<String> computedScopes, Collection<String> requestedScopes, boolean isQuery) {
        HashSet<String> returnedScopes = new HashSet<String>();
        for (String r : requestedScopes) {
            if (r.contains(",")) {
                throw new IllegalArgumentException("error: got embedded comma in scope \"" + r + "\"");
            }
            if (basicScopes.contains(r)) continue;
            for (String c : computedScopes) {
                if (r.equals(c)) {
                    returnedScopes.add(c);
                    continue;
                }
                String x = ScopeTemplateUtil.compareAsURI(r, c, isQuery);
                if (x == null) continue;
                returnedScopes.add(x);
            }
        }
        return returnedScopes;
    }

    public static String compareAsURI(String requestedScope, String computedScope, boolean isQuery) {
        try {
            StringTokenizer proposed;
            StringTokenizer base;
            URI r;
            if (!isQuery) {
                if (requestedScope.endsWith(":")) {
                    return null;
                }
                if (computedScope.endsWith(":")) {
                    if (requestedScope.startsWith(computedScope)) {
                        return requestedScope;
                    }
                    return null;
                }
            } else {
                if (requestedScope.endsWith(":")) {
                    if (computedScope.startsWith(requestedScope)) {
                        return computedScope;
                    }
                    return null;
                }
                if (computedScope.endsWith(":")) {
                    if (isQuery && requestedScope.startsWith(computedScope)) {
                        return requestedScope;
                    }
                    return null;
                }
            }
            if (!(r = URI.create(requestedScope)).isAbsolute() || r.getFragment() != null) {
                return null;
            }
            URI c = URI.create(computedScope);
            if (!c.isAbsolute() || c.getFragment() != null) {
                return null;
            }
            if (!r.getScheme().equals(c.getScheme())) {
                return null;
            }
            if (r.getPort() != c.getPort()) {
                return null;
            }
            if (r.getQuery() != null && !r.getQuery().equals(c.getQuery())) {
                return null;
            }
            if (!isQuery) {
                base = new StringTokenizer(c.getPath(), "/");
                proposed = new StringTokenizer(r.getPath(), "/");
            } else {
                base = new StringTokenizer(r.getPath(), "/");
                proposed = new StringTokenizer(c.getPath(), "/");
            }
            if (!isQuery && proposed.countTokens() < base.countTokens()) {
                return null;
            }
            while (base.hasMoreTokens()) {
                String b = base.nextToken();
                if (proposed.hasMoreTokens()) {
                    String p = proposed.nextToken();
                    if (b.equals(p)) continue;
                    return null;
                }
                if (!isQuery) continue;
                return requestedScope;
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (!isQuery) {
            return requestedScope;
        }
        return computedScope;
    }

    public static List<String> replaceTemplate(String currentTemplate, Map<String, List<String>> groups, Map claimsNoGroups) {
        ArrayList<String> result = new ArrayList<String>();
        if (groups.isEmpty()) {
            result.add(ScopeTemplateUtil.simpleReplacement(currentTemplate, claimsNoGroups));
            return result;
        }
        if (!(currentTemplate = TemplateUtil.replaceAll((String)currentTemplate, (Map)claimsNoGroups)).contains(TemplateUtil.LEFT_DELIMITER)) {
            result.add(currentTemplate);
            return result;
        }
        for (String key : groups.keySet()) {
            String claimKey = TemplateUtil.LEFT_DELIMITER + key + TemplateUtil.RIGHT_DELIMITER;
            List<String> groupNames = groups.get(key);
            if (!currentTemplate.contains(claimKey)) continue;
            for (String groupName : groupNames) {
                String newPath = currentTemplate.replace(claimKey, groupName);
                result.add(ScopeTemplateUtil.simpleReplacement(newPath, claimsNoGroups));
            }
        }
        return result;
    }

    protected static String simpleReplacement(String currentTemplate, Map claims) {
        return TemplateUtil.replaceAll((String)currentTemplate, (Map)claims);
    }
}

