/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.PayloadHandler;
import org.oa4mp.delegation.server.jwt.PayloadHandlerConfig;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.ServerQDLScriptHandlerConfig;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;

public class ServerQDLScriptHandler
implements PayloadHandler {
    ServerQDLScriptHandlerConfig cfg;
    List<ClaimSource> sources = new ArrayList<ClaimSource>();
    int responseCode = 0;

    public ServerQDLScriptHandler(ServerQDLScriptHandlerConfig config) {
        this.cfg = config;
    }

    public void init() throws Throwable {
    }

    public void refresh() throws Throwable {
    }

    public void addRequestState(ScriptRunRequest req) throws Throwable {
        JSONObject json;
        req.getArgs().put("claim_sources", this.getSources());
        req.getArgs().put("claims", this.getUserMetaData());
        req.getArgs().put("access_token", this.getAtData());
        req.getArgs().put("refresh_token", this.getRTData());
        if (this.getPhCfg().request != null && !(json = OA2HeaderUtils.headerToJSON((HttpServletRequest)this.getPhCfg().request, Arrays.asList("authorization", "cookie", "host"))).isEmpty()) {
            req.getArgs().put("auth_headers", json);
        }
    }

    public JSONObject getRTData() {
        return this.cfg.transaction.getRTData();
    }

    public void setRTData(JSONObject rtData) {
        this.cfg.transaction.setRTData(rtData);
    }

    public void checkClaims() throws Throwable {
    }

    public List<ClaimSource> getSources() throws Throwable {
        return this.cfg.transaction.getClaimSources(this.cfg.oa2SE);
    }

    public JSONObject execute(ClaimSource source, JSONObject claims) throws Throwable {
        if (!source.isEnabled()) {
            return claims;
        }
        if (!source.isEnabled()) {
            return claims;
        }
        if (source instanceof BasicClaimsSourceImpl) {
            ((BasicClaimsSourceImpl)source).setOa2SE(this.cfg.oa2SE);
        }
        if (this.cfg.request == null) {
            return source.process(claims, (ServiceTransaction)this.cfg.transaction);
        }
        return source.process(claims, this.cfg.request, (ServiceTransaction)this.cfg.transaction);
    }

    public void finish(String execPhase) throws Throwable {
    }

    public void saveState(String execPhase) throws Throwable {
    }

    public JSONObject getUserMetaData() {
        return this.cfg.transaction.getUserMetaData();
    }

    public void setClaims(JSONObject claims) {
        this.cfg.transaction.setUserMetaData(claims);
    }

    public JSONObject getExtendedAttributes() {
        return this.cfg.transaction.getExtendedAttributes();
    }

    public void setExtendedAttributes(JSONObject extendedAttributes) {
        this.cfg.transaction.setExtendedAttributes(extendedAttributes);
    }

    public void setAccountingInformation() {
    }

    public void refreshAccountingInformation() {
    }

    public ServerQDLScriptHandlerConfig getPhCfg() {
        return this.cfg;
    }

    public void setPhCfg(PayloadHandlerConfig phCfg) {
        this.cfg = (ServerQDLScriptHandlerConfig)phCfg;
    }

    public boolean hasScript() {
        return this.cfg.oa2SE.getQDLEnvironment().hasServerScripts();
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public JSONObject getAtData() {
        return this.cfg.transaction.getATData();
    }

    public void setAtData(JSONObject atData) {
        this.cfg.transaction.setATData(atData);
    }

    public void handleResponse(ScriptRunResponse resp) throws Throwable {
        this.responseCode = resp.getReturnCode();
        switch (resp.getReturnCode()) {
            case 1: {
                this.setClaims((JSONObject)resp.getReturnedValues().get("claims"));
                this.setAtData((JSONObject)resp.getReturnedValues().get("access_token"));
                this.setRTData((JSONObject)resp.getReturnedValues().get("refresh_token"));
                resp.getReturnedValues().get("claim_sources");
                return;
            }
            case 0: {
                return;
            }
        }
    }

    public JSONObject getPayload() {
        throw new NotImplementedException("No single payload in QDL Script Handler");
    }

    public void setPayload(JSONObject payload) {
        throw new NotImplementedException("No single payload in QDL Script Handler");
    }

    public TokenImpl getSignedPayload(JSONWebKey key) {
        throw new NotImplementedException("No single payload in QDL Script Handler");
    }

    public TokenImpl getSignedPayload(JSONWebKey key, String headerType) {
        throw new NotImplementedException("No single payload in QDL Script Handler");
    }
}

