/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm;

import edu.uiuc.ncsa.security.core.Identifier;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.oauth2.cm.CMConfig;

public class CM7591Config
extends CMConfig {
    public Identifier template = null;
    public boolean anonymousOK = false;
    public boolean autoApprove = false;
    public String autoApproverName = "auto-approved";
    List<String> allowedAnonymousDomains = new ArrayList<String>();
    List<String> allowedAutoApproveDomains = new ArrayList<String>();

    public CM7591Config() {
    }

    public CM7591Config(String protocol, URI uri, boolean enabled, Identifier template, boolean anonymousOK, boolean autoApprove) {
        super(protocol, uri, enabled);
        this.template = template;
        this.anonymousOK = anonymousOK;
        this.autoApprove = autoApprove;
    }

    @Override
    public String toString() {
        return "CM7591Config{protocol='" + this.protocol + "', uri=" + String.valueOf(this.uri) + ", enabled=" + this.enabled + ", isConfigured=" + this.isConfigured + ", template=" + String.valueOf(this.template) + ", anonymousOK=" + this.anonymousOK + ", autoApprove=" + this.autoApprove + ", autoApproverName=" + this.autoApproverName + "}";
    }

    public List<String> getAllowedAnonymousDomains() {
        return this.allowedAnonymousDomains;
    }

    public void setAllowedAnonymousDomains(List<String> allowedAnonymousDomains) {
        this.allowedAnonymousDomains = allowedAnonymousDomains;
    }

    public List<String> getAllowedAutoApproveDomains() {
        return this.allowedAutoApproveDomains;
    }

    public void setAllowedAutoApproveDomains(List<String> allowedAutoApproveDomains) {
        this.allowedAutoApproveDomains = allowedAutoApproveDomains;
    }

    public boolean checkAnonymousDomain(String host) throws UnknownHostException {
        if (this.anonymousOK) {
            return this.checkAllowedDomain(this.getAllowedAnonymousDomains(), host);
        }
        return false;
    }

    public boolean checkAutoApproveDomain(String host) throws UnknownHostException {
        if (this.autoApprove) {
            return this.checkAllowedDomain(this.getAllowedAutoApproveDomains(), host);
        }
        return false;
    }

    protected boolean checkAllowedDomain(List<String> allowedDomains, String host) throws UnknownHostException {
        if (allowedDomains.contains("*")) {
            return true;
        }
        boolean gotOne = false;
        for (String x : allowedDomains) {
            InetAddress xxx = InetAddress.getByName(x);
            if (!xxx.getHostAddress().equals(host)) continue;
            return true;
        }
        return false;
    }
}

