/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.net.URI;
import java.util.HashMap;
import org.oa4mp.server.loader.oauth2.cm.CM7591Config;
import org.oa4mp.server.loader.oauth2.cm.CMConfig;
import org.oa4mp.server.loader.oauth2.cm.ClientManagementConstants;

public class CMConfigs
extends HashMap<String, CMConfig>
implements ClientManagementConstants {
    boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CMConfig put(CMConfig cmEntry) {
        return this.put(cmEntry.protocol, cmEntry);
    }

    protected static CMConfig createConfigEntry(String protocol, String serverAddress, String endpoint, String rawURI, String enabled) {
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalArgumentException("Error: missing protocol");
        }
        if ((rawURI == null || rawURI.isEmpty()) && (serverAddress == null || serverAddress.isEmpty())) {
            throw new IllegalArgumentException("Error: Missing server address and registration address.");
        }
        URI uri = CMConfigs.createURIFromProtocol(protocol, serverAddress, endpoint, rawURI);
        boolean isEnabled = true;
        try {
            isEnabled = Boolean.parseBoolean(enabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CMConfig cmConfig = new CMConfig(protocol, uri, isEnabled);
        cmConfig.setEndpoint(endpoint);
        return cmConfig;
    }

    public static CMConfig createConfigEntry(String protocol, String serverAddress, String endpoint, String rawURI, String enabled, String templateIdentifier, String rawAnonymousOK, String rawAutoApprove, String rawAutoApproverName) {
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalArgumentException("Error: missing protocol");
        }
        switch (protocol) {
            case "rfc7591": {
                return CMConfigs.create7591ConfigEntry(protocol, serverAddress, endpoint, rawURI, enabled, templateIdentifier, rawAnonymousOK, rawAutoApprove, rawAutoApproverName);
            }
            case "rfc7592": 
            case "oa4mp": {
                if (!(StringUtils.isTrivial((String)templateIdentifier) && StringUtils.isTrivial((String)rawAutoApprove) && StringUtils.isTrivial((String)rawAnonymousOK))) {
                    throw new IllegalArgumentException("Error: unsupported attributes for protocol \"" + protocol + "\"");
                }
                return CMConfigs.createConfigEntry(protocol, serverAddress, endpoint, rawURI, enabled);
            }
        }
        throw new IllegalArgumentException("Error: unknown protocol");
    }

    protected static CM7591Config create7591ConfigEntry(String protocol, String serverAddress, String endpoint, String rawURI, String enabled, String templateIdentifier, String rawAnonymousOK, String rawAutoApprove, String rawAutoApproverName) {
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalArgumentException("Error: missing protocol");
        }
        if ((rawURI == null || rawURI.isEmpty()) && (serverAddress == null || serverAddress.isEmpty())) {
            throw new IllegalArgumentException("Error: Missing server address and registration address.");
        }
        URI uri = CMConfigs.createURIFromProtocol(protocol, serverAddress, endpoint, rawURI);
        boolean isEnabled = true;
        try {
            isEnabled = Boolean.parseBoolean(enabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean autoApprove = false;
        try {
            autoApprove = Boolean.parseBoolean(rawAutoApprove);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean anonymousOK = false;
        try {
            anonymousOK = Boolean.parseBoolean(rawAnonymousOK);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Identifier template = null;
        if (!StringUtils.isTrivial((String)templateIdentifier)) {
            template = BasicIdentifier.newID((String)templateIdentifier);
        }
        CM7591Config config = new CM7591Config(protocol, uri, isEnabled, template, anonymousOK, autoApprove);
        if (!StringUtils.isTrivial((String)rawAutoApproverName)) {
            config.autoApproverName = rawAutoApproverName;
        }
        config.setEndpoint(endpoint);
        return config;
    }

    protected static URI createURIFromProtocol(String protocol, String rawAddress, String endpoint, String rawURI) {
        boolean addSlash;
        boolean bl = addSlash = !rawAddress.endsWith("/");
        if (rawURI == null || rawURI.isEmpty()) {
            if (endpoint == null || endpoint.isEmpty()) {
                if (protocol.equals("oa4mp")) {
                    return URI.create(rawAddress + (addSlash ? "/" : "") + "clients");
                }
                if (protocol.equals("rfc7591") || protocol.equals("rfc7592")) {
                    return URI.create(rawAddress + (addSlash ? "/" : "") + "oidc-cm");
                }
                throw new IllegalArgumentException("Error: Unknown protocol \"" + protocol + "\"");
            }
            return URI.create(rawAddress + (addSlash ? "/" : "") + endpoint);
        }
        return URI.create(rawURI);
    }

    public CMConfig getOA4MPConfig() {
        return (CMConfig)this.get("oa4mp");
    }

    public CM7591Config getRFC7591Config() {
        return (CM7591Config)this.get("rfc7591");
    }

    public CMConfig getRFC7592Config() {
        return (CMConfig)this.get("rfc7592");
    }

    public boolean hasOA4MPConfig() {
        return this.getOA4MPConfig() != null;
    }

    public boolean hasRFC7591Config() {
        return this.getRFC7591Config() != null;
    }

    public boolean hasRFC7592Config() {
        return this.getRFC7592Config() != null;
    }
}

