/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.oidc_cm;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.IllegalAccessException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import edu.uiuc.ncsa.security.servlet.HeaderUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.OA2JSONException;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.delegation.server.WrongPasswordException;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.storage.servlet.EnvServlet;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.CM7591Config;
import org.oa4mp.server.loader.oauth2.cm.CMConfig;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.AddClientRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.PermissionServer;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.RemoveClientRequest;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.OA2ExceptionHandlerThingie;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class OIDCCMServlet
extends EnvServlet {
    public static final String PROXY_CLAIMS_LIST = "proxy_claims_list";
    public static final String FORWARD_REQUEST_SCOPES_TO_PROXY = "forward_scopes_to_proxy";
    public static final String PROXY_REQUEST_SCOPES = "proxy_request_scopes";
    public static final String IS_SERVICE_CLIENT = "is_service_client";
    public static final String SERVICE_CLIENT_USERS = "service_client_users";
    public static final String ERSATZ_CLIENT_PROVISIONERS = "org.oa4mp:/ersatz/provisioners";
    public static final String APPROVAL_STATUS = "org.oa4mp:/client/status";
    public static final String API_VERSION_LATEST = "latest";
    public static final String API_VERSION_NONE = "none";
    public static final String API_VERSION_5_4 = "v5.4";
    public static final String API_VERSION_5_5 = "v5.5";
    public static final String API_VERSION_KEY = "api_version";
    public static final String QUERY_PARAMETER = "query";
    static String defaultAPIVersion = "latest";
    PermissionServer permissionServer = null;
    protected SecureRandom secureRandom = new SecureRandom();
    SecureRandom random = new SecureRandom();
    String anonSubjectTemplate = "CILogon anonymous client ${action}";
    String anonMessageTemplate = "An anonymous client was ${action}:\n\n${client} ";
    String subjectTemplate = "CILogon client ${action} for ${admin_name}";
    String messageTemplate = "The \"${admin_name}\" (${admin_id}) ${action} the following client:\n\n${client} ";
    JWKUtil2 jwkUtil;

    public void storeUpdates() throws IOException, SQLException {
        if (storeUpdatesDone) {
            return;
        }
        storeUpdatesDone = true;
        this.processStoreCheck((Store)this.getOA2SE().getAdminClientStore());
        this.processStoreCheck((Store)this.getOA2SE().getPermissionStore());
    }

    protected OA2SE getOA2SE() {
        return (OA2SE)OIDCCMServlet.getEnvironment();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String version = this.getVersion(this.getOA2SE().getCmConfigs().getRFC7592Config(), httpServletRequest);
        try {
            if (!(this.getOA2SE().getCmConfigs().hasRFC7592Config() && this.getOA2SE().getCmConfigs().getRFC7592Config().enabled || !this.getOA2SE().getCmConfigs().isEnabled())) {
                throw new IllegalAccessError("RFC 7592 not supported on this server. Request rejected.");
            }
            if (this.doPing(httpServletRequest, httpServletResponse)) {
                return;
            }
            if (!this.getOA2SE().getCmConfigs().hasRFC7592Config()) {
                throw new IllegalAccessError("RFC 7592 not supported on this server. Request rejected.");
            }
            boolean isAnonymous = false;
            AdminClient adminClient = null;
            String rawID = HeaderUtils.getFirstParameterValue((HttpServletRequest)httpServletRequest, (String)"client_id");
            try {
                adminClient = this.getAndCheckAdminClient(httpServletRequest);
                isAnonymous = adminClient == null;
            }
            catch (UnknownClientException | IllegalArgumentException iax) {
                if (!this.getOA2SE().getCmConfigs().getRFC7591Config().anonymousOK) {
                    IllegalAccessException illegalAccessException = new IllegalAccessException(iax.getMessage() + ", anonymous access denied", iax.getCause());
                    throw illegalAccessException;
                }
                isAnonymous = true;
            }
            catch (Throwable ge) {
                DebugUtil.trace((String)ge.getMessage(), (Throwable)ge);
            }
            String[] query = httpServletRequest.getParameterValues(QUERY_PARAMETER);
            if (query != null && query.length != 0) {
                this.handleServerQuery(adminClient, Arrays.asList(query), httpServletRequest, httpServletResponse);
                return;
            }
            OA2Client oa2Client = null;
            if (isAnonymous) {
                if (!HeaderUtils.hasBearerHeader((HttpServletRequest)httpServletRequest)) {
                    throw new IllegalAccessException("Unsupported authorization method.");
                }
                String[] creds = HeaderUtils.getCredentialsFromHeaders((HttpServletRequest)httpServletRequest, (String)"Bearer");
                Identifier clientID = BasicIdentifier.newID((String)creds[HeaderUtils.ID_INDEX]);
                if (StringUtils.isTrivial((String)rawID)) {
                    throw new IllegalAccessException("missing client id");
                }
                if (!rawID.equals(clientID.toString())) {
                    throw new IllegalAccessException("client id does not match requested id");
                }
                this.getClient(httpServletRequest);
                oa2Client = (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)clientID));
                if (oa2Client == null) {
                    throw new UnknownClientException();
                }
                if (!this.getOA2SE().getClientApprovalStore().isApproved(clientID)) {
                    throw new UnapprovedClientException("unapproved client", (BaseClient)oa2Client);
                }
                if (!oa2Client.isPublicClient()) {
                    String secret = creds[HeaderUtils.SECRET_INDEX];
                    String hashedSecret = DigestUtils.sha1Hex((String)secret);
                    if (!oa2Client.getSecret().equals(hashedSecret)) {
                        throw new WrongPasswordException("client and secret do not match");
                    }
                }
                JSONObject json = this.toJSONObject(oa2Client, version, true);
                MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)oa2Client);
                debugger.trace((Object)this, "GET returns payload\n" + json.toString(2));
                this.writeOK(httpServletResponse, (JSON)json);
                return;
            }
            MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)adminClient);
            debugger.trace((Object)this, "Starting get");
            if (debugger.getDebugLevel() == 1) {
                this.printAllParameters(httpServletRequest);
            }
            if (rawID == null || rawID.isEmpty()) {
                debugger.trace((Object)this, "id = \"" + rawID + "\" for client listing");
                List clients = this.getOA2SE().getPermissionStore().getClients(adminClient.getIdentifier());
                JSONObject jsonObject = new JSONObject();
                JSONArray array = new JSONArray();
                for (Identifier id : clients) {
                    Client client = (Client)this.getOA2SE().getClientStore().get((Object)id);
                    if (client == null) continue;
                    JSONObject j2 = new JSONObject();
                    j2.put((Object)"client_id", (Object)id.toString());
                    String name = client.getName();
                    if (!StringUtils.isTrivial((String)name)) {
                        j2.put((Object)"name", (Object)name);
                    }
                    array.add((Object)j2);
                }
                jsonObject.put((Object)"clients", (Object)array);
                this.writeOK(httpServletResponse, (JSON)jsonObject);
                return;
            }
            Identifier id = BasicIdentifier.newID((String)rawID);
            if (isAnonymous) {
                if (!oa2Client.getIdentifierString().equals(rawID)) {
                    throw new IllegalAccessException("clients cannot access information about any other client");
                }
            } else {
                if (!this.getOA2SE().getPermissionStore().getClients(adminClient.getIdentifier()).contains(id)) {
                    throw new IllegalAccessException("this admin client does not administer the client with ID \"" + String.valueOf(id) + "\".");
                }
                oa2Client = (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)id));
            }
            if (oa2Client == null) {
                throw new OA2JSONException("invalid_request", "no such client", 400, null);
            }
            debugger.trace((Object)this, "   requested client is " + oa2Client.getIdentifierString());
            JSONObject json = this.toJSONObject(oa2Client, version, true);
            if (oa2Client.isErsatzClient()) {
                List permissions = this.getOA2SE().getPermissionStore().getByErsatzID(oa2Client.getIdentifier());
                JSONArray provisioners = new JSONArray();
                for (Permission p : permissions) {
                    if (!p.getErsatzChain().contains(oa2Client.getIdentifier()) || !p.getAdminID().equals(adminClient.getIdentifier())) continue;
                    provisioners.add((Object)p.getClientID().toString());
                }
                if (!provisioners.isEmpty()) {
                    if (provisioners.size() == 1) {
                        json.put((Object)ERSATZ_CLIENT_PROVISIONERS, provisioners.get(0));
                    } else {
                        json.put((Object)ERSATZ_CLIENT_PROVISIONERS, (Object)provisioners);
                    }
                }
            }
            debugger.trace((Object)this, "GET returns payload\n" + json.toString(2));
            this.writeOK(httpServletResponse, (JSON)json);
        }
        catch (Throwable t) {
            this.handleException(new ExceptionHandlerThingie(t, httpServletRequest, httpServletResponse));
        }
    }

    private void handleServerQuery(AdminClient adminClient, List<String> queries, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject jsonObject = new JSONObject();
        if (queries.contains("org.oa4mp:/server#defaults")) {
            jsonObject.put((Object)"rt_lifetime", (Object)(this.getOA2SE().getRefreshTokenLifetime() / 1000L));
            jsonObject.put((Object)"at_lifetime", (Object)(this.getOA2SE().getAccessTokenLifetime() / 1000L));
            jsonObject.put((Object)"id_token_lifetime", (Object)(this.getOA2SE().getIdTokenLifetime() / 1000L));
            jsonObject.put((Object)"max_rt_lifetime", (Object)(this.getOA2SE().getMaxRTLifetime() / 1000L));
            jsonObject.put((Object)"max_at_lifetime", (Object)(this.getOA2SE().getMaxATLifetime() / 1000L));
            jsonObject.put((Object)"max_id_token_lifetime", (Object)(this.getOA2SE().getMaxIdTokenLifetime() / 1000L));
            jsonObject.put((Object)"idt_max_lifetime", (Object)(this.getOA2SE().getMaxIdTokenLifetime() / 1000L));
            jsonObject.put((Object)"auth_grant_lifetime", (Object)(this.getOA2SE().getAuthorizationGrantLifetime() / 1000L));
            jsonObject.put((Object)"use_server_default", (Object)-1L);
            jsonObject.put((Object)"rt_lifetime_create_default", (Object)this.getOA2SE().getCmConfigs().getRFC7591Config().getDefaultRefreshTokenLifetime());
            jsonObject.put((Object)"rt_lifetime_update_default", (Object)this.getOA2SE().getCmConfigs().getRFC7592Config().getDefaultRefreshTokenLifetime());
            jsonObject.put((Object)"api_version_default", (Object)OIDCCMServlet.getDefaultAPIVersion());
            jsonObject.put((Object)"oa4mp_version", (Object)"6.2.1");
            JSONArray versions = new JSONArray();
            versions.add((Object)API_VERSION_LATEST);
            versions.add((Object)API_VERSION_5_5);
            versions.add((Object)API_VERSION_5_4);
            jsonObject.put((Object)"api_versions", (Object)versions);
            jsonObject.put((Object)OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_TAG, (Object)(this.getOA2SE().getRtGracePeriod() / 1000L));
            jsonObject.put((Object)OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_TAG, (Object)(this.getOA2SE().getRtGracePeriod() / 1000L));
            if (adminClient == null || !adminClient.hasVirtualIssuer()) {
                jsonObject.put((Object)"issuer", (Object)this.getOA2SE().getIssuer());
                jsonObject.put((Object)"at_issuer", (Object)this.getOA2SE().getIssuer());
            } else {
                VirtualIssuer vo = (VirtualIssuer)((Object)this.getOA2SE().getVIStore().get(adminClient.getVirtualIssuer()));
                jsonObject.put((Object)"issuer", (Object)vo.getIssuer());
                jsonObject.put((Object)"at_issuer", (Object)vo.getAtIssuer());
            }
        }
        this.writeOK(response, (JSON)jsonObject);
    }

    protected String formatIdentifiable(Store store, Identifiable identifiable) {
        XMLMap map = new XMLMap();
        store.getXMLConverter().toMap(identifiable, (Map)map);
        if (identifiable instanceof OA2Client) {
            OA2ClientConverter cc = (OA2ClientConverter)store.getXMLConverter();
            map.remove((Object)cc.getCK2().secret(new String[0]));
        }
        List outputList = StringUtils.formatMap((Map)map, null, (boolean)true, (boolean)false, (int)2, (int)120);
        StringBuffer stringBuffer = new StringBuffer();
        for (String x : outputList) {
            stringBuffer.append(x + "\n");
        }
        return stringBuffer.toString();
    }

    protected HashMap<String, String> defaultReplacements(HttpServletRequest req, AdminClient adminClient, OA2Client client) {
        Object actionString;
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (adminClient != null) {
            replacements.put("admin_id", adminClient.getIdentifierString());
            replacements.put("admin_name", adminClient.getName());
        }
        replacements.put("client_id", client.getIdentifierString());
        replacements.put("client", this.formatIdentifiable((Store)this.getOA2SE().getClientStore(), (Identifiable)client));
        switch (req.getMethod()) {
            case "PUT": {
                actionString = "updated";
                break;
            }
            case "POST": {
                actionString = "registered";
                break;
            }
            case "DELETE": {
                actionString = "deleted";
                break;
            }
            case "GET": {
                actionString = "got";
                break;
            }
            default: {
                actionString = "did a " + req.getMethod();
            }
        }
        replacements.put("action", (String)actionString);
        return replacements;
    }

    protected JSONObject toJSONObject(OA2Client client, String version, boolean isGet) {
        if (version.equals(API_VERSION_NONE)) {
            version = OIDCCMServlet.getDefaultAPIVersion();
        }
        switch (version) {
            case "v5.4": {
                return this.toJSONObject5_4(client, isGet);
            }
            case "v5.5": 
            case "latest": {
                return this.toJSONObject5_5(client, isGet);
            }
        }
        throw new IllegalArgumentException("unknown api version \"" + version + "\"");
    }

    protected JSONObject toJSONObject5_5(OA2Client client, boolean isGet) {
        JSONArray jsonArray;
        JSONObject json = new JSONObject();
        String registrationURI = this.getOA2SE().getCmConfigs().getRFC7591Config().uri.toString();
        json.put((Object)"registration_client_uri", (Object)(registrationURI + "?client_id=" + client.getIdentifierString()));
        json.put((Object)"client_id", (Object)client.getIdentifierString());
        json.put((Object)"client_name", (Object)client.getName());
        JSONArray cbs = new JSONArray();
        cbs.addAll(client.getCallbackURIs());
        json.put((Object)"redirect_uris", (Object)cbs);
        boolean gotJWKSURI = false;
        if (client.hasJWKSURI()) {
            gotJWKSURI = true;
            json.put((Object)"jwks_uri", (Object)client.getJwksURI().toString());
        }
        if (client.hasJWKS()) {
            if (gotJWKSURI) {
                throw new IllegalStateException("The specification explicitly forbids having both keys and a jwks uri. Request rejected");
            }
            JSONObject jwks = JSONWebKeyUtil.toJSON((JSONWebKeys)client.getJWKS());
            json.put((Object)"jwks", (Object)jwks);
        }
        if (!client.getGrantTypes().isEmpty()) {
            json.put((Object)"grant_types", client.getGrantTypes());
        }
        if (!client.getResponseTypes().isEmpty()) {
            json.put((Object)"response_types", client.getResponseTypes());
        }
        if (client.isPublicClient()) {
            json.put((Object)"token_endpoint_auth_method", (Object)API_VERSION_NONE);
        }
        json.put((Object)"rt_lifetime", (Object)this.lifetimeToSec(client.getRtLifetime()));
        json.put((Object)"max_rt_lifetime", (Object)this.lifetimeToSec(client.getMaxRTLifetime()));
        json.put((Object)"max_id_token_lifetime", (Object)this.lifetimeToSec(client.getMaxIDTLifetime()));
        json.put((Object)"at_lifetime", (Object)this.lifetimeToSec(client.getAtLifetime()));
        json.put((Object)"max_at_lifetime", (Object)this.lifetimeToSec(client.getMaxATLifetime()));
        json.put((Object)"id_token_lifetime", (Object)this.lifetimeToSec(client.getIdTokenLifetime()));
        json.put((Object)"ea_support", (Object)client.hasExtendedAttributeSupport());
        if (client.hasJWKS()) {
            json.put((Object)"jwks", (Object)JSONWebKeyUtil.toJSON((JSONWebKeys)client.getJWKS()));
        }
        if (client.hasJWKSURI()) {
            json.put((Object)"jwks_uri", (Object)client.getJwksURI().toString());
        }
        JSONArray scopes = new JSONArray();
        scopes.addAll(client.getScopes());
        if (!scopes.isEmpty()) {
            json.put((Object)"scope", (Object)scopes);
        }
        json.put((Object)"client_uri", (Object)client.getHomeUri());
        json.put((Object)"error_uri", (Object)client.getErrorUri());
        json.put((Object)"strict_scopes", (Object)client.useStrictScopes());
        json.put((Object)"skip_server_scripts", (Object)client.isSkipServerScripts());
        json.put((Object)"email", (Object)client.getEmail());
        if (!client.getProxyClaimsList().isEmpty()) {
            json.put((Object)PROXY_CLAIMS_LIST, client.getProxyClaimsList());
        }
        json.put((Object)FORWARD_REQUEST_SCOPES_TO_PROXY, (Object)client.isForwardScopesToProxy());
        if (!client.getProxyRequestScopes().isEmpty()) {
            json.put((Object)PROXY_REQUEST_SCOPES, client.getProxyRequestScopes());
        }
        json.put((Object)IS_SERVICE_CLIENT, (Object)client.isServiceClient());
        JSONArray array = new JSONArray();
        array.addAll(client.getServiceClientUsers());
        json.put((Object)SERVICE_CLIENT_USERS, (Object)array);
        OA2ClientKeys clientKeys = (OA2ClientKeys)this.getOA2SE().getClientStore().getMapConverter().getKeys();
        json.put((Object)clientKeys.rtGracePeriod(new String[0]), (Object)client.getRtGracePeriod());
        json.put((Object)clientKeys.extendsProvisioners(new String[0]), (Object)client.isExtendsProvisioners());
        json.put((Object)clientKeys.ersatzClient(new String[0]), (Object)client.isErsatzClient());
        json.put((Object)clientKeys.ersatzInheritIDToken(new String[0]), (Object)client.isErsatzInheritIDToken());
        if (client.hasPrototypes()) {
            jsonArray = new JSONArray();
            for (Identifier id : client.getPrototypes()) {
                jsonArray.add((Object)id.toString());
            }
            json.put((Object)clientKeys.prototypes(new String[0]), (Object)jsonArray);
        }
        json.put((Object)"client_id_issued_at", (Object)(client.getCreationTS().getTime() / 1000L));
        if (client.getConfig() != null && !client.getConfig().isEmpty()) {
            json.put((Object)"cfg", (Object)client.getConfig());
        }
        if (json.containsKey((Object)clientKeys.email(new String[0]))) {
            jsonArray = new JSONArray();
            jsonArray.add(json.get(clientKeys.email(new String[0])));
            json.remove(clientKeys.email(new String[0]));
            json.put((Object)"contacts", (Object)jsonArray);
        }
        if (client.hasOIDC_CM_Attributes()) {
            for (Object key : client.getOIDC_CM_Attributes().keySet()) {
                if (key.equals("client_id")) continue;
                json.put(key, client.getOIDC_CM_Attributes().get(key));
            }
        }
        return json;
    }

    protected JSONObject toJSONObject5_4(OA2Client client, boolean isGet) {
        JSONArray jsonArray;
        JSONObject json = new JSONObject();
        String registrationURI = this.getOA2SE().getCmConfigs().getRFC7591Config().uri.toString();
        json.put((Object)"registration_client_uri", (Object)(registrationURI + "?client_id=" + client.getIdentifierString()));
        json.put((Object)"client_id", (Object)client.getIdentifierString());
        json.put((Object)"client_name", (Object)client.getName());
        JSONArray cbs = new JSONArray();
        cbs.addAll(client.getCallbackURIs());
        json.put((Object)"redirect_uris", (Object)cbs);
        if (client.hasJWKSURI()) {
            json.put((Object)"jwks_uri", (Object)client.getJwksURI().toString());
        }
        if (client.hasJWKS()) {
            JSONObject jwks = JSONWebKeyUtil.toJSON((JSONWebKeys)client.getJWKS());
            json.put((Object)"jwks", (Object)jwks);
        }
        if (!client.getGrantTypes().isEmpty()) {
            json.put((Object)"grant_types", client.getGrantTypes());
        }
        if (!client.getResponseTypes().isEmpty()) {
            json.put((Object)"response_types", client.getResponseTypes());
        }
        if (client.isPublicClient()) {
            json.put((Object)"token_endpoint_auth_method", (Object)API_VERSION_NONE);
        }
        if (0L < client.getRtLifetime()) {
            json.put((Object)"rt_lifetime", (Object)(client.getRtLifetime() / 1000L));
        } else {
            json.put((Object)"rt_lifetime", (Object)0L);
        }
        if (0L < client.getAtLifetime()) {
            json.put((Object)"at_lifetime", (Object)(client.getAtLifetime() / 1000L));
        } else {
            json.put((Object)"at_lifetime", (Object)0L);
        }
        if (client.hasJWKS()) {
            json.put((Object)"jwks", (Object)JSONWebKeyUtil.toJSON((JSONWebKeys)client.getJWKS()));
        }
        if (client.hasJWKSURI()) {
            json.put((Object)"jwks_uri", (Object)client.getJwksURI().toString());
        }
        JSONArray scopes = new JSONArray();
        scopes.addAll(client.getScopes());
        json.put((Object)"scope", (Object)scopes);
        json.put((Object)"client_uri", (Object)client.getHomeUri());
        json.put((Object)"error_uri", (Object)client.getErrorUri());
        json.put((Object)"strict_scopes", (Object)client.useStrictScopes());
        json.put((Object)"skip_server_scripts", (Object)client.isSkipServerScripts());
        json.put((Object)PROXY_CLAIMS_LIST, client.getProxyClaimsList());
        json.put((Object)FORWARD_REQUEST_SCOPES_TO_PROXY, (Object)client.isForwardScopesToProxy());
        json.put((Object)PROXY_REQUEST_SCOPES, client.getProxyRequestScopes());
        json.put((Object)IS_SERVICE_CLIENT, (Object)client.isServiceClient());
        JSONArray array = new JSONArray();
        array.addAll(client.getServiceClientUsers());
        json.put((Object)SERVICE_CLIENT_USERS, (Object)array);
        json.put((Object)"email", (Object)client.getEmail());
        OA2ClientKeys clientKeys = (OA2ClientKeys)this.getOA2SE().getClientStore().getMapConverter().getKeys();
        json.put((Object)clientKeys.extendsProvisioners(new String[0]), (Object)client.isExtendsProvisioners());
        json.put((Object)clientKeys.ersatzClient(new String[0]), (Object)client.isErsatzClient());
        json.put((Object)clientKeys.ersatzInheritIDToken(new String[0]), (Object)client.isErsatzInheritIDToken());
        if (client.hasPrototypes()) {
            jsonArray = new JSONArray();
            for (Identifier id : client.getPrototypes()) {
                jsonArray.add((Object)id.toString());
            }
            json.put((Object)clientKeys.prototypes(new String[0]), (Object)jsonArray);
        }
        json.put((Object)"client_id_issued_at", (Object)(client.getCreationTS().getTime() / 1000L));
        if (client.getConfig() != null && !client.getConfig().isEmpty()) {
            json.put((Object)"cfg", (Object)client.getConfig());
        }
        if (json.containsKey((Object)clientKeys.email(new String[0]))) {
            jsonArray = new JSONArray();
            jsonArray.add(json.get(clientKeys.email(new String[0])));
            json.remove(clientKeys.email(new String[0]));
            json.put((Object)"contacts", (Object)jsonArray);
        }
        if (client.hasOIDC_CM_Attributes()) {
            for (Object key : client.getOIDC_CM_Attributes().keySet()) {
                json.put(key, client.getOIDC_CM_Attributes().get(key));
            }
        }
        return json;
    }

    public static String getDefaultAPIVersion() {
        return defaultAPIVersion;
    }

    public static void setDefaultAPIVersion(String defaultAPIVersion) {
        OIDCCMServlet.defaultAPIVersion = defaultAPIVersion;
    }

    protected long lifetimeToSec(long lifetime) {
        if (0L < lifetime) {
            return lifetime / 1000L;
        }
        return lifetime;
    }

    protected long lifetimeFromSec(long lifetime) {
        if (0L < lifetime) {
            return lifetime * 1000L;
        }
        return lifetime;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String version = this.getVersion(this.getOA2SE().getCmConfigs().getRFC7592Config(), req);
        try {
            if (!(this.getOA2SE().getCmConfigs().hasRFC7592Config() && this.getOA2SE().getCmConfigs().getRFC7592Config().enabled || !this.getOA2SE().getCmConfigs().isEnabled())) {
                throw new IllegalAccessError("RFC 7592 not supported on this server. Request rejected.");
            }
            AdminClient adminClient = this.getAndCheckAdminClient(req);
            MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)adminClient);
            String rawID = req.getParameter("client_id");
            debugger.trace((Object)this, "Starting delete request for admin client " + adminClient.getIdentifierString() + "\nfor client id =\"" + rawID + "\"");
            if (rawID == null || rawID.isEmpty()) {
                throw new OA2JSONException("invalid_request", "Missing client id", 400, null, (BaseClient)adminClient);
            }
            OA2Client client = (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)BasicIdentifier.newID((String)rawID)));
            if (client == null) {
                resp.setStatus(204);
                return;
            }
            debugger.trace((Object)this, "checking permissions");
            this.checkAdminPermission(adminClient, client);
            debugger.trace((Object)this, "removing approval");
            this.getOA2SE().getClientApprovalStore().remove((Object)client.getIdentifier());
            debugger.trace((Object)this, "removing client from store");
            this.getOA2SE().getClientStore().remove((Object)client.getIdentifier());
            RemoveClientRequest removeClientRequest = new RemoveClientRequest(adminClient, client);
            debugger.trace((Object)this, "removing all permissions.");
            this.getPermissionServer().removeClient(removeClientRequest);
            debugger.trace((Object)this, "done with remove. Writing response.");
            resp.setStatus(204);
            if (adminClient.isDebugOn()) {
                this.fireMessage(false, this.getOA2SE(), this.defaultReplacements(req, adminClient, client));
            }
            return;
        }
        catch (Throwable t) {
            this.handleException(new ExceptionHandlerThingie(t, req, resp));
            return;
        }
    }

    protected void checkAdminPermission(AdminClient adminClient, OA2Client client) {
        if (client == null) {
            throw new OA2JSONException("unauthorized_client", "unknown client", 401, null, (BaseClient)adminClient);
        }
        List clientList = this.getOA2SE().getPermissionStore().getClients(adminClient.getIdentifier());
        if (!clientList.contains(client.getIdentifier())) {
            throw new OA2JSONException("access_denied", "access denied", 403, null, (BaseClient)adminClient);
        }
    }

    protected String getVersion(CMConfig cmConfig, HttpServletRequest req) {
        if (null != req.getParameter(API_VERSION_KEY)) {
            return req.getParameter(API_VERSION_KEY);
        }
        String requestUri = req.getRequestURI();
        String endpoint = cmConfig.getEndpoint();
        if (StringUtils.isTrivial((String)endpoint)) {
            throw new NFWException("the endpoint for the " + cmConfig.protocol + " has not been configured.");
        }
        if (requestUri.endsWith("/")) {
            requestUri = requestUri.substring(0, requestUri.length() - 1);
        }
        if (requestUri.endsWith("/" + endpoint)) {
            return API_VERSION_NONE;
        }
        String version = requestUri.substring(1 + requestUri.lastIndexOf("/"));
        return version;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AdminClient adminClient = null;
        Object client = null;
        String version = this.getVersion(this.getOA2SE().getCmConfigs().getRFC7592Config(), req);
        try {
            JSON rawJSON;
            if (!(this.getOA2SE().getCmConfigs().hasRFC7592Config() && this.getOA2SE().getCmConfigs().getRFC7592Config().enabled || !this.getOA2SE().getCmConfigs().isEnabled())) {
                throw new IllegalAccessError("RFC 7592 not supported on this server. Request rejected.");
            }
            adminClient = this.getAndCheckAdminClient(req);
            MetaDebugUtil adminDebugger = OA4MPServlet.createDebugger((BaseClient)adminClient);
            if (adminDebugger.getDebugLevel() == 1) {
                this.printAllParameters(req);
            }
            if ((rawJSON = this.getPayload(req, adminDebugger)).isArray()) {
                adminDebugger.info((Object)this, "Got a JSON array rather than a request:" + String.valueOf(rawJSON));
                throw new IllegalArgumentException("incorrect argument. Not a valid JSON request");
            }
            JSONObject jsonRequest = (JSONObject)rawJSON;
            client = jsonRequest.containsKey((Object)"client_id") ? (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)BasicIdentifier.newID((String)jsonRequest.getString("client_id")))) : this.getClient(req);
            if (client == null) {
                throw new OA2JSONException("unauthorized_client", "unknown client", 400, null, (BaseClient)adminClient);
            }
            this.checkAdminPermission(adminClient, (OA2Client)((Object)client));
            adminDebugger.trace((Object)this, rawJSON.toString());
            if (jsonRequest.size() == 0) {
                adminDebugger.info((Object)this, "Got an empty JSON object. Request rejected.");
                throw new OA2JSONException("invalid_request", "invalid request", 400, null, (BaseClient)adminClient);
            }
            if (jsonRequest.containsKey((Object)"registration_access_token") || jsonRequest.containsKey((Object)"client_secret_expires_at") || jsonRequest.containsKey((Object)"client_id_issued_at")) {
                throw new OA2JSONException("invalid_request", "invalid parameter", 400, null, (BaseClient)client);
            }
            if (jsonRequest.containsKey((Object)"scope")) {
                boolean rejectRequest = false;
                JSONArray newScopes = this.toJA(jsonRequest, "scope");
                Collection oldScopes = client.getScopes();
                if (client.isPublicClient() && oldScopes.size() == 1 && oldScopes.contains("openid") && (newScopes.size() != 1 || !newScopes.contains((Object)"openid"))) {
                    throw new OA2JSONException("invalid_request", "Cannot increase scope of public client.", 400, null, (BaseClient)client);
                }
                HashSet<String> newScopeList = new HashSet<String>();
                Collection<String> supportedScopes = this.getOA2SE().getScopes();
                String scope = null;
                for (Object x : newScopes) {
                    scope = x.toString();
                    if (!supportedScopes.contains(scope)) {
                        rejectRequest = true;
                        adminDebugger.trace((Object)this, "rejected scope '" + scope + "', not on list of server supported scopes:" + String.valueOf(supportedScopes));
                        break;
                    }
                    newScopeList.add(scope);
                }
                if (rejectRequest) {
                    throw new OA2JSONException("invalid_scope", "invalid scope", 403, null, (BaseClient)client);
                }
                client.setScopes(newScopeList);
            }
            boolean isDebugOn = client.isDebugOn();
            OA2Client newClient = (OA2Client)this.getOA2SE().getClientStore().create();
            boolean generateNewSecret = false;
            if (jsonRequest.containsKey((Object)"client_secret")) {
                String hashedSecret = DigestUtils.sha1Hex((String)jsonRequest.getString("client_secret"));
                if (!hashedSecret.equals(client.getSecret())) {
                    throw new OA2JSONException("invalid_request", "client id does not match", 403, null, (BaseClient)client);
                }
                newClient.setSecret(client.getSecret());
            }
            newClient.setSecret(client.getSecret());
            newClient.setPublicClient(client.isPublicClient());
            jsonRequest.remove("client_secret");
            jsonRequest.remove("client_id");
            newClient.setIdentifier(client.getIdentifier());
            newClient.setConfig(client.getConfig());
            try {
                newClient = this.updateClient(newClient, adminClient, false, jsonRequest, false, version);
                if (adminClient.isDebugOn()) {
                    this.fireMessage(false, this.getOA2SE(), this.defaultReplacements(req, adminClient, newClient));
                }
                newClient.setDebugOn(isDebugOn);
                this.getOA2SE().getClientStore().save((Identifiable)newClient);
                if (jsonRequest.containsKey((Object)APPROVAL_STATUS)) {
                    String status = jsonRequest.getString(APPROVAL_STATUS);
                    ClientApproval approval = (ClientApproval)this.getOA2SE().getClientApprovalStore().get((Object)client.getIdentifier());
                    if (approval == null) {
                        approval = (ClientApproval)this.getOA2SE().getClientApprovalStore().create();
                        approval.setIdentifier(client.getIdentifier());
                        approval.setApprover(adminClient.getIdentifierString());
                    }
                    approval.setApprovalTimestamp(new Date());
                    switch (ClientApproval.Status.valueOf((String)status)) {
                        case APPROVED: {
                            approval.setApproved(true);
                            approval.setStatus(ClientApproval.Status.APPROVED);
                            break;
                        }
                        case REVOKED: {
                            approval.setApproved(false);
                            approval.setStatus(ClientApproval.Status.REVOKED);
                            break;
                        }
                        case PENDING: {
                            approval.setApproved(false);
                            approval.setStatus(ClientApproval.Status.PENDING);
                            break;
                        }
                        case NONE: {
                            approval.setApproved(false);
                            approval.setStatus(ClientApproval.Status.NONE);
                            break;
                        }
                        case DENIED: {
                            approval.setApproved(false);
                            approval.setStatus(ClientApproval.Status.DENIED);
                        }
                    }
                    this.getOA2SE().getClientApprovalStore().save((Identifiable)approval);
                }
                this.writeOK(resp, (JSON)this.toJSONObject(newClient, version, false));
            }
            catch (Throwable t) {
                this.warn("Error attempting to update client \"" + client.getIdentifierString() + "\". Message = \"" + t.getMessage() + "\". Request is rejected");
                this.handleException(new OA2ExceptionHandlerThingie(t, req, resp, (BaseClient)(client == null ? adminClient : client)));
            }
        }
        catch (Throwable t) {
            this.handleException(new OA2ExceptionHandlerThingie(t, req, resp, (BaseClient)(client == null ? adminClient : client)));
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (!(this.getOA2SE().getCmConfigs().hasRFC7591Config() && this.getOA2SE().getCmConfigs().getRFC7591Config().enabled || !this.getOA2SE().getCmConfigs().isEnabled())) {
                throw new IllegalAccessError("RFC 7591 not supported on this server. Request rejected.");
            }
            if (this.doPing(httpServletRequest, httpServletResponse)) {
                return;
            }
            DebugUtil.trace((Object)((Object)this), (String)("ENCODING is of type " + httpServletRequest.getContentType()));
            if (!httpServletRequest.getContentType().contains("application/json")) {
                httpServletResponse.setStatus(415);
                httpServletResponse.setContentType("application/json");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"error", (Object)"unsupported encoding");
                this.getMyLogger().info("Unsupported encoding of \"" + httpServletRequest.getContentType() + " for body of POST. Request rejected.");
                jsonObject.put((Object)"description", (Object)"Unsupported encoding for body of POST. Request rejected.");
                httpServletResponse.getWriter().println(jsonObject);
                httpServletResponse.getWriter().flush();
                return;
            }
            this.doIt(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            this.handleException(new ExceptionHandlerThingie(t, httpServletRequest, httpServletResponse));
        }
    }

    public PermissionServer getPermissionServer() {
        if (this.permissionServer == null) {
            this.permissionServer = new PermissionServer(this.getOA2SE());
        }
        return this.permissionServer;
    }

    protected AdminClient getAndCheckAdminClient(HttpServletRequest request) throws Throwable {
        String[] credentials = OA2HeaderUtils.getCredentialsFromHeaders((HttpServletRequest)request, (String)"Bearer");
        Identifier acID = BasicIdentifier.newID((String)credentials[OA2HeaderUtils.ID_INDEX]);
        if (!this.getOA2SE().getAdminClientStore().containsKey((Object)acID)) {
            throw new UnknownClientException("the given id of \"" + String.valueOf(acID) + "\" is not recognized as an admin client.");
        }
        AdminClient adminClient = (AdminClient)this.getOA2SE().getAdminClientStore().get((Object)acID);
        MetaDebugUtil adminDebugger = OA4MPServlet.createDebugger((BaseClient)adminClient);
        String adminSecret = credentials[OA2HeaderUtils.SECRET_INDEX];
        if (adminSecret == null || adminSecret.isEmpty()) {
            throw new WrongPasswordException("missing secret.");
        }
        if (!this.getOA2SE().getClientApprovalStore().isApproved(acID)) {
            adminDebugger.trace((Object)this, "Admin client \"" + String.valueOf(acID) + "\" is not approved.");
            throw new UnapprovedClientException("this admin client has not been approved.", null);
        }
        String hashedSecret = DigestUtils.sha1Hex((String)adminSecret);
        if (!adminClient.getSecret().equals(hashedSecret)) {
            adminDebugger.trace((Object)this, "Admin client \"" + String.valueOf(acID) + "\" and secret do not match.");
            throw new WrongPasswordException("client and secret do not match");
        }
        return adminClient;
    }

    protected OA2Client getAndCheckOA2Client(HttpServletRequest request) throws Throwable {
        String[] credentials = OA2HeaderUtils.getCredentialsFromHeaders((HttpServletRequest)request, (String)"Bearer");
        Identifier clientID = BasicIdentifier.newID((String)credentials[OA2HeaderUtils.ID_INDEX]);
        if (!this.getOA2SE().getClientStore().containsKey((Object)clientID)) {
            throw new GeneralException("the given id of \"" + String.valueOf(clientID) + "\" is not recognized as a  client.");
        }
        OA2Client oa2Client = (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)clientID));
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)oa2Client);
        String clientSecret = credentials[OA2HeaderUtils.SECRET_INDEX];
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new GeneralException("missing secret.");
        }
        if (!this.getOA2SE().getClientApprovalStore().isApproved(clientID)) {
            debugger.trace((Object)this, "Client \"" + String.valueOf(clientID) + "\" is not approved.");
            throw new UnapprovedClientException("this client has not been approved.", (BaseClient)oa2Client);
        }
        String hashedSecret = DigestUtils.sha1Hex((String)clientSecret);
        if (!oa2Client.getSecret().equals(hashedSecret)) {
            debugger.trace((Object)this, "Client \"" + String.valueOf(clientID) + "\" and secret do not match.");
            throw new GeneralException("client and secret do not match");
        }
        return oa2Client;
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        try {
            this.doIt2(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            this.handleException(new ExceptionHandlerThingie(t, httpServletRequest, httpServletResponse));
        }
    }

    protected void doIt2(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        if (!this.getOA2SE().getCmConfigs().isEnabled()) {
            throw new ServletException("unsupported service");
        }
        String version = this.getVersion(this.getOA2SE().getCmConfigs().getRFC7591Config(), httpServletRequest);
        CM7591Config cm7591Config = this.getOA2SE().getCmConfigs().getRFC7591Config();
        boolean isAnonymous = false;
        String host = httpServletRequest.getRemoteHost();
        AdminClient adminClient = null;
        try {
            adminClient = this.getAndCheckAdminClient(httpServletRequest);
        }
        catch (IllegalArgumentException ge) {
            if (!cm7591Config.anonymousOK) {
                DebugUtil.trace((Object)((Object)this), (String)"anonymous mode not enabled, exception thrown.");
                throw ge;
            }
            if (!cm7591Config.checkAnonymousDomain(host)) {
                throw new GeneralException("Anonymous client access restricted for domain " + host + ".");
            }
            DebugUtil.trace((Object)((Object)this), (String)"anonymous ok");
            isAnonymous = true;
        }
        catch (UnknownClientException | UnapprovedClientException | WrongPasswordException zzz) {
            throw new GeneralException("Bad admin client " + host + ":" + zzz.getMessage());
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)adminClient);
        if (debugger.getDebugLevel() == 1) {
            this.printAllParameters(httpServletRequest);
        }
        debugger.trace((Object)this, "Starting to process " + httpServletRequest.getMethod());
        JSON rawJSON = this.getPayload(httpServletRequest, debugger);
        if (!isAnonymous && adminClient.getMaxClients() < this.getOA2SE().getPermissionStore().getClientCount(adminClient.getIdentifier())) {
            debugger.info((Object)this, " Max client count of " + adminClient.getMaxClients() + " exceeded.");
            throw new GeneralException("Max client count of " + adminClient.getMaxClients() + " exceeded.");
        }
        debugger.trace((Object)this, rawJSON.toString());
        if (rawJSON.isArray()) {
            debugger.info((Object)this, " Got a JSON array rather than a request:" + String.valueOf(rawJSON));
            throw new IllegalArgumentException("incorrect argument. Not a valid JSON request");
        }
        JSONObject jsonRequest = (JSONObject)rawJSON;
        OA2Client template = null;
        template = (OA2Client)this.getOA2SE().getClientStore().create();
        if (cm7591Config.template != null) {
            Identifier newID = template.getIdentifier();
            Date createTS = template.getCreationTS();
            template = (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)cm7591Config.template));
            template.setIdentifier(newID);
            template.setCreationTS(createTS);
        }
        boolean returnStringScopes = false;
        try {
            jsonRequest.getJSONArray("scope");
            returnStringScopes = false;
        }
        catch (JSONException jse) {
            returnStringScopes = true;
        }
        OA2Client newClient = this.processRegistrationRequest(jsonRequest, adminClient, isAnonymous, template, version);
        if (isAnonymous) {
            this.fireMessage(isAnonymous, this.getOA2SE(), this.defaultReplacements(httpServletRequest, adminClient, newClient));
        } else if (adminClient.isDebugOn()) {
            this.fireMessage(false, this.getOA2SE(), this.defaultReplacements(httpServletRequest, adminClient, newClient));
        }
        JSONObject jsonResp = new JSONObject();
        Object newID = newClient.getIdentifierString();
        if (jsonRequest.containsKey((Object)"client_id")) {
            if (adminClient != null && adminClient.isAllowCustomIDs()) {
                newID = jsonRequest.getString("client_id");
            }
        } else if (adminClient != null && adminClient.isAllowCustomIDs() && adminClient.isGenerateIDs()) {
            if (adminClient.getIdHead() == null) {
                this.warn(adminClient.getIdentifierString() + " requested generate client id but there is no id head set");
            } else {
                byte[] u = new byte[16];
                this.secureRandom.nextBytes(u);
                BigInteger bi = new BigInteger(u);
                bi = bi.abs();
                Object uniquePart = bi.toString(16);
                if (adminClient.isUseTimestampInIDs()) {
                    uniquePart = (String)uniquePart + "/" + System.currentTimeMillis();
                }
                newID = (String)newID + (((String)(newID = adminClient.getIdHead().toString())).endsWith("/") ? "" : "/") + (String)uniquePart;
            }
        }
        newClient.setIdentifier(BasicIdentifier.newID((String)newID));
        jsonResp.put((Object)"client_id", newID);
        if (!StringUtils.isTrivial((String)newClient.getSecret())) {
            jsonResp.put((Object)"client_secret", (Object)newClient.getSecret());
            String hashedSecret = DigestUtils.sha1Hex((String)newClient.getSecret());
            jsonResp.put((Object)"client_id_issued_at", (Object)(newClient.getCreationTS().getTime() / 1000L));
            String secret = DigestUtils.sha1Hex((String)newClient.getSecret());
            newClient.setSecret(secret);
            jsonResp.put((Object)"client_secret_expires_at", (Object)0L);
        }
        String registrationURI = this.getOA2SE().getCmConfigs().getRFC7591Config().uri.toString();
        jsonResp.put((Object)"registration_client_uri", (Object)(registrationURI + "?client_id=" + newClient.getIdentifierString()));
        if (returnStringScopes) {
            jsonResp.put((Object)"scope", (Object)String.join((CharSequence)" ", newClient.getScopes()));
        } else {
            Object xxx = new JSONArray();
            xxx.addAll(newClient.getScopes());
            jsonResp.put((Object)"scope", xxx);
        }
        switch (version) {
            case "none": 
            case "v5.4": {
                break;
            }
            default: {
                newClient.getOIDC_CM_Attributes().put((Object)API_VERSION_KEY, (Object)version);
            }
        }
        debugger.trace((Object)this, "saving this client");
        this.getOA2SE().getClientStore().save((Identifiable)newClient);
        if (!isAnonymous) {
            debugger.trace((Object)this, "Adding permissions for client " + newClient.getIdentifierString());
            AddClientRequest addClientRequest = new AddClientRequest(adminClient, newClient);
            this.getPermissionServer().addClient(addClientRequest);
        }
        debugger.trace((Object)this, "Setting approval record for client " + newClient.getIdentifierString());
        ClientApproval approval = new ClientApproval(newClient.getIdentifier());
        approval.setApprovalTimestamp(new Date());
        if (isAnonymous) {
            if (cm7591Config.autoApprove && cm7591Config.checkAutoApproveDomain(host)) {
                approval.setApprover(cm7591Config.autoApproverName);
                approval.setApproved(true);
                approval.setStatus(ClientApproval.Status.APPROVED);
            } else {
                approval.setApproved(false);
                approval.setStatus(ClientApproval.Status.PENDING);
            }
        } else {
            approval.setApprover(adminClient.getIdentifierString());
            approval.setApproved(true);
            approval.setStatus(ClientApproval.Status.APPROVED);
        }
        this.getOA2SE().getClientApprovalStore().save((Identifiable)approval);
        this.writeCreateOK(httpServletResponse, (JSON)jsonResp);
        this.logOK(httpServletRequest);
    }

    private void writeOK(HttpServletResponse httpServletResponse, JSON resp) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("application/json");
        httpServletResponse.getWriter().println(resp.toString());
        httpServletResponse.getWriter().flush();
    }

    private void writeCreateOK(HttpServletResponse httpServletResponse, JSON resp) throws IOException {
        httpServletResponse.setStatus(201);
        httpServletResponse.setContentType("application/json");
        httpServletResponse.getWriter().println(resp.toString());
        httpServletResponse.getWriter().flush();
    }

    protected JSON getPayload(HttpServletRequest httpServletRequest, MetaDebugUtil adminDebugger) throws IOException {
        BufferedReader br = httpServletRequest.getReader();
        adminDebugger.trace((Object)this, "query=" + httpServletRequest.getQueryString());
        StringBuffer stringBuffer = new StringBuffer();
        String line = br.readLine();
        adminDebugger.trace((Object)this, "line=" + line);
        while (line != null) {
            stringBuffer.append(line);
            line = br.readLine();
        }
        br.close();
        if (stringBuffer.length() == 0) {
            throw new IllegalArgumentException("There is no content for this request");
        }
        return JSONSerializer.toJSON((Object)stringBuffer.toString());
    }

    protected OA2Client getClient(HttpServletRequest req) {
        String rawID = req.getParameter("client_id");
        if (rawID == null || rawID.isEmpty()) {
            return null;
        }
        return (OA2Client)((Object)this.getOA2SE().getClientStore().get((Object)BasicIdentifier.newID((String)rawID)));
    }

    protected OA2Client updateClient(OA2Client client, AdminClient adminClient, boolean isAnonymous, JSONObject jsonRequest, boolean newClient, String version) {
        OA2ClientKeys keys = new OA2ClientKeys();
        if (jsonRequest.containsKey((Object)"application_type") && !jsonRequest.getString("application_type").equals("web")) {
            throw new OA2JSONException("invalid_request", "Unsupported application type", 400, null, (BaseClient)client);
        }
        jsonRequest.remove("application_type");
        this.handleGrants(client, jsonRequest, keys);
        this.handleResponseTypes(client, jsonRequest, keys);
        JSONArray redirectURIs = null;
        if (jsonRequest.containsKey((Object)"redirect_uris")) {
            redirectURIs = this.toJSONArray(jsonRequest, "redirect_uris", client);
            for (Object z : redirectURIs) {
                if (!(z instanceof String)) {
                    throw new OA2JSONException("invalid_request", " illegal redirect uri \"" + String.valueOf(z) + "\" ", 400, null, (BaseClient)client);
                }
                if (!z.toString().contains("*")) continue;
                throw new OA2JSONException("invalid_request", "wildcards not allows in redirect uri \"" + String.valueOf(z) + "\" ", 400, null, (BaseClient)client);
            }
            client.setCallbackURIs((Collection<String>)redirectURIs);
            jsonRequest.remove("redirect_uris");
        }
        if (!jsonRequest.containsKey((Object)"client_name")) {
            throw new OA2JSONException("invalid_request", "no client name", 400, null, (BaseClient)client);
        }
        client.setName(jsonRequest.getString("client_name"));
        jsonRequest.remove("client_name");
        if (jsonRequest.containsKey((Object)"client_uri")) {
            client.setHomeUri(jsonRequest.getString("client_uri"));
            jsonRequest.remove("client_uri");
        } else {
            client.setHomeUri("");
        }
        OA2ClientKeys clientKeys = (OA2ClientKeys)this.getOA2SE().getClientStore().getMapConverter().getKeys();
        if (jsonRequest.containsKey((Object)"token_endpoint_auth_method")) {
            String authMethod = jsonRequest.getString("token_endpoint_auth_method");
            boolean gotSupportedAuthMethod = false;
            switch (authMethod) {
                case "none": {
                    if (newClient) {
                        gotSupportedAuthMethod = true;
                        client.setPublicClient(true);
                        break;
                    }
                    if (client.isPublicClient()) {
                        gotSupportedAuthMethod = true;
                        break;
                    }
                    throw new OA2JSONException("invalid_request_object", "cannot change from a confidential to a public client", 400, null, (BaseClient)client);
                }
                case "client_secret_basic": 
                case "client_secret_post": {
                    if (!newClient && client.isPublicClient()) {
                        throw new OA2JSONException("invalid_request_object", "cannot change from a public to a confidential client", 400, null, (BaseClient)client);
                    }
                    gotSupportedAuthMethod = true;
                    client.setPublicClient(false);
                    client.setSignTokens(true);
                    break;
                }
                case "private_key_jwt": {
                    if (jsonRequest.containsKey((Object)"jwks_uri")) {
                        client.setJwksURI(URI.create(jsonRequest.getString("jwks_uri")));
                        jsonRequest.remove("jwks_uri");
                        client.setServiceClient(true);
                        gotSupportedAuthMethod = true;
                    }
                    if (!jsonRequest.containsKey((Object)"jwks")) break;
                    client.setSecret(null);
                    client.setJWKS(this.getJwkUtil().fromJSON((JSON)jsonRequest.getJSONObject("jwks")));
                    jsonRequest.remove("jwks");
                    client.setServiceClient(true);
                    gotSupportedAuthMethod = true;
                    break;
                }
                default: {
                    gotSupportedAuthMethod = false;
                }
            }
            if (!gotSupportedAuthMethod) {
                throw new OA2JSONException("invalid_request_object", "unsupported token endpoint authorization method \"" + authMethod + "\"", 400, null, (BaseClient)client);
            }
            jsonRequest.remove("token_endpoint_auth_method");
        }
        if (!jsonRequest.containsKey((Object)"scope")) {
            client.setScopes(new ArrayList());
        } else {
            JSONArray newScopes = this.toJA(jsonRequest, "scope");
            HashSet unique = new HashSet();
            unique.addAll(newScopes);
            if (client.isPublicClient()) {
                if (!unique.contains("openid")) {
                    throw new OA2JSONException("invalid_request_object", "cannot decrease scope on a public client.", 400, null, (BaseClient)client);
                }
                if (1 < newScopes.size() && !unique.contains("offline_access")) {
                    throw new OA2JSONException("invalid_request_object", "cannot increase scopes on a public client.", 400, null, (BaseClient)client);
                }
            }
            newScopes.clear();
            newScopes.addAll(unique);
            client.setScopes((Collection)newScopes);
        }
        jsonRequest.remove("scope");
        if (newClient) {
            if (client.isPublicClient()) {
                client.setSecret("");
            } else {
                byte[] bytes = new byte[this.getOA2SE().getClientSecretLength()];
                this.random.nextBytes(bytes);
                String secret64 = Base64.encodeBase64URLSafeString((byte[])bytes);
                client.setSecret(secret64);
            }
        }
        if (jsonRequest.containsKey((Object)"contacts")) {
            JSONArray emails = this.toJA(jsonRequest, "contacts");
            if (1 < emails.size()) {
                ServletDebugUtil.info((Object)((Object)this), (String)("Multiple contacts addresses found " + String.valueOf(emails) + "\n Only the first is used currently."));
            }
            if (!emails.isEmpty()) {
                client.setEmail(emails.getString(0));
            }
            jsonRequest.remove("contacts");
        }
        if (jsonRequest.containsKey((Object)"cfg")) {
            if (client.isPublicClient()) {
                throw new OA2JSONException("invalid_request_object", "custom configurations not permitted in public clients.", 400, null, (BaseClient)client);
            }
            JSONObject jsonObject = jsonRequest.getJSONObject("cfg");
            if (isAnonymous && jsonRequest.getString("cfg").toLowerCase().contains("qdl")) {
                throw new OA2JSONException("invalid_request_object", "QDL scripting is not allowed for this client.", 400, null, (BaseClient)client);
            }
            if (adminClient.isAllowQDL()) {
                if (adminClient.allowQDLCodeBlocks() && jsonRequest.getString("cfg").contains("qdl") && jsonRequest.getString("cfg").contains("qdl") && jsonRequest.getString("cfg").contains("\"code\"")) {
                    throw new OA2JSONException("invalid_request_object", "QDL code blocks are not allowed for this client.", 400, null, (BaseClient)client);
                }
            } else if (jsonRequest.getString("cfg").toLowerCase().contains("qdl")) {
                throw new OA2JSONException("invalid_request_object", "QDL scripting is not allowed for this client.", 400, null, (BaseClient)client);
            }
            jsonRequest.remove("cfg");
            client.setConfig(jsonObject);
        } else if (!newClient) {
            client.setConfig(null);
        }
        if (jsonRequest.containsKey((Object)"rt_lifetime")) {
            client.setRtLifetime(this.lifetimeFromParameter(jsonRequest.get("rt_lifetime")));
            jsonRequest.remove("rt_lifetime");
        } else if (newClient) {
            client.setRtLifetime(this.getOA2SE().getCmConfigs().getRFC7591Config().getDefaultRefreshTokenLifetime());
        } else {
            client.setRtLifetime(this.getOA2SE().getCmConfigs().getRFC7592Config().getDefaultRefreshTokenLifetime());
        }
        if (jsonRequest.containsKey((Object)"max_rt_lifetime")) {
            client.setMaxRTLifetime(this.lifetimeFromParameter(jsonRequest.get("max_rt_lifetime")));
            jsonRequest.remove("max_rt_lifetime");
        }
        if (jsonRequest.containsKey((Object)"at_lifetime")) {
            client.setAtLifetime(this.lifetimeFromParameter(jsonRequest.get("at_lifetime")));
            jsonRequest.remove("at_lifetime");
        }
        if (jsonRequest.containsKey((Object)"max_at_lifetime")) {
            client.setMaxATLifetime(this.lifetimeFromParameter(jsonRequest.get("max_at_lifetime")));
            jsonRequest.remove("max_at_lifetime");
        }
        if (jsonRequest.containsKey((Object)"id_token_lifetime")) {
            client.setIdTokenLifetime(this.lifetimeFromParameter(jsonRequest.get("id_token_lifetime")));
            jsonRequest.remove("id_token_lifetime");
        }
        if (jsonRequest.containsKey((Object)"max_id_token_lifetime")) {
            client.setMaxIDTLifetime(this.lifetimeFromParameter(jsonRequest.get("max_id_token_lifetime")));
            jsonRequest.remove("max_id_token_lifetime");
        }
        if (!isAnonymous) {
            if (jsonRequest.containsKey((Object)clientKeys.prototypes(new String[0]))) {
                JSONArray jsonArray = jsonRequest.getJSONArray(clientKeys.prototypes(new String[0]));
                ArrayList<Identifier> prototypes = new ArrayList<Identifier>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    prototypes.add(BasicIdentifier.newID((String)jsonArray.getString(i)));
                }
                client.setPrototypes(prototypes);
            }
            if (jsonRequest.containsKey((Object)clientKeys.rtGracePeriod(new String[0]))) {
                client.setRtGracePeriod(this.lifetimeFromParameter(jsonRequest.get(clientKeys.rtGracePeriod(new String[0]))));
            } else {
                client.setRtGracePeriod(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT);
            }
            if (jsonRequest.containsKey((Object)clientKeys.extendsProvisioners(new String[0]))) {
                client.setExtendsProvisioners(jsonRequest.getBoolean(clientKeys.extendsProvisioners(new String[0])));
            }
            if (jsonRequest.containsKey((Object)clientKeys.ersatzClient(new String[0]))) {
                client.setErsatzClient(jsonRequest.getBoolean(clientKeys.ersatzClient(new String[0])));
            }
            if (jsonRequest.containsKey((Object)clientKeys.ersatzInheritIDToken(new String[0]))) {
                client.setErsatzInheritIDToken(jsonRequest.getBoolean(clientKeys.ersatzInheritIDToken(new String[0])));
            }
            if (jsonRequest.containsKey((Object)"ea_support")) {
                client.setExtendedAttributeSupport(jsonRequest.getBoolean("ea_support"));
            }
            if (client.isErsatzClient() && jsonRequest.containsKey((Object)ERSATZ_CLIENT_PROVISIONERS)) {
                ArrayList<Identifier> ersatzChain;
                try {
                    JSONArray array = jsonRequest.getJSONArray(ERSATZ_CLIENT_PROVISIONERS);
                    ersatzChain = new ArrayList(array.size());
                    for (Object obj : array) {
                        ersatzChain.add(BasicIdentifier.newID((String)obj.toString()));
                    }
                }
                catch (Throwable t) {
                    ersatzChain = new ArrayList<Identifier>(1);
                    ersatzChain.add(BasicIdentifier.newID((String)jsonRequest.getString(ERSATZ_CLIENT_PROVISIONERS)));
                }
                Identifier provisionerID = (Identifier)ersatzChain.get(0);
                Permission permission = this.getOA2SE().getPermissionStore().getErsatzChain(adminClient.getIdentifier(), provisionerID, client.getIdentifier());
                if (permission == null) {
                    permission = (Permission)this.getOA2SE().getPermissionStore().create();
                    permission.setSubstitute(true);
                    permission.setAdminID(adminClient.getIdentifier());
                    permission.setClientID(provisionerID);
                    permission.setErsatzChain(ersatzChain);
                } else {
                    permission.setErsatzChain(ersatzChain);
                }
                this.getOA2SE().getPermissionStore().save((Identifiable)permission);
            }
            if (jsonRequest.containsKey((Object)"strict_scopes")) {
                client.setStrictscopes(jsonRequest.getBoolean("strict_scopes"));
                jsonRequest.remove("strict_scopes");
            }
            if (jsonRequest.containsKey((Object)"skip_server_scripts")) {
                client.setSkipServerScripts(jsonRequest.getBoolean("skip_server_scripts"));
                jsonRequest.remove("skip_server_scripts");
            }
            if (jsonRequest.containsKey((Object)PROXY_CLAIMS_LIST)) {
                client.setProxyClaimsList((Collection<String>)this.toJSONArray(jsonRequest, PROXY_CLAIMS_LIST, client));
                jsonRequest.remove(PROXY_CLAIMS_LIST);
            }
            if (jsonRequest.containsKey((Object)FORWARD_REQUEST_SCOPES_TO_PROXY)) {
                client.setForwardScopesToProxy(jsonRequest.getBoolean(FORWARD_REQUEST_SCOPES_TO_PROXY));
                jsonRequest.remove(FORWARD_REQUEST_SCOPES_TO_PROXY);
            }
            if (jsonRequest.containsKey((Object)PROXY_REQUEST_SCOPES)) {
                client.setProxyRequestScopes((Collection<String>)this.toJSONArray(jsonRequest, PROXY_REQUEST_SCOPES, client));
                jsonRequest.remove(PROXY_REQUEST_SCOPES);
            }
            if (jsonRequest.containsKey((Object)IS_SERVICE_CLIENT)) {
                client.setServiceClient(jsonRequest.getBoolean(IS_SERVICE_CLIENT));
                jsonRequest.remove(IS_SERVICE_CLIENT);
            }
            if (jsonRequest.containsKey((Object)SERVICE_CLIENT_USERS)) {
                client.setServiceClientUsers((Collection)this.toJSONArray(jsonRequest, SERVICE_CLIENT_USERS, client));
                jsonRequest.remove(SERVICE_CLIENT_USERS);
            }
        }
        if (jsonRequest.containsKey((Object)"description")) {
            client.setDescription(jsonRequest.getString("description"));
            jsonRequest.remove("description");
        }
        client.removeOIDC_CM_Attributes();
        if (!jsonRequest.isEmpty()) {
            client.setOIDC_CM_attributes(jsonRequest);
        }
        return client;
    }

    protected long lifetimeFromParameter(Object raw) {
        if (raw instanceof Integer) {
            return this.lifetimeFromSec(((Integer)raw).intValue());
        }
        if (raw instanceof Long) {
            return this.lifetimeFromSec((Long)raw);
        }
        return XMLConfigUtil.getValueSecsOrMillis((String)raw.toString(), (boolean)true);
    }

    protected JSONArray toJSONArray(JSONObject jsonRequest, String key, OA2Client client) {
        JSONArray array = null;
        if (jsonRequest.containsKey((Object)key)) {
            Object object = jsonRequest.get(key);
            if (object instanceof JSONArray) {
                array = (JSONArray)object;
            } else if (object instanceof JSONObject) {
                JSONObject j = (JSONObject)object;
                if (j.isEmpty()) {
                    array = new JSONArray();
                }
            } else if (object instanceof String) {
                array = new JSONArray();
                array.add(object);
            } else {
                throw new OA2JSONException("invalid_request", "cannot interpret " + key + ", got " + String.valueOf(object), 400, null, (BaseClient)client);
            }
        }
        return array;
    }

    protected void handleResponseTypes(OA2Client client, JSONObject jsonRequest, OA2ClientKeys keys) {
        JSONArray responseTypes;
        if (jsonRequest.containsKey((Object)"response_types") && !(responseTypes = this.toJA(jsonRequest, "response_types")).isEmpty()) {
            if (!responseTypes.contains((Object)"code")) {
                throw new OA2JSONException("unsupported_response_type", "unsupported response type", 400, null, (BaseClient)client);
            }
            if (responseTypes.contains((Object)"token")) {
                throw new OA2JSONException("unsupported_response_type", "unsupported response type", 400, null, (BaseClient)client);
            }
            if (1 < responseTypes.size() && !this.checkJAEntry(responseTypes, "id_token")) {
                throw new OA2JSONException("unsupported_response_type", "unsupported response type", 400, null, (BaseClient)client);
            }
            client.setResponseTypes((List<String>)responseTypes);
        }
        jsonRequest.remove("response_types");
    }

    protected boolean checkJAEntry(JSONArray jsonArray, String entry) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!jsonArray.getString(i).equals(entry)) continue;
            return true;
        }
        return false;
    }

    protected boolean areAllGrantsSupported(JSONArray proposedGrants, String[] supportedGrants) {
        for (int i = 0; i < proposedGrants.size(); ++i) {
            boolean oneOK = false;
            for (int j = 0; j < supportedGrants.length; ++j) {
                oneOK = oneOK || StringUtils.equals((String)proposedGrants.getString(i), (String)supportedGrants[j]);
            }
            if (oneOK) continue;
            return false;
        }
        return true;
    }

    protected void handleGrants(OA2Client client, JSONObject jsonRequest, OA2ClientKeys keys) {
        if (jsonRequest.containsKey((Object)"grant_types")) {
            JSONArray grantTypes = this.toJA(jsonRequest, "grant_types");
            String[] supportedGrants = new String[]{"authorization_code", "refresh_token", "urn:ietf:params:oauth:grant-type:device_code", "urn:ietf:params:oauth:grant-type:token-exchange"};
            if (!this.areAllGrantsSupported(grantTypes, supportedGrants)) {
                throw new OA2JSONException("registration_not_supported", "unsupported grant type", 400, null);
            }
            boolean requestedRT = false;
            client.setGrantTypes((List<String>)grantTypes);
            for (int i = 0; i < grantTypes.size(); ++i) {
                if (!grantTypes.getString(i).equals("refresh_token")) continue;
                requestedRT = true;
                break;
            }
            if (requestedRT) {
                if (jsonRequest.containsKey((Object)keys.rtLifetime(new String[0]))) {
                    Object raw = jsonRequest.get(keys.rtLifetime(new String[0]));
                    if (raw instanceof Integer) {
                        client.setRtLifetime((long)((Integer)raw).intValue() * 1000L);
                    } else if (raw instanceof Long) {
                        client.setRtLifetime((Long)raw * 1000L);
                    } else {
                        client.setRtLifetime(XMLConfigUtil.getValueSecsOrMillis((String)raw.toString(), (boolean)true));
                    }
                } else {
                    client.setRtLifetime(-1L);
                }
            }
        } else {
            client.setRtLifetime(0L);
        }
        jsonRequest.remove("grant_types");
    }

    protected JSONArray toJA(JSONObject obj, String key) {
        JSONArray array = null;
        Object object = obj.get(key);
        if (object instanceof JSONArray) {
            array = (JSONArray)object;
        } else {
            if (object instanceof JSONObject && ((JSONObject)object).isEmpty()) {
                array = new JSONArray();
            }
            if (object instanceof String) {
                String rawScopes = obj.getString(key);
                StringTokenizer st = new StringTokenizer(rawScopes, " ");
                array = new JSONArray();
                while (st.hasMoreTokens()) {
                    String nextScope = st.nextToken();
                    if (array.contains((Object)nextScope)) continue;
                    array.add((Object)nextScope);
                }
            }
        }
        return array;
    }

    protected OA2Client processRegistrationRequest(JSONObject jsonRequest, AdminClient adminClient, boolean isAnonymous, OA2Client client, String version) {
        return this.updateClient(client, adminClient, isAnonymous, jsonRequest, true, version);
    }

    protected void fireMessage(boolean isAnonymous, OA2SE oa2SE, HashMap<String, String> replacements) {
        if (isAnonymous) {
            oa2SE.getMailUtil().sendMessage(this.anonSubjectTemplate, this.anonMessageTemplate, replacements, oa2SE.getNotifyACEventEmailAddresses());
        } else {
            oa2SE.getMailUtil().sendMessage(this.subjectTemplate, this.messageTemplate, replacements, oa2SE.getNotifyACEventEmailAddresses());
        }
    }

    public JWKUtil2 getJwkUtil() {
        if (this.jwkUtil == null) {
            this.jwkUtil = new JWKUtil2();
        }
        return this.jwkUtil;
    }

    public void setJwkUtil(JWKUtil2 jwkUtil) {
        this.jwkUtil = jwkUtil;
    }
}

