/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import java.util.List;
import java.util.Map;
import org.oa4mp.delegation.common.services.DoubleDispatchServer;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.services.Response;
import org.oa4mp.delegation.common.services.Server;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionException;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDRequest;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public abstract class AbstractDDServer
implements DoubleDispatchServer,
Server {
    protected OA2SE cose;

    public AbstractDDServer(OA2SE cose) {
        this.cose = cose;
    }

    public Response process(Request request) {
        return request.process((Server)this);
    }

    protected OA2Client subset(OA2Client client, List<String> attributes) {
        ColumnMap map = new ColumnMap();
        this.cose.getClientStore().getXMLConverter().toMap((Identifiable)client, (Map)map);
        ColumnMap reducedMap = new ColumnMap();
        for (String key : attributes) {
            reducedMap.put(key, map.get((Object)key));
        }
        reducedMap.put(this.cose.getClientStore().getMapConverter().getKeys().identifier(new String[0]), (Object)client.getIdentifierString());
        OA2Client x = (OA2Client)this.cose.getClientStore().getMapConverter().fromMap((ConversionMap)reducedMap, null);
        return x;
    }

    protected AdminClient subset(AdminClient client, List<String> attributes) {
        ColumnMap map = new ColumnMap();
        this.cose.getAdminClientStore().getMapConverter().toMap((Identifiable)client, (ConversionMap)map);
        ColumnMap reducedMap = new ColumnMap();
        for (String key : attributes) {
            reducedMap.put(key, map.get((Object)key));
        }
        reducedMap.put(this.cose.getClientStore().getMapConverter().getKeys().identifier(new String[0]), (Object)client.getIdentifierString());
        AdminClient x = (AdminClient)this.cose.getAdminClientStore().getMapConverter().fromMap((ConversionMap)reducedMap, null);
        return x;
    }

    protected void canRead(AbstractDDRequest request) {
        if (request.getAdminClient() != null) {
            this.isACApproved(request);
            this.getPermissions(request).canRead();
        }
        if (request.getClient() == null) {
            throw new PermissionException("Missing client.");
        }
    }

    protected void canWrite(AbstractDDRequest request) {
        if (request.getAdminClient() != null) {
            this.isACApproved(request);
            this.getPermissions(request).canWrite();
        }
        if (request.getClient() == null) {
            throw new PermissionException("Missing client.");
        }
    }

    protected void isACApproved(AbstractDDRequest request) {
        if (!this.getClientApprovalStore().isApproved(request.adminClient.getIdentifier())) {
            throw new UnapprovedClientException("This admin client is not approved", (BaseClient)request.adminClient);
        }
    }

    protected void canApprove(AbstractDDRequest request) {
        if (request.getAdminClient() != null) {
            this.isACApproved(request);
            this.getPermissions(request).canApprove();
        }
        if (request.getClient() == null) {
            throw new PermissionException("Missing client.");
        }
    }

    protected void canDelete(AbstractDDRequest request) {
        if (request.getAdminClient() != null) {
            this.isACApproved(request);
            this.getPermissions(request).canDelete();
        }
        if (request.getClient() == null) {
            throw new PermissionException("Missing client.");
        }
    }

    protected void canCreate(AbstractDDRequest request) {
        this.isACApproved(request);
        this.getPermissions(request).canCreate();
    }

    protected PermissionList getPermissions(AbstractDDRequest request) {
        return this.cose.getPermissionStore().get(request.adminClient.getIdentifier(), request.client.getIdentifier());
    }

    protected ClientStore getClientStore() {
        return this.cose.getClientStore();
    }

    protected ClientApprovalStore getClientApprovalStore() {
        return this.cose.getClientApprovalStore();
    }

    protected PermissionsStore<Permission> getPermissionStore() {
        return this.cose.getPermissionStore();
    }

    protected AdminClientStore<AdminClient> getAdminClientStore() {
        return this.cose.getAdminClientStore();
    }
}

