/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.things.SAT;
import org.oa4mp.server.api.admin.things.SATFactory;
import org.oa4mp.server.api.admin.things.actions.Action;
import org.oa4mp.server.api.admin.things.actions.ActionAdd;
import org.oa4mp.server.api.admin.things.actions.ActionApprove;
import org.oa4mp.server.api.admin.things.actions.ActionCreate;
import org.oa4mp.server.api.admin.things.actions.ActionGet;
import org.oa4mp.server.api.admin.things.actions.ActionList;
import org.oa4mp.server.api.admin.things.actions.ActionRemove;
import org.oa4mp.server.api.admin.things.actions.ActionSet;
import org.oa4mp.server.api.admin.things.actions.ActionUnapprove;
import org.oa4mp.server.api.admin.things.actions.MissingAction;
import org.oa4mp.server.api.admin.things.types.Type;
import org.oa4mp.server.api.admin.things.types.TypeAdmin;
import org.oa4mp.server.api.admin.things.types.TypeAttribute;
import org.oa4mp.server.api.admin.things.types.TypeClient;
import org.oa4mp.server.api.admin.things.types.TypePermission;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDRequest;
import org.oa4mp.server.loader.oauth2.cm.util.admin.ACGetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeRemoveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeSetClientRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.ApproveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.CreateRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.GetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.RemoveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.UnapproveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.AddClientRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListAdminsRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListClientsRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.PermissionRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.RemoveClientRequest;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public class RequestFactory
implements SAT {
    public static AbstractDDRequest convertToRequest(JSONObject json) {
        AbstractDDRequest req = null;
        Action action = SATFactory.getMethod((JSONObject)json);
        if (action instanceof MissingAction) {
            throw new GeneralException("Error: no valid method found");
        }
        Type type = SATFactory.getType((JSONObject)json);
        BaseClient target = SATFactory.getTarget((JSONObject)json);
        switch (SATFactory.getSubjectValue((JSONObject)json)) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new GeneralException("Unknown subject type");
            }
        }
        return req;
    }

    public static AbstractDDRequest createRequest(RequestObject ro) {
        return RequestFactory.createRequest((BaseClient)ro.adminClient, ro.type, ro.action, (BaseClient)ro.client, ro.content);
    }

    public Parameter[] convertObjectsToParameters(Object[] objArray) {
        Parameter[] paramArray = new Parameter[objArray.length];
        int i = 0;
        for (Object obj : objArray) {
            try {
                Constructor cons = Parameter.class.getConstructor(obj.getClass());
                paramArray[i++] = (Parameter)cons.newInstance(obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("This method can't handle objects of type: " + String.valueOf(obj.getClass()), e);
            }
        }
        return paramArray;
    }

    public static AbstractDDRequest createRequest(BaseClient b, Type t, Action a, BaseClient c, JSON x) {
        throw new NFWException("Error: If this is invoked, it is because Java is not resolving its overloaded classes right.");
    }

    public static AttributeGetRequest createRequest(AdminClient aSubj, TypeAttribute typeAttribute, ActionGet actionGet, OA2Client cTarget, JSON content) {
        if (!content.isArray()) {
            throw new GeneralException("Content must be a list of attributes to get");
        }
        JSONArray array = (JSONArray)content;
        String[] arrayString = (String[])array.toArray((Object[])new String[array.size()]);
        return new AttributeGetRequest(aSubj, cTarget, Arrays.asList(arrayString));
    }

    public static AttributeSetClientRequest createRequest(AdminClient aSubj, TypeAttribute typeAttribute, ActionSet actionSet, OA2Client cTarget, JSON content) {
        if (content.isArray()) {
            throw new GeneralException("Content must be a map of attributes to set");
        }
        return new AttributeSetClientRequest(aSubj, cTarget, (Map<String, Object>)((JSONObject)content));
    }

    public static AttributeRemoveRequest createRequest(AdminClient aSubj, TypeAttribute typeAttribute, ActionRemove actionRemove, OA2Client cTarget, JSON content) {
        if (!content.isArray()) {
            throw new GeneralException("Content must be a list of attributes to get");
        }
        JSONArray array = (JSONArray)content;
        String[] arrayString = (String[])array.toArray((Object[])new String[array.size()]);
        return new AttributeRemoveRequest(aSubj, cTarget, Arrays.asList(arrayString));
    }

    public static AddClientRequest createRequest(AdminClient adminClient, TypePermission typeP, ActionAdd acreate, OA2Client client, JSON json) {
        return new AddClientRequest(adminClient, client);
    }

    public static RemoveClientRequest createRequest(AdminClient adminClient, TypePermission typeP, ActionRemove actionRemove, OA2Client client, JSON json) {
        return new RemoveClientRequest(adminClient, client);
    }

    public static PermissionRequest createRequest(AdminClient adminClient, TypePermission typeP, ActionList aList, OA2Client client, JSON json) {
        if (client == null) {
            return new ListClientsRequest(adminClient, client);
        }
        if (adminClient == null) {
            return new ListAdminsRequest(adminClient, client);
        }
        throw new GeneralException("inconsistent arguments for list request");
    }

    public static ApproveRequest createRequest(AdminClient adminClient, TypeClient typeClient, ActionApprove actionApprove, OA2Client client, JSON json) {
        return new ApproveRequest(adminClient, client, (Map<String, Object>)((JSONObject)json));
    }

    public static UnapproveRequest createRequest(AdminClient adminClient, TypeClient typeClient, ActionUnapprove actionUnapprove, OA2Client client, JSON json) {
        return new UnapproveRequest(adminClient, client, (Map<String, Object>)((JSONObject)json));
    }

    public static CreateRequest createRequest(AdminClient adminClient, TypeClient typeClient, ActionCreate actionCreate, OA2Client client, JSON json) {
        if (json.isArray()) {
            throw new IllegalArgumentException("Error: cannot create a client from a JSON array -- it must be an map (JSON object) of key/value pairs");
        }
        return new CreateRequest(adminClient, client, (Map<String, Object>)((JSONObject)json));
    }

    public static RemoveRequest createRequest(AdminClient adminClient, TypeClient typeClient, ActionRemove actionRemove, OA2Client client, JSON json) {
        return new RemoveRequest(adminClient, client);
    }

    public static GetRequest createRequest(AdminClient adminClient, TypeClient typeClient, ActionGet actionGet, OA2Client client, JSON json) {
        return new GetRequest(adminClient, client);
    }

    public static ACGetRequest createRequest(AdminClient adminClient, TypeAdmin typeClient, ActionGet actionGet, OA2Client client, JSON json) {
        return new ACGetRequest(adminClient);
    }

    public static class RequestObject {
        public AdminClient adminClient;
        public OA2Client client;
        public Type type;
        public Action action;
        public JSON content;
    }
}

