/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.services.Response;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.util.admin.ACGetResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeAdminClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetAdminClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.ClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.CreateResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.GetResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.AddClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListAdminsResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.PermissionResponse;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;

public class ResponseSerializer {
    OA2SE cose;

    public ResponseSerializer(OA2SE cose) {
        this.cose = cose;
    }

    public void serialize(Response response, HttpServletResponse servletResponse) throws IOException {
        if (response instanceof GetResponse) {
            this.serialize((GetResponse)response, servletResponse);
            return;
        }
        if (response instanceof CreateResponse) {
            this.serialize((CreateResponse)response, servletResponse);
            return;
        }
        if (response instanceof ListClientResponse) {
            this.serialize((ListClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof ListAdminsResponse) {
            this.serialize((ListAdminsResponse)response, servletResponse);
            return;
        }
        if (response instanceof ClientResponse) {
            this.serialize((ClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof AttributeGetClientResponse) {
            this.serialize((AttributeGetClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof AttributeClientResponse) {
            this.serialize((AttributeClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof ACGetResponse) {
            this.serialize((ACGetResponse)response, servletResponse);
            return;
        }
        if (response instanceof AttributeGetAdminClientResponse) {
            this.serialize((AttributeGetAdminClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof AttributeAdminClientResponse) {
            this.serialize((AttributeAdminClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof AddClientResponse) {
            this.serialize((AddClientResponse)response, servletResponse);
            return;
        }
        if (response instanceof PermissionResponse) {
            this.serialize((PermissionResponse)response, servletResponse);
            return;
        }
        throw new NotImplementedException("Serialization of this response is not implemented yet");
    }

    protected void serialize(PermissionResponse response, HttpServletResponse servletResponse) throws IOException {
        this.ok(servletResponse);
    }

    protected void serialize(ClientResponse response, HttpServletResponse servletResponse) throws IOException {
        this.ok(servletResponse);
    }

    protected void serialize(AttributeGetClientResponse response, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        OA2ClientConverter clientConverter = (OA2ClientConverter)this.cose.getClientStore().getMapConverter();
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        OA2ClientKeys keys = (OA2ClientKeys)clientConverter.getKeys();
        List<String> allKeys = keys.allKeys();
        allKeys.remove(keys.secret(new String[0]));
        OA2Client newClient = (OA2Client)clientConverter.subset((Identifiable)response.getClient(), response.getAttributes());
        JSONObject jsonClient = new JSONObject();
        clientConverter.toJSON(newClient, jsonClient);
        if (jsonClient.getJSONObject(clientConverter.getJSONComponentName()).containsKey((Object)keys.cfg(new String[0]))) {
            jsonClient.put((Object)keys.cfg(new String[0]), (Object)jsonClient.getJSONObject(clientConverter.getJSONComponentName()).getJSONObject(keys.cfg(new String[0])));
            jsonClient.getJSONObject(clientConverter.getJSONComponentName()).remove(keys.cfg(new String[0]));
        }
        json.put((Object)"content", (Object)jsonClient);
        pw.println(json);
    }

    protected void serialize(AttributeGetAdminClientResponse response, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        JSONObject json = new JSONObject();
        AdminClientConverter adminClientConverter = (AdminClientConverter)this.cose.getAdminClientStore().getMapConverter();
        json.put((Object)"status", (Object)0);
        AdminClientKeys keys = (AdminClientKeys)adminClientConverter.getKeys();
        List allKeys = keys.allKeys();
        allKeys.remove(keys.secret(new String[0]));
        AdminClient newClient = (AdminClient)adminClientConverter.subset((Identifiable)response.getAdminClient(), response.getAttributes());
        JSONObject jsonClient = new JSONObject();
        adminClientConverter.toJSON(newClient, jsonClient);
        json.put((Object)"content", (Object)jsonClient);
        pw.println(json);
    }

    protected void serialize(AttributeClientResponse response, HttpServletResponse servletResponse) throws IOException {
        this.ok(servletResponse);
    }

    protected void serialize(AttributeAdminClientResponse response, HttpServletResponse servletResponse) throws IOException {
        this.ok(servletResponse);
    }

    private void ok(HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        pw.println(json);
    }

    protected void serialize(ListClientResponse response, HttpServletResponse servletResponse) throws IOException {
        JSONArray clientIDs = new JSONArray();
        if (response.getClients() != null) {
            for (OA2Client client : response.getClients()) {
                clientIDs.add((Object)client.getIdentifierString());
            }
        }
        PrintWriter pw = servletResponse.getWriter();
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        json.put((Object)"content", (Object)clientIDs);
        pw.println(json);
    }

    protected void serialize(ListAdminsResponse response, HttpServletResponse servletResponse) throws IOException {
        JSONArray adminIDs = new JSONArray();
        if (response.getAdmins() != null) {
            for (AdminClient client : response.getAdmins()) {
                adminIDs.add((Object)client.getIdentifierString());
            }
        }
        PrintWriter pw = servletResponse.getWriter();
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        json.put((Object)"content", (Object)adminIDs);
        pw.println(json);
    }

    protected void serialize(GetResponse response, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        if (response.getClient() == null) {
            pw.println("");
            return;
        }
        JSONObject json = this.clientToJSON(response.getClient());
        json.put((Object)"approved", (Object)response.isApproved());
        pw.println(json);
    }

    protected void serialize(ACGetResponse response, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        if (response.getAdminClient() == null) {
            pw.println("");
            return;
        }
        JSONObject json = this.acToJSON(response.getAdminClient());
        json.put((Object)"approved", (Object)response.isApproved());
        pw.println(json);
    }

    private void serializeClient(OA2Client client, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        if (client == null) {
            pw.println("");
        } else {
            JSONObject json = this.clientToJSON(client);
            pw.println(json);
        }
    }

    private JSONObject clientToJSON(OA2Client client) {
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        OA2ClientConverter clientConverter = (OA2ClientConverter)this.cose.getClientStore().getMapConverter();
        OA2ClientKeys keys = (OA2ClientKeys)clientConverter.getKeys();
        List<String> allKeys = keys.allKeys();
        allKeys.remove(keys.secret(new String[0]));
        OA2Client newClient = (OA2Client)clientConverter.subset((Identifiable)client, allKeys);
        JSONObject jsonClient = new JSONObject();
        clientConverter.toJSON(newClient, jsonClient);
        if (jsonClient.getJSONObject(clientConverter.getJSONComponentName()).containsKey((Object)keys.cfg(new String[0]))) {
            jsonClient.put((Object)keys.cfg(new String[0]), (Object)jsonClient.getJSONObject(clientConverter.getJSONComponentName()).getJSONObject(keys.cfg(new String[0])));
            jsonClient.getJSONObject(clientConverter.getJSONComponentName()).remove(keys.cfg(new String[0]));
        }
        json.put((Object)"content", (Object)jsonClient);
        return json;
    }

    private JSONObject acToJSON(AdminClient client) {
        JSONObject json = new JSONObject();
        json.put((Object)"status", (Object)0);
        AdminClientConverter adminClientConverter = (AdminClientConverter)this.cose.getAdminClientStore().getMapConverter();
        AdminClientKeys keys = (AdminClientKeys)adminClientConverter.getKeys();
        List allKeys = keys.allKeys();
        allKeys.remove(keys.secret(new String[0]));
        AdminClient newClient = (AdminClient)adminClientConverter.subset((Identifiable)client, allKeys);
        JSONObject jsonClient = new JSONObject();
        adminClientConverter.toJSON(newClient, jsonClient);
        json.put((Object)"content", (Object)jsonClient);
        return json;
    }

    protected void serialize(CreateResponse response, HttpServletResponse servletResponse) throws IOException {
        PrintWriter pw = servletResponse.getWriter();
        if (response.getClient() == null) {
            pw.println("");
            return;
        }
        JSONObject json = this.clientToJSON(response.getClient());
        json.put((Object)"secret", (Object)response.getSecret());
        servletResponse.getWriter().println(json);
    }
}

