/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util.attributes;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import org.oa4mp.delegation.common.services.Response;
import org.oa4mp.delegation.common.services.Server;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeRemoveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeServer;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeSetClientRequest;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public abstract class AttributeRequest
extends AbstractDDRequest {
    public AttributeRequest(AdminClient adminClient, OA2Client client) {
        super(adminClient, client);
    }

    public Response process(Server server) {
        if (server instanceof AttributeServer) {
            AttributeServer attributeServer = (AttributeServer)server;
            if (this instanceof AttributeGetRequest) {
                return attributeServer.get((AttributeGetRequest)this);
            }
            if (this instanceof AttributeSetClientRequest) {
                return attributeServer.set((AttributeSetClientRequest)this);
            }
            if (this instanceof AttributeRemoveRequest) {
                return attributeServer.remove((AttributeRemoveRequest)this);
            }
            throw new GeneralException("Action not supported");
        }
        throw new NFWException("Incorrect server is invoking this method. Expected an AttributeServer and got a " + server.getClass().getSimpleName());
    }
}

