/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util.attributes;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.services.Response;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDServer;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeAdminClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetAdminClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeGetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeRemoveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.attributes.AttributeSetClientRequest;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;

public class AttributeServer
extends AbstractDDServer {
    public AttributeServer(OA2SE cose) {
        super(cose);
    }

    public Response get(AttributeGetRequest request) {
        if (request.getClient() != null) {
            return this.getClientAttributes(request);
        }
        if (request.hasAdminClient()) {
            return this.getAdminClientAttributes(request);
        }
        throw new GeneralException("Error: No admin client");
    }

    protected AttributeClientResponse getClientAttributes(AttributeGetRequest request) {
        this.canRead(request);
        OA2Client fullclient = (OA2Client)((Object)this.getClientStore().get((Object)request.getClient().getIdentifier()));
        AttributeGetClientResponse response = new AttributeGetClientResponse(this.subset(fullclient, request.attributes), request.attributes);
        return response;
    }

    protected AttributeGetAdminClientResponse getAdminClientAttributes(AttributeGetRequest request) {
        AdminClient adminClient = (AdminClient)this.getAdminClientStore().get((Object)request.getAdminClient().getIdentifier());
        AttributeGetAdminClientResponse response = new AttributeGetAdminClientResponse(this.subset(adminClient, request.attributes), request.attributes);
        return response;
    }

    protected OA2ClientConverter getClientConverter() {
        return (OA2ClientConverter)this.cose.getClientStore().getMapConverter();
    }

    protected AdminClientConverter getACConverter() {
        return (AdminClientConverter)this.cose.getAdminClientStore().getMapConverter();
    }

    public Response set(AttributeSetClientRequest request) {
        if (request.hasClient()) {
            return this.setClientAttribute(request);
        }
        if (request.hasAdminClient()) {
            return this.setAdminClientAttribute(request);
        }
        throw new GeneralException("Error: Neither client nor admin given.");
    }

    protected AttributeClientResponse setClientAttribute(AttributeSetClientRequest request) {
        this.canWrite(request);
        OA2Client client = (OA2Client)((Object)this.getClientStore().get((Object)request.getClient().getIdentifier()));
        OA2ClientConverter clientConverter = this.getClientConverter();
        ColumnMap map = new ColumnMap();
        clientConverter.toMap(client, (ConversionMap<String, Object>)map);
        for (String key : request.getAttributes().keySet()) {
            if (!key.equals(this.getClientConverter().getKeys().identifier(new String[0]))) {
                map.put(key, request.getAttributes().get(key));
            }
            if (!key.equalsIgnoreCase(clientConverter.getCK2().secret(new String[0]))) continue;
            String secret = DigestUtils.sha1Hex((String)String.valueOf(request.getAttributes().get(key)));
            map.put(key, (Object)secret);
        }
        Client updatedClient = this.getClientConverter().fromMap((ConversionMap<String, Object>)map, null);
        this.getClientStore().save(updatedClient);
        AttributeClientResponse attributeClientResponse = new AttributeClientResponse(updatedClient);
        return attributeClientResponse;
    }

    protected AttributeAdminClientResponse setAdminClientAttribute(AttributeSetClientRequest request) {
        AdminClient client = (AdminClient)this.getAdminClientStore().get((Object)request.getAdminClient().getIdentifier());
        ColumnMap map = new ColumnMap();
        this.getACConverter().toMap(client, (ConversionMap)map);
        for (String key : request.getAttributes().keySet()) {
            if (key.equals(this.getACConverter().getKeys().identifier(new String[0]))) continue;
            map.put(key, request.getAttributes().get(key));
        }
        AdminClient updatedClient = this.getACConverter().fromMap((ConversionMap)map, null);
        this.getAdminClientStore().save((Identifiable)updatedClient);
        AttributeAdminClientResponse attributeClientResponse = new AttributeAdminClientResponse(updatedClient);
        return attributeClientResponse;
    }

    public Response remove(AttributeRemoveRequest request) {
        if (request.hasClient()) {
            return this.removeClient(request);
        }
        if (request.hasAdminClient()) {
            return this.removeAdminClient(request);
        }
        throw new GeneralException("Error: No admin client or client");
    }

    protected AttributeClientResponse removeClient(AttributeRemoveRequest request) {
        this.canWrite(request);
        OA2Client client = (OA2Client)((Object)this.getClientStore().get((Object)request.getClient().getIdentifier()));
        ColumnMap map = new ColumnMap();
        this.getClientConverter().toMap(client, (ConversionMap<String, Object>)map);
        for (String key : request.getAttributes()) {
            if (key.equals(this.getClientConverter().getKeys().identifier(new String[0]))) continue;
            map.remove((Object)key);
        }
        Client updatedClient = this.getClientConverter().fromMap((ConversionMap<String, Object>)map, null);
        this.getClientStore().save(updatedClient);
        AttributeClientResponse attributeClientResponse = new AttributeClientResponse(updatedClient);
        return attributeClientResponse;
    }

    protected AttributeAdminClientResponse removeAdminClient(AttributeRemoveRequest request) {
        AdminClient client = (AdminClient)this.getAdminClientStore().get((Object)request.getAdminClient().getIdentifier());
        ColumnMap map = new ColumnMap();
        this.getACConverter().toMap(client, (ConversionMap)map);
        for (String key : request.getAttributes()) {
            if (key.equals(this.getACConverter().getKeys().identifier(new String[0]))) continue;
            map.remove((Object)key);
        }
        AdminClient updatedClient = this.getACConverter().fromMap((ConversionMap)map, null);
        this.getAdminClientStore().save((Identifiable)updatedClient);
        AttributeAdminClientResponse attributeClientResponse = new AttributeAdminClientResponse(updatedClient);
        return attributeClientResponse;
    }
}

