/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util.client;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.things.actions.ActionAdd;
import org.oa4mp.server.api.admin.things.types.TypePermission;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDServer;
import org.oa4mp.server.loader.oauth2.cm.util.RequestFactory;
import org.oa4mp.server.loader.oauth2.cm.util.client.ApproveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.ClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.CreateRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.CreateResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.GetRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.GetResponse;
import org.oa4mp.server.loader.oauth2.cm.util.client.RemoveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.client.UnapproveRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.PermissionServer;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientApprovalKeys;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;

public class ClientServer
extends AbstractDDServer {
    SecureRandom random = new SecureRandom();

    public ClientServer(OA2SE cose) {
        super(cose);
    }

    public ClientResponse approve(ApproveRequest request) {
        this.canApprove(request);
        Identifier id = request.getClient().getIdentifier();
        ClientApproval approval = null;
        OA2ClientApprovalKeys keys = new OA2ClientApprovalKeys();
        if (this.getClientApprovalStore().containsKey((Object)id)) {
            approval = (ClientApproval)this.getClientApprovalStore().get((Object)id);
        } else {
            approval = (ClientApproval)this.getClientApprovalStore().create();
            approval.setIdentifier(id);
        }
        if (request.getAttributes() != null && request.getAttributes().containsKey(keys.approver(new String[0]))) {
            approval.setApprover(String.valueOf(request.getAttributes().get(keys.approver(new String[0]))));
        } else {
            approval.setApprover(request.getAdminClient().getIdentifierString());
        }
        approval.setApproved(true);
        this.getClientApprovalStore().save((Identifiable)approval);
        return new ClientResponse();
    }

    public ClientResponse unapprove(UnapproveRequest request) {
        this.canApprove(request);
        ClientApproval approval = (ClientApproval)this.getClientApprovalStore().get((Object)request.getClient().getIdentifier());
        OA2ClientApprovalKeys keys = new OA2ClientApprovalKeys();
        if (request.getAttributes() != null && request.getAttributes().containsKey(keys.approver(new String[0]))) {
            approval.setApprover(String.valueOf(request.getAttributes().get(keys.approver(new String[0]))));
        } else {
            approval.setApprover(request.getAdminClient().getIdentifierString());
        }
        approval.setApproved(false);
        this.getClientApprovalStore().save((Identifiable)approval);
        return new ClientResponse();
    }

    public CreateResponse create(CreateRequest request) {
        if (request.getAdminClient() != null && (request.getAdminClient().getIdentifier() == null || request.getAdminClient().getIdentifierString().length() == 0)) {
            throw new GeneralException("Error: An admin client was specified, but no identifier for this client was given. Request rejected.");
        }
        if (request.getAdminClient().getMaxClients() < this.getPermissionStore().getClientCount(request.getAdminClient().getIdentifier())) {
            throw new GeneralException("Error: The number of clients the admin with id \"" + request.getAdminClient().getIdentifierString() + "\"  can create, " + request.getAdminClient().getMaxClients() + ", has been exceeded.");
        }
        ColumnMap values = new ColumnMap();
        values.putAll(request.getAttributes());
        OA2ClientKeys keys = (OA2ClientKeys)this.getClientStore().getMapConverter().getKeys();
        OA2Client client = (OA2Client)this.getClientStore().create();
        values.put(keys.identifier(new String[0]), (Object)client.getIdentifier());
        values.put(keys.creationTS(new String[0]), (Object)client.getCreationTS());
        values.put(keys.lastModifiedTS(new String[0]), (Object)client.getLastModifiedTS());
        String secret = null;
        if (values.containsKey((Object)keys.secret(new String[0]))) {
            secret = (String)values.get((Object)keys.secret(new String[0]));
        } else {
            byte[] bytes = new byte[this.cose.getClientSecretLength()];
            this.random.nextBytes(bytes);
            secret = Base64.encodeBase64URLSafeString((byte[])bytes);
        }
        String hash = DigestUtils.sha1Hex((String)secret);
        values.put(keys.secret(new String[0]), (Object)hash);
        this.getClientStore().getMapConverter().fromMap((ConversionMap)values, (Identifiable)client);
        this.getClientStore().save((Identifiable)client);
        if (request.getAdminClient() != null) {
            PermissionServer permissionServer = new PermissionServer(this.cose);
            permissionServer.process(RequestFactory.createRequest(request.getAdminClient(), new TypePermission(), new ActionAdd(), client, null));
        }
        ClientApproval approval = (ClientApproval)this.getClientApprovalStore().create();
        approval.setApproved(false);
        approval.setIdentifier(client.getIdentifier());
        this.getClientApprovalStore().save((Identifiable)approval);
        return new CreateResponse(client, secret);
    }

    public ClientResponse remove(RemoveRequest request) {
        this.canDelete(request);
        Identifier clientID = request.getClient().getIdentifier();
        this.getClientApprovalStore().remove((Object)clientID);
        List admins = this.getPermissionStore().getAdmins(clientID);
        for (Identifier adminID : admins) {
            PermissionList permissions = this.getPermissionStore().get(adminID, clientID);
            for (Permission p : permissions) {
                this.getPermissionStore().remove((Object)p.getIdentifier());
            }
        }
        this.getClientStore().remove((Object)clientID);
        return new ClientResponse();
    }

    public ClientResponse get(GetRequest request) {
        this.canRead(request);
        OA2Client client = (OA2Client)((Object)this.getClientStore().get((Object)request.getClient().getIdentifier()));
        client.setSecret("");
        return new GetResponse(client, this.cose.getClientApprovalStore().isApproved(client.getIdentifier()));
    }
}

