/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.cm.util.permissions;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.util.LinkedList;
import java.util.List;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.cm.util.AbstractDDServer;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.AddClientRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.AddClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListAdminsRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListAdminsResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListClientResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.ListClientsRequest;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.PermissionResponse;
import org.oa4mp.server.loader.oauth2.cm.util.permissions.RemoveClientRequest;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public class PermissionServer
extends AbstractDDServer {
    public PermissionServer(OA2SE cose) {
        super(cose);
    }

    public PermissionResponse listAdmins(ListAdminsRequest request) {
        List adminIDs = this.getPermissionStore().getAdmins(request.getClient().getIdentifier());
        LinkedList<AdminClient> admins = new LinkedList<AdminClient>();
        for (Identifier id : adminIDs) {
            try {
                this.getPermissionStore().get(id, request.getClient().getIdentifier());
                admins.add((AdminClient)this.getAdminClientStore().get((Object)id));
            }
            catch (Throwable throwable) {}
        }
        return new ListAdminsResponse(admins);
    }

    public PermissionResponse listClients(ListClientsRequest request) {
        List clientIDs = this.getPermissionStore().getClients(request.getAdminClient().getIdentifier());
        LinkedList<OA2Client> clients = new LinkedList<OA2Client>();
        for (Identifier id : clientIDs) {
            try {
                this.getPermissionStore().get(request.getAdminClient().getIdentifier(), id);
                clients.add((OA2Client)((Object)this.getClientStore().get((Object)id)));
            }
            catch (Throwable throwable) {}
        }
        return new ListClientResponse(clients);
    }

    public PermissionResponse removeClient(RemoveClientRequest request) {
        this.canWrite(request);
        PermissionList permissionList = this.getPermissionStore().get(request.getAdminClient().getIdentifier(), request.getClient().getIdentifier());
        for (Permission p : permissionList) {
            this.getPermissionStore().remove((Object)p.getIdentifier());
        }
        return new PermissionResponse();
    }

    public PermissionResponse addClient(AddClientRequest request) {
        Permission p = null;
        PermissionList pList = this.getPermissionStore().get(request.getAdminClient().getIdentifier(), request.getClient().getIdentifier());
        switch (pList.size()) {
            case 0: {
                p = (Permission)this.getPermissionStore().create();
                break;
            }
            case 1: {
                p = (Permission)pList.get(0);
                break;
            }
            default: {
                throw new GeneralException("Internal error. Multiple permissiions entries found");
            }
        }
        p.setAdminID(request.getAdminClient().getIdentifier());
        p.setClientID(request.getClient().getIdentifier());
        p.setApprove(true);
        p.setCreate(true);
        p.setDelete(true);
        p.setRead(true);
        p.setWrite(true);
        this.getPermissionStore().save((Identifiable)p);
        return new AddClientResponse();
    }
}

