/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.loader;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.OA2ConfigurationLoaderUtils;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.issuers.AGIssuer;
import org.oa4mp.delegation.server.issuers.ATIssuer;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.server.AGI2;
import org.oa4mp.delegation.server.server.ATI2;
import org.oa4mp.delegation.server.server.PAI2;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.delegation.server.storage.uuc.AbandonedRule;
import org.oa4mp.delegation.server.storage.uuc.GPRule;
import org.oa4mp.delegation.server.storage.uuc.ListRule;
import org.oa4mp.delegation.server.storage.uuc.RuleFilter;
import org.oa4mp.delegation.server.storage.uuc.UUCConfiguration;
import org.oa4mp.delegation.server.storage.uuc.UnusedRule;
import org.oa4mp.server.api.ClientApprovalProvider;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClientStoreProviders;
import org.oa4mp.server.api.admin.adminClient.MultiDSAdminClientStoreProvider;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.api.admin.transactions.DSTransactionProvider;
import org.oa4mp.server.api.admin.transactions.OA4MPIdentifierProvider;
import org.oa4mp.server.api.storage.MultiDSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.MultiDSClientStoreProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientStoreProvider;
import org.oa4mp.server.api.storage.servlet.AbstractConfigurationLoader;
import org.oa4mp.server.api.storage.sql.provider.DSSQLClientApprovalStoreProvider;
import org.oa4mp.server.api.util.ClientApprovalMemoryStore;
import org.oa4mp.server.api.util.ClientApproverConverter;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimsSource;
import org.oa4mp.server.loader.oauth2.cm.CM7591Config;
import org.oa4mp.server.loader.oauth2.cm.CMConfig;
import org.oa4mp.server.loader.oauth2.cm.CMConfigs;
import org.oa4mp.server.loader.oauth2.servlet.DIServiceConfig;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628ServletConfig;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientMemoryStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientProvider;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientSQLStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2FSTStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2MTStore;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2MultiTypeTransactionProvider;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2SQLTransactionStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TConverter;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.SQLTXRStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.tx.TXFSProvider;
import org.oa4mp.server.loader.oauth2.storage.tx.TXMemoryStore;
import org.oa4mp.server.loader.oauth2.storage.tx.TXMultiStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordConverter;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordProvider;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordSerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;
import org.oa4mp.server.loader.oauth2.storage.vi.SQLVIStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.vi.VIConverter;
import org.oa4mp.server.loader.oauth2.storage.vi.VIFSProvider;
import org.oa4mp.server.loader.oauth2.storage.vi.VIMemoryStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VIMultiStoreProvider;
import org.oa4mp.server.loader.oauth2.storage.vi.VIProvider;
import org.oa4mp.server.loader.oauth2.storage.vi.VISerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.qdl.scripting.OA2QDLConfigurationLoader;
import org.oa4mp.server.loader.qdl.scripting.OA2QDLEnvironment;

public class OA2ConfigurationLoader<T extends ServiceEnvironmentImpl>
extends AbstractConfigurationLoader<T> {
    public static final String STRICT_ACLS = "strict_acls";
    public static final String SAFE_GARBAGE_COLLECTION = "safe_gc";
    public static final String PRINT_TS_IN_DEBUG = "printTSInDebug";
    public static final String NOTIFY_ADMIN_CLIENT_ADDRESSES = "notifyACEmailAddresses";
    public static final String CLEANUP_INTERVAL_TAG = "cleanupInterval";
    public static final String CLEANUP_ALARMS_TAG = "cleanupAlarms";
    public static final String CLEANUP_LOCKING_ENABLED = "cleanupLockingEnabled";
    public static final String CLEANUP_FAIL_ON_ERRORS = "cleanupFailOnErrors";
    public static final String ALLOW_PROMPT_NONE = "allowPromptNone";
    public static final String MONITOR_ENABLED = "monitorEnable";
    public static final String MONITOR_INTERVAL = "monitorInterval";
    public static final String MONITOR_ALARMS = "monitorAlarms";
    public static final String UUC_ALARMS = "alarms";
    public static final String UUC_BLACKLIST = "blacklist";
    public static final String UUC_DELETE_VERSION_FLAG = "deleteVersions";
    public static final String UUC_DEBUG_ON = "debug";
    public static final String UUC_ENABLED = "enabled";
    public static final String UUC_GRACE_PERIOD = "gracePeriod";
    public static final String UUC_INTERVAL = "interval";
    public static final String UUC_LAST_ACCESSED_NEVER = "lastAccessedNever";
    public static final String UUC_LIST_ITEM = "clientID";
    public static final String UUC_LIST_REGEX = "regex";
    public static final String UUC_CREATED_AFTER = "createdAfter";
    public static final String UUC_ACTION_TAG = "action";
    public static final String UUC_TAG = "unusedClientCleanup";
    public static final String UUC_TEST_MODE_ON = "testModeOn";
    public static final String UUC_WHITELIST = "whitelist";
    public static final String UUC_FILTER_TAG = "filter";
    public static final String UUC_FILTER_ALLOW_OVERRIDE = "allowOverride";
    public static final String UUC_FILTER_VERSION = "version";
    public static final String UUC_FILTER_DATE = "date";
    public static final String UUC_FILTER_DATE_WHEN = "when";
    public static final String UUC_FILTER_DATE_TYPE = "type";
    public static final String UUC_FILTER_DATE_VALUE = "value";
    public static final String UUC_RULE_UNUSED_GRACE_PERIOD = "gracePeriod";
    public static final String UUC_RULE_UNUSED_TAG = "unused";
    public static final String UUC_RULE_ABANDONED_TAG = "abandoned";
    public static final String RFC7636_REQUIRED_TAG = "rfc7636Required";
    public static final String DEMO_MODE_TAG = "demoModeEnabled";
    public static final String QDL_CONFIG_NAME_ATTR = "qdlConfigName";
    public static final String QDL_DEFAULT_CONFIGURATION_NAME = "qdl-default";
    public static long REFRESH_TOKEN_LIFETIME_DEFAULT = 1296000000L;
    public static long MAX_REFRESH_TOKEN_LIFETIME_DEFAULT = 2L * REFRESH_TOKEN_LIFETIME_DEFAULT;
    public static long ACCESS_TOKEN_LIFETIME_DEFAULT = 900000L;
    public static long MAX_ACCESS_TOKEN_LIFETIME_DEFAULT = 2L * ACCESS_TOKEN_LIFETIME_DEFAULT;
    public static long ID_TOKEN_LIFETIME_DEFAULT = 900000L;
    public static long MAX_ID_TOKEN_LIFETIME_DEFAULT = MAX_ACCESS_TOKEN_LIFETIME_DEFAULT;
    public static long AUTHORIZATION_GRANT_LIFETIME_DEFAULT = 900000L;
    public static long MAX_AUTHORIZATION_GRANT_LIFETIME_DEFAULT = 2L * AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
    public static String REFRESH_TOKEN_GRACE_PERIOD_TAG = "rtGracePeriod";
    public static long REFRESH_TOKEN_GRACE_PERIOD_DEFAULT = 21600000L;
    public static long REFRESH_TOKEN_GRACE_PERIOD_DISABLED = -1L;
    public static long REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT = -2L;
    public static long REFRESH_TOKEN_GRACE_PERIOD_NOT_CONFIGURED = -3L;
    public static int CLIENT_SECRET_LENGTH_DEFAULT = 258;
    public static long CLEANUP_INTERVAL_DEFAULT = 1800000L;
    public static boolean CLEANUP_LOCKING_ENABLED_DEFAULT = false;
    public static boolean CLEANUP_FAIL_ON_ERRORS_DEFAULT = true;
    public static boolean MONITOR_ENABLED_DEFAULT = false;
    public static long UUC_INTERVAL_DEFAULT = 21600000L;
    public static long UUC_GRACE_PERIOD_DEFAULT = 21600000L;
    public static long MONITOR_INTERVAL_DEFAULT = 0x6DDD00L;
    RFC8628ServletConfig rfc8628ServletConfig = null;
    Collection<LocalTime> cleanupAlarms = null;
    Collection<LocalTime> monitorAlarms = null;
    String notifyACEventEmailAddresses = null;
    protected Boolean rfc7636Required = null;
    protected Boolean printTSInDebug = false;
    Boolean demoModeEnabled = null;
    Boolean allowPromptNone = null;
    String qdlConfigurationName = null;
    long cleanupInterval = -1L;
    long monitorInterval = -1L;
    UUCConfiguration uucConfiguration = null;
    Boolean cleanupLockingEnabled = null;
    Boolean cleanupFailOnErrors = null;
    Boolean monitorEnabled = null;
    Boolean safeGC = null;
    boolean qdlStrictACLS = false;
    HashMap<String, String> constants;
    Boolean utilServerEnabled = null;
    Boolean rfc8693Enabled = null;
    Boolean ccfEnabled = null;
    Boolean rfc8628Enabled = null;
    CMConfigs cmConfigs;
    protected MultiDSAdminClientStoreProvider macp;
    Provider<AGIssuer> agip = null;
    long rtGracePeriod = REFRESH_TOKEN_GRACE_PERIOD_NOT_CONFIGURED;
    long agLifetime = -1L;
    long idTokenLifetime = -1L;
    long maxIDTokenLifetime = -1L;
    long atLifetime = -1L;
    long rtLifetime = -1L;
    long maxAGLifetime = -1L;
    long maxATLifetime = -1L;
    long maxRTLifetime = -1L;
    String issuer = null;
    long maxClientRefreshTokenLifetime = -1L;
    Boolean oidcEnabled = null;
    Boolean twoFactorSupportEnabled = null;
    Boolean refreshTokenEnabled = null;
    Collection<String> scopes = null;
    protected ClaimSource claimSource;
    LDAPConfiguration ldapConfiguration;
    int clientSecretLength = -1;
    Provider<VIStore> voStoreProvider;
    Provider<TXStore> txStoreProvider;
    DIServiceConfig DIServiceConfig = null;

    public OA2ConfigurationLoader(ConfigurationNode node) {
        super(node);
    }

    public OA2ConfigurationLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public T createInstance() {
        try {
            this.initialize();
            OA2SE se = new OA2SE(this.getMyLogger(), this.getTransactionStoreProvider(), this.getTXStoreProvider(), this.getVOStoreProvider(), this.getClientStoreProvider(), this.getMaxAllowedNewClientRequests(), this.getAGLifetime(), this.getMaxAGLifetime(), this.getIDTokenLifetime(), this.getMaxIDTokenLifetime(), this.getMaxATLifetime(), this.getATLifetime(), this.getRTLifetime(), this.getMaxRTLifetime(), this.getClientApprovalStoreProvider(), this.getMailUtilProvider(), this.getMP(), this.getAGIProvider(), this.getATIProvider(), this.getPAIProvider(), this.getTokenForgeProvider(), this.getConstants(), this.getAuthorizationServletConfig(), this.getUsernameTransformer(), this.getPingable(), (Provider<PermissionsStore>)this.getMpp(), (Provider<AdminClientStore>)this.getMacp(), this.getClientSecretLength(), this.getScopes(), this.getClaimSource(), this.getLdapConfiguration(), this.isRefreshTokenEnabled(), this.isTwoFactorSupportEnabled(), this.getMaxClientRefreshTokenLifetime(), this.getJSONWebKeys(), this.getIssuer(), this.isUtilServerEnabled(), this.isOIDCEnabled(), this.getCmConfigs(), this.getQDLEnvironment(), this.isRFC8693Enabled(), this.isQdlStrictACLS(), this.isSafeGC(), this.isCleanupLockingEnabled(), this.getCleanupFailOnErrors(), this.getRFC8628ServletConfig(), this.isRFC8628Enabled(), this.isprintTSInDebug(), this.getCleanupInterval(), this.getCleanupAlarms(), this.isNotifyACEventEmailAddresses(), this.isRFC7636Required(), this.isDemoModeEnabled(), this.getRTGracePeriod(), this.isMonitorEnabled(), this.getMonitorInterval(), this.getMonitorAlarms(), this.isCCFEnabled(), this.getDebugger(), this.isAllowPromptNone(), this.getDISerivceConfig());
            if (this.getClaimSource() instanceof BasicClaimsSourceImpl) {
                ((BasicClaimsSourceImpl)this.getClaimSource()).setOa2SE(se);
            }
            return (T)((Object)se);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new GeneralException("Could not create the runtime environment", (Throwable)e);
        }
    }

    public Collection<LocalTime> getAlarms(ConfigurationNode node, String tag) {
        return Configurations.getAlarms((ConfigurationNode)node, (String)tag);
    }

    public Collection<LocalTime> getAlarms(String tag) {
        return Configurations.getAlarms((ConfigurationNode)this.cn, (String)tag);
    }

    public Collection<LocalTime> getMonitorAlarms() {
        if (this.monitorAlarms == null) {
            this.monitorAlarms = this.getAlarms(MONITOR_ALARMS);
        }
        return this.monitorAlarms;
    }

    public Collection<LocalTime> getCleanupAlarms() {
        if (this.cleanupAlarms == null) {
            this.cleanupAlarms = this.getAlarms(CLEANUP_ALARMS_TAG);
        }
        return this.cleanupAlarms;
    }

    public RFC8628ServletConfig getRFC8628ServletConfig() {
        if (this.rfc8628ServletConfig == null) {
            this.rfc8628ServletConfig = new RFC8628ServletConfig();
            List kids = this.cn.getChildren("deviceFlowServlet");
            Object address = this.getServiceAddress().toString();
            if (!((String)address).endsWith("/")) {
                address = (String)address + "/";
            }
            this.rfc8628ServletConfig.deviceEndpoint = (String)address + "device";
            this.rfc8628ServletConfig.deviceAuthorizationEndpoint = (String)address + "device_authorization";
            if (!kids.isEmpty()) {
                String codeChars;
                String separator;
                this.rfc8628Enabled = Boolean.TRUE;
                ConfigurationNode sn = (ConfigurationNode)kids.get(0);
                String x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"verificationURI");
                if (!StringUtils.isTrivial((String)x)) {
                    this.rfc8628ServletConfig.deviceEndpoint = x;
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"authorizationURI")))) {
                    this.rfc8628ServletConfig.deviceAuthorizationEndpoint = x;
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"lifetime")))) {
                    try {
                        this.rfc8628ServletConfig.lifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)UUC_INTERVAL)))) {
                    try {
                        this.rfc8628ServletConfig.interval = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"codeLength")))) {
                    try {
                        this.rfc8628ServletConfig.userCodeLength = Integer.parseInt(x);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isTrivial((String)(separator = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"codeSeparator")))) {
                    this.rfc8628ServletConfig.userCodeSeperator = separator;
                }
                if (!StringUtils.isTrivial((String)(codeChars = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"codeChars")))) {
                    this.rfc8628ServletConfig.codeChars = codeChars.toCharArray();
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"codePeriodLength")))) {
                    try {
                        this.rfc8628ServletConfig.userCodePeriodLength = Integer.parseInt(x);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.rfc8628ServletConfig;
    }

    protected OA2QDLEnvironment getQDLEnvironment() {
        Object x;
        ConfigurationNode node;
        block6: {
            List kids;
            block5: {
                kids = this.cn.getChildren("qdl");
                node = null;
                if (kids.size() != 1) break block5;
                node = (ConfigurationNode)kids.get(0);
                x = Configurations.getFirstAttribute((ConfigurationNode)node, (String)"name");
                if (this.getQdlConfigurationName().equals(x)) break block6;
                DebugUtil.trace((Object)((Object)this), (String)("note that a default QDL configuration of " + this.getQdlConfigurationName() + " was specified, but the actual name of the only configuration was \"\", which was loaded."));
                break block6;
            }
            for (ConfigurationNode tempNode : kids) {
                String x2 = Configurations.getFirstAttribute((ConfigurationNode)tempNode, (String)"name");
                if (!this.getQdlConfigurationName().equals(x2)) continue;
                node = tempNode;
                break;
            }
        }
        if (node == null) {
            return new OA2QDLEnvironment();
        }
        x = Configurations.getFirstAttribute((ConfigurationNode)node, (String)STRICT_ACLS);
        if (!StringUtils.isTrivial((String)x)) {
            try {
                this.qdlStrictACLS = Boolean.parseBoolean((String)x);
            }
            catch (Throwable tempNode) {
                // empty catch block
            }
        }
        OA2QDLConfigurationLoader loader = new OA2QDLConfigurationLoader("(none)", node, this.getMyLogger());
        return (OA2QDLEnvironment)loader.load();
    }

    public String isNotifyACEventEmailAddresses() {
        if (this.notifyACEventEmailAddresses == null) {
            this.notifyACEventEmailAddresses = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)NOTIFY_ADMIN_CLIENT_ADDRESSES);
            DebugUtil.trace((Object)((Object)this), (String)("admin client notification addresses: " + this.notifyACEventEmailAddresses));
        }
        return this.notifyACEventEmailAddresses;
    }

    public Boolean isRFC7636Required() {
        if (this.rfc7636Required == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)RFC7636_REQUIRED_TAG);
            try {
                this.rfc7636Required = Boolean.parseBoolean(raw);
            }
            catch (Throwable t) {
                this.rfc7636Required = Boolean.FALSE;
            }
        }
        return this.rfc7636Required;
    }

    public boolean isprintTSInDebug() {
        if (this.printTSInDebug == null) {
            try {
                this.printTSInDebug = Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)PRINT_TS_IN_DEBUG));
            }
            catch (Throwable t) {
                this.printTSInDebug = Boolean.TRUE;
            }
            DebugUtil.trace((Object)((Object)this), (String)("print TS in debug? " + this.printTSInDebug));
        }
        return this.printTSInDebug;
    }

    public Boolean isDemoModeEnabled() {
        if (this.demoModeEnabled == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)DEMO_MODE_TAG);
            this.demoModeEnabled = StringUtils.isTrivial((String)raw) ? Boolean.FALSE : Boolean.valueOf(Boolean.parseBoolean(raw));
        }
        return this.demoModeEnabled;
    }

    public String getQdlConfigurationName() {
        if (this.qdlConfigurationName == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)QDL_CONFIG_NAME_ATTR);
            this.qdlConfigurationName = StringUtils.isTrivial((String)raw) ? QDL_DEFAULT_CONFIGURATION_NAME : raw;
        }
        return this.qdlConfigurationName;
    }

    public Boolean isAllowPromptNone() {
        if (this.allowPromptNone == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)ALLOW_PROMPT_NONE);
            this.allowPromptNone = raw != null && (raw.equals("true") || raw.equals("on") || raw.equals(UUC_ENABLED)) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.allowPromptNone;
    }

    public long getCleanupInterval() {
        if (this.cleanupInterval < 0L) {
            this.cleanupInterval = this.getInterval(CLEANUP_INTERVAL_TAG, CLEANUP_INTERVAL_DEFAULT);
        }
        return this.cleanupInterval;
    }

    public long getMonitorInterval() {
        if (this.monitorInterval < 0L) {
            this.monitorInterval = this.getInterval(MONITOR_INTERVAL, MONITOR_INTERVAL_DEFAULT);
        }
        return this.monitorInterval;
    }

    public UUCConfiguration getUucConfiguration() {
        return this.NEWgetUUCConfiguration();
    }

    public UUCConfiguration NEWgetUUCConfiguration() {
        if (this.uucConfiguration == null) {
            this.uucConfiguration = new UUCConfiguration();
            ConfigurationNode node = Configurations.getFirstNode((ConfigurationNode)this.cn, (String)UUC_TAG);
            this.uucConfiguration.enabled = Configurations.getFirstBooleanValue((ConfigurationNode)node, (String)UUC_ENABLED, (boolean)false);
            this.uucConfiguration.setDebugOn(Configurations.getFirstBooleanValue((ConfigurationNode)node, (String)UUC_DEBUG_ON, (boolean)false));
            this.uucConfiguration.testMode = Configurations.getFirstBooleanValue((ConfigurationNode)node, (String)UUC_TEST_MODE_ON, (boolean)false);
            String raw = Configurations.getFirstAttribute((ConfigurationNode)node, (String)UUC_INTERVAL);
            this.uucConfiguration.interval = StringUtils.isTrivial((String)raw) ? UUC_INTERVAL_DEFAULT : XMLConfigUtil.getValueSecsOrMillis((String)raw, (boolean)true);
            this.uucConfiguration.alarms = this.getAlarms(node, UUC_ALARMS);
            this.uucConfiguration.setWhiteList(this.createLR(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_WHITELIST), true));
            this.uucConfiguration.setBlackList(this.createLR(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_BLACKLIST), false));
            this.uucConfiguration.setUnusedRule((UnusedRule)this.createGPR(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_RULE_UNUSED_TAG), true));
            this.uucConfiguration.setAbandonedRule((AbandonedRule)this.createGPR(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_RULE_ABANDONED_TAG), false));
            ConfigurationNode filterNode = Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_FILTER_TAG);
            if (filterNode != null) {
                this.uucConfiguration.setFilter(this.getRuleFilter(filterNode));
            }
        }
        return this.uucConfiguration;
    }

    protected ListRule createLR(ConfigurationNode node, boolean isWhiteList) {
        if (node == null) {
            return null;
        }
        ListRule listRule = new ListRule();
        listRule.setBlackList(false);
        List[] outList = this.processUUCList(node);
        listRule.setIdList(outList[0]);
        listRule.setRegexList(outList[1]);
        listRule.setRuleFilter(this.getRuleFilter(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_FILTER_TAG)));
        return listRule;
    }

    protected GPRule createGPR(ConfigurationNode node, boolean isUnused) {
        if (node == null) {
            return null;
        }
        Object gpRule = isUnused ? new UnusedRule() : new AbandonedRule();
        gpRule.setFilter(this.getRuleFilter(Configurations.getFirstNode((ConfigurationNode)node, (String)UUC_FILTER_TAG)));
        gpRule.setAction(Configurations.getFirstAttribute((ConfigurationNode)node, (String)UUC_ACTION_TAG));
        String rawDate = Configurations.getFirstAttribute((ConfigurationNode)node, (String)"gracePeriod");
        if (StringUtils.isTrivial((String)rawDate)) {
            throw new IllegalArgumentException("Missing gracePeriod attribute.");
        }
        gpRule.setGracePeriod(XMLConfigUtil.getValueSecsOrMillis((String)rawDate, (boolean)true).longValue());
        return gpRule;
    }

    protected RuleFilter getRuleFilter(ConfigurationNode node) {
        if (node == null) {
            return null;
        }
        RuleFilter filter = new RuleFilter();
        String raw = Configurations.getFirstAttribute((ConfigurationNode)node, (String)UUC_FILTER_VERSION);
        if (!StringUtils.isTrivial((String)raw)) {
            filter.setVersion(raw);
        }
        raw = Configurations.getFirstAttribute((ConfigurationNode)node, (String)UUC_FILTER_ALLOW_OVERRIDE);
        try {
            filter.setAllowOverride(Boolean.parseBoolean(raw));
        }
        catch (Throwable t) {
            filter.setAllowOverride(true);
        }
        List kids = node.getChildren(UUC_FILTER_DATE);
        for (ConfigurationNode n : kids) {
            String when = Configurations.getFirstAttribute((ConfigurationNode)n, (String)UUC_FILTER_DATE_WHEN);
            String type = Configurations.getFirstAttribute((ConfigurationNode)n, (String)UUC_FILTER_DATE_TYPE);
            String value = Configurations.getFirstAttribute((ConfigurationNode)n, (String)UUC_FILTER_DATE_VALUE);
            filter.add(when, type, value);
        }
        return filter;
    }

    protected List[] processUUCList(ConfigurationNode node) {
        List kidRegex;
        List kids = node.getChildren(UUC_LIST_ITEM);
        ArrayList<Identifier> ids = null;
        ArrayList<String> regex = null;
        if (kids != null && !kids.isEmpty()) {
            ids = new ArrayList<Identifier>();
            for (ConfigurationNode kidNode : kids) {
                ids.add(BasicIdentifier.newID((String)kidNode.getValue().toString()));
            }
        }
        if ((kidRegex = node.getChildren(UUC_LIST_REGEX)) != null && !kidRegex.isEmpty()) {
            regex = new ArrayList<String>();
            for (ConfigurationNode kidNode : kidRegex) {
                regex.add(kidNode.getValue().toString());
            }
        }
        return new List[]{ids, regex};
    }

    public long getInterval(String tag, long defaultInterval) {
        long interval = defaultInterval;
        try {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)tag);
            interval = StringUtils.isTrivial((String)raw) ? CLEANUP_INTERVAL_DEFAULT : XMLConfigUtil.getValueSecsOrMillis((String)raw, (boolean)true);
        }
        catch (Throwable t) {
            interval = CLEANUP_INTERVAL_DEFAULT;
        }
        DebugUtil.trace((Object)((Object)this), (String)(tag + " set to " + interval));
        return interval;
    }

    public Boolean isCleanupLockingEnabled() {
        if (this.cleanupLockingEnabled == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)CLEANUP_LOCKING_ENABLED);
            if (StringUtils.isTrivial((String)raw)) {
                this.cleanupLockingEnabled = CLEANUP_LOCKING_ENABLED_DEFAULT;
            } else {
                try {
                    this.cleanupLockingEnabled = Boolean.parseBoolean(raw);
                }
                catch (Throwable t) {
                    this.cleanupLockingEnabled = CLEANUP_LOCKING_ENABLED_DEFAULT;
                }
            }
            DebugUtil.trace((Object)((Object)this), (String)("cleanupLockingEnabled set to " + this.cleanupLockingEnabled));
        }
        return this.cleanupLockingEnabled;
    }

    public Boolean getCleanupFailOnErrors() {
        if (this.cleanupFailOnErrors == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)CLEANUP_FAIL_ON_ERRORS);
            if (StringUtils.isTrivial((String)raw)) {
                this.cleanupFailOnErrors = CLEANUP_FAIL_ON_ERRORS_DEFAULT;
            } else {
                try {
                    this.cleanupFailOnErrors = Boolean.parseBoolean(raw);
                }
                catch (Throwable t) {
                    this.cleanupFailOnErrors = CLEANUP_FAIL_ON_ERRORS_DEFAULT;
                }
            }
            DebugUtil.trace((Object)((Object)this), (String)("cleanupFailOnErrors set to " + this.cleanupFailOnErrors));
        }
        return this.cleanupFailOnErrors;
    }

    public Boolean isMonitorEnabled() {
        if (this.monitorEnabled == null) {
            String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)MONITOR_ENABLED);
            if (StringUtils.isTrivial((String)raw)) {
                this.monitorEnabled = MONITOR_ENABLED_DEFAULT;
            } else {
                try {
                    this.monitorEnabled = Boolean.parseBoolean(raw);
                }
                catch (Throwable t) {
                    this.monitorEnabled = MONITOR_ENABLED_DEFAULT;
                }
            }
            DebugUtil.trace((Object)((Object)this), (String)("monitorEnable set to " + this.monitorEnabled));
        }
        return this.monitorEnabled;
    }

    public boolean isSafeGC() {
        if (this.safeGC == null) {
            try {
                this.safeGC = Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)SAFE_GARBAGE_COLLECTION));
            }
            catch (Throwable t) {
                this.safeGC = Boolean.TRUE;
            }
            DebugUtil.trace((Object)((Object)this), (String)("safe garbage collection enabled? " + this.safeGC));
        }
        return this.safeGC;
    }

    public boolean isQdlStrictACLS() {
        return this.qdlStrictACLS;
    }

    public HashMap<String, String> getConstants() {
        if (this.constants == null) {
            this.constants = new HashMap();
            this.constants.put("oa4mp:callback_uri", "redirect_uri");
            this.constants.put("oa4mp:token", "code");
            this.constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
            this.constants.put("oa4mp:certreq", "certreq");
            this.constants.put("oa4mp:certlifetime", "certlifetime");
            this.constants.put("oa4mp:client_id", "client_id");
        }
        return this.constants;
    }

    protected Boolean isUtilServerEnabled() {
        if (this.utilServerEnabled == null) {
            try {
                this.utilServerEnabled = Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"enableUtilServlet"));
            }
            catch (Throwable t) {
                this.utilServerEnabled = Boolean.TRUE;
            }
        }
        return this.utilServerEnabled;
    }

    protected Boolean isRFC8693Enabled() {
        if (this.rfc8693Enabled == null) {
            try {
                this.rfc8693Enabled = Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"enableTokenExchange"));
            }
            catch (Throwable t) {
                this.rfc8693Enabled = Boolean.TRUE;
            }
            DebugUtil.trace((Object)((Object)this), (String)("RFC 8693 support enabled? " + this.rfc8693Enabled));
        }
        return this.rfc8693Enabled;
    }

    protected Boolean isCCFEnabled() {
        if (this.ccfEnabled == null) {
            try {
                String raw = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"enableClientCredentialsFlow");
                this.ccfEnabled = raw == null ? Boolean.TRUE : Boolean.valueOf("true".equals(raw));
            }
            catch (Throwable t) {
                this.ccfEnabled = Boolean.TRUE;
            }
            DebugUtil.trace((Object)((Object)this), (String)("client credential support enabled? " + this.ccfEnabled));
        }
        return this.ccfEnabled;
    }

    protected Boolean isRFC8628Enabled() {
        if (this.rfc8628Enabled == null) {
            try {
                this.rfc8628Enabled = Boolean.parseBoolean(Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"enableDeviceFlow"));
            }
            catch (Throwable t) {
                this.rfc8628Enabled = Boolean.FALSE;
            }
            DebugUtil.trace((Object)((Object)this), (String)("RFC 8628 support enabled? " + this.rfc8628Enabled));
        }
        return this.rfc8628Enabled;
    }

    protected CMConfigs createDefaultCMConfig() {
        CMConfigs cmConfigs = new CMConfigs();
        Object serverAddress = this.getServiceAddress().toString();
        if (!((String)serverAddress).endsWith("/")) {
            serverAddress = (String)serverAddress + "/";
        }
        CMConfig tempCfg = new CMConfig("oa4mp", URI.create((String)serverAddress + "clients"), true);
        cmConfigs.put(tempCfg);
        tempCfg = new CM7591Config("rfc7591", URI.create((String)serverAddress + "oidc-cm"), true, null, false, false);
        cmConfigs.put(tempCfg);
        tempCfg = new CMConfig("rfc7592", URI.create((String)serverAddress + "oidc-cm"), true);
        cmConfigs.put(tempCfg);
        return cmConfigs;
    }

    public CMConfigs getCmConfigs() {
        if (this.cmConfigs == null) {
            List kids = this.cn.getChildren("clientManagement");
            CMConfigs defaultCMConfigs = this.createDefaultCMConfig();
            if (kids == null || kids.isEmpty()) {
                this.cmConfigs = defaultCMConfigs;
                return this.cmConfigs;
            }
            if (1 < kids.size()) {
                throw new IllegalArgumentException("Multiple clientManagement elements found.");
            }
            ConfigurationNode cmNode = (ConfigurationNode)kids.get(0);
            kids = cmNode.getChildren();
            this.cmConfigs = new CMConfigs();
            String e = Configurations.getFirstAttribute((ConfigurationNode)cmNode, (String)UUC_ENABLED);
            if (!StringUtils.isTrivial((String)e)) {
                try {
                    this.cmConfigs.setEnabled(Boolean.parseBoolean(e));
                }
                catch (Throwable t) {
                    this.cmConfigs.setEnabled(true);
                }
            }
            if (!this.cmConfigs.isEnabled()) {
                return this.cmConfigs;
            }
            String serverAddress = this.getServiceAddress().toString();
            for (ConfigurationNode sn : kids) {
                if (!sn.getName().equals("api")) continue;
                try {
                    String endpoint = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"endpoint");
                    endpoint = StringUtils.isTrivial((String)endpoint) ? "oidc-cm" : endpoint;
                    CMConfig cfg = CMConfigs.createConfigEntry(Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"protocol"), serverAddress, endpoint, Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"url"), Configurations.getFirstAttribute((ConfigurationNode)sn, (String)UUC_ENABLED), Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"template"), Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"anonymousOK"), Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"autoApprove"), Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"autoApproverName"));
                    String raw = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"defaultRefreshTokenLifetime");
                    if (!StringUtils.isTrivial((String)raw)) {
                        cfg.setDefaultRefreshTokenLifetime(XMLConfigUtil.getValueSecsOrMillis((String)raw, (boolean)false));
                    }
                    if (cfg instanceof CM7591Config) {
                        StringTokenizer st;
                        CM7591Config ccc = (CM7591Config)cfg;
                        String allowed = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"autoApproveAllowedDomains");
                        if (ccc.autoApprove) {
                            if (allowed == null) {
                                ccc.getAllowedAutoApproveDomains().add("*");
                            } else {
                                st = new StringTokenizer(allowed, ",");
                                while (st.hasMoreTokens()) {
                                    ccc.getAllowedAutoApproveDomains().add(st.nextToken().trim());
                                }
                            }
                        }
                        allowed = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"anonymousAllowedDomains");
                        if (ccc.anonymousOK) {
                            if (allowed == null) {
                                ccc.getAllowedAnonymousDomains().add("*");
                            } else {
                                st = new StringTokenizer(allowed, ",");
                                while (st.hasMoreTokens()) {
                                    ccc.getAllowedAnonymousDomains().add(st.nextToken().trim());
                                }
                            }
                        }
                    }
                    this.cmConfigs.put(cfg);
                }
                catch (Throwable t) {
                    ServletDebugUtil.warn((Object)((Object)this), (String)("error loading client management api entry \"" + t.getMessage() + "\""));
                }
            }
            if (this.cmConfigs.isEmpty()) {
                ServletDebugUtil.warn((Object)((Object)this), (String)"Warning: none of the entries in the client managment element parsed. Using defaults...");
            }
            if (!this.cmConfigs.hasOA4MPConfig()) {
                this.cmConfigs.put(defaultCMConfigs.getOA4MPConfig());
            }
            if (!this.cmConfigs.hasRFC7592Config()) {
                this.cmConfigs.put(defaultCMConfigs.getRFC7592Config());
            }
            if (!this.cmConfigs.hasRFC7591Config()) {
                this.cmConfigs.put(defaultCMConfigs.getRFC7591Config());
            }
        }
        return this.cmConfigs;
    }

    protected MultiDSAdminClientStoreProvider getMacp() {
        if (this.macp == null) {
            this.macp = new MultiDSAdminClientStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger(), null, null, (IdentifiableProvider)AdminClientStoreProviders.getAdminClientProvider());
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getACMP((ConfigurationNode)this.cn));
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getACFSP((ConfigurationNode)this.cn));
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getMariaACS((ConfigurationNode)this.cn, (ConnectionPoolProvider)this.getMariaDBConnectionPoolProvider()));
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getMysqlACS((ConfigurationNode)this.cn, (ConnectionPoolProvider)this.getMySQLConnectionPoolProvider()));
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getPostgresACS((ConfigurationNode)this.cn, (ConnectionPoolProvider)this.getPgConnectionPoolProvider()));
            this.macp.addListener((CfgEventListener)AdminClientStoreProviders.getDerbyACS((ConfigurationNode)this.cn, (ConnectionPoolProvider)this.getDerbyConnectionPoolProvider()));
            AdminClientStore adminClientStore = (AdminClientStore)this.macp.get();
        }
        return this.macp;
    }

    protected JSONWebKeys getJSONWebKeys() {
        ConfigurationNode node = Configurations.getFirstNode((ConfigurationNode)this.cn, (String)"JSONWebKey");
        if (node == null) {
            this.warn(" No signing keys in the configuration file. Signing is not available");
            return new JSONWebKeys(null);
        }
        String json = Configurations.getNodeValue((ConfigurationNode)node, (String)"json", null);
        JSONWebKeys keys = null;
        try {
            if (json == null) {
                String path = Configurations.getNodeValue((ConfigurationNode)node, (String)"path", null);
                if (path != null) {
                    keys = JSONWebKeyUtil.fromJSON((File)new File(path));
                    this.info("loaded JSON web keys from file \"" + path + "\"");
                }
            } else {
                keys = JSONWebKeyUtil.fromJSON((String)json);
                this.info("loaded JSON web keys directly from configuration");
            }
        }
        catch (Throwable t) {
            throw new GeneralException("Error reading signing keys", t);
        }
        if (keys == null) {
            throw new IllegalStateException(" Could not load signing keys");
        }
        if (keys.size() == 1) {
            keys.setDefaultKeyID((String)keys.keySet().iterator().next());
        } else {
            keys.setDefaultKeyID(Configurations.getFirstAttribute((ConfigurationNode)node, (String)"defaultKeyID"));
        }
        return keys;
    }

    public Provider<AGIssuer> getAGIProvider() {
        if (this.agip == null) {
            return new Provider<AGIssuer>(){

                public AGIssuer get() {
                    return new AGI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress(), OA2ConfigurationLoader.this.isOIDCEnabled());
                }
            };
        }
        return this.agip;
    }

    public Provider<ClientApprovalStore> getClientApprovalStoreProvider() {
        return this.getCASP();
    }

    public Provider<ClientStore> getClientStoreProvider() {
        return this.getCSP();
    }

    protected MultiDSClientApprovalStoreProvider getCASP() {
        if (this.casp == null) {
            this.casp = new MultiDSClientApprovalStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger());
            final ClientApprovalProvider caProvider = new ClientApprovalProvider();
            ClientApprovalKeys caKeys = new ClientApprovalKeys();
            caKeys.identifier(new String[]{"client_id"});
            final ClientApproverConverter cp = new ClientApproverConverter((SerializationKeys)caKeys, (IdentifiableProviderImpl)caProvider);
            this.casp.addListener((CfgEventListener)new DSFSClientApprovalStoreProvider(this.cn, cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getMySQLConnectionPoolProvider(), "mysql", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getMariaDBConnectionPoolProvider(), "mariadb", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getPgConnectionPoolProvider(), "postgresql", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider)this.getDerbyConnectionPoolProvider(), "derby", (MapConverter)cp));
            this.casp.addListener((CfgEventListener)new TypedProvider<ClientApprovalStore>(this.cn, "memoryStore", "clientApprovals"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientApprovalStore get() {
                    return new ClientApprovalMemoryStore((IdentifiableProviderImpl)caProvider, cp);
                }
            });
        }
        return this.casp;
    }

    public DerbyConnectionPoolProvider getDerbyConnectionPoolProvider(String databaseName, String schema) {
        if (this.derbyConnectionPoolProvider == null) {
            this.derbyConnectionPoolProvider = new DerbyConnectionPoolProvider(databaseName, schema);
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("oa4mp-derby.sql");
                if (inputStream != null) {
                    List createScript = SQLStore.crappySQLParser((List)FileUtil.readFileAsLines((InputStream)inputStream));
                    this.derbyConnectionPoolProvider.setCreateScript(createScript);
                } else {
                    this.getMyLogger().warn("Default Derby script not found");
                }
            }
            catch (Throwable t) {
                this.getMyLogger().warn("Could not load default Derby script (" + t.getClass().getSimpleName() + "):" + t.getMessage(), t);
            }
        }
        return this.derbyConnectionPoolProvider;
    }

    public long getRTGracePeriod() {
        if (this.rtGracePeriod == REFRESH_TOKEN_GRACE_PERIOD_NOT_CONFIGURED) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)REFRESH_TOKEN_GRACE_PERIOD_TAG);
            if (StringUtils.isTrivial((String)x)) {
                this.rtGracePeriod = REFRESH_TOKEN_GRACE_PERIOD_DEFAULT;
            } else {
                try {
                    this.rtGracePeriod = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.rtGracePeriod = REFRESH_TOKEN_GRACE_PERIOD_DEFAULT;
                }
            }
        }
        return this.rtGracePeriod;
    }

    protected long getAGLifetime() {
        if (this.agLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"authorizationGrantLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.agLifetime = AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
            } else {
                try {
                    this.agLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.agLifetime = AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
                }
            }
        }
        return this.agLifetime;
    }

    protected long getIDTokenLifetime() {
        if (this.idTokenLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"defaultIDTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.idTokenLifetime = ID_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.idTokenLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.idTokenLifetime = ID_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.idTokenLifetime;
    }

    public long getMaxIDTokenLifetime() {
        if (this.maxIDTokenLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"defaultIDTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.maxIDTokenLifetime = MAX_ID_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.maxIDTokenLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.maxIDTokenLifetime = MAX_ID_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.maxIDTokenLifetime;
    }

    protected long getATLifetime() {
        if (this.atLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"defaultAccessTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"accessTokenLifetime");
            }
            if (StringUtils.isTrivial((String)x)) {
                this.atLifetime = ACCESS_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.atLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.atLifetime = ACCESS_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.atLifetime;
    }

    protected long getRTLifetime() {
        if (this.rtLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"defaultRefreshTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"refreshTokenLifetime");
            }
            if (StringUtils.isTrivial((String)x)) {
                this.rtLifetime = REFRESH_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.rtLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)false);
                }
                catch (Throwable t) {
                    this.rtLifetime = REFRESH_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.rtLifetime;
    }

    public long getMaxAGLifetime() {
        if (this.maxAGLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxAuthorizationGrantLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.maxAGLifetime = MAX_AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
            } else {
                try {
                    this.maxAGLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)false);
                }
                catch (Throwable t) {
                    this.maxAGLifetime = MAX_AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
                }
            }
        }
        return this.maxAGLifetime;
    }

    public long getMaxATLifetime() {
        if (this.maxATLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxAccessTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.maxATLifetime = MAX_ACCESS_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.maxATLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)false);
                }
                catch (Throwable t) {
                    this.maxATLifetime = MAX_ACCESS_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.maxATLifetime;
    }

    public void setMaxATLifetime(long maxATLifetime) {
        this.maxATLifetime = maxATLifetime;
    }

    public long getMaxRTLifetime() {
        if (this.maxRTLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxRefreshTokenLifetime");
            if (StringUtils.isTrivial((String)x)) {
                this.maxRTLifetime = MAX_REFRESH_TOKEN_LIFETIME_DEFAULT;
            } else {
                try {
                    this.maxRTLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.maxRTLifetime = MAX_REFRESH_TOKEN_LIFETIME_DEFAULT;
                }
            }
        }
        return this.maxRTLifetime;
    }

    protected String getIssuer() {
        if (this.issuer == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"issuer");
            if (x == null || x.length() == 0) {
                return null;
            }
            this.issuer = x;
        }
        return this.issuer;
    }

    protected long getMaxClientRefreshTokenLifetime() {
        if (this.maxClientRefreshTokenLifetime < 0L) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxClientRefreshTokenLifetime");
            if (x == null || x.length() == 0) {
                this.maxClientRefreshTokenLifetime = 33696000000L;
            } else {
                try {
                    this.maxClientRefreshTokenLifetime = XMLConfigUtil.getValueSecsOrMillis((String)x, (boolean)true);
                }
                catch (Throwable t) {
                    this.maxClientRefreshTokenLifetime = 33696000000L;
                }
            }
        }
        return this.maxClientRefreshTokenLifetime;
    }

    public boolean isOIDCEnabled() {
        if (this.oidcEnabled == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"OIDCEnabled");
            if (x == null) {
                this.oidcEnabled = Boolean.TRUE;
            } else {
                try {
                    this.oidcEnabled = Boolean.valueOf(x);
                }
                catch (Throwable t) {
                    this.info("Could not parse OIDC enabled flag, setting default to true");
                    this.oidcEnabled = Boolean.TRUE;
                }
            }
        }
        return this.oidcEnabled;
    }

    public boolean isRefreshTokenEnabled() {
        if (this.refreshTokenEnabled == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"refreshTokenEnabled");
            if (x == null) {
                this.refreshTokenEnabled = Boolean.FALSE;
            } else {
                try {
                    this.refreshTokenEnabled = Boolean.valueOf(x);
                }
                catch (Throwable t) {
                    this.info("Could not parse refresh token enabled attribute. Setting default to false.");
                    this.refreshTokenEnabled = Boolean.FALSE;
                }
            }
        }
        return this.refreshTokenEnabled;
    }

    public boolean isTwoFactorSupportEnabled() {
        if (this.twoFactorSupportEnabled == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"enableTwoFactorSupport");
            if (x == null) {
                this.twoFactorSupportEnabled = Boolean.FALSE;
            } else {
                try {
                    this.twoFactorSupportEnabled = Boolean.valueOf(x);
                }
                catch (Throwable t) {
                    this.info("Could not parse two factor enabled attribute. Setting default to false.");
                    this.twoFactorSupportEnabled = Boolean.FALSE;
                }
            }
        }
        return this.twoFactorSupportEnabled;
    }

    public void setRefreshTokenEnabled(boolean refreshTokenEnabled) {
        this.refreshTokenEnabled = refreshTokenEnabled;
    }

    public ClaimSource getClaimSource() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        DebugUtil.trace((Object)((Object)this), (String)("Getting scope handler " + String.valueOf(this.claimSource)));
        if (this.claimSource == null) {
            if (0 < this.cn.getChildrenCount("scopes")) {
                String scopeHandlerName = Configurations.getFirstAttribute((ConfigurationNode)Configurations.getFirstNode((ConfigurationNode)this.cn, (String)"scopes"), (String)"handler");
                if (scopeHandlerName != null) {
                    Class<?> k = Class.forName(scopeHandlerName);
                    Object x = k.newInstance();
                    if (!(x instanceof ClaimSource)) {
                        throw new GeneralException("The scope handler specified by the class name \"" + scopeHandlerName + "\" does not extend the ScopeHandler interface and therefore cannot be used to handle scopes.");
                    }
                    this.claimSource = (ClaimSource)x;
                    ClaimSourceConfiguration configuration = new ClaimSourceConfiguration();
                    configuration.setEnabled(true);
                    this.claimSource.setConfiguration(configuration);
                } else {
                    this.info("Scope handler attribute found in configuration, but no value was found for it. Skipping custom loaded scope handling.");
                }
            }
            if (this.claimSource == null) {
                DebugUtil.trace((Object)((Object)this), (String)"No server-wide configured Scope handler");
                if (this.getLdapConfiguration().isEnabled()) {
                    DebugUtil.trace((Object)((Object)this), (String)"   LDAP scope handler enabled, creating default");
                    this.claimSource = new LDAPClaimsSource(this.getLdapConfiguration(), this.myLogger);
                } else {
                    DebugUtil.trace((Object)((Object)this), (String)"   LDAP scope handler disabled, creating basic");
                    ClaimSourceConfiguration claimSourceConfiguration = new ClaimSourceConfiguration();
                    claimSourceConfiguration.setEnabled(false);
                    this.claimSource = new BasicClaimsSourceImpl();
                    this.claimSource.setConfiguration(claimSourceConfiguration);
                }
            }
            this.claimSource.setScopes(this.getScopes());
            DebugUtil.trace((Object)((Object)this), (String)("   Actual scope handler = " + this.claimSource.getClass().getSimpleName()));
        }
        return this.claimSource;
    }

    protected LDAPConfiguration getLdapConfiguration() {
        if (this.ldapConfiguration == null) {
            LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
            this.ldapConfiguration = ldapConfigurationUtil.getLdapConfiguration(this.myLogger, this.cn);
        }
        return this.ldapConfiguration;
    }

    public Collection<String> getScopes() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.scopes == null) {
            this.scopes = OA2ConfigurationLoaderUtils.getScopes((ConfigurationNode)this.cn);
        }
        return this.scopes;
    }

    public int getClientSecretLength() {
        if (this.clientSecretLength < 0) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"clientSecretLength");
            if (x != null) {
                try {
                    this.clientSecretLength = Integer.parseInt(x);
                }
                catch (Throwable t) {
                    this.clientSecretLength = CLIENT_SECRET_LENGTH_DEFAULT;
                }
            } else {
                this.clientSecretLength = CLIENT_SECRET_LENGTH_DEFAULT;
            }
        }
        return this.clientSecretLength;
    }

    protected MultiDSClientStoreProvider getCSP() {
        if (this.csp == null) {
            OA2ClientConverter<Client> converter = new OA2ClientConverter<Client>(this.getClientProvider());
            this.csp = new OA2MultiDSClientStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger(), null, null, this.getClientProvider());
            this.csp.addListener((CfgEventListener)new DSFSClientStoreProvider(this.cn, converter, this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener(new OA2ClientSQLStoreProvider((ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider()), "derby", (MapConverter)converter, (Provider<Client>)this.getClientProvider()));
            this.csp.addListener((CfgEventListener)new TypedProvider<ClientStore>(this.cn, "memoryStore", "clients"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientStore get() {
                    return new OA2ClientMemoryStore<Client>(OA2ConfigurationLoader.this.getClientProvider());
                }
            });
        }
        return this.csp;
    }

    protected OA2SQLTransactionStoreProvider createSQLTSP(ConfigurationNode config, ConnectionPoolProvider<? extends ConnectionPool> cpp, String type, MultiDSClientStoreProvider clientStoreProvider, Provider<? extends OA2ServiceTransaction> tp, Provider<TokenForge> tfp, MapConverter converter) {
        return new OA2SQLTransactionStoreProvider(config, cpp, type, clientStoreProvider, tp, tfp, converter);
    }

    protected SQLTXRStoreProvider createSQLTXRecordP(ConfigurationNode config, ConnectionPoolProvider<? extends ConnectionPool> cpp, String type, TXRecordProvider<? extends TXRecord> tp, Provider<TokenForge> tfp, TXRecordConverter converter) {
        return new SQLTXRStoreProvider(config, cpp, type, converter, tp);
    }

    protected SQLVIStoreProvider createSQLVOP(ConfigurationNode config, ConnectionPoolProvider<? extends ConnectionPool> cpp, String type, VIProvider<? extends VirtualIssuer> tp, Provider<TokenForge> tfp, VIConverter converter) {
        return new SQLVIStoreProvider(config, cpp, type, converter, tp);
    }

    protected Provider<VIStore> getVOStoreProvider() {
        VIProvider VIProvider2 = new VIProvider(null, (OA2TokenForge)this.getTokenForgeProvider().get());
        VIConverter VIConverter2 = new VIConverter((SerializationKeys)new VISerializationKeys(), VIProvider2);
        return this.getVOStoreProvider(VIProvider2, VIConverter2);
    }

    protected Provider<VIStore> getVOStoreProvider(final VIProvider VIProvider2, final VIConverter<? extends VirtualIssuer> VIConverter2) {
        if (this.voStoreProvider == null) {
            VIMultiStoreProvider storeProvider = new VIMultiStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger(), null, null, VIProvider2, VIConverter2);
            storeProvider.addListener((CfgEventListener)this.createSQLVOP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getMySQLConnectionPoolProvider(), "mysql", VIProvider2, this.getTokenForgeProvider(), VIConverter2));
            storeProvider.addListener((CfgEventListener)this.createSQLVOP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getMariaDBConnectionPoolProvider(), "mariadb", VIProvider2, this.getTokenForgeProvider(), VIConverter2));
            storeProvider.addListener((CfgEventListener)this.createSQLVOP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getPgConnectionPoolProvider(), "postgresql", VIProvider2, this.getTokenForgeProvider(), VIConverter2));
            storeProvider.addListener((CfgEventListener)this.createSQLVOP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getDerbyConnectionPoolProvider(), "derby", VIProvider2, this.getTokenForgeProvider(), VIConverter2));
            storeProvider.addListener((CfgEventListener)new VIFSProvider(this.cn, VIProvider2, VIConverter2));
            storeProvider.addListener((CfgEventListener)new TypedProvider<VIStore>(this.cn, "memoryStore", "voStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public VIStore get() {
                    return new VIMemoryStore(VIProvider2, VIConverter2);
                }
            });
            this.voStoreProvider = storeProvider;
        }
        return this.voStoreProvider;
    }

    protected Provider<TXStore> getTXStoreProvider() {
        TXRecordProvider txRecordProvider = new TXRecordProvider(null, (OA2TokenForge)this.getTokenForgeProvider().get());
        TXRecordConverter txRecordConverter = new TXRecordConverter(new TXRecordSerializationKeys(), txRecordProvider, (ClientStore<? extends OA2Client>)((ClientStore<OA2Client>)((ClientStore<? extends OA2Client>)((ClientStore)this.getClientStoreProvider().get()))));
        return this.getTXStoreProvider(txRecordProvider, txRecordConverter);
    }

    protected Provider<TXStore> getTXStoreProvider(final TXRecordProvider txRecordProvider, final TXRecordConverter<? extends TXRecord> txRecordConverter) {
        if (this.txStoreProvider == null) {
            TXMultiStoreProvider storeProvider = new TXMultiStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger(), null, null, txRecordProvider, txRecordConverter);
            storeProvider.addListener((CfgEventListener)this.createSQLTXRecordP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getMySQLConnectionPoolProvider(), "mysql", txRecordProvider, this.getTokenForgeProvider(), txRecordConverter));
            storeProvider.addListener((CfgEventListener)this.createSQLTXRecordP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getMariaDBConnectionPoolProvider(), "mariadb", txRecordProvider, this.getTokenForgeProvider(), txRecordConverter));
            storeProvider.addListener((CfgEventListener)this.createSQLTXRecordP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getPgConnectionPoolProvider(), "postgresql", txRecordProvider, this.getTokenForgeProvider(), txRecordConverter));
            storeProvider.addListener((CfgEventListener)this.createSQLTXRecordP(this.cn, (ConnectionPoolProvider<ConnectionPool>)this.getDerbyConnectionPoolProvider(), "derby", txRecordProvider, this.getTokenForgeProvider(), txRecordConverter));
            storeProvider.addListener((CfgEventListener)new TXFSProvider(this.cn, txRecordProvider, txRecordConverter));
            storeProvider.addListener((CfgEventListener)new TypedProvider<TXStore>(this.cn, "memoryStore", "txStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public TXStore get() {
                    return new TXMemoryStore(txRecordProvider, txRecordConverter);
                }
            });
            this.txStoreProvider = storeProvider;
        }
        return this.txStoreProvider;
    }

    protected Provider<TransactionStore> getTSP(IdentifiableProvider tp, OA2TConverter<? extends OA2ServiceTransaction> tc) {
        if (this.tsp == null) {
            final IdentifiableProvider tp1 = tp;
            OA2MultiTypeTransactionProvider storeProvider = new OA2MultiTypeTransactionProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), this.getMyLogger(), tp);
            storeProvider.addListener((CfgEventListener)this.createSQLTSP(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)((ConnectionPoolProvider<ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", this.getCSP(), (Provider<? extends OA2ServiceTransaction>)((Provider<OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)this.createSQLTSP(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)((ConnectionPoolProvider<ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", this.getCSP(), (Provider<? extends OA2ServiceTransaction>)((Provider<OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)this.createSQLTSP(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)((ConnectionPoolProvider<ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", this.getCSP(), (Provider<? extends OA2ServiceTransaction>)((Provider<OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)this.createSQLTSP(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)((ConnectionPoolProvider<ConnectionPool>)this.getDerbyConnectionPoolProvider()), "derby", this.getCSP(), (Provider<? extends OA2ServiceTransaction>)((Provider<OA2ServiceTransaction>)tp), this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new OA2FSTStoreProvider(this.cn, (IdentifiableProvider<? extends OA2ServiceTransaction>)tp, this.getTokenForgeProvider(), tc));
            storeProvider.addListener((CfgEventListener)new TypedProvider<TransactionStore>(this.cn, "memoryStore", "transactions"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public TransactionStore get() {
                    return new OA2MTStore(tp1);
                }
            });
            this.tsp = storeProvider;
        }
        return this.tsp;
    }

    protected Provider<TransactionStore> getTSP() {
        ST2Provider tp = new ST2Provider((IdentifierProvider<Identifier>)new OA4MPIdentifierProvider("transaction", false));
        OA2TransactionKeys keys = new OA2TransactionKeys();
        OA2TConverter tc = new OA2TConverter(keys, tp, (TokenForge)this.getTokenForgeProvider().get(), (ClientStore<? extends Client>)((ClientStore<Client>)((ClientStore<? extends Client>)((ClientStore)this.getClientStoreProvider().get()))));
        return this.getTSP((IdentifiableProvider)tp, tc);
    }

    public Provider<TransactionStore> getTransactionStoreProvider() {
        return this.getTSP();
    }

    public Provider<TokenForge> getTokenForgeProvider() {
        return new Provider<TokenForge>(){

            public TokenForge get() {
                return new OA2TokenForge(OA2ConfigurationLoader.this.getServiceAddress().toString());
            }
        };
    }

    public Provider<ATIssuer> getATIProvider() {
        return new Provider<ATIssuer>(){

            public ATIssuer get() {
                return new ATI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress(), OA2ConfigurationLoader.this.isOIDCEnabled());
            }
        };
    }

    public Provider<PAIssuer> getPAIProvider() {
        return new Provider<PAIssuer>(){

            public PAIssuer get() {
                return new PAI2((TokenForge)OA2ConfigurationLoader.this.getTokenForgeProvider().get(), OA2ConfigurationLoader.this.getServiceAddress(), OA2ConfigurationLoader.this.isOIDCEnabled());
            }
        };
    }

    public IdentifiableProvider<? extends Client> getClientProvider() {
        return new OA2ClientProvider((IdentifierProvider<Identifier>)new OA4MPIdentifierProvider("client_id", false));
    }

    public String getVersionString() {
        return "OA4MP, version 6.2.1";
    }

    protected DIServiceConfig getDISerivceConfig() {
        if (this.DIServiceConfig == null) {
            List kids = this.cn.getChildren("diService");
            this.DIServiceConfig = new DIServiceConfig();
            this.DIServiceConfig.setEnabled(false);
            if (kids.isEmpty()) {
                return this.DIServiceConfig;
            }
            ConfigurationNode topNode = (ConfigurationNode)kids.get(0);
            String rawEnabled = Configurations.getFirstAttribute((ConfigurationNode)topNode, (String)UUC_ENABLED);
            if (!StringUtils.isTrivial((String)rawEnabled)) {
                try {
                    this.DIServiceConfig.setEnabled(Boolean.parseBoolean(rawEnabled));
                }
                catch (Throwable t) {
                    this.info("Could not determine if db service is enabled: got \"" + rawEnabled + "\" in tag");
                }
            }
            ConfigurationNode usersNode = Configurations.getFirstNode((ConfigurationNode)topNode, (String)"users");
            List userNodes = usersNode.getChildren("user");
            for (ConfigurationNode tempNode : userNodes) {
                String rawUser = Configurations.getFirstAttribute((ConfigurationNode)tempNode, (String)"username");
                String rawHash = Configurations.getFirstAttribute((ConfigurationNode)tempNode, (String)"hash");
                this.DIServiceConfig.addUser(rawUser, rawHash);
            }
        }
        return this.DIServiceConfig;
    }

    public static class OA2MultiDSClientStoreProvider
    extends MultiDSClientStoreProvider {
        public OA2MultiDSClientStoreProvider(ConfigurationNode config, boolean disableDefaultStore, MyLoggingFacade logger) {
            super(config, disableDefaultStore, logger);
        }

        public OA2MultiDSClientStoreProvider(ConfigurationNode config, boolean disableDefaultStore, MyLoggingFacade logger, String type, String target, IdentifiableProvider clientProvider) {
            super(config, disableDefaultStore, logger, type, target, clientProvider);
        }

        public ClientStore getDefaultStore() {
            this.logger.info("Using default in memory client store");
            return new OA2ClientMemoryStore(this.clientProvider);
        }
    }

    public static class ST2Provider
    extends DSTransactionProvider<OA2ServiceTransaction> {
        public ST2Provider(IdentifierProvider<Identifier> idProvider) {
            super(idProvider);
        }

        public OA2ServiceTransaction get(boolean createNewIdentifier) {
            return new OA2ServiceTransaction(this.createNewId(createNewIdentifier));
        }
    }

    public class OA4MP2TProvider
    extends DSTransactionProvider<OA2ServiceTransaction> {
        public OA4MP2TProvider(IdentifierProvider<Identifier> idProvider) {
            super(idProvider);
        }

        public OA2ServiceTransaction get(boolean createNewIdentifier) {
            return new OA2ServiceTransaction(this.createNewId(createNewIdentifier));
        }
    }
}

