/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.loader;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import java.util.Map;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.util.ACNewClientEvent;
import org.oa4mp.server.api.util.NewAdminClientEvent;
import org.oa4mp.server.api.util.NewClientEvent;
import org.oa4mp.server.api.util.NewClientNotifier;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public class OA2NewClientNotifier
extends NewClientNotifier {
    public static final String SCOPES = "scopes";
    public static final String REFRESH_LIFETIME = "refreshLifetime";
    public static final String REFRESH_ENABLED = "refreshEnabled";
    public static final String ISSUER = "issuer";
    public static final String SIGN_TOKEN_OK = "signTokens";
    public static final String LDAP_CONFIGURATION = "ldapConfiguration";
    public static final String CALLBACK = "callback";
    public static final String IS_PUBLIC = "isPublic";
    public static final String STRICT_SCOPES = "strictScopes";

    public OA2NewClientNotifier(MailUtil mailUtil, MyLoggingFacade loggingFacade) {
        super(mailUtil, loggingFacade);
    }

    protected Map<String, String> getReplacements(BaseClient client) {
        Map replacements = super.getReplacements(client);
        if (client instanceof AdminClient) {
            return replacements;
        }
        OA2Client oa2Client = (OA2Client)client;
        replacements.remove("failureUri");
        replacements.put(SCOPES, String.valueOf(oa2Client.getScopes()));
        replacements.put(CALLBACK, String.valueOf(oa2Client.getCallbackURIs()));
        replacements.put(REFRESH_ENABLED, Boolean.toString(oa2Client.isRTLifetimeEnabled()));
        replacements.put(IS_PUBLIC, Boolean.toString(oa2Client.isPublicClient()));
        replacements.put(STRICT_SCOPES, Boolean.toString(oa2Client.useStrictScopes()));
        if (oa2Client.isRTLifetimeEnabled()) {
            replacements.put(REFRESH_LIFETIME, Long.toString(oa2Client.getRtLifetime()));
        } else {
            replacements.put(REFRESH_LIFETIME, "n/a");
        }
        replacements.put(SIGN_TOKEN_OK, Boolean.toString(oa2Client.isSignTokens()));
        if (oa2Client.getLdaps() == null || oa2Client.getLdaps().isEmpty()) {
            replacements.put(LDAP_CONFIGURATION, "(none)");
        } else {
            LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
            replacements.put(LDAP_CONFIGURATION, ldapConfigurationUtil.toJSON(oa2Client.getLdaps()).toString(2));
        }
        if (oa2Client.getIssuer() == null) {
            replacements.put(ISSUER, "(none)");
        } else {
            replacements.put(ISSUER, oa2Client.getIssuer());
        }
        return replacements;
    }

    public void fireNewClientEvent(NewClientEvent notificationEvent) {
        String body;
        String subject;
        if (!this.mailUtil.isEnabled()) {
            return;
        }
        BaseClient client = notificationEvent.getClient();
        Map<String, String> replacements = this.getReplacements(client);
        boolean done = false;
        boolean rc = false;
        if (notificationEvent instanceof NewAdminClientEvent) {
            subject = "New administrative client registration on ${host}";
            body = "A new administrative client has requested approved on ${host}\n\nIf you approve this request, you should send a notice\nto the contact email and include the generated identifier.\nPlease review all of the information below prior to approval.\n\nGenerated identifier: ${identifier}\nCreation time: ${creationTime}\n\nName: ${name}\nContact email: ${email}";
            rc = this.mailUtil.sendMessage(subject, body, replacements);
            done = true;
        }
        if (notificationEvent instanceof ACNewClientEvent) {
            replacements.put("admin_id", ((ACNewClientEvent)notificationEvent).getAdminClient().getIdentifierString());
            subject = "New client created by admin ${admin_id}";
            body = "An OIDC client has been created on ${host}.\n\n\n Admin identifier : ${admin_id}\nClient identifier : ${identifier}\n    Creation time : ${creationTime}\n\n\n            Name  : ${name}\n   Contact email  : ${email}\n        Home uri  : ${homeUri}\n          Scopes  : ${scopes}\n       Callbacks  :\n${callback}\n\n\n Refresh enabled?  : ${refreshEnabled}\nRefresh lifetime?  : ${refreshLifetime}\n           Issuer  : ${issuer}\n     Sign tokens?  : ${signTokens}\n   Proxy Limited?  : ${limitedProxy}\n   Public client?  : ${isPublic}\n   Strict Scopes?  : ${strictScopes}\n";
            rc = this.mailUtil.sendMessage(subject, body, replacements);
            done = true;
        }
        if (!done) {
            rc = this.mailUtil.sendMessage(replacements);
        }
        if (rc) {
            this.loggingFacade.info("sending email notification for client " + client.getIdentifierString());
        } else {
            this.loggingFacade.info("failure sending email notification for client " + client.getIdentifierString());
        }
    }
}

