/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.loader;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.LockingCleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.storage.MonitoredStoreInterface;
import edu.uiuc.ncsa.security.storage.events.LastAccessedEventListener;
import edu.uiuc.ncsa.security.storage.events.LastAccessedThread;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPool;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.oa4mp.delegation.common.storage.clients.ClientConverter;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.server.claims.ClaimSourceFactory;
import org.oa4mp.delegation.server.storage.upkeep.UpkeepThread;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.api.admin.adminClient.AdminClientStoreProviders;
import org.oa4mp.server.api.admin.things.SATFactory;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.storage.servlet.OA4MPServletInitializer;
import org.oa4mp.server.api.util.NewClientNotifier;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.ClaimSourceFactoryImpl;
import org.oa4mp.server.loader.oauth2.loader.OA2NewClientNotifier;
import org.oa4mp.server.loader.oauth2.servlet.AbstractAccessTokenServlet2;
import org.oa4mp.server.loader.oauth2.servlet.MultiAuthServlet;
import org.oa4mp.server.loader.oauth2.servlet.OA2ExceptionHandler;
import org.oa4mp.server.loader.oauth2.servlet.TokenExchangeRecordRetentionPolicy;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenRetentionPolicy;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.evaluate.MetaEvaluator;
import org.qdl_lang.evaluate.OpEvaluator;
import org.qdl_lang.expressions.module.MIStack;
import org.qdl_lang.expressions.module.MTStack;
import org.qdl_lang.functions.FStack;
import org.qdl_lang.state.State;
import org.qdl_lang.state.StateUtils;
import org.qdl_lang.variables.VStack;

public class OA2ServletInitializer
extends OA4MPServletInitializer {
    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new OA2ExceptionHandler(this.getEnvironment().getMyLogger());
        }
        return this.exceptionHandler;
    }

    protected NewClientNotifier createNewClientNotifier(MailUtil mailUtil, MyLoggingFacade logger) {
        return new OA2NewClientNotifier(mailUtil, logger);
    }

    public void init() throws ServletException {
        DerbyConnectionPool dcp;
        if (isInitRun) {
            return;
        }
        super.init();
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("LOG4J_FORMAT_MSG_NO_LOOKUPS", "true");
        final OA2SE oa2SE = (OA2SE)this.getEnvironment();
        OA2Scopes.ScopeUtil.setBasicScopes(oa2SE.getScopes());
        if (oa2SE.getClientStore() instanceof SQLStore && ((SQLStore)oa2SE.getClientStore()).getConnectionPool() instanceof DerbyConnectionPool && (dcp = (DerbyConnectionPool)((SQLStore)oa2SE.getClientStore()).getConnectionPool()).getConnectionParameters().isCreateOne()) {
            dcp.createStore();
        }
        DebugUtil.setInstance((MetaDebugUtil)oa2SE.getDebugger());
        DebugUtil.setPrintTS((boolean)oa2SE.isPrintTSInDebug());
        if (oa2SE.isMonitorEnabled() && OA4MPServlet.lastAccessedThread == null) {
            LastAccessedEventListener lastAccessedEventListener = new LastAccessedEventListener();
            String name = "last accessed monitor";
            LastAccessedThread lastAccessedThread = new LastAccessedThread(name, oa2SE.getMyLogger(), lastAccessedEventListener);
            this.addMonitoredStores(oa2SE, lastAccessedEventListener);
            if (oa2SE.hasMonitorAlarams()) {
                lastAccessedThread.setAlarms(oa2SE.getMonitorAlarms());
                DebugUtil.trace((Object)((Object)this), (String)("starting \"" + (String)name + "\" with alarms:" + String.valueOf(oa2SE.getMonitorAlarms())));
            } else {
                lastAccessedThread.setCleanupInterval(oa2SE.getMonitorInterval());
                DebugUtil.trace((Object)((Object)this), (String)("starting \"" + (String)name + "\" with interval:" + oa2SE.getMonitorInterval() + " ms."));
            }
            lastAccessedThread.setStopThread(false);
            lastAccessedThread.start();
        }
        if (MultiAuthServlet.upkeepThreadList == null) {
            ArrayList<UpkeepThread> upkeepThreads = new ArrayList<UpkeepThread>();
            for (Store store : oa2SE.getAllStores()) {
                MonitoredStoreInterface MonitoredStoreInterface2;
                if (!(store instanceof MonitoredStoreInterface) || (MonitoredStoreInterface2 = (MonitoredStoreInterface)store).getUpkeepConfiguration() == null || !MonitoredStoreInterface2.getUpkeepConfiguration().isEnabled()) continue;
                UpkeepThread upkeepThread = new UpkeepThread("upkeep thread for " + MonitoredStoreInterface2.getClass().getSimpleName(), (AbstractEnvironment)oa2SE, MonitoredStoreInterface2);
                upkeepThread.setStopThread(false);
                upkeepThread.start();
                upkeepThreads.add(upkeepThread);
            }
            MultiAuthServlet.upkeepThreadList = upkeepThreads;
        }
        if (oa2SE.isRefreshTokenEnabled()) {
            OA4MPServlet.transactionCleanup.getRetentionPolicies().clear();
            if (oa2SE.hasCleanupAlarms()) {
                OA4MPServlet.transactionCleanup.setAlarms(oa2SE.getCleanupAlarms());
                DebugUtil.trace((Object)((Object)this), (String)("setting transaction cleanup alarms " + String.valueOf(oa2SE.getCleanupAlarms())));
            } else {
                OA4MPServlet.transactionCleanup.setCleanupInterval(oa2SE.getCleanupInterval());
                DebugUtil.trace((Object)((Object)this), (String)("setting transaction cleanup interval to " + oa2SE.getCleanupInterval() + " ms."));
            }
            OA4MPServlet.transactionCleanup.addRetentionPolicy((RetentionPolicy)new RefreshTokenRetentionPolicy((RefreshTokenStore)oa2SE.getTransactionStore(), oa2SE.getTxStore(), oa2SE.getServiceAddress().toString(), oa2SE.isSafeGC()));
            OA4MPServlet.transactionCleanup.setEnabledLocking(oa2SE.isCleanupLockingEnabled());
            OA4MPServlet.transactionCleanup.setFailOnError(oa2SE.isCleanupFailOnErrors());
            OA4MPServlet.transactionCleanup.setStopThread(false);
            OA4MPServlet.transactionCleanup.start();
            oa2SE.getMyLogger().info("Started refresh token cleanup thread with interval " + oa2SE.getCleanupInterval() + " ms.");
        }
        if (!ClaimSourceFactory.isFactorySet()) {
            ClaimSourceFactory.setFactory((ClaimSourceFactory)new ClaimSourceFactoryImpl());
        }
        if (AbstractAccessTokenServlet2.txRecordCleanup == null) {
            String name = "TX record cleanup";
            LockingCleanup lc = new LockingCleanup(this.getEnvironment().getMyLogger(), name);
            lc.setStore((Store)oa2SE.getTxStore());
            if (oa2SE.hasCleanupAlarms()) {
                lc.setAlarms(oa2SE.getCleanupAlarms());
                DebugUtil.trace((Object)((Object)this), (String)("setting \"" + name + "\" alarms to " + String.valueOf(oa2SE.getCleanupAlarms())));
            } else {
                lc.setCleanupInterval(oa2SE.getCleanupInterval());
                DebugUtil.trace((Object)((Object)this), (String)("setting \"" + name + "\" interval to " + oa2SE.getCleanupInterval() + " ms."));
            }
            lc.setEnabledLocking(oa2SE.isCleanupLockingEnabled());
            lc.setFailOnError(oa2SE.isCleanupFailOnErrors());
            lc.setStopThread(false);
            lc.addRetentionPolicy((RetentionPolicy)new TokenExchangeRecordRetentionPolicy(oa2SE.getServiceAddress().toString(), oa2SE.isSafeGC()));
            AbstractAccessTokenServlet2.txRecordCleanup = lc;
            AbstractAccessTokenServlet2.txRecordCleanup.start();
            oa2SE.getMyLogger().info("Starting token exchange record store cleanup thread with interval " + oa2SE.getCleanupInterval() + " ms.");
        }
        try {
            SATFactory.setAdminClientConverter((AdminClientConverter)AdminClientStoreProviders.getAdminClientConverter());
            SATFactory.setClientConverter((ClientConverter)((ClientConverter)oa2SE.getClientStore().getMapConverter()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StateUtils.setFactory((StateUtils)new StateUtils(){

            public State create() {
                OA2State ss = new OA2State(new VStack(), new OpEvaluator(), MetaEvaluator.getInstance(), new FStack(), new MTStack(), new MIStack(), null, true, true, false, true, null);
                ss.setOa2se(oa2SE);
                return ss;
            }
        });
    }

    protected void addMonitoredStores(OA2SE oa2SE, LastAccessedEventListener lastAccessedEventListener) {
        for (Store store : oa2SE.getAllStores()) {
            if (!(store instanceof MonitoredStoreInterface)) continue;
            ((MonitoredStoreInterface)store).addLastAccessedEventListener(lastAccessedEventListener);
        }
    }
}

