/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.ATRequest;
import org.oa4mp.delegation.server.request.ATResponse;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.server.api.storage.servlet.IssuerTransactionState;
import org.oa4mp.server.loader.oauth2.servlet.MultiAuthServlet;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;

public abstract class AbstractAccessTokenServlet2
extends MultiAuthServlet {
    public static Cleanup<Identifier, TXRecord> txRecordCleanup = null;

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected abstract ATRequest getATRequest(HttpServletRequest var1, ServiceTransaction var2, OA2Client var3);

    protected abstract ServiceTransaction getTransaction(AuthorizationGrant var1, HttpServletRequest var2) throws ServletException;

    @Override
    public OA2Client getClient(HttpServletRequest request) {
        return (OA2Client)super.getClient(request);
    }

    protected abstract AuthorizationGrant checkAGExpiration(AuthorizationGrant var1);

    protected IssuerTransactionState doDelegation(Client client, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable, ServletException {
        AbstractAccessTokenServlet2.createDebugger((BaseClient)client).info((Object)this, "5.a. Starting access token exchange");
        this.info("5.a. Starting access token exchange");
        AuthorizationGrant ag = AbstractAccessTokenServlet2.getServiceEnvironment().getTokenForge().getAuthorizationGrant(httpServletRequest);
        AuthorizationGrant updatedAG = this.checkAGExpiration(ag);
        ServiceTransaction transaction = this.getTransaction(ag, httpServletRequest);
        return this.getIssuerTransactionState(httpServletRequest, httpServletResponse, updatedAG, transaction, (OA2Client)client, GenericStoreUtils.toXML((Store)this.getTransactionStore(), (Identifiable)transaction));
    }

    protected IssuerTransactionState getIssuerTransactionState(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthorizationGrant updatedAG, ServiceTransaction transaction, OA2Client client, XMLMap backup) throws Throwable {
        return this.getIssuerTransactionState(httpServletRequest, httpServletResponse, updatedAG, transaction, client, backup, false);
    }

    protected IssuerTransactionState getIssuerTransactionState(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthorizationGrant updatedAG, ServiceTransaction transaction, OA2Client client, XMLMap backup, boolean isRFC8628) throws Throwable {
        if (updatedAG != null) {
            transaction.setAuthorizationGrant(updatedAG);
        }
        MetaDebugUtil debugger = AbstractAccessTokenServlet2.createDebugger((BaseClient)transaction.getClient());
        ATRequest atRequest = this.getATRequest(httpServletRequest, transaction, client);
        atRequest.setAuthorizationGrant(updatedAG);
        ATResponse atResp = (ATResponse)this.getATI().process((Request)atRequest);
        if (!isRFC8628) {
            transaction = this.verifyAndGet((IssuerResponse)atResp);
        }
        String cc = "client=" + String.valueOf(transaction.getClient());
        debugger.info((Object)this, "5.a. got access token " + cc);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, atResp.getParameters(), (BasicTransaction)transaction, backup));
        transaction.setAuthGrantValid(false);
        transaction.setAccessToken(atResp.getAccessToken());
        transaction.setAccessTokenValid(true);
        debugger.info((Object)this, "5.b. done with access token exchange with " + cc);
        IssuerTransactionState transactionState = new IssuerTransactionState(httpServletRequest, httpServletResponse, atResp.getParameters(), (BasicTransaction)transaction, backup, (IssuerResponse)atResp);
        transactionState.setRfc8628(isRFC8628);
        this.postprocess((TransactionState)transactionState);
        return transactionState;
    }

    protected IssuerTransactionState doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable, ServletException {
        return this.doDelegation(this.getClient(httpServletRequest), httpServletRequest, httpServletResponse);
    }
}

