/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.IOException;
import java.net.URI;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.TokenManagerServlet;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public abstract class BearerTokenServlet
extends OA4MPServlet {
    protected OA2ServiceTransaction findTransaction(AccessTokenImpl at, TokenManagerServlet.State state) throws IOException {
        OA2GeneralError x;
        OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.getTransactionStore().get((AccessToken)new AccessTokenImpl(at.getJti()));
        OA2SE oa2SE = (OA2SE)BearerTokenServlet.getServiceEnvironment();
        if (transaction == null) {
            TXRecord oldTXR = (TXRecord)oa2SE.getTxStore().get(BasicIdentifier.newID((URI)at.getJti()));
            if (oldTXR == null) {
                ServletDebugUtil.trace((Object)((Object)this), (String)("No transaction found, no TXRecord found for access token = " + String.valueOf(at)));
                OA2GeneralError ge = new OA2GeneralError("invalid_token", "token not found", 401, null);
                ge.setForensicMessage("Error getting exchange record for the access token \"" + String.valueOf(at.getJti()) + "\"");
                throw ge;
            }
            transaction = (OA2ServiceTransaction)((Object)this.getTransactionStore().get((Object)oldTXR.getParentID()));
            if (!oldTXR.isValid()) {
                OA2GeneralError x2 = new OA2GeneralError("invalid_token", "The token is not valid", 401, null, (BaseClient)(transaction == null ? null : transaction.getClient()));
                x2.setForensicMessage("The token is not valid");
                throw x2;
            }
            if (oldTXR.getExpiresAt() < System.currentTimeMillis()) {
                OA2GeneralError x3 = new OA2GeneralError("invalid_token", "The token has expired", 401, null, (BaseClient)(transaction == null ? null : transaction.getClient()));
                x3.setForensicMessage("The token has expired");
                throw x3;
            }
            state.txRecord = oldTXR;
            state.transaction = transaction;
        } else {
            state.transaction = transaction;
        }
        if (transaction == null) {
            x = new OA2GeneralError("invalid_request", "no transaction found.", 400, null);
            x.setForensicMessage("no transaction found.");
            throw x;
        }
        if (at.isJWT()) {
            JSONWebKeys keys = ((OA2SE)BearerTokenServlet.getServiceEnvironment()).getJsonWebKeys();
            VirtualIssuer vo = oa2SE.getVI(transaction.getClient().getIdentifier());
            if (vo != null) {
                keys = vo.getJsonWebKeys();
            }
            try {
                JWTUtil.verifyAndReadJWT((String)at.getToken(), (JSONWebKeys)keys);
            }
            catch (Throwable t) {
                ServletDebugUtil.trace((Object)((Object)this), (String)("Failed to verify access token JWT for " + String.valueOf(at)));
                OA2GeneralError x4 = new OA2GeneralError("invalid_request", "invalid access token", 400, null, (BaseClient)transaction.getClient());
                x4.setForensicMessage("invalid access token");
                throw x4;
            }
        }
        if (at.isExpired()) {
            x = new OA2RedirectableError("invalid_token", "expired token.", 400, transaction.getRequestState(), transaction.getCallback(), (BaseClient)transaction.getClient());
            x.setForensicMessage("expired token.");
            throw x;
        }
        return transaction;
    }
}

