/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;

public class ClientUtils {
    public static long computeATLifetime(OA2ServiceTransaction st2, OA2Client client, OA2SE oa2SE) {
        if (oa2SE.getMaxATLifetime() <= 0L) {
            throw new NFWException("the server-wide default for the access token lifetime has not been set.");
        }
        return ClientUtils.computeTokenLifetime(oa2SE.getMaxATLifetime(), oa2SE.getAccessTokenLifetime(), client.getAtLifetime(), client.getMaxATLifetime(), client.getAccessTokensConfig(), st2.getRequestedATLifetime());
    }

    public static long computeATLifetime(OA2ServiceTransaction st2, OA2SE oa2SE) {
        return ClientUtils.computeATLifetime(st2, st2.getOA2Client(), oa2SE);
    }

    public static long computeTokenLifetime(long serverMaxLifetime, long defaultServerLifetime, long clientLifetime, long clientMaxLifetime, AbstractPayloadConfig config, long requestLifetime) {
        return ClientUtils.computeTokenLifetime(serverMaxLifetime, defaultServerLifetime, clientLifetime, clientMaxLifetime, config == null ? null : config.getLifetime(), requestLifetime);
    }

    public static long computeTokenLifetime(long serverMaxLifetime, long defaultServerLifetime, long clientLifetime, long clientMaxLifetime, Long clientConfiguredLifetime, long requestLifetime) {
        if (serverMaxLifetime <= 0L) {
            throw new NFWException("the server-wide default for the token lifetime has not been set.");
        }
        long maxLifetime = serverMaxLifetime;
        if (0L < clientMaxLifetime) {
            maxLifetime = Math.min(clientMaxLifetime, serverMaxLifetime);
        }
        long lifetime = -1L;
        lifetime = 0L < clientLifetime ? Math.min(clientLifetime, maxLifetime) : defaultServerLifetime;
        if (clientConfiguredLifetime != null && 0L < clientConfiguredLifetime) {
            lifetime = Math.min(clientConfiguredLifetime, maxLifetime);
        }
        if (0L < requestLifetime) {
            lifetime = Math.min(requestLifetime, maxLifetime);
        }
        return lifetime;
    }

    public static long computeRTGracePeriod(OA2Client client, OA2SE oa2SE) {
        if (!oa2SE.isRTGracePeriodEnabled()) {
            return 0L;
        }
        if (client.getRtGracePeriod() == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT) {
            return oa2SE.getRtGracePeriod();
        }
        return client.getRtGracePeriod();
    }

    public static long computeIDTLifetime(OA2ServiceTransaction st2, OA2SE oa2SE) {
        return ClientUtils.computeIDTLifetime(st2, st2.getOA2Client(), oa2SE);
    }

    public static long computeIDTLifetime(OA2ServiceTransaction st2, OA2Client client, OA2SE oa2SE) {
        if (oa2SE.getMaxIdTokenLifetime() <= 0L) {
            throw new NFWException("the server-wide default for the IDToken token lifetime has not been set.");
        }
        return ClientUtils.computeTokenLifetime(oa2SE.getMaxIdTokenLifetime(), oa2SE.getIdTokenLifetime(), client.getIdTokenLifetime(), client.getMaxIDTLifetime(), client.getIDTokenConfig(), st2.getRequestedIDTLifetime());
    }

    protected static long computeATLifetimeNEW(OA2ServiceTransaction st2, OA2SE oa2SE) {
        return ClientUtils.computeATLifetime(st2, st2.getOA2Client(), oa2SE);
    }

    public static long computeRefreshLifetime(OA2ServiceTransaction st2, OA2Client client, OA2SE oa2SE) {
        return ClientUtils.computeRefreshLifetimeNEW(st2, client, oa2SE);
    }

    public static long computeRefreshLifetime(OA2ServiceTransaction st2, OA2SE oa2SE) {
        return ClientUtils.computeRefreshLifetime(st2, st2.getOA2Client(), oa2SE);
    }

    public static long computeRefreshLifetimeOLD(OA2ServiceTransaction st2, OA2SE oa2SE) {
        if (!oa2SE.isRefreshTokenEnabled()) {
            throw new NFWException("Refresh tokens are disabled for this server.");
        }
        if (oa2SE.getMaxRTLifetime() <= 0L) {
            throw new NFWException("Either refresh tokens are disabled for this server, or the server-wide default for the refresh token lifetime has not been set.");
        }
        long lifetime = -1L;
        OA2Client client = (OA2Client)st2.getClient();
        lifetime = 0L < client.getRtLifetime() ? Math.min(oa2SE.getMaxRTLifetime(), client.getRtLifetime()) : OA2ConfigurationLoader.REFRESH_TOKEN_LIFETIME_DEFAULT;
        st2.setMaxRTLifetime(lifetime);
        if (client.hasRefreshTokenConfig() && 0L < client.getRefreshTokensConfig().getLifetime()) {
            lifetime = Math.min(client.getRefreshTokensConfig().getLifetime(), lifetime);
        }
        if (0L < st2.getRequestedRTLifetime()) {
            lifetime = Math.min(st2.getRequestedRTLifetime(), lifetime);
        }
        return lifetime;
    }

    public static long computeRefreshLifetimeNEW(OA2ServiceTransaction st2, OA2Client client, OA2SE oa2SE) {
        if (!oa2SE.isRefreshTokenEnabled()) {
            throw new NFWException("Refresh tokens are disabled for this server.");
        }
        if (oa2SE.getMaxRTLifetime() <= 0L) {
            throw new NFWException("Either refresh tokens are disabled for this server, or the server-wide default for the refresh token lifetime has not been set.");
        }
        return ClientUtils.computeTokenLifetime(oa2SE.getMaxRTLifetime(), oa2SE.getRefreshTokenLifetime(), client.getRtLifetime(), client.getMaxRTLifetime(), client.getRefreshTokensConfig(), st2.getRequestedRTLifetime());
    }

    public static void verifyClientSecret(OA2Client client, String rawSecret, boolean isAT) {
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)client);
        if (rawSecret == null) {
            debugger.trace(ClientUtils.class, "verifyClientSecret: no secret, throwing exception.");
            if (isAT) {
                throw new OA2ATException("unauthorized_client", "missing secret");
            }
            throw new OA2GeneralError("unauthorized_client", "missing secret", 401, null, (BaseClient)client);
        }
        if (StringUtils.isTrivial((String)client.getSecret())) {
            debugger.trace(ClientUtils.class, "verifyClientSecret: no secret, so client is not configured right.");
            if (isAT) {
                throw new OA2ATException("unauthorized_client", "client has no configured secret", (String)null);
            }
            throw new OA2GeneralError("unauthorized_client", "client has no configured secret.", 401, null, (BaseClient)client);
        }
        if (!client.getSecret().equals(DigestUtils.sha1Hex((String)rawSecret))) {
            debugger.trace(ClientUtils.class, "verifyClientSecret: bad secret, throwing exception.");
            if (isAT) {
                throw new OA2ATException("unauthorized_client", "incorrect secret", (BaseClient)client);
            }
            throw new OA2GeneralError("unauthorized_client", "incorrect secret", 401, null, (BaseClient)client);
        }
        debugger.trace(ClientUtils.class, "verifyClientSecret: secret ok.");
    }

    public static void verifyClient(OA2Client client, HttpServletRequest request, boolean isAT) {
    }

    public static String getClientSecret(HttpServletRequest request, String raw) {
        String rawSecret = null;
        if (OA2HeaderUtils.hasBasicHeader((HttpServletRequest)request)) {
            DebugUtil.trace(ClientUtils.class, (String)"doIt: Got the header.");
            try {
                rawSecret = OA2HeaderUtils.getSecretFromHeaders((HttpServletRequest)request);
            }
            catch (UnsupportedEncodingException e) {
                throw new NFWException("internal use of UTF-8 encoding failed");
            }
        } else {
            DebugUtil.trace(ClientUtils.class, (String)"doIt: no header for authentication, looking at parameters.");
            rawSecret = raw;
        }
        return rawSecret;
    }

    public static Collection<String> resolveScopes(TransactionState transactionState, OA2Client oa2Client, boolean isRFC8628) {
        return ClientUtils.resolveScopes(transactionState, oa2Client, false, isRFC8628);
    }

    public static Collection<String> resolveScopes(OA2ServiceTransaction t) {
        return ClientUtils.resolveScopes(null, t, t.getOA2Client(), false, false);
    }

    public static Collection<String> resolveScopes(HttpServletRequest request, OA2ServiceTransaction st, OA2Client oa2Client, boolean isNew, boolean isRFC8628) {
        String rawScopes = request.getParameter("scope");
        ArrayList<String> passedInScopes = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(rawScopes);
        while (stringTokenizer.hasMoreTokens()) {
            passedInScopes.add(stringTokenizer.nextToken());
        }
        return ClientUtils.resolveScopes(request, st, oa2Client, passedInScopes, isNew, isRFC8628, false);
    }

    public static Collection<String> resolveScopes(HttpServletRequest request, OA2ServiceTransaction st, OA2Client oa2Client, Collection passedInScopes, boolean isNew, boolean isRFC8628, boolean isRFC6749_4_4) {
        ArrayList<String> requestedScopes = new ArrayList<String>();
        if (passedInScopes.isEmpty()) {
            return requestedScopes;
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)st.getOA2Client());
        if (oa2Client.isPublicClient()) {
            if (!oa2Client.getScopes().contains("openid")) {
                throw new OA2RedirectableError("invalid_request", "The openid scope is missing from the request.", 400, st.getRequestState(), st.getCallback(), (BaseClient)oa2Client);
            }
            requestedScopes.add("openid");
            debugger.trace(ClientUtils.class, ".resolveScopes: after resolution=" + String.valueOf(requestedScopes));
            st.setScopes(requestedScopes);
            return requestedScopes;
        }
        boolean hasOpenIDScope = false;
        for (Object y : passedInScopes) {
            String x = y.toString();
            if (!isRFC6749_4_4 && x.equals("offline_access")) continue;
            if (oa2Client.useStrictScopes() && !OA2Scopes.ScopeUtil.hasScope((String)x) && !oa2Client.getScopes().contains(x)) {
                throw new OA2RedirectableError("invalid_scope", "Unrecognized scope \"" + x + "\"", 400, st.getRequestState(), st.getCallback(), (BaseClient)oa2Client);
            }
            if (x.equals("openid")) {
                hasOpenIDScope = true;
            }
            requestedScopes.add(x);
        }
        if (((OA2SE)OA4MPServlet.getServiceEnvironment()).isOIDCEnabled() && oa2Client.useStrictScopes() && oa2Client.getScopes().contains("openid") && !hasOpenIDScope) {
            throw new OA2RedirectableError("invalid_request", "The openid scope is missing from the request.", 400, st.getRequestState(), st.getCallback(), (BaseClient)oa2Client);
        }
        st.setScopes(requestedScopes);
        debugger.trace(ClientUtils.class, ".resolveScopes: " + (oa2Client.useStrictScopes() ? "" : "non-") + "strict scopes after resolution=" + String.valueOf(requestedScopes));
        return requestedScopes;
    }

    public static Collection<String> resolveScopes(TransactionState transactionState, OA2Client oa2Client, boolean isNew, boolean isRFC8628) {
        return ClientUtils.resolveScopes(transactionState.getRequest(), (OA2ServiceTransaction)transactionState.getTransaction(), oa2Client, isNew, isRFC8628);
    }
}

