/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class DIServiceConfig {
    public static final String DI_SERVICE_CONFIG_TAG = "diService";
    public static final String DI_SERVICE_ENABLED_ATTRIBUTE = "enabled";
    public static final String DI_SERVICE_USERS_TAG = "users";
    public static final String DI_SERVICE_USER_TAG = "user";
    public static final String DI_SERVICE_NAME_ATTRIBUTE = "username";
    public static final String DI_SERVICE_HASH_ATTRIBUTE = "hash";
    boolean enabled = false;
    Map<String, String> users = new HashMap<String, String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean hasUsers() {
        return !this.users.isEmpty();
    }

    public boolean hasUser(String username) {
        return this.users.containsKey(username);
    }

    public String getHash(String username) {
        return this.users.get(username);
    }

    public void checkPassword(String username, String password) {
        if (!this.hasUser(username)) {
            throw new UnknownDISericeUserException("unknown db service user \"" + username + "\"");
        }
        String hashed = DigestUtils.sha1Hex((String)password);
        if (!hashed.equals(this.getHash(username))) {
            throw new UnknownDISericeUserException("incorrect db service password for \"" + username + "\"");
        }
    }

    public void addUser(String username, String hash) {
        this.users.put(username, hash);
    }

    public static class UnknownDISericeUserException
    extends GeneralException {
        public UnknownDISericeUserException() {
        }

        public UnknownDISericeUserException(Throwable cause) {
            super(cause);
        }

        public UnknownDISericeUserException(String message) {
            super(message);
        }

        public UnknownDISericeUserException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

