/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.util.ssl.MyTrustManager;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;

public class LDAPSSLSocketFactory
extends SocketFactory {
    static KeyManagerFactory keyManagerFactory;
    static LDAPConfiguration ldapConfiguration;
    protected static SSLConfiguration sslConfiguration;
    static String ldap;

    protected static void say(String x) {
        System.err.println(x);
    }

    public LDAPSSLSocketFactory() {
        LDAPSSLSocketFactory.say("in constructor");
    }

    public static SocketFactory getDefault() {
        LDAPSSLSocketFactory.say("in getDefault");
        return new LDAPSSLSocketFactory();
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        LDAPSSLSocketFactory.say("in create socket #1");
        return null;
    }

    protected SSLContext getContext() throws NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance(LDAPSSLSocketFactory.getSslConfiguration().getTlsVersion());
        return sc;
    }

    protected SSLSocketFactory getSF() throws GeneralSecurityException, IOException {
        SSLContext sc = SSLContext.getInstance("SSL");
        MyTrustManager mtm = new MyTrustManager(null, LDAPSSLSocketFactory.getSslConfiguration());
        mtm.setHost(LDAPSSLSocketFactory.getLdapConfiguration().getServer());
        TrustManager[] trustAllCerts = new TrustManager[]{mtm};
        sc.init(this.getKeyManagerFactory().getKeyManagers(), trustAllCerts, new SecureRandom());
        SSLSocketFactory sf = sc.getSocketFactory();
        return sf;
    }

    protected SSLConnectionSocketFactory getSocketFactory() {
        try {
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(this.getContext());
            return socketFactory;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        if (keyManagerFactory == null) {
            keyManagerFactory = KeyManagerFactory.getInstance(LDAPSSLSocketFactory.getSslConfiguration().getKeyManagerFactory());
            KeyStore ks = KeyStore.getInstance(LDAPSSLSocketFactory.getSslConfiguration().getKeystoreType());
            FileInputStream fis = new FileInputStream(LDAPSSLSocketFactory.getSslConfiguration().getKeystore());
            ks.load(fis, LDAPSSLSocketFactory.getSslConfiguration().getKeystorePasswordChars());
            keyManagerFactory.init(ks, LDAPSSLSocketFactory.getSslConfiguration().getKeystorePasswordChars());
        }
        return keyManagerFactory;
    }

    @Override
    public Socket createSocket(String address, int port) throws IOException {
        LDAPSSLSocketFactory.say("in create socket #2");
        try {
            return this.getSF().createSocket(LDAPSSLSocketFactory.getLdapConfiguration().getServer(), LDAPSSLSocketFactory.getLdapConfiguration().getPort());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Socket createSocket(String address, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        LDAPSSLSocketFactory.say("in create socket #3");
        return null;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        LDAPSSLSocketFactory.say("in create socket #4");
        return null;
    }

    public static void clear() {
        sslConfiguration = null;
    }

    public static SSLConfiguration getSslConfiguration() {
        return LDAPSSLSocketFactory.getLdapConfiguration().getSslConfiguration();
    }

    public static LDAPConfiguration getLdapConfiguration() {
        return ldapConfiguration;
    }

    public static void setLdapConfiguration(LDAPConfiguration ldapConfiguration) {
        LDAPSSLSocketFactory.ldapConfiguration = ldapConfiguration;
    }

    static {
        ldap = "{\"ldap\": {\"authorizationType\": \"simple\",\"address\": \"registry-test.cilogon.org\",\"port\": 636,\"principal\": \"uid=oa4mp_user,ou=system,o=NANOGrav,dc=cilogon,dc=org\",\"password\": \"b6r6r4PFUGOWOa25WL4q\",\"searchBase\": \"ou=people,o=NANOGrav,dc=cilogon,dc=org\",\"searchAttributes\": [{\"name\": \"CILogonPersonMediaWikiUsername\",\"returnAsList\": false,\"returnName\":\"preferred_username\"},{\"name\": \"givenName\",\"returnAsList\": false,\"returnName\": \"given_name\"},{\"name\": \"sn\",\"returnAsList\": false,\"returnName\": \"family_name\"},{\"name\": \"mail\",\"returnAsList\": false,\"returnName\": \"email\"}],\"searchName\": \"username\"}}";
    }
}

