/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.HeaderUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.storage.upkeep.UpkeepThread;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public abstract class MultiAuthServlet
extends OA4MPServlet {
    public static List<UpkeepThread> upkeepThreadList = null;

    public Client getClient(HttpServletRequest request) {
        String assertionType = request.getParameter("client_assertion_type");
        if (!StringUtils.isTrivial((String)assertionType) && assertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            try {
                return OA2HeaderUtils.getRFC7523Client(request, (OA2SE)MultiAuthServlet.getServiceEnvironment());
            }
            catch (Throwable t) {
                throw new OA2ATException("invalid_request", t.getMessage());
            }
        }
        OA2Client client = null;
        Identifier paramID = OA2HeaderUtils.getIDFromParameters(request);
        Identifier headerID = null;
        try {
            headerID = OA2HeaderUtils.getIDFromHeaders((HttpServletRequest)request);
        }
        catch (UnsupportedEncodingException e) {
            throw new NFWException("Error: internal use of UTF-8 encoding failed");
        }
        catch (Throwable tt) {
            ServletDebugUtil.trace(((Object)((Object)this)).getClass(), (String)("Got an exception checking for the header. This is usually benign:\"" + tt.getMessage() + "\""));
        }
        if (paramID == null) {
            if (headerID == null) {
                throw new OA2ATException("invalid_request", "no client identifier given");
            }
            client = (OA2Client)this.getClient(headerID);
        } else if (headerID == null) {
            client = (OA2Client)this.getClient(paramID);
        } else {
            if (!paramID.equals(headerID)) {
                throw new OA2ATException("invalid_request", "too many client identifiers");
            }
            client = (OA2Client)this.getClient(headerID);
        }
        return client;
    }

    public void verifyClientSecret(OA2Client client, String rawSecret) {
        ClientUtils.verifyClientSecret(client, rawSecret, true);
    }

    public void verifyClient(OA2Client client, HttpServletRequest request) {
        this.verifyClient(client, request, true);
    }

    public void verifyClient(OA2Client client, HttpServletRequest request, boolean isAT) {
        String grantType = request.getParameter("client_assertion_type");
        if (grantType != null && grantType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            try {
                OA2HeaderUtils.verifyRFC7523Client(client, request, (OA2SE)MultiAuthServlet.getServiceEnvironment());
            }
            catch (Throwable t) {
                if (isAT) {
                    throw new OA2ATException("unauthorized_client", "could not verify client:" + t.getMessage());
                }
                throw new OA2GeneralError("unauthorized_client", "could not verify client:" + t.getMessage(), 401, null, (BaseClient)client);
            }
            return;
        }
        ClientUtils.verifyClientSecret(client, this.getClientSecret(request), isAT);
    }

    protected String getClientSecret(HttpServletRequest request) {
        return ClientUtils.getClientSecret(request, HeaderUtils.getFirstParameterValue((HttpServletRequest)request, (String)"client_secret"));
    }

    public AdminClient getAdminClient(HttpServletRequest request) {
        AdminClient adminClient = null;
        Identifier paramID = OA2HeaderUtils.getIDFromParameters(request);
        Identifier headerID = null;
        try {
            headerID = OA2HeaderUtils.getIDFromHeaders((HttpServletRequest)request);
        }
        catch (UnsupportedEncodingException e) {
            throw new NFWException("Error: internal use of UTF-8 encoding failed");
        }
        catch (Throwable tt) {
            ServletDebugUtil.trace(((Object)((Object)this)).getClass(), (String)("Got an exception checking for the header. This is usually benign:\"" + tt.getMessage() + "\""));
        }
        if (paramID == null) {
            if (headerID == null) {
                throw new OA2ATException("invalid_request", "no client identifier given");
            }
            adminClient = this.getAdminClient(headerID);
        } else if (headerID == null) {
            adminClient = this.getAdminClient(paramID);
        } else {
            if (!paramID.equals(headerID)) {
                throw new OA2ATException("invalid_request", "too many client identifiers", (BaseClient)adminClient);
            }
            adminClient = this.getAdminClient(headerID);
        }
        return adminClient;
    }

    public AdminClient getAdminClient(Identifier identifier) {
        AdminClientStore store = MultiAuthServlet.getServiceEnvironment().getAdminClientStore();
        if (identifier == null) {
            throw new UnknownClientException("no client id");
        }
        AdminClient c = (AdminClient)store.get((Object)identifier);
        if (c == null) {
            if (store.size() == 0) {
                DebugUtil.trace((Object)((Object)this), (String)"ADMIN CLIENT STORE HAS NO ENTRIES!");
                DebugUtil.trace((Object)((Object)this), (String)("client name is " + store.getClass().getSimpleName()));
                DebugUtil.trace((Object)((Object)this), (String)("client store is a " + String.valueOf(store)));
            }
            String ww = "Unknown admin client: \"" + String.valueOf(identifier) + "\"  cannot be found.";
            this.warn(ww + " admin client store is " + String.valueOf(store));
            throw new UnknownClientException(ww + "  Is the value in the client config correct?", identifier);
        }
        this.checkClientApproval((BaseClient)c);
        return c;
    }
}

