/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.storage.servlet.AbstractRegistrationServlet;
import org.oa4mp.server.api.util.NewAdminClientEvent;
import org.oa4mp.server.api.util.NewClientEvent;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.OA2RegistrationServlet;

public class OA2AdminRegistrationServlet
extends AbstractRegistrationServlet {
    public static final String ISSUER_NAME = "issuer";

    protected String getInitPage() {
        return "admin-client-registration-init.jsp";
    }

    protected String getOKPage() {
        return "admin-client-registration-ok.jsp";
    }

    protected BaseClient setupNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        OA2SE oa2se = (OA2SE)OA2AdminRegistrationServlet.getServiceEnvironment();
        AdminClient client = (AdminClient)oa2se.getAdminClientStore().create();
        this.info("creating entry for client=" + client.getIdentifierString());
        client.setName(this.getRequiredParam(request, "clientName", (BaseClient)client));
        String x = this.getRequiredParam(request, "clientEmail", (BaseClient)client);
        Pattern p = Pattern.compile(this.emailPattern);
        Matcher m = p.matcher(x);
        if (!m.matches()) {
            throw new AbstractRegistrationServlet.ClientRegistrationRetryException("The email address \"" + x + "\" is not valid.", null, (BaseClient)client);
        }
        client.setEmail(x);
        String issuer = this.getParameter(request, ISSUER_NAME);
        if (!this.isEmpty(issuer)) {
            client.setIssuer(issuer);
        }
        byte[] bytes = new byte[oa2se.getClientSecretLength()];
        OA2RegistrationServlet.random.nextBytes(bytes);
        String secret64 = Base64.encodeBase64URLSafeString((byte[])bytes);
        client.setSecret(secret64);
        ((OA2SE)OA2AdminRegistrationServlet.getServiceEnvironment()).getAdminClientStore().save((Identifiable)client);
        this.info("Adding approval record for client=" + client.getIdentifierString());
        ClientApproval clientApproval = new ClientApproval(client.getIdentifier());
        clientApproval.setApproved(false);
        this.info("done with client registration, client=" + client.getIdentifierString());
        return client;
    }

    protected BaseClient addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AdminClient client = (AdminClient)this.setupNewClient(request, response);
        this.fireNewClientEvent((NewClientEvent)new NewAdminClientEvent((Object)this, client));
        return client;
    }

    protected void save(BaseClient client) {
        ((OA2SE)OA2AdminRegistrationServlet.getServiceEnvironment()).getAdminClientStore().save((Identifiable)((AdminClient)client));
    }

    public void present(PresentableState state) throws Throwable {
        super.present(state);
        if (state.getState() == 100) {
            if (state instanceof AbstractRegistrationServlet.ClientState) {
                AbstractRegistrationServlet.ClientState cState = (AbstractRegistrationServlet.ClientState)state;
                String secret = DigestUtils.sha1Hex((String)cState.getClient().getSecret());
                cState.getClient().setSecret(secret);
                this.save(cState.getClient());
            } else {
                throw new IllegalStateException("Error: An instance of ClientState was expected, but got an instance of \"" + state.getClass().getName() + "\"");
            }
        }
    }

    public void prepare(PresentableState state) throws Throwable {
        super.prepare(state);
        HttpServletRequest request = state.getRequest();
        if (state.getState() == 0) {
            request.setAttribute(ISSUER_NAME, (Object)ISSUER_NAME);
        }
    }
}

