/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.IllegalAccessException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.NonceHerder;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.delegation.server.jwt.HandlerRunner;
import org.oa4mp.delegation.server.request.AGResponse;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.server.AGIResponse2;
import org.oa4mp.delegation.server.server.AGRequest2;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.server.api.storage.servlet.IssuerTransactionState;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2ServletUtils;
import org.oa4mp.server.loader.oauth2.state.ScriptRuntimeEngineFactory;
import org.oa4mp.server.loader.oauth2.storage.UsernameFindable;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.oauth2.tokens.AccessTokenConfig;

public class OA2AuthorizedServletUtil {
    protected OA4MPServlet servlet = null;

    public OA2AuthorizedServletUtil(OA4MPServlet servlet) {
        this.servlet = servlet;
    }

    public OA2ServiceTransaction doDelegation(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        return this.doDelegation(req, resp, false);
    }

    public OA2ServiceTransaction doDelegation(HttpServletRequest req, HttpServletResponse resp, boolean encodeTokenInResponse) throws Throwable {
        OA2Client client;
        try {
            client = (OA2Client)this.servlet.getClient(req);
        }
        catch (UnknownClientException ukc) {
            throw new OA2GeneralError("unauthorized_client", "unknown client", 400, null);
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)client);
        OA2SE oa2se = (OA2SE)OA4MPServlet.getServiceEnvironment();
        this.basicChecks(req);
        try {
            String cid = "client=" + String.valueOf(client.getIdentifier());
            debugger.info((Object)this, "2.a. Start a new request: " + cid);
            this.servlet.checkClientApproval((BaseClient)client);
            AGRequest2 agRequest2 = new AGRequest2(req, oa2se.getAuthorizationGrantLifetime());
            AGIResponse2 agResponse = (AGIResponse2)this.servlet.getAGI().process((Request)agRequest2);
            agResponse.setEncodeToken(encodeTokenInResponse);
            OA2ServiceTransaction transaction = this.createNewTransaction(agResponse.getGrant());
            transaction.setResponseTypes(this.getAndCheckResponseTypes(req));
            transaction.setAuthGrantLifetime(oa2se.getAuthorizationGrantLifetime());
            String requestState = req.getParameter("state");
            transaction.setRequestState(requestState);
            transaction.setClient(client);
            OA2Client resolvedClient = OA2ClientUtils.resolvePrototypes(oa2se, client);
            OA2ServletUtils.processXAs(req, transaction, resolvedClient);
            agResponse.setServiceTransaction((ServiceTransaction)transaction);
            transaction = (OA2ServiceTransaction)this.verifyAndGet((IssuerResponse)agResponse);
            Date now = new Date();
            transaction.setAuthTime(now);
            resolvedClient.setLastAccessed(now);
            client.setLastAccessed(now);
            debugger.info((Object)this, "Saved new transaction with id=" + transaction.getIdentifierString());
            String codeChallenge = req.getParameter("code_challenge");
            String codeChallengeMethod = req.getParameter("code_challenge_method");
            OA2AuthorizedServletUtil.setupPKCE(codeChallenge, codeChallengeMethod, oa2se, transaction, resolvedClient, debugger);
            Map params = agResponse.getParameters();
            XMLMap backup = GenericStoreUtils.toXML((Store)OA4MPServlet.getServiceEnvironment().getTransactionStore(), (Identifiable)transaction);
            this.preprocess(new TransactionState(req, resp, params, (BasicTransaction)transaction, backup));
            debugger.info((Object)this, "2.b finished initial request for token =\"" + transaction.getIdentifierString() + "\".");
            this.postprocess((TransactionState)new IssuerTransactionState(req, resp, params, (BasicTransaction)transaction, backup, (IssuerResponse)agResponse), resolvedClient);
            this.servlet.getTransactionStore().save((Identifiable)transaction);
            agResponse.write(resp);
            return transaction;
        }
        catch (Throwable t) {
            if (t instanceof UnapprovedClientException) {
                DebugUtil.warn((Object)this, (String)("Unapproved client: " + client.getIdentifierString()));
            }
            throw t;
        }
    }

    public static void setupPKCE(String codeChallenge, String codeChallengeMethod, OA2SE oa2se, OA2ServiceTransaction transaction, OA2Client resolvedClient, MetaDebugUtil debugger) {
        if (StringUtils.isTrivial((String)codeChallenge)) {
            if (oa2se.isRfc7636Required() && resolvedClient.isPublicClient()) {
                throw new OA2RedirectableError("access_denied", "access denied", 401, transaction.getRequestState(), transaction.getCallback());
            }
        } else {
            debugger.trace("Setting code challenge to codeChallenge");
            transaction.setCodeChallenge(codeChallenge);
            if (StringUtils.isTrivial((String)codeChallengeMethod)) {
                transaction.setCodeChallengeMethod("plain");
            } else {
                transaction.setCodeChallengeMethod(codeChallengeMethod);
            }
        }
    }

    protected OA2ServiceTransaction doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        String rawcb = this.basicChecks(httpServletRequest);
        OA2ServiceTransaction t = this.CheckIdTokenHint(httpServletRequest, httpServletResponse, rawcb);
        t.setResponseTypes(this.getAndCheckResponseTypes(httpServletRequest));
        if (t != null) {
            return t;
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)t.getOA2Client());
        debugger.trace((Object)this, "Starting doDelegation");
        t = this.doDelegation(httpServletRequest, httpServletResponse);
        OA2SE oa2SE = (OA2SE)OA4MPServlet.getServiceEnvironment();
        OA2Client resolvedClient = OA2ClientUtils.resolvePrototypes(oa2SE, t.getOA2Client());
        debugger.trace((Object)this, "Starting done with doDelegation, creating claim util");
        HandlerRunner handlerRunner = new HandlerRunner((OIDCServiceTransactionInterface)t, ScriptRuntimeEngineFactory.createRTE(oa2SE, t, resolvedClient.getConfig()));
        OA2ClientUtils.setupHandlers(handlerRunner, oa2SE, t, resolvedClient, httpServletRequest);
        DebugUtil.trace((Object)this, (String)"starting to process claims, creating basic claims:");
        try {
            handlerRunner.doAuthClaims();
        }
        catch (IllegalAccessException iax) {
            oa2SE.getTransactionStore().save((Identifiable)t);
            throw new OA2RedirectableError("access_denied", "access denied", 401, t.getRequestState(), t.getCallback());
        }
        if (!t.getFlowStates().acceptRequests || t.getFlowStates().getClaims) {
            oa2SE.getTransactionStore().save((Identifiable)t);
            throw new OA2RedirectableError("access_denied", "access denied", 401, t.getRequestState(), t.getCallback());
        }
        DebugUtil.trace((Object)this, (String)("done with claims, transaction saved, claims = " + String.valueOf(t.getUserMetaData())));
        return t;
    }

    private String basicChecks(HttpServletRequest httpServletRequest) {
        String requestState = httpServletRequest.getParameter("state");
        String rawcb = httpServletRequest.getParameter("redirect_uri");
        try {
            URI.create(rawcb);
        }
        catch (Throwable t) {
            throw new OA2GeneralError("request_uri_not_supported", "redirect is not a valid uri", 400, requestState);
        }
        if (httpServletRequest.getParameterMap().containsKey("request_uri")) {
            throw new OA2GeneralError("request_uri_not_supported", "Request uri not supported by this server", 400, requestState);
        }
        if (httpServletRequest.getParameterMap().containsKey("request")) {
            throw new OA2GeneralError("request_not_supported", "Request not supported by this server", 400, requestState);
        }
        if (!httpServletRequest.getParameterMap().containsKey("response_type")) {
            throw new OA2GeneralError("invalid_request", " The response_type is missing from the request.", 400, requestState);
        }
        return rawcb;
    }

    protected List<String> getAndCheckResponseTypes(HttpServletRequest httpServletRequest) {
        JSONArray array = new JSONArray();
        String requestState = httpServletRequest.getParameter("state");
        String rawResponseType = httpServletRequest.getParameter("response_type");
        StringTokenizer st = new StringTokenizer(rawResponseType, " ");
        TreeSet<String> responseTypes = new TreeSet<String>();
        while (st.hasMoreTokens()) {
            responseTypes.add(st.nextToken());
        }
        if (responseTypes.size() == 0 || 2 < responseTypes.size()) {
            DebugUtil.trace((Object)this, (String)("unrecognized response type \"" + httpServletRequest.getParameter("response_type")));
            throw new OA2GeneralError("unsupported_response_type", "The given response_type is not supported.", 400, requestState);
        }
        if (responseTypes.contains("code")) {
            if (responseTypes.size() != 1 && !responseTypes.contains("id_token")) {
                DebugUtil.trace((Object)this, (String)("unrecognized response type \"" + httpServletRequest.getParameter("response_type")));
                throw new OA2GeneralError("unsupported_response_type", "The given response_type is not supported.", 400, requestState);
            }
            array.addAll(responseTypes);
            return array;
        }
        DebugUtil.trace((Object)this, (String)("unrecognized response type \"" + httpServletRequest.getParameter("response_type")));
        throw new OA2GeneralError("unsupported_response_type", "The given response_type is not supported.", 400, requestState);
    }

    protected OA2ServiceTransaction CheckIdTokenHint(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String callback) {
        if (!httpServletRequest.getParameterMap().containsKey("id_token_hint")) {
            return null;
        }
        UsernameFindable ufStore = null;
        String rawIDToken = String.valueOf(httpServletRequest.getParameterMap().get("id_token_hint"));
        JSONObject idToken = null;
        try {
            idToken = JWTUtil.verifyAndReadJWT((String)rawIDToken, (JSONWebKeys)((OA2SE)OA4MPServlet.getServiceEnvironment()).getJsonWebKeys());
        }
        catch (Throwable e) {
            throw new OA2GeneralError("invalid_request", "cannot read ID token hint", 400, null);
        }
        String username = null;
        if (idToken.containsKey((Object)"sub") && StringUtils.isTrivial((String)(username = idToken.getString("sub")))) {
            throw new OA2GeneralError("request_not_supported", "Missing username parameter in the ID token. This request is not supported on this server", 400, null);
        }
        OA2ServiceTransaction t = null;
        try {
            ufStore = (UsernameFindable)this.servlet.getTransactionStore();
            List list = ufStore.getByUsername(username);
            if (!list.isEmpty()) {
                t = (OA2ServiceTransaction)((Object)list.get(0));
                if (idToken.containsKey((Object)"aud")) {
                    if (!t.getClient().getIdentifierString().equals(idToken.getString("aud"))) {
                        throw new OA2RedirectableError("request_not_supported", "Incorrect aud parameter in the ID token. This request is not supported on this server", 400, t.getRequestState(), t.getCallback(), (BaseClient)t.getClient());
                    }
                } else {
                    throw new OA2RedirectableError("request_not_supported", "No aud parameter in the ID token. This request is not supported on this server", 400, t.getRequestState(), t.getCallback(), (BaseClient)t.getClient());
                }
                httpServletResponse.setStatus(200);
                return t;
            }
        }
        catch (IOException e) {
            throw new NFWException("Could not cast the store to a username findable store.");
        }
        throw new OA2GeneralError("login_required", "Login required.", 401, null, (BaseClient)(t == null ? null : t.getClient()));
    }

    protected ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws UnsupportedEncodingException {
        String nonce;
        String rawRefreshLifetime;
        String rawATLifetime;
        AGResponse agResponse = (AGResponse)iResponse;
        Map params = agResponse.getParameters();
        OA2ServiceTransaction st = (OA2ServiceTransaction)agResponse.getServiceTransaction();
        String givenRedirect = (String)params.get("redirect_uri");
        OA2Client resolvedClient = OA2ClientUtils.resolvePrototypes((OA2SE)OA4MPServlet.getServiceEnvironment(), st.getOA2Client());
        OA2ClientUtils.check(resolvedClient, givenRedirect);
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)resolvedClient);
        String rawSecret = (String)params.get("client_secret");
        if (rawSecret != null) {
            debugger.info((Object)this, "Client is sending secret in initial request. Though not forbidden by the protocol this is discouraged.");
            if (!resolvedClient.getSecret().equals(rawSecret)) {
                debugger.info((Object)this, "And for what it is worth, the client sent along an incorrect secret too...");
            }
        }
        if (!StringUtils.isTrivial((String)(rawATLifetime = (String)params.get("at_lifetime")))) {
            try {
                long at = XMLConfigUtil.getValueSecsOrMillis((String)rawATLifetime);
                st.setRequestedATLifetime(at);
            }
            catch (Throwable t) {
                OA4MPServlet.getServiceEnvironment().info("Could not set request access token lifetime to \"" + rawATLifetime + "\" for client " + resolvedClient.getIdentifierString());
            }
        }
        if (!StringUtils.isTrivial((String)(rawRefreshLifetime = (String)params.get("rt_lifetime")))) {
            try {
                long rt = XMLConfigUtil.getValueSecsOrMillis((String)rawRefreshLifetime);
                st.setRequestedRTLifetime(rt);
            }
            catch (Throwable t) {
                OA4MPServlet.getServiceEnvironment().info("Could not set request refresh token lifetime to \"" + rawRefreshLifetime + "\" for client " + resolvedClient.getIdentifierString());
            }
        }
        if ((nonce = (String)params.get("nonce")) == null || nonce.length() == 0) {
            debugger.info((Object)this, "No nonce in initial request for " + resolvedClient.getIdentifierString());
        }
        NonceHerder.putNonce((String)nonce);
        if (params.containsKey("display") && !((String)params.get("display")).equals("page")) {
            throw new OA2RedirectableError("invalid_request", "Only display=page is supported", 400, st.getRequestState(), st.getCallback(), (BaseClient)st.getClient());
        }
        debugger.info((Object)this, "Created new unsaved transaction with id=" + st.getIdentifierString());
        st.setAuthGrantValid(false);
        st.setAccessTokenValid(false);
        st.setCallback(URI.create((String)params.get("redirect_uri")));
        st.setNonce(nonce);
        if (agResponse.getParameters().containsKey("max_age")) {
            throw new OA2RedirectableError("invalid_request", "The max_age parameter is not supported at this time.", 400, st.getRequestState(), st.getCallback());
        }
        this.checkPrompts(st, params);
        if (params.containsKey("request")) {
            throw new OA2RedirectableError("request_not_supported", "request not supported on this server", 400, st.getRequestState(), st.getCallback());
        }
        if (params.containsKey("request_uri")) {
            throw new OA2RedirectableError("request_uri_not_supported", "request_uri not supported on this server", 400, st.getRequestState(), st.getCallback());
        }
        if (params.containsKey("response_mode")) {
            st.setResponseMode((String)params.get("response_mode"));
        }
        return st;
    }

    protected OA2ServiceTransaction createNewTransaction(AuthorizationGrant grant) {
        return new OA2ServiceTransaction(grant);
    }

    protected static Collection<String> intersection(Collection<String> x, Collection<String> y) {
        ArrayList<String> output = new ArrayList<String>();
        for (String val : x) {
            if (!y.contains(val)) continue;
            output.add(val);
        }
        return output;
    }

    protected void checkPrompts(OA2ServiceTransaction transaction, Map<String, String> map) {
        if (!map.containsKey("prompt")) {
            return;
        }
        String prompts = map.get("prompt");
        StringTokenizer st = new StringTokenizer(prompts);
        ArrayList<String> prompt = new ArrayList<String>();
        while (st.hasMoreElements()) {
            prompt.add(st.nextToken());
        }
        if (!prompt.contains("none") && prompt.size() == 0) {
            throw new OA2RedirectableError("login_required", "A login is required on this server", 400, map.get("state"));
        }
        if (prompt.contains("none") && 1 < prompt.size()) {
            throw new OA2RedirectableError("invalid_request", "You cannot specify \"none\" for the prompt and any other option", 400, transaction.getRequestState(), transaction.getCallback());
        }
        OA2SE oa2SE = (OA2SE)OA4MPServlet.getServiceEnvironment();
        if (prompt.contains("none") && transaction.getOA2Client().isOIDCClient()) {
            JSONObject idTokenHint;
            String issuer;
            JSONWebKeys keys;
            boolean isInVI;
            if (!transaction.getOA2Client().isAllowPromptNone()) {
                throw new OA2RedirectableError("invalid_request", "Specifying prompt with value  \"none\" is not supported for this client id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            if (oa2SE.isAllowPromptNone()) {
                if (!transaction.getOA2Client().isAllowPromptNone()) {
                    throw new OA2RedirectableError("invalid_request", "Specifying prompt with value  \"none\" is not supported for this client id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
                }
            } else {
                throw new OA2RedirectableError("invalid_request", "Specifying prompt with value  \"none\" is not supported for this server id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            if (!map.containsKey("id_token_hint")) {
                throw new OA2RedirectableError("invalid_request", "Specifying prompt with value  \"none\" requires an id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            boolean ok = false;
            VirtualIssuer vi = oa2SE.getVI(transaction.getClient().getIdentifier());
            boolean bl = isInVI = vi != null;
            if (isInVI) {
                keys = oa2SE.getJsonWebKeys();
                issuer = oa2SE.getIssuer();
            } else {
                keys = vi.getJsonWebKeys();
                issuer = vi.getIssuer();
            }
            try {
                idTokenHint = JWTUtil.verifyAndReadJWT((String)map.get("id_token_hint"), (JSONWebKeys)keys);
            }
            catch (Throwable t) {
                MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)transaction.getOA2Client());
                debugger.trace("Could not verify ID Token hint JWT token:" + t.getMessage(), t);
                throw new OA2RedirectableError("invalid_request", "Invalid token hine for id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            if (!idTokenHint.getString("iss").equals(issuer) || !idTokenHint.getString("aud").equals(transaction.getClient().getIdentifierString())) {
                throw new OA2RedirectableError("invalid_request", "ID token not found.id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            Identifier oldIDToken = BasicIdentifier.newID((String)idTokenHint.getString("jti"));
            Object oldTransaction = ((OA2TStoreInterface)oa2SE.getTransactionStore()).getByIDTokenID(oldIDToken);
            if (oldTransaction == null) {
                throw new OA2RedirectableError("invalid_request", "ID token not found.id_token_hint", 400, transaction.getRequestState(), transaction.getCallback());
            }
            IDTokenImpl idToken = new IDTokenImpl(oldIDToken.getUri());
            if (idToken.isExpired()) {
                throw new OA2RedirectableError("invalid_request", "Expired ID token ", 400, transaction.getRequestState(), transaction.getCallback());
            }
            transaction.setIDTokenHint(idTokenHint);
            transaction.setUsername(oldTransaction.getUsername());
            transaction.setAuthTime(((OA2ServiceTransaction)((Object)oldTransaction)).getAuthTime());
            transaction.setPrompt("none");
            return;
        }
        if (prompt.contains("login")) {
            transaction.setPrompt("login");
            return;
        }
        if (prompt.contains("select_account")) {
            transaction.setPrompt("select_account");
            return;
        }
        if (prompt.contains("consent")) {
            transaction.setPrompt("consent");
            return;
        }
        throw new OA2RedirectableError("login_required", "Only prompt=login,none or select_account are supported on this server.", 400, transaction.getRequestState(), transaction.getCallback());
    }

    public void preprocess(TransactionState state) throws Throwable {
    }

    public void figureOutAudienceAndResource(TransactionState state) {
        OA2AuthorizedServletUtil.figureOutAudienceAndResource((OA2ServiceTransaction)state.getTransaction(), state.getRequest().getParameterValues("resource"), state.getRequest().getParameterValues("audience"));
    }

    public static void figureOutAudienceAndResource(OA2ServiceTransaction t, String[] rawResource, String[] rawAudience) {
        if (rawResource == null && rawAudience == null || rawResource.length == 0 && rawAudience.length == 0) {
            return;
        }
        LinkedList<String> resource = new LinkedList<String>();
        LinkedList<String> audience = new LinkedList<String>();
        if (rawResource != null) {
            for (String r : rawResource) {
                try {
                    URI uri = URI.create(r);
                    resource.add(r);
                    if (!uri.isAbsolute()) {
                        throw new OA2GeneralError("invalid_target", "Only absolute uris are allowed", 400, t.getRequestState(), (BaseClient)t.getClient());
                    }
                    if (!StringUtils.isTrivial((String)uri.getFragment())) {
                        throw new OA2GeneralError("invalid_target", "Fragments are not allowed", 400, t.getRequestState(), (BaseClient)t.getClient());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (rawAudience != null) {
            for (String a : rawAudience) {
                audience.add(a);
            }
        }
        if (resource.size() == 0 && audience.size() == 0) {
            OA2Client client = OA2ClientUtils.resolvePrototypes((OA2SE)OA4MPServlet.getServiceEnvironment(), (OA2Client)t.getClient());
            AccessTokenConfig atCfg = client.getAccessTokensConfig();
            if (atCfg.getTemplates().size() == 1) {
                String x = atCfg.getAudience().iterator().next();
                try {
                    URI.create(x);
                    resource.add(x);
                }
                catch (Throwable throwable) {
                    audience.add(x);
                }
            } else {
                throw new OA2GeneralError("invalid_request", "missing audience request", 400, t.getRequestState(), (BaseClient)t.getClient());
            }
        }
        t.setResource(resource);
        t.setAudience(audience);
    }

    protected Collection<String> resolveScopes(TransactionState transactionState, OA2Client client) {
        return ClientUtils.resolveScopes(transactionState, client, false, false);
    }

    public void postprocess(TransactionState transactionState, OA2Client client) {
        this.figureOutAudienceAndResource(transactionState);
        OA2ServiceTransaction t = (OA2ServiceTransaction)transactionState.getTransaction();
        Collection<String> scopes = this.resolveScopes(transactionState, client);
        t.setScopes(scopes);
        t.setValidatedScopes(scopes);
        t.setRequestedIDTLifetime(ClientUtils.computeIDTLifetime(t, client, (OA2SE)OA4MPServlet.getServiceEnvironment()));
        transactionState.getResponse().setHeader("X-Frame-Options", "DENY");
    }

    public static String createCallback(ServiceTransaction trans, Map<String, String> params) {
        Object cb = trans.getCallback().toString();
        OA2ServiceTransaction st = (OA2ServiceTransaction)trans;
        String idStr = st.getIdentifierString();
        String responseDelimiter = "?";
        if (st.hasResponseMode() && st.getResponseMode().equals("fragment")) {
            responseDelimiter = "#";
        }
        try {
            cb = (String)cb + (((String)cb).indexOf(responseDelimiter) == -1 ? responseDelimiter : "&") + "code=" + TokenUtils.b32EncodeToken((String)idStr);
            if (params.containsKey("state")) {
                cb = (String)cb + "&state=" + URLEncoder.encode(params.get("state"), "UTF-8");
            }
            if (((OA2ServiceTransaction)trans).getUserMetaData().containsKey((Object)"iss")) {
                cb = (String)cb + (((String)cb).indexOf(responseDelimiter) == -1 ? responseDelimiter : "&") + "iss=" + String.valueOf(st.getUserMetaData().get("iss"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ((OA2ServiceTransaction)trans).setCreatedCallback((String)cb);
        return cb;
    }
}

