/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.util.NewClientEvent;
import org.oa4mp.server.loader.oauth2.servlet.OA2RegistrationServlet;

public class OA2AutoRegistrationServlet
extends OA2RegistrationServlet {
    @Override
    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Client client = super.addNewClient(request, response);
        if (client != null) {
            OA2AutoRegistrationServlet.approveClient(client.getIdentifier(), "auto-approver");
        }
        this.fireNewClientEvent(new NewClientEvent((Object)this, (BaseClient)client));
        return client;
    }

    public static void approveClient(Identifier clientIdentifier, String approver) throws IOException {
        ClientApproval clientApproval = (ClientApproval)OA2AutoRegistrationServlet.getServiceEnvironment().getClientApprovalStore().get((Object)clientIdentifier);
        if (approver == null) {
            approver = "";
        }
        clientApproval.setApprover(approver);
        clientApproval.setApproved(true);
        clientApproval.setStatus(ClientApproval.Status.APPROVED);
        OA2AutoRegistrationServlet.getServiceEnvironment().getClientApprovalStore().save((Identifiable)clientApproval);
    }
}

