/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.util.scripting.ScriptSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.jwt.AccessTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.HandlerRunner;
import org.oa4mp.delegation.server.jwt.IDTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.PayloadHandler;
import org.oa4mp.delegation.server.jwt.RefreshTokenHandlerInterface;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.storage.servlet.AbstractRegistrationServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.AbstractAccessTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.claims.IDTokenClientConfig;
import org.oa4mp.server.loader.oauth2.claims.IDTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.claims.ServerQDLScriptHandler;
import org.oa4mp.server.loader.oauth2.claims.ServerQDLScriptHandlerConfig;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.tokens.BasicRefreshTokenHandler;
import org.oa4mp.server.loader.oauth2.tokens.RFC9068ATHandler;
import org.oa4mp.server.loader.oauth2.tokens.ScitokenHandler;
import org.oa4mp.server.loader.oauth2.tokens.WLCGTokenHandler;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;
import org.qdl_lang.scripting.AnaphorUtil;
import org.qdl_lang.scripting.QDLScript;

public class OA2ClientUtils {
    public static void check(Client client, String redirect) {
        if (client == null) {
            throw new OA2GeneralError("invalid_request", "no client id", 400, null);
        }
        if (!(client instanceof OA2Client)) {
            throw new NFWException("Client is not an OA2Client");
        }
        OA2Client oa2Client = (OA2Client)client;
        boolean foundCB = false;
        if (oa2Client.getCallbackURIs() == null) {
            throw new OA2GeneralError("invalid_request", "client has not registered any callback URIs", 400, null, (BaseClient)oa2Client);
        }
        for (String uri : oa2Client.getCallbackURIs()) {
            if (!uri.equals(redirect)) continue;
            foundCB = true;
            break;
        }
        if (!foundCB) {
            ServletDebugUtil.trace(OA2ClientUtils.class, (String)("invalid redirect uri for client \"" + oa2Client.getIdentifierString() + "\": \"" + redirect + "\""));
            throw new OA2GeneralError("invalid_request", "The given redirect_uri is not valid for this client.", 400, null, (BaseClient)oa2Client);
        }
    }

    public static LinkedList<String> createCallbacks(List<String> rawCBs, List<String> dudUris) throws IOException {
        LinkedList<String> uris = new LinkedList<String>();
        for (String x : rawCBs) {
            if (x == null || x.isEmpty() || x.trim().isEmpty()) continue;
            try {
                if (x.contains("*")) {
                    throw new IllegalArgumentException("wildcard in \"" + x + "\" is not allowed.");
                }
                URI temp = URI.create(x);
                if (!temp.isAbsolute()) {
                    throw new IllegalArgumentException("uri \"" + String.valueOf(temp) + "\" is not absolute.");
                }
                String host = temp.getHost();
                String scheme = temp.getScheme();
                ServletDebugUtil.trace(OA2ClientUtils.class, (String)("createCallbacks, processing callback \"" + x + "\""));
                if (scheme != null && scheme.toLowerCase().equals("https")) {
                    uris.add(x);
                    continue;
                }
                if (OA2ClientUtils.isPrivate(host, scheme)) {
                    uris.add(x);
                    continue;
                }
                if (temp.getAuthority() == null || temp.getAuthority().isEmpty()) {
                    uris.add(x);
                    continue;
                }
                dudUris.add(x);
            }
            catch (IllegalArgumentException urisx) {
                dudUris.add(x);
            }
        }
        return uris;
    }

    public static LinkedList<String> createCallbacksForWebUI(OA2Client client, String rawCBs) throws IOException {
        if (StringUtils.isTrivial((String)rawCBs)) {
            return new LinkedList<String>();
        }
        BufferedReader br = new BufferedReader(new StringReader(rawCBs));
        String x = br.readLine();
        LinkedList<String> uris = new LinkedList<String>();
        LinkedList<String> dudUris = new LinkedList<String>();
        while (x != null) {
            uris.add(x);
            x = br.readLine();
        }
        br.close();
        LinkedList<String> foundURIs = OA2ClientUtils.createCallbacks(uris, dudUris);
        if (0 < dudUris.size()) {
            Object xx = null;
            boolean isFirst = true;
            boolean isOne = dudUris.size() == 1;
            for (String y : dudUris) {
                if (isFirst) {
                    xx = y;
                    isFirst = false;
                    continue;
                }
                xx = (String)xx + ", " + y;
            }
            String helpfulMessage = "The callback" + (isOne ? " " : "s ") + (String)xx + (isOne ? "is" : "are") + " not valid.";
            throw new AbstractRegistrationServlet.ClientRegistrationRetryException(helpfulMessage, null, (BaseClient)client);
        }
        return foundURIs;
    }

    protected static int[] toQuad(String address) {
        StringTokenizer stringTokenizer = new StringTokenizer(address, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        int[] quad = new int[4];
        for (int i = 0; i < 4; ++i) {
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            String raw = stringTokenizer.nextToken();
            try {
                quad[i] = Integer.parseInt(raw);
                if (0 <= quad[i] && quad[i] <= 255) continue;
                return null;
            }
            catch (NumberFormatException nfx) {
                return null;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return quad;
    }

    protected static boolean isOnPrivateNetwork(String address) {
        String regex = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
        if (!address.matches(regex)) {
            return false;
        }
        int[] quad = OA2ClientUtils.toQuad(address);
        if (quad == null) {
            return false;
        }
        if (quad[0] == 10) {
            return true;
        }
        if (quad[0] == 192 && quad[1] == 168) {
            return true;
        }
        if (quad[0] == 172 && 16 <= quad[1] && quad[1] <= 31) {
            return true;
        }
        return quad[0] == 127 && quad[1] == 0 && quad[2] == 0 && quad[3] == 1;
    }

    protected static boolean isPrivate(String host, String scheme) {
        if (host != null && OA2ClientUtils.isOnPrivateNetwork(host)) {
            return true;
        }
        return scheme != null && scheme.toLowerCase().equals("http") && (host.toLowerCase().equals("localhost") || host.equals("[::1]"));
    }

    public static void setupHandlers(HandlerRunner handlerRunner, OA2SE oa2SE, OA2ServiceTransaction transaction, OA2Client client, HttpServletRequest req) throws Throwable {
        OA2ClientUtils.setupHandlers(handlerRunner, oa2SE, transaction, client, null, null, null, req);
    }

    public static void setupHandlers(HandlerRunner handlerRunner, OA2SE oa2SE, OA2ServiceTransaction transaction, OA2Client client, TXRecord idTX, TXRecord atTX, TXRecord rtTX, HttpServletRequest req) throws Throwable {
        PayloadHandlerConfigImpl st;
        MetaDebugUtil debugger = DebugUtil.getInstance();
        if (transaction.getClient().isDebugOn()) {
            debugger = new MetaDebugUtil();
            debugger.setIsEnabled(true);
        }
        debugger.trace(OA2ClientUtils.class, "Setting up handlers");
        if (!client.isSkipServerScripts() && oa2SE.getQDLEnvironment().hasServerScripts()) {
            ServerQDLScriptHandlerConfig qdlScriptHandlerConfig = new ServerQDLScriptHandlerConfig(oa2SE, transaction, atTX, req);
            ServerQDLScriptHandler qdlScriptHandler = new ServerQDLScriptHandler(qdlScriptHandlerConfig);
            handlerRunner.addHandler((PayloadHandler)qdlScriptHandler);
        }
        PayloadHandlerConfigImpl idthCfg = null;
        IDTokenHandler idTokenHandler = null;
        if (client.hasIDTokenConfig()) {
            debugger.trace(OA2ClientUtils.class, "has id token config, creating handler");
            idthCfg = new PayloadHandlerConfigImpl(client.getIDTokenConfig(), oa2SE, transaction, client, idTX, req);
            switch (client.getIDTokenConfig().getType()) {
                case "default": 
                case "identity": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown identity token handler type");
                }
            }
        } else {
            debugger.trace(OA2ClientUtils.class, "Found legacy id token configuration.");
            idthCfg = new PayloadHandlerConfigImpl(new IDTokenClientConfig(), oa2SE, transaction, client, atTX, req);
            idthCfg.setLegacyHandler(true);
        }
        idTokenHandler = new IDTokenHandler(idthCfg);
        handlerRunner.setIdTokenHandlerInterface((IDTokenHandlerInterface)idTokenHandler);
        if (client.hasAccessTokenConfig()) {
            debugger.trace(OA2ClientUtils.class, "has access token config, creating handler, type=" + client.getAccessTokensConfig().getType());
            st = new PayloadHandlerConfigImpl(client.getAccessTokensConfig(), oa2SE, transaction, client, atTX, req);
            AbstractAccessTokenHandler sth = null;
            switch (client.getAccessTokensConfig().getType()) {
                case "wlcg": {
                    sth = new WLCGTokenHandler(st);
                    debugger.trace(OA2ClientUtils.class, "WLCG access token handler created");
                    break;
                }
                case "scitoken": 
                case "sci_token": {
                    sth = new ScitokenHandler(st);
                    debugger.trace(OA2ClientUtils.class, "SciTokens access token handler created");
                    break;
                }
                case "rfc9068": 
                case "rfc_9068": 
                case "at+jwt": {
                    sth = new RFC9068ATHandler(st);
                    debugger.trace(OA2ClientUtils.class, "RFC 9068 access token handler created");
                    break;
                }
                case "default": 
                case "access": {
                    sth = new AbstractAccessTokenHandler(st);
                    debugger.trace(OA2ClientUtils.class, "generic access token handler created");
                    break;
                }
                default: {
                    debugger.trace(OA2ClientUtils.class, "unknown handler of type \"" + client.getAccessTokensConfig().getType() + "\" requested.");
                    throw new IllegalArgumentException("unknown access token handler type");
                }
            }
            sth.setUserMetaData(idTokenHandler.getUserMetaData());
            handlerRunner.setAccessTokenHandler((AccessTokenHandlerInterface)sth);
        }
        if (client.hasRefreshTokenConfig()) {
            debugger.trace(OA2ClientUtils.class, "has refresh token config, creating handler");
            st = new PayloadHandlerConfigImpl(client.getRefreshTokensConfig(), oa2SE, transaction, client, rtTX, req);
            BasicRefreshTokenHandler rth = new BasicRefreshTokenHandler(st);
            switch (client.getRefreshTokensConfig().getType()) {
                case "default": 
                case "refresh": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown refresh token handler type");
                }
            }
            handlerRunner.setRefreshTokenHandler((RefreshTokenHandlerInterface)rth);
        }
    }

    public static List<String> scopesFromTemplates(List<String> scopes, OA2ServiceTransaction t) {
        ArrayList<String> computedScopes = new ArrayList<String>();
        return computedScopes;
    }

    public static OA2Client createErsatz(Identifier provisioningClientID, OA2SE oa2se, OA2Client ersatzClient, List<Identifier> ersatzChain) {
        ArrayList<Identifier> prototypes = new ArrayList<Identifier>();
        if (ersatzClient.isExtendsProvisioners()) {
            prototypes.add(provisioningClientID);
            prototypes.addAll(ersatzChain.subList(0, ersatzChain.size() - 1));
            prototypes.addAll(ersatzClient.getPrototypes());
            ersatzClient.setPrototypes(prototypes);
        }
        return OA2ClientUtils.resolvePrototypes(oa2se, ersatzClient);
    }

    public static OA2Client createErsatz(OA2SE oa2SE, OA2ServiceTransaction t, OA2Client client) {
        try {
            Permission ersatzChain = oa2SE.getPermissionStore().getErsatzChain(t.getProvisioningAdminID(), t.getProvisioningClientID(), client.getIdentifier());
            return OA2ClientUtils.createErsatz(t.getProvisioningClientID(), oa2SE, client, ersatzChain.getErsatzChain());
        }
        catch (UnknownClientException ucx) {
            throw new OA2ATException("unauthorized_client", ucx.getMessage(), 500, t.getRequestState(), (BaseClient)t.getClient());
        }
    }

    public static OA2Client resolvePrototypes(OA2SE oa2SE, OA2Client baseClient) {
        return OA2ClientUtils.resolvePrototypes(oa2SE.getClientStore(), baseClient);
    }

    public static OA2Client resolvePrototypes(ClientStore store, OA2Client baseClient) {
        if (!baseClient.hasPrototypes()) {
            return baseClient;
        }
        ColumnMap clientMap = new ColumnMap();
        MapConverter mapConverter = store.getMapConverter();
        mapConverter.toMap((Identifiable)baseClient, (ConversionMap)clientMap);
        OA2ClientKeys oa2ClientKeys = (OA2ClientKeys)mapConverter.getKeys();
        HashSet<String> skipSet = new HashSet<String>();
        skipSet.add(oa2ClientKeys.secret(new String[0]));
        skipSet.add(oa2ClientKeys.identifier(new String[0]));
        skipSet.add(oa2ClientKeys.name(new String[0]));
        skipSet.add(oa2ClientKeys.ersatzInheritIDToken(new String[0]));
        for (Identifier id : baseClient.getPrototypes()) {
            OA2Client currentClient = (OA2Client)((Object)store.get((Object)id));
            if (currentClient == null) {
                throw new UnknownClientException("client \"" + String.valueOf(id) + "\" does not exist");
            }
            ColumnMap map = new ColumnMap();
            mapConverter.toMap((Identifiable)currentClient, (ConversionMap)map);
            for (String key : map.keySet()) {
                if (skipSet.contains(key)) continue;
                Object obj = map.get((Object)key);
                if (obj instanceof Long) {
                    long pValue = (Long)obj;
                    long eValue = -1L;
                    if (clientMap.containsKey((Object)key)) {
                        eValue = clientMap.getLong(key);
                    }
                    if (eValue >= 0L) continue;
                    clientMap.put(key, (Object)pValue);
                    continue;
                }
                if (obj instanceof Integer) {
                    int pValue = (Integer)obj;
                    int eValue = -1;
                    if (clientMap.containsKey((Object)key)) {
                        eValue = clientMap.getInteger(key);
                    }
                    if (eValue >= 0) continue;
                    clientMap.put(key, (Object)pValue);
                    continue;
                }
                clientMap.put(key, obj);
            }
        }
        OA2Client client = (OA2Client)store.getMapConverter().fromMap((ConversionMap)clientMap, null);
        client.setReadOnly(true);
        return client;
    }

    public static void setupDriverPayloadConfig(AbstractPayloadConfig pc, OA2Client client) {
        JSONObject cfg = client.getConfig();
        ScriptSet scriptSet = cfg.get(QDLRuntimeEngine.CONFIG_TAG) instanceof JSONArray ? AnaphorUtil.createScripts((JSON)cfg.getJSONArray(QDLRuntimeEngine.CONFIG_TAG)) : AnaphorUtil.createScripts((JSON)cfg.getJSONObject(QDLRuntimeEngine.CONFIG_TAG));
        for (QDLScript script : scriptSet) {
            if (script.getProperties().containsKey((Object)"exec_phase")) continue;
            script.getProperties().put((Object)"exec_phase", (Object)"all");
        }
        pc.setScriptSet(scriptSet);
    }
}

