/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.server.api.storage.servlet.DiscoveryServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class OA2DiscoveryServlet
extends DiscoveryServlet {
    public static String DISCOVERY_PATH_SEPARATOR = "/";

    protected VirtualIssuer getVI(HttpServletRequest req, String requestUri) {
        VirtualIssuer vo = null;
        String host = this.getOA2SE().getServiceAddress().getHost();
        String p = requestUri.substring(this.getOA2SE().getServiceAddress().getPath().length());
        StringTokenizer st = new StringTokenizer(p, "/");
        String x = st.nextToken();
        if (x.equals(".well-known")) {
            if (!st.hasMoreTokens()) {
                throw new OA2GeneralError("invalid_request", "unsupported discovery url", 400, null);
            }
            String x1 = st.nextToken();
            if (x1.equals("openid-configuration") || x1.equals("oauth-authorization-server")) {
                if (st.hasMoreTokens()) {
                    String component = st.nextToken();
                    vo = (VirtualIssuer)((Object)this.getOA2SE().getVIStore().findByPath(host + DISCOVERY_PATH_SEPARATOR + component));
                    if (vo == null) {
                        throw new OA2GeneralError("invalid_request", "unknown virtual issuer \"" + component + "\"", 400, null);
                    }
                    return vo;
                }
                return vo;
            }
        }
        if (!st.hasMoreTokens()) {
            throw new OA2GeneralError("invalid_request", "unsupported discovery url", 400, null);
        }
        String nextToken = st.nextToken();
        if (x.equals(".well-known") && nextToken.equals("openid-configuration") || nextToken.equals("oauth-authorization-server")) {
            return vo;
        }
        if (!nextToken.equals(".well-known") || !st.nextToken().equals("openid-configuration") || st.hasMoreTokens()) {
            throw new OA2GeneralError("invalid_request", "unsupported discovery url for \"" + x + "\"", 400, null);
        }
        vo = (VirtualIssuer)((Object)this.getOA2SE().getVIStore().findByPath(host + DISCOVERY_PATH_SEPARATOR + x));
        return vo;
    }

    protected OA2SE getOA2SE() {
        return (OA2SE)OA2DiscoveryServlet.getServiceEnvironment();
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        String certPath = "/certs";
        String requestUri = httpServletRequest.getRequestURI();
        boolean isCerts = false;
        if (requestUri.contains(certPath)) {
            isCerts = true;
            requestUri = requestUri.endsWith(certPath) ? requestUri.substring(0, requestUri.length() - certPath.length()) : requestUri.substring(requestUri.indexOf(certPath) + certPath.length());
        }
        if (isCerts) {
            String discoveryPath = requestUri.substring(1 + requestUri.lastIndexOf("/"));
            Object vo = this.getOA2SE().getVIStore().findByPath(this.getOA2SE().getServiceAddress().getHost() + DISCOVERY_PATH_SEPARATOR + discoveryPath);
            JSONWebKeys publicKeys = vo == null ? JSONWebKeyUtil.makePublic((JSONWebKeys)((OA2SE)OA2DiscoveryServlet.getServiceEnvironment()).getJsonWebKeys()) : JSONWebKeyUtil.makePublic((JSONWebKeys)((VirtualIssuer)((Object)vo)).getJsonWebKeys());
            JSONObject json = JSONWebKeyUtil.toJSON((JSONWebKeys)publicKeys);
            String out = JSONUtils.valueToString((Object)json, (int)1, (int)0);
            httpServletResponse.setHeader("Content-Type", "application/json;charset=UTF-8");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(out);
            printWriter.flush();
            printWriter.close();
            return;
        }
        VirtualIssuer vo = this.getVI(httpServletRequest, requestUri);
        JSONObject jsonObject = new JSONObject();
        jsonObject = this.setValues(httpServletRequest, jsonObject, vo);
        String out = JSONUtils.valueToString((Object)jsonObject, (int)1, (int)0);
        httpServletResponse.setHeader("Content-Type", "application/json;charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(out);
        printWriter.close();
        printWriter.flush();
        this.logOK(httpServletRequest);
    }

    public static String getIssuer(HttpServletRequest request) {
        OA2SE oa2SE = (OA2SE)OA2DiscoveryServlet.getServiceEnvironment();
        if (oa2SE.getIssuer() != null) {
            return oa2SE.getIssuer();
        }
        return OA2DiscoveryServlet.getRequestURI((HttpServletRequest)request, (boolean)false);
    }

    protected JSONObject setValues(HttpServletRequest request, JSONObject jsonObject, VirtualIssuer vo) {
        OA2SE oa2SE = (OA2SE)OA2DiscoveryServlet.getServiceEnvironment();
        String requestURI = OA2DiscoveryServlet.getRequestURI((HttpServletRequest)request);
        if (requestURI.endsWith("/")) {
            requestURI = requestURI.substring(0, requestURI.length() - 1);
        }
        JSONObject json = super.setValues(request, jsonObject);
        if (vo == null) {
            json.put((Object)"jwks_uri", (Object)(requestURI + "/certs"));
        } else {
            String p = vo.getDiscoveryPath().substring(vo.getDiscoveryPath().lastIndexOf("/") + 1);
            json.put((Object)"jwks_uri", (Object)(requestURI + "/certs/" + p));
        }
        if (vo == null) {
            json.put((Object)"issuer", (Object)OA2DiscoveryServlet.getIssuer(request));
        } else {
            json.put((Object)"issuer", (Object)vo.getIssuer());
        }
        json.put((Object)"token_endpoint", (Object)(requestURI + "/token"));
        json.put((Object)"userinfo_endpoint", (Object)(requestURI + "/userinfo"));
        json.put((Object)"introspection_endpoint", (Object)(requestURI + "/introspect"));
        json.put((Object)"revocation_endpoint", (Object)(requestURI + "/revoke"));
        json.put((Object)"request_parameter_supported", (Object)false);
        json.put((Object)"request_uri_parameter_supported", (Object)false);
        JSONArray revAuthMethods = new JSONArray();
        revAuthMethods.add((Object)"client_secret_basic");
        json.put((Object)"revocation_endpoint_auth_methods_supported", (Object)revAuthMethods);
        if (oa2SE.isRfc8628Enabled()) {
            json.put((Object)"device_authorization_endpoint", (Object)oa2SE.getRfc8628ServletConfig().deviceAuthorizationEndpoint);
        }
        JSONArray tokenEndpointAuthSupported = new JSONArray();
        tokenEndpointAuthSupported.add((Object)"client_secret_post");
        tokenEndpointAuthSupported.add((Object)"client_secret_basic");
        tokenEndpointAuthSupported.add((Object)"private_key_jwt");
        json.put((Object)"token_endpoint_auth_methods_supported", (Object)tokenEndpointAuthSupported);
        JSONArray subjectTypes = new JSONArray();
        subjectTypes.add((Object)"public");
        json.put((Object)"subject_types_supported", (Object)subjectTypes);
        JSONArray scopes = new JSONArray();
        Collection<String> serverScopes = oa2SE.getScopes();
        for (String s : serverScopes) {
            scopes.add((Object)s);
        }
        if (!scopes.contains((Object)"offline_access")) {
            scopes.add((Object)"offline_access");
        }
        JSONArray ccm = new JSONArray();
        ccm.add((Object)"plain");
        ccm.add((Object)"S256");
        json.put((Object)"code_challenge_method_supported", (Object)ccm);
        json.put((Object)"scopes_supported", (Object)scopes);
        JSONArray responseTypes = new JSONArray();
        responseTypes.add((Object)"code");
        responseTypes.add((Object)"id_token");
        json.put((Object)"response_types_supported", (Object)responseTypes);
        JSONArray grantTypes = new JSONArray();
        grantTypes.add((Object)"web");
        grantTypes.add((Object)"urn:oa4mp:params:oauth:grant-type:token-info");
        if (oa2SE.isRfc8693Enabled()) {
            grantTypes.add((Object)"urn:ietf:params:oauth:grant-type:token-exchange");
        }
        grantTypes.add((Object)"refresh_token");
        grantTypes.add((Object)"authorization_code");
        grantTypes.add((Object)"client_credentials");
        if (oa2SE.isRfc8628Enabled()) {
            grantTypes.add((Object)"urn:ietf:params:oauth:grant-type:device_code");
        }
        json.put((Object)"grant_types_supported", (Object)grantTypes);
        JSONArray responseModesSupported = new JSONArray();
        responseModesSupported.add((Object)"query");
        responseModesSupported.add((Object)"fragment");
        responseModesSupported.add((Object)"form_post");
        json.put((Object)"response_modes_supported", (Object)responseModesSupported);
        JSONArray claimsSupported = new JSONArray();
        if (oa2SE.getClaimSource() != null) {
            claimsSupported.addAll(oa2SE.getClaimSource().getClaims());
            json.put((Object)"claims_supported", (Object)claimsSupported);
        }
        JSONArray signingAlgs = new JSONArray();
        signingAlgs.add((Object)"RS256");
        signingAlgs.add((Object)"RS384");
        signingAlgs.add((Object)"RS512");
        json.put((Object)"id_token_signing_alg_values_supported", (Object)signingAlgs);
        return json;
    }
}

