/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.exceptions.MissingContentException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.ExceptionWrapper;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2JSONException;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.server.api.storage.servlet.AbstractAuthenticationServlet;
import org.oa4mp.server.loader.oauth2.claims.LDAPException;
import org.oa4mp.server.loader.oauth2.servlet.OA2ExceptionHandlerThingie;
import org.qdl_lang.exceptions.QDLException;
import org.qdl_lang.exceptions.QDLExceptionWithTrace;

public class OA2ExceptionHandler
implements ExceptionHandler {
    MyLoggingFacade logger;

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public OA2ExceptionHandler(MyLoggingFacade logger) {
        this.logger = logger;
    }

    protected void warn(String x) {
        if (this.getLogger() != null) {
            this.getLogger().warn(x);
        } else {
            System.err.println(x);
        }
    }

    protected void info(String x) {
        if (this.getLogger() != null) {
            this.getLogger().info(x);
        } else {
            System.err.println(x);
        }
    }

    protected void error(String x) {
        if (this.getLogger() != null) {
            this.getLogger().error(x);
        } else {
            System.err.println(x);
        }
    }

    public void handleException(ExceptionHandlerThingie xh) throws IOException, ServletException {
        Throwable t = xh.throwable;
        HttpServletRequest request = xh.request;
        HttpServletResponse response = xh.response;
        BaseClient baseClient = null;
        Object forensicMessage = null;
        if (t instanceof OA2GeneralError) {
            OA2GeneralError ge = (OA2GeneralError)t;
            if (ge.hasClient()) {
                baseClient = ge.getClient();
            }
            if (ge.hasForensicMessage()) {
                forensicMessage = ge.getForensicMessage();
            }
        } else if (xh instanceof OA2ExceptionHandlerThingie && ((OA2ExceptionHandlerThingie)xh).hasClient()) {
            baseClient = ((OA2ExceptionHandlerThingie)xh).client;
        }
        if (t instanceof QDLException) {
            QDLException qx = (QDLException)t;
            if (qx.getCause() != null) {
                t = qx.getCause();
            }
            if (qx instanceof QDLExceptionWithTrace) {
                QDLExceptionWithTrace qxTrace = (QDLExceptionWithTrace)qx;
                forensicMessage = qxTrace.isScript() ? "QDL script stack trace:\n" + qxTrace.stackTrace() : "No QDL script";
            }
        }
        Object message = "";
        if (baseClient != null) {
            message = "[" + baseClient.getIdentifierString() + "]";
        }
        String address = AbstractServlet.getRequestIPAddress((HttpServletRequest)xh.request);
        message = (String)message + "<" + address + ">";
        if (forensicMessage == null) {
            message = (String)message + " error: " + t.getMessage();
            this.warn((String)message);
        } else {
            message = (String)message + "\n\tclient id : " + (baseClient == null ? "unknown" : baseClient.getIdentifierString());
            message = (String)message + "\n\t    error : " + t.getMessage();
            message = (String)message + "\n\t  message : " + (String)forensicMessage;
            this.warn((String)message);
        }
        if (t == null) {
            t = new OA2GeneralError("server_error", "Internal error", 500, null);
        }
        if (t instanceof MissingContentException) {
            t = new OA2GeneralError("server_error", t.getMessage(), 400, null);
        }
        if (t instanceof LDAPException) {
            t = new OA2GeneralError("server_error", "LDAP error", 500, null);
        }
        if (t instanceof NullPointerException || t.getCause() != null && t.getCause() instanceof NullPointerException) {
            this.getLogger().error("Null pointer", t);
            t.printStackTrace();
            t = new OA2GeneralError("server_error", "Null pointer", 500, null);
        }
        if (t instanceof ExceptionWrapper) {
            t = t.getCause();
        }
        if (t instanceof ServletException) {
            response.setStatus(500);
            throw (ServletException)t;
        }
        if (t instanceof OA2JSONException) {
            this.handleOA2Error((OA2JSONException)t, response);
            return;
        }
        if (t instanceof OA2ATException) {
            this.handleOA2Error((OA2ATException)t, response);
            return;
        }
        if (t instanceof OA2RedirectableError) {
            this.handleOA2Error((OA2RedirectableError)t, response);
            return;
        }
        if (t instanceof OA2GeneralError) {
            this.handleOA2Error((OA2GeneralError)t, response);
            return;
        }
        if (t instanceof UnknownClientException || t instanceof UnapprovedClientException) {
            this.handleOA2Error(new OA2GeneralError("unauthorized_client", "unknown client", 400, null), response);
            return;
        }
        this.handleOA2Error(new OA2GeneralError("server_error", t.getMessage(), 500, null), response);
    }

    protected String encode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        return URLEncoder.encode(x, "UTF-8");
    }

    protected void handleOA2Error(OA2GeneralError oa2GeneralError, HttpServletResponse response) throws IOException {
        DebugUtil.trace((Object)this, (String)("error = " + String.valueOf((Object)oa2GeneralError)));
        oa2GeneralError.printStackTrace();
        if (oa2GeneralError.getCause() != null) {
            oa2GeneralError.getCause().printStackTrace();
        }
        PrintWriter writer = response.getWriter();
        response.setStatus(oa2GeneralError.getHttpStatus());
        writer.println("error=\"" + this.encode(oa2GeneralError.getError()) + "\"");
        writer.println("error_description=\"" + this.encode(oa2GeneralError.getDescription()) + "\"");
        if (oa2GeneralError.getState() != null) {
            writer.println("state=\"" + this.encode(oa2GeneralError.getState()) + "\"");
        }
        writer.flush();
        writer.close();
    }

    protected void handleOA2Error(OA2JSONException jsonException, HttpServletResponse response) throws IOException {
        response.setStatus(jsonException.getHttpStatus());
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(jsonException.toJSON().toString());
        writer.flush();
        writer.close();
    }

    protected void handleOA2Error(OA2ATException oa2ATException, HttpServletResponse response) throws IOException {
        response.setStatus(oa2ATException.getHttpStatus());
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(oa2ATException.toJSON().toString());
        writer.flush();
        writer.close();
    }

    protected void handleOA2Error(OA2RedirectableError oa2RedirectableError, HttpServletResponse response) throws IOException {
        Object cb;
        if (oa2RedirectableError.getCallback() == null) {
            this.handleOA2Error(new OA2GeneralError(oa2RedirectableError), response);
            return;
        }
        AbstractAuthenticationServlet.MyHttpServletResponseWrapper wrapper = null;
        if (response instanceof AbstractAuthenticationServlet.MyHttpServletResponseWrapper) {
            wrapper = (AbstractAuthenticationServlet.MyHttpServletResponseWrapper)response;
            wrapper.setExceptionEncountered(true);
        }
        boolean hasQM = 0 < ((String)(cb = oa2RedirectableError.getCallback().toString())).indexOf("?");
        cb = (String)cb + (hasQM ? "&" : "?") + "error=" + oa2RedirectableError.getError() + "&" + URLEncoder.encode("error_description", "UTF-8") + "=" + URLEncoder.encode(oa2RedirectableError.getDescription(), "UTF-8");
        String state = oa2RedirectableError.getState();
        state = state == null ? "" : state;
        cb = (String)cb + "&state=" + URLEncoder.encode(state, "UTF-8");
        response.setStatus(301);
        response.sendRedirect((String)cb);
    }
}

