/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.HeaderUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public class OA2HeaderUtils
extends HeaderUtils {
    public static String getATFromParameter(HttpServletRequest request) {
        String rawID = request.getParameter("access_token");
        if (StringUtils.isTrivial((String)rawID)) {
            return null;
        }
        return rawID;
    }

    public static Identifier getIDFromParameters(HttpServletRequest request) {
        Object paramID = null;
        String rawID = request.getParameter(AbstractServlet.CONST((String)"oa4mp:client_id"));
        if (StringUtils.isTrivial((String)rawID)) {
            return null;
        }
        return BasicIdentifier.newID((String)rawID);
    }

    public static BaseClient findRFC7523Client(HttpServletRequest request, OA2SE oa2SE, JSONObject json) throws NoSuchAlgorithmException, InvalidKeySpecException {
        OA2Client client;
        String state;
        String string = state = json.containsKey((Object)"state") ? json.getString("state") : null;
        if (!json.containsKey((Object)"sub")) {
            throw new OA2GeneralError("invalid_request", "missing sub claim, i.e., no client ID", 400, state);
        }
        Identifier clientID = BasicIdentifier.newID((String)json.getString("sub"));
        if (oa2SE.getClientStore().containsKey((Object)clientID)) {
            client = (OA2Client)((Object)oa2SE.getClientStore().get((Object)clientID));
        } else if (oa2SE.getAdminClientStore().containsKey((Object)clientID)) {
            client = (BaseClient)oa2SE.getAdminClientStore().get((Object)clientID);
        } else {
            throw new OA2GeneralError("invalid_request", "client_assertion is not a valid client", 400, null);
        }
        if (!oa2SE.getClientApprovalStore().isApproved(clientID)) {
            throw new OA2GeneralError("unauthorized_client", "client not approved", 400, state);
        }
        if (!client.hasJWKS()) {
            throw new OA2GeneralError("invalid_request", "client does not support RFC 7523", 400, state);
        }
        return client;
    }

    public static BaseClient getAndVerifyRFC7523Client(HttpServletRequest request, OA2SE oa2SE) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return OA2HeaderUtils.getAndVerifyRFC7523Client(request, oa2SE, false);
    }

    public static BaseClient getAndVerifyRFC7523Client(HttpServletRequest request, OA2SE oa2SE, boolean isDeviceFlow) throws NoSuchAlgorithmException, InvalidKeySpecException {
        JSONObject[] hp;
        String assertionType = request.getParameter("client_assertion_type");
        if (!assertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            throw new OA2GeneralError("invalid_request", "unsupported client_assertion_type", 400, null);
        }
        String raw = request.getParameter("client_assertion");
        if (StringUtils.isTrivial((String)raw)) {
            throw new OA2GeneralError("invalid_request", "missing client_assertion", 400, null);
        }
        try {
            hp = MyOtherJWTUtil2.readJWT((String)raw);
        }
        catch (IllegalArgumentException iax) {
            throw new OA2GeneralError("invalid_request", "client_assertion is not a JWT", 400, null);
        }
        catch (Throwable t) {
            throw new OA2GeneralError("invalid_request", "could not decode JWT:" + t.getMessage(), 400, null);
        }
        JSONObject json = hp[1];
        BaseClient client = OA2HeaderUtils.findRFC7523Client(request, oa2SE, json);
        String state = json.containsKey((Object)"state") ? json.getString("state") : null;
        try {
            MyOtherJWTUtil2.verifyAndReadJWT((String)raw, (JSONWebKeys)client.getJWKS());
        }
        catch (Throwable t) {
            throw new OA2GeneralError("invalid_token", "failed to verify token", 400, state);
        }
        if (json.containsKey((Object)"aud")) {
            Object serverName = oa2SE.getServiceAddress().toString();
            serverName = isDeviceFlow ? (String)serverName + (((String)serverName).endsWith("/") ? "" : "/") + "device_authorization" : (String)serverName + (((String)serverName).endsWith("/") ? "" : "/") + "token";
            if (!json.getString("aud").equals(serverName)) {
                throw new IllegalArgumentException("wrong aud");
            }
        } else {
            throw new IllegalArgumentException("missing aud");
        }
        if (json.containsKey((Object)"iss")) {
            Identifier id = BasicIdentifier.newID((String)json.getString("iss"));
            if (!client.getIdentifier().equals(id)) {
                throw new UnknownClientException("unknown iss with id \"" + String.valueOf(id) + "\"");
            }
        } else {
            throw new IllegalArgumentException("missing iss");
        }
        if (json.containsKey((Object)"exp")) {
            if (json.getLong("exp") * 1000L < System.currentTimeMillis()) {
                throw new IllegalArgumentException("Expired token ");
            }
        } else {
            throw new IllegalArgumentException("missing exp");
        }
        if (json.containsKey((Object)"nbf") && System.currentTimeMillis() < json.getLong("nbf") * 1000L) {
            throw new IllegalArgumentException("Token is not valid yet");
        }
        return client;
    }

    public static OA2Client getRFC7523Client(HttpServletRequest request, OA2SE oa2SE) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String state;
        JSONObject[] hp;
        String raw = request.getParameter("client_assertion");
        if (StringUtils.isTrivial((String)raw)) {
            throw new OA2GeneralError("invalid_request", "missing client_assertion", 400, null);
        }
        try {
            hp = MyOtherJWTUtil2.readJWT((String)raw);
        }
        catch (IllegalArgumentException iax) {
            throw new OA2GeneralError("invalid_request", "client_assertion is not a JWT", 400, null);
        }
        catch (Throwable t) {
            throw new OA2GeneralError("invalid_request", "could not decode JWT:" + t.getMessage(), 400, null);
        }
        JSONObject json = hp[1];
        String string = state = json.containsKey((Object)"state") ? json.getString("state") : null;
        if (!json.containsKey((Object)"sub")) {
            throw new OA2GeneralError("invalid_request", "missing sub claim, i.e., no client ID", 400, state);
        }
        Identifier clientID = BasicIdentifier.newID((String)json.getString("sub"));
        OA2Client client = (OA2Client)((Object)oa2SE.getClientStore().get((Object)clientID));
        if (!oa2SE.getClientApprovalStore().isApproved(clientID)) {
            throw new OA2GeneralError("unauthorized_client", "client not approved", 400, state);
        }
        return client;
    }

    public static void verifyRFC7523Client(OA2Client client, HttpServletRequest request, OA2SE oa2SE) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String state;
        JSONObject[] hp;
        String raw = request.getParameter("client_assertion");
        if (StringUtils.isTrivial((String)raw)) {
            throw new OA2GeneralError("invalid_request", "missing client_assertion", 400, null);
        }
        try {
            hp = MyOtherJWTUtil2.readJWT((String)raw);
        }
        catch (IllegalArgumentException iax) {
            throw new OA2GeneralError("invalid_request", "client_assertion is not a JWT", 400, null);
        }
        catch (Throwable t) {
            throw new OA2GeneralError("invalid_request", "could not decode JWT:" + t.getMessage(), 400, null);
        }
        JSONObject json = hp[1];
        String string = state = json.containsKey((Object)"state") ? json.getString("state") : null;
        if (!client.hasJWKS()) {
            throw new OA2GeneralError("invalid_request", "client does not support RFC 7523", 400, state);
        }
        try {
            MyOtherJWTUtil2.verifyAndReadJWT((String)raw, (JSONWebKeys)client.getJWKS());
        }
        catch (Throwable t) {
            throw new OA2GeneralError("invalid_token", "failed to verify token", 400, state);
        }
        if (json.containsKey((Object)"aud")) {
            Object serverName;
            serverName = (String)serverName + (((String)(serverName = oa2SE.getServiceAddress().toString())).endsWith("/") ? "" : "/") + "token";
            if (!json.getString("aud").equals(serverName)) {
                throw new IllegalArgumentException("wrong aud");
            }
        } else {
            throw new IllegalArgumentException("missing aud");
        }
        if (json.containsKey((Object)"iss")) {
            Identifier id = BasicIdentifier.newID((String)json.getString("iss"));
            if (!client.getIdentifier().equals(id)) {
                throw new UnknownClientException("unknown iss with id \"" + String.valueOf(id) + "\"");
            }
        } else {
            throw new IllegalArgumentException("missing iss");
        }
        if (json.containsKey((Object)"exp")) {
            if (json.getLong("exp") * 1000L < System.currentTimeMillis()) {
                throw new IllegalArgumentException("Expired token ");
            }
        } else {
            throw new IllegalArgumentException("missing exp");
        }
        if (json.containsKey((Object)"nbf") && System.currentTimeMillis() < json.getLong("nbf") * 1000L) {
            throw new IllegalArgumentException("Token is not valid yet");
        }
    }
}

