/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.RetryException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.storage.servlet.AbstractRegistrationServlet;
import org.oa4mp.server.api.util.NewClientEvent;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;

public class OA2RegistrationServlet
extends AbstractRegistrationServlet {
    protected static SecureRandom random = new SecureRandom();
    public static final String CALLBACK_URI = "callbackURI";
    public static final String REFRESH_TOKEN_LIFETIME = "rtLifetime";
    public static final String REFRESH_TOKEN_FIELD_VISIBLE = "rtFieldVisible";
    public static final String VI_NAME = "viName";
    public static final String LDAP_NAME = "ldap";
    public static final String ISSUER_NAME = "issuer";
    public static final String SCOPES_NAME = "scopes";

    protected OA2SE getOA2SE() {
        return (OA2SE)OA2RegistrationServlet.getServiceEnvironment();
    }

    protected Collection<String> getDisplayScopes() {
        HashSet<String> displayScopes = new HashSet<String>();
        displayScopes.addAll(this.getOA2SE().getScopes());
        if (!displayScopes.contains("offline_access")) {
            displayScopes.add("offline_access");
        }
        TreeSet<String> d = new TreeSet<String>();
        d.addAll(displayScopes);
        return d;
    }

    public void prepare(PresentableState state) throws Throwable {
        super.prepare(state);
        HttpServletRequest request = state.getRequest();
        if (state.getState() == 0) {
            Collection<String> displayScopes = this.getDisplayScopes();
            String[] scopes = new String[displayScopes.size()];
            displayScopes.toArray(scopes);
            request.setAttribute(SCOPES_NAME, (Object)scopes);
            request.setAttribute(VI_NAME, (Object)VI_NAME);
            request.setAttribute(LDAP_NAME, (Object)LDAP_NAME);
            request.setAttribute(ISSUER_NAME, (Object)ISSUER_NAME);
            request.setAttribute(CALLBACK_URI, (Object)CALLBACK_URI);
            request.setAttribute(REFRESH_TOKEN_LIFETIME, (Object)REFRESH_TOKEN_LIFETIME);
            if (this.getOA2SE().isRefreshTokenEnabled()) {
                request.setAttribute(REFRESH_TOKEN_FIELD_VISIBLE, (Object)" ");
            } else {
                request.setAttribute(REFRESH_TOKEN_FIELD_VISIBLE, (Object)" style=\"display: none;\"");
            }
        }
    }

    protected Client setupNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        OA2Client client = (OA2Client)super.setupNewClient(request, response);
        String rawCBs = this.getParameter(request, CALLBACK_URI);
        String rawRTLifetime = this.getParameter(request, REFRESH_TOKEN_LIFETIME);
        String[] rawScopes = request.getParameterValues("chkScopes");
        if (rawScopes != null) {
            LinkedList<String> newScopes = new LinkedList<String>();
            boolean hasDefaultScope = false;
            for (String scope : rawScopes) {
                if ("openid".equals(scope)) {
                    hasDefaultScope = true;
                }
                newScopes.add(scope);
            }
            if (!hasDefaultScope) {
                newScopes.add("openid");
            }
            client.setScopes(newScopes);
        }
        String issuer = this.getParameter(request, ISSUER_NAME);
        String ldap = this.getParameter(request, LDAP_NAME);
        if (!this.isEmpty(issuer)) {
            client.setIssuer(issuer);
        }
        if (!this.isEmpty(ldap)) {
            try {
                JSONObject json = JSONObject.fromObject((Object)ldap);
                LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
                Collection ldapConfiguration = ldapConfigurationUtil.fromJSON((JSON)json);
                client.setLdaps(ldapConfiguration);
            }
            catch (Throwable t) {
                this.warn("Could not parse LDAP string during client registration for \"" + client.getIdentifierString() + "\". Skipping...");
            }
        }
        try {
            URI.create(client.getHomeUri());
        }
        catch (Throwable t) {
            throw new AbstractRegistrationServlet.ClientRegistrationRetryException("Error. The stated home uri is invalid: " + t.getMessage(), null, (BaseClient)client);
        }
        if (rawRTLifetime == null || rawRTLifetime.length() == 0) {
            client.setRtLifetime(0L);
        } else {
            long clientRtLifetime = 0L;
            boolean rtLifetimeOK = true;
            if (rawRTLifetime != null && 0 < rawRTLifetime.length()) {
                try {
                    clientRtLifetime = Long.parseLong(rawRTLifetime) * 1000L;
                    rtLifetimeOK = clientRtLifetime >= 0L;
                }
                catch (Throwable t) {
                    rtLifetimeOK = false;
                }
                if (!rtLifetimeOK) {
                    this.info("Client requested illegal value for refresh token lifetime at registration of \"" + rawRTLifetime + "\"");
                }
            }
            client.setRtLifetime(Math.min(this.getOA2SE().getMaxClientRefreshTokenLifetime(), clientRtLifetime));
        }
        String rawIsPublic = this.getParameter(request, "clientIsPublic");
        client.setPublicClient(false);
        if (rawIsPublic != null) {
            try {
                client.setPublicClient(rawIsPublic.equals("on"));
                LinkedList<String> publicScopes = new LinkedList<String>();
                publicScopes.add("openid");
                client.setScopes(publicScopes);
            }
            catch (Throwable publicScopes) {
                // empty catch block
            }
        }
        if (client.isPublicClient()) {
            client.setSecret("(no secret)");
        } else {
            String publicKey = this.getParameter(request, "clientPublicKey");
            if (StringUtils.isTrivial((String)publicKey)) {
                byte[] bytes = new byte[this.getOA2SE().getClientSecretLength()];
                random.nextBytes(bytes);
                String secret64 = Base64.encodeBase64URLSafeString((byte[])bytes);
                client.setSecret(secret64);
            } else {
                JSONWebKeys jsonWebKeys;
                client.setSecret("(no secret)");
                boolean gotKey = false;
                try {
                    PublicKey publicKey1 = KeyUtil.fromX509PEM((String)publicKey);
                    JSONWebKey jsonWebKey = new JSONWebKey();
                    jsonWebKey.publicKey = publicKey1;
                    Random random = new Random();
                    byte[] bytes = new byte[8];
                    random.nextBytes(bytes);
                    if (!(publicKey1 instanceof RSAPublicKey)) {
                        throw new AbstractRegistrationServlet.ClientRegistrationRetryException("The public key is not a supported type. Only RSA keys are supported.", null, (BaseClient)client);
                    }
                    jsonWebKey.type = "RSA";
                    jsonWebKey.id = Base64.encodeBase64URLSafeString((byte[])bytes);
                    jsonWebKey.use = "sig";
                    jsonWebKey.algorithm = "RS256";
                    jsonWebKeys = new JSONWebKeys(jsonWebKey.id);
                    jsonWebKeys.put(jsonWebKey);
                    gotKey = true;
                }
                catch (Throwable t) {
                    try {
                        publicKey = publicKey.replace("\n", " ");
                        publicKey = publicKey.replace("\r", " ");
                        jsonWebKeys = JSONWebKeyUtil.fromJSON((String)publicKey);
                    }
                    catch (Throwable tt) {
                        throw new AbstractRegistrationServlet.ClientRegistrationRetryException("The public key could not be parsed as PKCS or JWK.", null, (BaseClient)client);
                    }
                }
                client.setJWKS(jsonWebKeys);
            }
        }
        client.setCallbackURIs(OA2ClientUtils.createCallbacksForWebUI(client, rawCBs));
        client.setSignTokens(true);
        ClientApproval approval = (ClientApproval)this.getOA2SE().getClientApprovalStore().create();
        approval.setApproved(false);
        approval.setIdentifier(client.getIdentifier());
        this.getOA2SE().getClientApprovalStore().save((Identifiable)approval);
        return client;
    }

    private LinkedList<String> newCreateCallbacks(String rawCBs) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(rawCBs));
        String x = br.readLine();
        LinkedList<String> uris = new LinkedList<String>();
        while (x != null) {
            try {
                URI.create(x);
                uris.add(x);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            x = br.readLine();
        }
        return uris;
    }

    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response, boolean fireClientEvents) throws Throwable {
        OA2Client client = (OA2Client)this.setupNewClient(request, response);
        if (fireClientEvents) {
            this.fireNewClientEvent(new NewClientEvent((Object)this, (BaseClient)client));
        }
        return client;
    }

    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.addNewClient(request, response, true);
    }

    public void present(PresentableState state) throws Throwable {
        super.present(state);
        if (state.getState() == 100) {
            if (state instanceof AbstractRegistrationServlet.ClientState) {
                AbstractRegistrationServlet.ClientState cState = (AbstractRegistrationServlet.ClientState)state;
                String secret = DigestUtils.sha1Hex((String)cState.getClient().getSecret());
                cState.getClient().setSecret(secret);
                this.save(cState.getClient());
            } else {
                throw new IllegalStateException("An instance of ClientState was expected, but got an instance of \"" + state.getClass().getName() + "\"");
            }
        }
    }

    protected void setRetryParameters(HttpServletRequest request, RetryException r) {
        super.setRetryParameters(request, r);
        if (this.getOA2SE().isRefreshTokenEnabled()) {
            request.setAttribute(REFRESH_TOKEN_FIELD_VISIBLE, (Object)" ");
        } else {
            request.setAttribute(REFRESH_TOKEN_FIELD_VISIBLE, (Object)" style=\"display: none;\"");
        }
        String[] scopes = new String[this.getOA2SE().getScopes().size()];
        this.getOA2SE().getScopes().toArray(scopes);
        request.setAttribute(SCOPES_NAME, (Object)scopes);
    }
}

