/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.jwt.ScriptRuntimeException;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.state.ExtendedParameters;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.qdl_lang.exceptions.AssertionException;
import org.qdl_lang.exceptions.ParsingException;
import org.qdl_lang.exceptions.QDLExceptionWithTrace;

public class OA2ServletUtils {
    public static int stackTraceMaxLines = 5;
    public static final String TEMPLATES_KEY = "templates";

    public static void handleScriptEngineException(Object callingObject, OA2SE oa2SE, Throwable t, MetaDebugUtil debugger, OA2ServiceTransaction transaction, XMLMap tBackup) {
        OA2ServletUtils.handleScriptEngineException(callingObject, oa2SE, t, debugger, transaction, tBackup, null);
    }

    public static void handleScriptEngineException(Object callingObject, OA2SE oa2SE, Throwable exception, MetaDebugUtil debugger, OA2ServiceTransaction transaction, XMLMap tBackup, TXRecord txRecord) {
        if (tBackup != null) {
            OA2ServletUtils.rollback(oa2SE, tBackup, txRecord);
        }
        OA2ATException atException = null;
        String message = null;
        if (exception instanceof OA2ATException) {
            OA2ServletUtils.pp\u03be(exception, callingObject, oa2SE, debugger, exception.getMessage());
            throw (OA2ATException)exception;
        }
        if (exception instanceof QDLExceptionWithTrace) {
            message = "error processing request:" + exception.getMessage();
            atException = new OA2ATException("invalid_request", message, 400, transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        if (exception instanceof AssertionException) {
            message = "assertion exception:" + exception.getMessage();
            atException = new OA2ATException("invalid_request", message, 400, transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        if (exception instanceof ScriptRuntimeException) {
            ScriptRuntimeException sre = (ScriptRuntimeException)exception;
            message = "script runtime exception: \"" + sre.getMessage() + "\"";
            atException = sre.getErrorURI() == null ? new OA2ATException(sre.getRequestedType(), sre.getMessage(), sre.getHttpStatus(), transaction.getRequestState(), (BaseClient)transaction.getClient()) : new OA2ATException(sre.getRequestedType(), sre.getMessage(), sre.getHttpStatus(), sre.getErrorURI(), transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        if (exception instanceof ParsingException) {
            ParsingException parsingException = (ParsingException)exception;
            Object msg = parsingException.hasScriptName() ? "error parsing script '" + parsingException.getScriptName() + "' " : "parser error ";
            msg = (String)msg + "at line # " + parsingException.getLineNumber() + ", char=" + parsingException.getEndCharacterPosition();
            debugger.trace(OA2ServletUtils.class, (String)msg, exception);
        }
        if (exception instanceof IllegalAccessException) {
            message = "illegal access exception \"" + exception.getMessage() + "\"";
            atException = new OA2ATException("unauthorized_client", "access denied", transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        if (atException == null) {
            message = "unable to update claims on token refresh: \"" + exception.getMessage() + "\"";
            atException = new OA2ATException("invalid_request", message, 400, transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        OA2ServletUtils.pp\u03be(exception, callingObject, oa2SE, debugger, message);
        throw atException;
    }

    protected static void rollback(OA2SE oa2SE, XMLMap backup, TXRecord txRecord) {
        GenericStoreUtils.fromXMLAndSave((Store)oa2SE.getTransactionStore(), (XMLMap)backup);
        if (txRecord != null) {
            oa2SE.getTxStore().remove(txRecord.getIdentifier());
        }
    }

    public static String truncateStackTrace(Throwable e, int n, boolean printIt) {
        Object current = OA2ServletUtils.truncateStackTrace2(e, n, printIt);
        Throwable nextE = e.getCause();
        if (nextE != null) {
            for (int i = 1; i < n; ++i) {
                current = (String)current + "\n" + OA2ServletUtils.truncateStackTrace2(nextE, n, printIt);
                if ((nextE = nextE.getCause()) == null) break;
            }
        }
        return current;
    }

    protected static String truncateStackTrace2(Throwable e, int n, boolean printIt) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String[] lines = writer.toString().split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(lines.length, n); ++i) {
            sb.append(lines[i]).append("\n");
        }
        if (printIt) {
            System.err.println(sb);
        }
        return sb.toString();
    }

    protected static void pp\u03be(Throwable throwable, Object callingObject, OA2SE oa2SE, MetaDebugUtil debugger, String message) {
        if (debugger == null) {
            oa2SE.warn(message);
            oa2SE.warn(OA2ServletUtils.truncateStackTrace(throwable, stackTraceMaxLines, false));
            return;
        }
        debugger.trace(callingObject, message);
        debugger.trace(callingObject, OA2ServletUtils.truncateStackTrace(throwable, stackTraceMaxLines, false));
    }

    public static void processReservedXAs(JSONObject xas, OA2ServiceTransaction t) {
        String key;
        JSONObject xa;
        if (xas.containsKey((Object)ExtendedParameters.OA4MP_NS) && (xa = xas.getJSONObject(ExtendedParameters.OA4MP_NS)).containsKey((Object)(key = "/templates"))) {
            JSONArray templates;
            Object object = xa.get(key);
            if (object instanceof JSONArray) {
                templates = (JSONArray)object;
            } else {
                templates = new JSONArray();
                templates.add(object.toString());
            }
            t.setUseTemplates((List<String>)templates);
            xa.remove(key);
        }
    }

    public static void processXAs(Map<String, String[]> params, OA2ServiceTransaction t, OA2Client client) {
        ExtendedParameters xp = new ExtendedParameters();
        JSONObject extAttr = xp.snoopParameters(params);
        if (extAttr.isEmpty()) {
            return;
        }
        OA2ServletUtils.processReservedXAs(extAttr, t);
        if (client.hasExtendedAttributeSupport() && extAttr != null && !extAttr.isEmpty()) {
            t.setExtendedAttributes(extAttr);
        }
    }

    public static void processXAs(HttpServletRequest request, OA2ServiceTransaction t, OA2Client client) {
        OA2ServletUtils.processXAs(request.getParameterMap(), t, client);
    }
}

