/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.exceptions.InvalidAlgorithmException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidSignatureException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.core.exceptions.UnsupportedJWTTypeException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.IOException;
import java.net.URI;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.util.ClientDebugUtil;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class OA2TokenUtils {
    public static JSONWebKeys getKeys(OA2SE oa2se, OA2Client client) {
        VirtualIssuer vo = oa2se.getVI(client.getIdentifier());
        JSONWebKeys keys = ((OA2SE)OA4MPServlet.getServiceEnvironment()).getJsonWebKeys();
        if (vo != null) {
            keys = vo.getJsonWebKeys();
            ServletDebugUtil.trace(OA2TokenUtils.class, (String)("Got VI for client " + client.getIdentifierString()));
        }
        return keys;
    }

    public static AccessTokenImpl getAT(String subjectToken, OA2SE oa2se, JSONWebKeys keys, MetaDebugUtil debugger) {
        OA2ATException x;
        AccessTokenImpl accessToken = TokenFactory.createAT((String)subjectToken);
        if (accessToken.isJWT()) {
            try {
                JWTUtil.verifyAndReadJWT((String)subjectToken, (JSONWebKeys)keys);
            }
            catch (InvalidAlgorithmException | InvalidSignatureException | UnsupportedJWTTypeException tt) {
                debugger.trace(OA2TokenUtils.class, "Failed to verify access token JWT: \"" + tt.getMessage());
                throw new OA2GeneralError("invalid_request", "invalid access token", 400, null, debugger instanceof ClientDebugUtil ? ((ClientDebugUtil)debugger).getClient() : null);
            }
        }
        debugger.trace(OA2TokenUtils.class, "access token from subject token = " + String.valueOf(accessToken));
        boolean isAtValid = false;
        boolean isATExpired = true;
        OA2ServiceTransaction t = (OA2ServiceTransaction)oa2se.getTransactionStore().get((AccessToken)accessToken);
        if (t == null) {
            t = OA2TokenUtils.getTransactionFromTX(oa2se, accessToken.getJti(), debugger);
            if (t != null) {
                TXRecord txRecord = (TXRecord)oa2se.getTxStore().get(BasicIdentifier.newID((URI)accessToken.getJti()));
                isAtValid = txRecord.isValid();
                isATExpired = txRecord.getExpiresAt() < System.currentTimeMillis();
            }
        } else {
            isAtValid = t.isAccessTokenValid();
            isATExpired = accessToken.isExpired();
        }
        if (t == null) {
            if (debugger instanceof ClientDebugUtil) {
                ClientDebugUtil clientDebugUtil = (ClientDebugUtil)debugger;
                oa2se.getMyLogger().info("client " + clientDebugUtil.getClient().getIdentifierString() + ",  transaction not found for \"" + String.valueOf(accessToken) + "\"");
            }
            debugger.trace(OA2TokenUtils.class, "Transaction not found for \"" + String.valueOf(accessToken.getJti()) + "\"");
            x = new OA2ATException("invalid_grant", "unknown access token", t.getRequestState(), (BaseClient)t.getClient());
            x.setForensicMessage("unknown token:" + subjectToken);
            throw x;
        }
        if (!isAtValid) {
            debugger.info(OA2TokenUtils.class, "Access token invalid: " + t.summary());
            x = new OA2ATException("invalid_token", "token invalid", t.getRequestState(), (BaseClient)t.getClient());
            x.setForensicMessage("offending token invalid:" + subjectToken);
            throw x;
        }
        if (isATExpired) {
            debugger.info(OA2TokenUtils.class, "Access token expired: " + t.summary());
            x = new OA2ATException("invalid_token", "token expired", t.getRequestState(), (BaseClient)t.getClient());
            x.setForensicMessage("offending token expired:" + subjectToken);
            throw x;
        }
        return accessToken;
    }

    public static IDTokenImpl getIDToken(String subjectToken, OA2SE oa2SE, JSONWebKeys keys, MetaDebugUtil debugger) {
        try {
            JSONObject tt = JWTUtil.verifyAndReadJWT((String)subjectToken, (JSONWebKeys)keys);
            IDTokenImpl idToken = new IDTokenImpl(subjectToken, URI.create(tt.getString("jti")));
            debugger.trace(OA2TokenUtils.class, "created ID token with id = " + String.valueOf(idToken.getJti()));
            return idToken;
        }
        catch (IllegalArgumentException | JSONException tt) {
            debugger.trace(OA2TokenUtils.class, "Failed to parse ID token as JWT:" + tt.getMessage());
            throw new OA2GeneralError("invalid_request", "Unable to parse JSON object:" + tt.getMessage(), 400, null);
        }
        catch (InvalidAlgorithmException | InvalidSignatureException | UnsupportedJWTTypeException tt) {
            debugger.trace(OA2TokenUtils.class, "Failed to verify refresh token JWT: \"" + tt.getMessage());
            throw new OA2GeneralError("invalid_request", "invalid refresh token:" + tt.getMessage(), 400, null);
        }
    }

    public static RefreshTokenImpl getRT(String subjectToken, OA2SE oa2SE, JSONWebKeys keys, MetaDebugUtil debugger) {
        OA2ATException x;
        RefreshTokenImpl refreshToken = TokenFactory.createRT((String)subjectToken);
        if (refreshToken.isJWT()) {
            try {
                JWTUtil.verifyAndReadJWT((String)subjectToken, (JSONWebKeys)keys);
            }
            catch (InvalidAlgorithmException | InvalidSignatureException | UnsupportedJWTTypeException tt) {
                debugger.trace(OA2TokenUtils.class, "Failed to verify refresh token JWT: \"" + tt.getMessage());
                throw new OA2GeneralError("invalid_request", "invalid refresh token", 400, null);
            }
        }
        debugger.trace(OA2TokenUtils.class, "refresh token from subject token = " + String.valueOf(refreshToken));
        OA2ServiceTransaction t = null;
        boolean isRTValid = false;
        boolean isRTExpired = true;
        try {
            RefreshTokenStore zzz = (RefreshTokenStore)oa2SE.getTransactionStore();
            t = zzz.get((RefreshToken)refreshToken);
            isRTValid = t.isRefreshTokenValid();
            isRTExpired = refreshToken.isExpired();
        }
        catch (TransactionNotFoundException tnfx) {
            t = OA2TokenUtils.getTransactionFromTX(oa2SE, refreshToken.getJti(), debugger);
            TXRecord txRecord = (TXRecord)oa2SE.getTxStore().get(BasicIdentifier.newID((URI)refreshToken.getJti()));
            isRTValid = txRecord.isValid();
            isRTExpired = txRecord.getExpiresAt() < System.currentTimeMillis();
        }
        catch (Throwable tt) {
            debugger.error(OA2TokenUtils.class, "error getting refresh token:" + String.valueOf(refreshToken.getJti()) + " message:" + tt.getMessage());
            OA2ATException x2 = new OA2ATException("invalid_grant", "invalid refresh token", (BaseClient)(t == null ? (BaseClient)null : t.getClient()));
            x2.setForensicMessage("invalid refresh token, could not get transaction");
            throw x2;
        }
        if (t == null) {
            BaseClient ccc = null;
            if (debugger instanceof ClientDebugUtil) {
                ClientDebugUtil clientDebugUtil = (ClientDebugUtil)debugger;
                ccc = clientDebugUtil.getClient();
                oa2SE.getMyLogger().info("client " + clientDebugUtil.getClient().getIdentifierString() + ",  transaction not found for \"" + String.valueOf(refreshToken) + "\"");
            }
            debugger.trace(OA2TokenUtils.class, "Transaction not found for \"" + String.valueOf(refreshToken.getJti()) + "\"");
            OA2ATException x3 = new OA2ATException("invalid_grant", "invalid refresh token", ccc == null ? (BaseClient)null : ccc);
            x3.setForensicMessage("invalid refresh token, transaction not found");
            throw x3;
        }
        if (!isRTValid) {
            debugger.info(OA2TokenUtils.class, "Refresh token invalid: " + t.summary());
            x = new OA2ATException("invalid_grant", "invalid refresh token", t.getRequestState(), (BaseClient)t.getClient());
            x.setForensicMessage("invalid refresh token");
            throw x;
        }
        if (isRTExpired) {
            debugger.info(OA2TokenUtils.class, "Refresh token expired: " + t.summary());
            x = new OA2ATException("invalid_grant", "expired refresh token", t.getRequestState(), (BaseClient)t.getClient());
            x.setForensicMessage("expired refresh token");
            throw x;
        }
        return refreshToken;
    }

    public static OA2ServiceTransaction getTransactionFromTX(OA2SE oa2se, AccessTokenImpl accessToken, MetaDebugUtil debugger) throws IOException {
        return OA2TokenUtils.getTransactionFromTX(oa2se, accessToken.getJti(), debugger);
    }

    public static OA2ServiceTransaction getTransactionFromTX(OA2SE oa2se, RefreshTokenImpl refreshToken, MetaDebugUtil debugger) throws IOException {
        return OA2TokenUtils.getTransactionFromTX(oa2se, refreshToken.getJti(), debugger);
    }

    public static OA2ServiceTransaction getTransactionFromTX(OA2SE oa2se, IDTokenImpl idToken, MetaDebugUtil debugger) throws IOException {
        return OA2TokenUtils.getTransactionFromTX(oa2se, idToken.getJti(), debugger);
    }

    protected static OA2ServiceTransaction getTransactionFromTX(OA2SE oa2se, URI jti, MetaDebugUtil debugger) {
        TXRecord txRecord = (TXRecord)oa2se.getTxStore().get(BasicIdentifier.newID((URI)jti));
        if (txRecord == null) {
            if (debugger == null) {
                ServletDebugUtil.trace(OA2TokenUtils.class, (String)("No transaction found, no TXRecord found for token with id = " + String.valueOf(jti)));
            } else {
                debugger.info(OA2TokenUtils.class, "no transaction found");
            }
            OA2GeneralError ge = new OA2GeneralError("invalid_token", "token not found", 401, null);
            ge.setForensicMessage("offending token not found:" + String.valueOf(jti));
            throw ge;
        }
        if (!txRecord.isValid()) {
            if (debugger != null) {
                debugger.info(OA2TokenUtils.class, "invalid token");
            }
            OA2ATException x = new OA2ATException("invalid_token", "invalid token", (String)null);
            x.setForensicMessage("offending token invalid:" + String.valueOf(jti));
            throw x;
        }
        if (txRecord.getExpiresAt() < System.currentTimeMillis()) {
            if (debugger != null) {
                debugger.info(OA2TokenUtils.class, "expired token");
            }
            OA2ATException x = new OA2ATException("invalid_token", "token expired", (String)null);
            x.setForensicMessage("offending token expired:" + String.valueOf(jti));
            throw x;
        }
        return (OA2ServiceTransaction)((Object)oa2se.getTransactionStore().get((Object)txRecord.getParentID()));
    }
}

