/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.servlet.TokenManagerServlet;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;

public class RFC7009
extends TokenManagerServlet {
    protected void doIt(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        TokenManagerServlet.State state;
        OA2SE oa2SE;
        block9: {
            oa2SE = (OA2SE)RFC7009.getServiceEnvironment();
            try {
                state = this.isRFC7523Client(req) ? this.check7523(req) : (!OA2HeaderUtils.getAuthHeader((HttpServletRequest)req, (String)"Basic").isEmpty() ? this.checkBasic(req) : this.checkBearer(req));
                if (state == null) {
                    resp.setStatus(200);
                    this.logOK(req);
                    return;
                }
                if (state.isAT || state.transaction == null) break block9;
                List records = oa2SE.getTxStore().getByParentID(state.transaction.getIdentifier());
                for (TXRecord txRecord : records) {
                    if (!txRecord.getIdentifierString().equals(state.refreshToken.getJti().toString())) continue;
                    state.txRecord = txRecord;
                    break;
                }
            }
            catch (OA2GeneralError x) {
                DebugUtil.error((Object)((Object)this), (String)"Got exception checking bearer/basic header ", (Throwable)x);
                resp.setStatus(200);
                this.logOK(req);
                return;
            }
        }
        this.checkAdminClientStatus(state.transaction.getOA2Client().getIdentifier());
        if (state.txRecord != null) {
            state.txRecord.setValid(false);
            oa2SE.getTxStore().save(state.txRecord);
            if (!state.isAT && state.transaction.getRefreshToken().getJti().toString().equals(state.txRecord.getIdentifierString())) {
                state.transaction.setRefreshTokenValid(false);
                oa2SE.getTransactionStore().save((Identifiable)state.transaction);
            }
            resp.setStatus(200);
            return;
        }
        if (state.transaction == null) {
            resp.setStatus(200);
            return;
        }
        if (state.isAT) {
            state.transaction.setAccessTokenValid(false);
        } else {
            state.transaction.setRefreshTokenValid(false);
        }
        oa2SE.getTransactionStore().save((Identifiable)state.transaction);
        resp.setStatus(200);
        this.logOK(req);
    }

    protected boolean checkToken(OA2Client requestingClient, String token) {
        OA2SE oa2SE = (OA2SE)RFC7009.getServiceEnvironment();
        OA2ServiceTransaction t = this.getTransFromToken(token);
        if (t != null) {
            if (!t.getClient().getIdentifier().equals(requestingClient.getIdentifier())) {
                throw new OA2GeneralError("unauthorized_client", "Unauthorized client", 401, null, (BaseClient)requestingClient);
            }
            oa2SE.getTransactionStore().remove((Object)t.getIdentifier());
            return true;
        }
        return false;
    }
}

