/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.servlet.TokenManagerServlet;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;

public class RFC7662
extends TokenManagerServlet {
    protected void doIt(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        TokenManagerServlet.State state;
        try {
            state = this.isRFC7523Client(req) ? this.check7523(req) : (!OA2HeaderUtils.getAuthHeader((HttpServletRequest)req, (String)"Basic").isEmpty() ? this.checkBasic(req) : this.checkBearer(req));
        }
        catch (OA2GeneralError x) {
            this.info("Got exception checking bearer/basic header:" + x.getMessage());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"active", (Object)false);
            this.writeOK(resp, jsonObject);
            return;
        }
        this.checkAdminClientStatus(state.transaction.getClient().getIdentifier());
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)state.transaction.getOA2Client());
        if (state.txRecord != null) {
            debugger.trace((Object)this, "introspect, token in exchange record = \"" + String.valueOf(state.txRecord.getIdentifier()) + "\"");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"active", (Object)state.txRecord.isValid());
            if (jsonObject.getBoolean("active")) {
                this.populateResponse(state, jsonObject);
            }
            debugger.trace((Object)this, "token is " + (jsonObject.getBoolean("active") ? "" : "not") + " active");
            this.writeOK(resp, jsonObject);
            return;
        }
        if (state.transaction != null) {
            debugger.trace((Object)this, "introspect, from transaction = \"" + String.valueOf(state.transaction.getIdentifier()) + "\"");
            JSONObject jsonObject = new JSONObject();
            if (state.isAT) {
                jsonObject.put((Object)"active", (Object)state.transaction.isAccessTokenValid());
            } else {
                jsonObject.put((Object)"active", (Object)state.transaction.isRefreshTokenValid());
            }
            if (jsonObject.getBoolean("active")) {
                this.populateResponse(state, jsonObject);
            }
            debugger.trace((Object)this, "token is " + (jsonObject.getBoolean("active") ? "" : "not") + " active");
            this.writeOK(resp, jsonObject);
            this.logOK(req);
            return;
        }
        debugger.trace((Object)this, "default case: token is not active");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"active", (Object)false);
        this.writeOK(resp, jsonObject);
        this.logOK(req);
    }

    protected void populateResponse(TokenManagerServlet.State state, JSONObject json) {
        AccessTokenImpl token;
        if (!json.containsKey((Object)"active")) {
            return;
        }
        if (!json.getBoolean("active")) {
            return;
        }
        Object object = token = state.isAT ? state.accessToken : state.refreshToken;
        if (token.isJWT()) {
            return;
        }
        if (state.txRecord != null) {
            TXRecord txr = state.txRecord;
            json.put((Object)"aud", txr.getAudience());
            if (txr.getScopes() == null || txr.getScopes().isEmpty()) {
                json.put((Object)"scope", state.transaction.getScopes());
            } else {
                json.put((Object)"scope", txr.getScopes());
            }
            json.put((Object)"exp", (Object)(txr.getExpiresAt() / 1000L));
            json.put((Object)"iat", (Object)(txr.getIssuedAt() / 1000L));
            json.put((Object)"nbf", (Object)(token.getIssuedAt() / 1000L));
            json.put((Object)"iss", (Object)txr.getIssuer());
            json.put((Object)"jti", (Object)token.getJti().toString());
            json.put((Object)"username", (Object)state.transaction.getUsername());
            json.put((Object)"client_id", (Object)state.transaction.getOA2Client().getIdentifierString());
            json.put((Object)"token_type", (Object)(token instanceof AccessToken ? "urn:ietf:params:oauth:token-type:access_token" : "urn:ietf:params:oauth:token-type:refresh_token"));
            return;
        }
        OA2ServiceTransaction transaction = state.transaction;
        long authTime = transaction.getAuthTime().getTime();
        if (state.isAT) {
            json.put((Object)"aud", transaction.getAudience());
            json.put((Object)"scope", transaction.getScopes());
            json.put((Object)"exp", (Object)((authTime + transaction.getAccessTokenLifetime()) / 1000L));
        } else {
            json.put((Object)"exp", (Object)((authTime + transaction.getRefreshTokenLifetime()) / 1000L));
        }
        if (transaction.getUserMetaData().containsKey((Object)"iss")) {
            json.put((Object)"iss", (Object)transaction.getUserMetaData().getString("iss"));
        }
        json.put((Object)"iat", (Object)(authTime / 1000L));
        json.put((Object)"nbf", (Object)(token.getIssuedAt() / 1000L));
        json.put((Object)"jti", (Object)token.getJti().toString());
        json.put((Object)"username", (Object)state.transaction.getUsername());
        json.put((Object)"client_id", (Object)state.transaction.getOA2Client().getIdentifierString());
        json.put((Object)"token_type", (Object)(token instanceof AccessToken ? "urn:ietf:params:oauth:token-type:access_token" : "urn:ietf:params:oauth:token-type:refresh_token"));
    }
}

