/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.net.URI;
import net.sf.json.JSONObject;

public class RFC8628State {
    String USER_CODE_KEY = "user_code";
    String DEVICE_CODE_KEY = "device_code";
    String LIFETIME_KEY = "lifetime";
    String ISSUED_AT_KEY = "issued_at";
    String LAST_TRY_KEY = "last_try";
    String FIRST_TRY_KEY = "first_try";
    String IS_VALID_KEY = "is_valid";
    String ORIGINAL_SCOPES_KEY = "original_scopes";
    public String userCode = null;
    public URI deviceCode = null;
    public long lifetime = -1L;
    public long issuedAt = -1L;
    public long lastTry = -1L;
    public long interval = -1L;
    public boolean firstTry = true;
    public boolean valid = false;
    String INTERVAL_KEY = "interval";
    public String originalScopes = "";

    public void fromJSON(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)this.USER_CODE_KEY)) {
            this.userCode = jsonObject.getString(this.USER_CODE_KEY);
        }
        if (jsonObject.containsKey((Object)this.DEVICE_CODE_KEY)) {
            this.deviceCode = URI.create(jsonObject.getString(this.DEVICE_CODE_KEY));
        }
        if (jsonObject.containsKey((Object)this.LIFETIME_KEY)) {
            this.lifetime = jsonObject.getLong(this.LIFETIME_KEY);
        }
        if (jsonObject.containsKey((Object)this.ISSUED_AT_KEY)) {
            this.issuedAt = jsonObject.getLong(this.ISSUED_AT_KEY);
        }
        if (jsonObject.containsKey((Object)this.ORIGINAL_SCOPES_KEY)) {
            this.originalScopes = jsonObject.getString(this.ORIGINAL_SCOPES_KEY);
        }
        if (jsonObject.containsKey((Object)this.LAST_TRY_KEY)) {
            this.lastTry = jsonObject.getLong(this.LAST_TRY_KEY);
        }
        if (jsonObject.containsKey((Object)this.FIRST_TRY_KEY)) {
            this.firstTry = jsonObject.getBoolean(this.FIRST_TRY_KEY);
        }
        if (jsonObject.containsKey((Object)this.INTERVAL_KEY)) {
            this.interval = jsonObject.getLong(this.INTERVAL_KEY);
        }
        this.valid = jsonObject.getBoolean(this.IS_VALID_KEY);
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)this.IS_VALID_KEY, (Object)this.valid);
        jsonObject.put((Object)this.FIRST_TRY_KEY, (Object)this.firstTry);
        if (!StringUtils.isTrivial((String)this.userCode)) {
            jsonObject.put((Object)this.USER_CODE_KEY, (Object)this.userCode);
        }
        if (this.deviceCode != null) {
            jsonObject.put((Object)this.DEVICE_CODE_KEY, (Object)this.deviceCode.toString());
        }
        if (0L < this.lastTry) {
            jsonObject.put((Object)this.LAST_TRY_KEY, (Object)this.lastTry);
        }
        if (!StringUtils.isTrivial((String)this.originalScopes)) {
            jsonObject.put((Object)this.ORIGINAL_SCOPES_KEY, (Object)this.originalScopes);
        }
        if (0L < this.lifetime) {
            jsonObject.put((Object)this.LIFETIME_KEY, (Object)this.lifetime);
        }
        if (0L < this.issuedAt) {
            jsonObject.put((Object)this.ISSUED_AT_KEY, (Object)this.issuedAt);
        }
        if (0L < this.interval) {
            jsonObject.put((Object)this.INTERVAL_KEY, (Object)this.interval);
        }
        return jsonObject;
    }

    public boolean isExpired() {
        return this.issuedAt + this.lifetime < System.currentTimeMillis();
    }
}

