/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.server.RFC7662Constants;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.BearerTokenServlet;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2TokenUtils;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.tokens.UITokenUtils;

public abstract class TokenManagerServlet
extends BearerTokenServlet
implements RFC7662Constants {
    protected OA2Client verifyClient(HttpServletRequest req, String headerAuthz) throws UnsupportedEncodingException {
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        String[] credentials = OA2HeaderUtils.getCredentialsFromHeaders((HttpServletRequest)req, (String)headerAuthz);
        Identifier acID = BasicIdentifier.newID((String)credentials[OA2HeaderUtils.ID_INDEX]);
        if (!oa2SE.getClientStore().containsKey((Object)acID)) {
            throw new GeneralException("the given id of \"" + String.valueOf(acID) + "\" is not recognized as valid client.");
        }
        String adminSecret = credentials[OA2HeaderUtils.SECRET_INDEX];
        if (adminSecret == null || adminSecret.isEmpty()) {
            throw new GeneralException("missing secret.");
        }
        OA2Client client = (OA2Client)((Object)oa2SE.getClientStore().get((Object)acID));
        if (!oa2SE.getClientApprovalStore().isApproved(acID)) {
            ServletDebugUtil.trace((Object)((Object)this), (String)("Client \"" + String.valueOf(acID) + "\" is not approved."));
            throw new GeneralException("this  client has not been approved.");
        }
        String hashedSecret = DigestUtils.sha1Hex((String)adminSecret);
        if (!client.getSecret().equals(hashedSecret)) {
            throw new GeneralException("client and secret do not match");
        }
        return client;
    }

    protected State checkBasic(HttpServletRequest req) throws Throwable {
        State state = new State();
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        Object at = null;
        Object rt = null;
        OA2Client client = this.verifyClient(req, "Basic");
        return this.getState(req, state, oa2SE, client);
    }

    protected boolean isRFC7523Client(HttpServletRequest req) {
        System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": " + req.getParameter("client_assertion_type"));
        return req.getParameter("client_assertion_type") != null && req.getParameter("client_assertion_type").equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
    }

    protected State check7523(HttpServletRequest req) throws Throwable {
        State state = new State();
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        OA2Client oa2Client = (OA2Client)OA2HeaderUtils.getAndVerifyRFC7523Client(req, (OA2SE)TokenManagerServlet.getServiceEnvironment());
        return this.getState(req, state, oa2SE, oa2Client);
    }

    private State getState(HttpServletRequest req, State state, OA2SE oa2SE, OA2Client client) {
        OA2ServiceTransaction transaction;
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)client);
        JSONWebKeys keys = OA2TokenUtils.getKeys(oa2SE, client);
        String token = req.getParameter("token");
        String tokenTypeHint = req.getParameter("token_type_hint");
        state.transaction = transaction = this.getOA2ServiceTransactionBasic(state, oa2SE, keys, token, tokenTypeHint, debugger);
        if (!client.getIdentifier().equals(transaction.getOA2Client().getIdentifier())) {
            debugger.info((Object)this, "unauthorized client");
            throw new OA2GeneralError("unauthorized_client", "Unauthorized client", 401, null, (BaseClient)client);
        }
        debugger.trace((Object)this, "introspection endpoint basic auth ok.");
        return state;
    }

    private OA2ServiceTransaction getOA2ServiceTransactionBasic(State state, OA2SE oa2SE, JSONWebKeys keys, String token, String tokenTypeHint, MetaDebugUtil debugger) {
        RefreshTokenImpl rt = null;
        AccessTokenImpl at = null;
        if (StringUtils.isTrivial((String)tokenTypeHint)) {
            try {
                rt = OA2TokenUtils.getRT(token, oa2SE, keys, debugger);
            }
            catch (Throwable t) {
                at = OA2TokenUtils.getAT(token, oa2SE, keys, debugger);
            }
        } else {
            switch (tokenTypeHint) {
                case "access_token": {
                    at = OA2TokenUtils.getAT(token, oa2SE, keys, debugger);
                    break;
                }
                case "refresh_token": {
                    rt = OA2TokenUtils.getRT(token, oa2SE, keys, debugger);
                    break;
                }
                default: {
                    throw new OA2GeneralError("unsupported_token_type", "The token type of \"" + tokenTypeHint + "\" is not supported on this server.", 403, null);
                }
            }
        }
        OA2ServiceTransaction transaction = null;
        TXRecord txr = null;
        if (at == null && rt == null) {
            throw new NFWException("could not determine token type");
        }
        if (at != null) {
            state.accessToken = at;
            state.isAT = true;
            try {
                transaction = (OA2ServiceTransaction)oa2SE.getTransactionStore().get((AccessToken)at);
            }
            catch (TransactionNotFoundException t) {
                txr = (TXRecord)oa2SE.getTxStore().get(BasicIdentifier.newID((URI)at.getJti()));
                transaction = (OA2ServiceTransaction)((Object)oa2SE.getTransactionStore().get((Object)txr.getParentID()));
                state.txRecord = txr;
            }
        }
        if (rt != null) {
            state.refreshToken = rt;
            state.isAT = false;
            try {
                transaction = ((RefreshTokenStore)oa2SE.getTransactionStore()).get((RefreshToken)rt);
            }
            catch (TransactionNotFoundException transactionNotFoundException) {
                txr = (TXRecord)oa2SE.getTxStore().get(BasicIdentifier.newID((URI)rt.getJti()));
                transaction = (OA2ServiceTransaction)((Object)oa2SE.getTransactionStore().get((Object)txr.getParentID()));
                state.txRecord = txr;
            }
        }
        if (transaction == null) {
            throw new OA2GeneralError("invalid_token", "invalid token", 400, null);
        }
        return transaction;
    }

    protected State checkBearer(HttpServletRequest req) throws Throwable {
        State state = new State();
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        AccessTokenImpl atBearer = null;
        Object atPayload = null;
        Object rt = null;
        atBearer = UITokenUtils.getAT(UITokenUtils.getRawAT(req));
        OA2ServiceTransaction transaction = this.findTransaction(atBearer, state);
        OA2Client client = transaction.getOA2Client();
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)client);
        debugger.trace((Object)this, "checked client, verifying access token is bearer token");
        JSONWebKeys keys = OA2TokenUtils.getKeys(oa2SE, client);
        state.transaction = transaction;
        String token = req.getParameter("token");
        String tokenTypeHint = req.getParameter("token_type_hint");
        this.finishState(state, oa2SE, atBearer, keys, token, tokenTypeHint, debugger);
        debugger.trace((Object)this, "access token is the bearer token");
        return state;
    }

    private void finishState(State state, OA2SE oa2SE, AccessTokenImpl atBearer, JSONWebKeys keys, String token, String tokenTypeHint, MetaDebugUtil debugger) {
        AccessTokenImpl accessToken = null;
        RefreshTokenImpl refreshToken = null;
        if (StringUtils.isTrivial((String)tokenTypeHint)) {
            try {
                refreshToken = OA2TokenUtils.getRT(token, oa2SE, keys, debugger);
            }
            catch (Throwable t) {
                accessToken = OA2TokenUtils.getAT(token, oa2SE, keys, debugger);
            }
        } else {
            switch (tokenTypeHint) {
                case "access_token": {
                    accessToken = OA2TokenUtils.getAT(token, oa2SE, keys, debugger);
                    break;
                }
                case "refresh_token": {
                    refreshToken = OA2TokenUtils.getRT(token, oa2SE, keys, debugger);
                    break;
                }
                default: {
                    throw new OA2GeneralError("unsupported_token_type", "The token type of \"" + tokenTypeHint + "\" is not supported on this server.", 403, null);
                }
            }
        }
        if (accessToken == null && refreshToken == null) {
            throw new NFWException("could not determine token type");
        }
        if (accessToken != null) {
            if (atBearer.getJti().equals(accessToken.getJti())) {
                state.accessToken = atBearer;
                state.isAT = true;
            } else {
                throw new OA2GeneralError("access_denied", "bearer and requested token must match", 401, null);
            }
        }
        if (refreshToken != null) {
            state.refreshToken = refreshToken;
            state.isAT = false;
        }
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setStatus(405);
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.getWriter().println("GET unsupported on this server");
        httpServletResponse.getWriter().flush();
    }

    protected int getTokenType(String token) {
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        return ((OA2TokenForge)oa2SE.getTokenForge()).getType(token);
    }

    protected void writeOK(HttpServletResponse httpServletResponse, JSONObject resp) throws IOException {
        if (resp != null) {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().println(resp.toString());
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().flush();
        }
        httpServletResponse.setStatus(200);
    }

    protected OA2ServiceTransaction getTransFromToken(String token) {
        if (TokenUtils.isBase32((String)token)) {
            token = TokenUtils.b32DecodeToken((String)token);
        }
        OA2SE oa2SE = (OA2SE)TokenManagerServlet.getServiceEnvironment();
        OA2TokenForge tf = (OA2TokenForge)oa2SE.getTokenForge();
        switch (tf.getType(token)) {
            case 1: {
                throw new OA2GeneralError("invalid_request", "invalid request", 400, null);
            }
            case 10: {
                return (OA2ServiceTransaction)oa2SE.getTransactionStore().get((AccessToken)tf.getAccessToken(new String[]{token}));
            }
            case 100: {
                RefreshTokenStore refreshTokenStore = (RefreshTokenStore)oa2SE.getTransactionStore();
                return refreshTokenStore.get((RefreshToken)tf.getRefreshToken(new String[]{token}));
            }
        }
        return null;
    }

    public static class State {
        OA2ServiceTransaction transaction;
        boolean isAT = false;
        AccessTokenImpl accessToken;
        RefreshTokenImpl refreshToken;
        TXRecord txRecord;
    }
}

