/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.HandlerRunner;
import org.oa4mp.delegation.server.jwt.ScriptRuntimeException;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.delegation.server.server.UII2;
import org.oa4mp.delegation.server.server.UIIRequest2;
import org.oa4mp.delegation.server.server.UIIResponse2;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.IDTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.servlet.BearerTokenServlet;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.TokenManagerServlet;
import org.oa4mp.server.loader.oauth2.state.ScriptRuntimeEngineFactory;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.tokens.UITokenUtils;
import org.qdl_lang.exceptions.AssertionException;

public class UserInfoServlet
extends BearerTokenServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AccessTokenImpl at = null;
        try {
            at = UITokenUtils.getAT(UITokenUtils.getRawAT(request));
        }
        catch (Throwable t) {
            response.setHeader("WWW-Authenticate", "Bearer realm=\"oa4mp\", error=\"invalid_token\"");
            response.setStatus(401);
            return;
        }
        TokenManagerServlet.State state = new TokenManagerServlet.State();
        OA2ServiceTransaction transaction = null;
        try {
            transaction = this.findTransaction(at, state);
        }
        catch (OA2GeneralError e) {
            e.setForensicMessage(e.getForensicMessage() + "\nerror in user info endpoint.");
            throw e;
        }
        if (!transaction.isAccessTokenValid()) {
            response.setHeader("WWW-Authenticate", "Bearer realm=\"oa4mp\", error=\"invalid_token\"");
            throw new OA2RedirectableError("access_denied", "access denied", 401, transaction.getRequestState(), transaction.getCallback());
        }
        if (!transaction.getScopes().contains("openid")) {
            throw new OA2RedirectableError("access_denied", "access denied", 401, transaction.getRequestState(), transaction.getCallback());
        }
        OA2SE oa2SE = (OA2SE)UserInfoServlet.getServiceEnvironment();
        MetaDebugUtil debugger = UserInfoServlet.createDebugger((BaseClient)transaction.getOA2Client());
        if (!transaction.getFlowStates().userInfo) {
            throw new OA2RedirectableError("access_denied", "access denied", 401, transaction.getRequestState(), transaction.getCallback());
        }
        this.checkAdminClientStatus(transaction.getClient().getIdentifier());
        OA2Client resolvedClient = OA2ClientUtils.resolvePrototypes(oa2SE, transaction.getOA2Client());
        UII2 uis = new UII2(oa2SE.getTokenForge(), UserInfoServlet.getServiceEnvironment().getServiceAddress());
        UIIRequest2 uireq = new UIIRequest2(request, (AccessToken)at);
        uireq.setUsername(this.getUsername((ServiceTransaction)transaction));
        UIIResponse2 uiresp = (UIIResponse2)uis.process((Request)uireq);
        IDTokenHandler idTokenHandler = new IDTokenHandler(new PayloadHandlerConfigImpl(resolvedClient.getIDTokenConfig(), oa2SE, transaction, resolvedClient, null, null));
        idTokenHandler.refreshAccountingInformation();
        HandlerRunner handlerRunner = new HandlerRunner((OIDCServiceTransactionInterface)transaction, ScriptRuntimeEngineFactory.createRTE(oa2SE, transaction, null, resolvedClient.getConfig()));
        OA2ClientUtils.setupHandlers(handlerRunner, oa2SE, transaction, resolvedClient, request);
        try {
            handlerRunner.doUserInfo();
        }
        catch (AssertionException assertionError) {
            debugger.trace((Object)this, "assertion exception \"" + assertionError.getMessage() + "\"");
            throw new OA2ATException("invalid_request", assertionError.getMessage(), 400, transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        catch (ScriptRuntimeException sre) {
            debugger.trace((Object)this, "script runtime exception \"" + sre.getMessage() + "\"");
            throw new OA2ATException(sre.getRequestedType(), sre.getMessage(), sre.getHttpStatus(), transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        catch (IllegalAccessException iax) {
            throw new OA2ATException("unauthorized_client", "access denied", transaction.getRequestState(), (BaseClient)transaction.getClient());
        }
        catch (Throwable throwable) {
            debugger.trace((Object)this, "Unable to update claims on token refresh", throwable);
            debugger.warn((Object)this, "Unable to update claims on token refresh: \"" + throwable.getMessage() + "\"");
        }
        debugger.trace((Object)this, "finished processing claims.");
        if (handlerRunner.hasATHandler()) {
            transaction.setUserMetaData(handlerRunner.getAccessTokenHandler().getUserMetaData());
        } else if (handlerRunner.hasIDTokenHandler()) {
            transaction.setUserMetaData(handlerRunner.getIdTokenHandlerInterface().getUserMetaData());
        }
        this.getTransactionStore().save((Identifiable)transaction);
        uiresp.getUserInfo().getMap().putAll(this.stripClaims(transaction.getUserMetaData()));
        uiresp.write(response);
        this.info(((Object)((Object)this)).getClass().getSimpleName() + ":request ok(" + AbstractServlet.getRequestIPAddress((HttpServletRequest)request) + ")");
    }

    protected JSONObject stripClaims(JSONObject json) {
        String[] x;
        JSONObject r = new JSONObject();
        r.putAll((Map)json);
        for (String y : x = new String[]{"iat", "nonce", "exp", "expires_in", "auth_time"}) {
            r.remove(y);
        }
        return r;
    }

    protected String getUsername(ServiceTransaction transaction) {
        return transaction.getUsername();
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }
}

