/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.state;

import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import edu.uiuc.ncsa.security.util.scripting.ScriptRuntimeEngine;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;
import org.qdl_lang.evaluate.MetaEvaluator;
import org.qdl_lang.evaluate.OpEvaluator;
import org.qdl_lang.expressions.module.MIStack;
import org.qdl_lang.expressions.module.MTStack;
import org.qdl_lang.functions.FStack;
import org.qdl_lang.state.State;
import org.qdl_lang.state.StateUtils;
import org.qdl_lang.variables.VStack;

public class ScriptRuntimeEngineFactory {
    public static ScriptRuntimeEngine createRTE(final OA2SE oa2SE, final OA2ServiceTransaction transaction, final TXRecord txRecord, JSONObject config) {
        OA2Client oa2Client = (OA2Client)transaction.getClient();
        if (oa2SE.getQDLEnvironment() != null && oa2SE.getQDLEnvironment().isEnabled()) {
            if (!StateUtils.isFactorySet()) {
                StateUtils.setFactory((StateUtils)new StateUtils(){

                    public State create() {
                        OA2State ss = new OA2State(new VStack(), new OpEvaluator(), MetaEvaluator.getInstance(), new FStack(), new MTStack(), new MIStack(), null, true, true, false, true, null);
                        ss.setTransaction(transaction);
                        ss.setOa2se(oa2SE);
                        ss.setTxRecord(txRecord);
                        return ss;
                    }
                });
            }
            QDLRuntimeEngine qrt = new QDLRuntimeEngine(oa2SE.getQDLEnvironment(), transaction);
            qrt.setConfigToCS(transaction.getConfigToCS());
            OA2State state = qrt.getState();
            state.setOa2se(oa2SE);
            VirtualIssuer vo = oa2SE.getVI(oa2Client.getIdentifier());
            if (vo != null) {
                state.setJsonWebKeys(vo.getJsonWebKeys());
            } else {
                state.setJsonWebKeys(oa2SE.getJsonWebKeys());
            }
            state.setTransaction(transaction);
            state.setTxRecord(txRecord);
            state.setLogger(oa2SE.getMyLogger());
            state.setStrictACLs(oa2SE.isQdlStrictACLs());
            return qrt;
        }
        oa2SE.getMyLogger().warn("*********************************");
        oa2SE.getMyLogger().warn("* QDL scripting detected, but   * ");
        oa2SE.getMyLogger().warn("* QDL scripts cannot be run.    *");
        oa2SE.getMyLogger().warn("* No/invalid runtime engine has *");
        oa2SE.getMyLogger().warn("* been configured.              *");
        oa2SE.getMyLogger().warn("*********************************");
        return null;
    }

    public static ScriptRuntimeEngine createRTE(OA2SE oa2SE, OA2ServiceTransaction transaction, JSONObject config) {
        return ScriptRuntimeEngineFactory.createRTE(oa2SE, transaction, null, config);
    }

    public static class NoOpRuntimeEngine
    extends ScriptRuntimeEngine {
        public static final ScriptRunResponse srr = new ScriptRunResponse(null, null, 0);

        public String serializeState() {
            return "";
        }

        public String serializeState(String version) {
            return null;
        }

        public void deserializeState(String state, String version) {
        }

        public ScriptRunResponse run(ScriptRunRequest request) {
            return srr;
        }
    }
}

