/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage;

import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import java.util.Date;
import java.util.Map;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.oauth2.storage.SafeGCRetentionPolicy;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class RefreshTokenRetentionPolicy
extends SafeGCRetentionPolicy {
    RefreshTokenStore rts;
    TXStore txStore;
    boolean rttracing = false;

    public RefreshTokenRetentionPolicy(RefreshTokenStore rts, TXStore txStore, String serviceAddress, boolean safeGC) {
        super(serviceAddress, safeGC);
        this.rts = rts;
        this.txStore = txStore;
    }

    public boolean applies() {
        return true;
    }

    protected void trace(String x) {
        if (this.rttracing) {
            DebugUtil.trace((Object)this, (String)x);
        }
    }

    public boolean retain(Object key, Object value) {
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)((Object)value);
        String id = "id=" + (st2.getClient() != null ? st2.getClient().getIdentifierString() : "(no id)") + ", trans = " + (st2.hasAuthorizationGrant() ? st2.getAuthorizationGrant().getToken() : "no auth grant");
        this.trace("starting check: " + id);
        if (this.safeGCSkipIt(key.toString())) {
            this.trace("safe GC skipping...");
            return true;
        }
        String token = null;
        this.trace("expired?" + st2.getAuthorizationGrant().isExpired() + ", at null?" + (st2.getAccessToken() == null));
        if (st2.getAuthorizationGrant().isExpired() && st2.getAccessToken() == null) {
            this.trace("abandoned transaction: " + id);
            return false;
        }
        long timeout = -1L;
        if (st2.hasRefreshToken()) {
            RefreshTokenImpl rt = (RefreshTokenImpl)st2.getRefreshToken();
            this.trace("Checking refresh token: " + id);
            if (rt.isOldVersion()) {
                if (st2.getRefreshTokenLifetime() <= 0L) {
                    OA2Client oa2Client = (OA2Client)st2.getClient();
                    if (0L < oa2Client.getRtLifetime()) {
                        timeout = oa2Client.getRtLifetime();
                    }
                } else {
                    timeout = st2.getRefreshTokenLifetime();
                }
            } else {
                timeout = 0L < st2.getRefreshTokenExpiresAt() ? st2.getRefreshTokenExpiresAt() - System.currentTimeMillis() : st2.getRefreshTokenLifetime();
            }
            token = rt.getJti().toString();
        } else {
            this.trace("  Checking AT or Authz");
            if (st2.hasAccessToken()) {
                this.trace("  Checking access token");
                token = st2.getAccessToken().getJti().toString();
                timeout = st2.getAccessTokenLifetime();
            } else {
                this.trace("  Checking authz grant");
                token = st2.getIdentifierString();
                timeout = st2.getAuthzGrantLifetime();
            }
        }
        this.trace(" timeout: " + timeout);
        try {
            if (timeout <= 0L) {
                this.trace("  check timeout for token " + token + " with default timeout");
                DateUtils.checkTimestamp((String)token);
            } else {
                this.trace("check timeout for token " + token + " with issue date " + String.valueOf(DateUtils.getDate((String)token)));
                DateUtils.checkTimestamp((String)token, (long)timeout);
            }
            this.trace(" retaining token " + token);
            return true;
        }
        catch (InvalidTimestampException its) {
            this.trace("timestamp expired");
            int parentCount = this.txStore.getCountByParent(st2.getIdentifier());
            this.trace("              parent count=" + parentCount);
            if (0 < parentCount) {
                this.trace("tx store parent count: 0<" + parentCount + ", returning true (retain it) ");
                return true;
            }
            if (st2.getClient() != null && st2.getClient().isDebugOn()) {
                MetaDebugUtil debugUtil = OA4MPServlet.createDebugger((BaseClient)st2.getOA2Client());
                String msg = String.valueOf(new Date(System.currentTimeMillis())) + ": ***Removing token " + token + " with time out " + timeout + " for client " + st2.getClient().getIdentifierString();
                debugUtil.trace((Object)this, msg);
            }
            this.trace("tx store parent count: 0, returning false (do NOT retain it) ");
            return false;
        }
    }

    public Map getMap() {
        return this.rts;
    }
}

