/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import java.net.URI;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.Token;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;

public class TokenInfoRecord {
    Identifier clientID;
    Identifier transactionID;
    AccessTokenImpl accessToken;
    long atLifetime = 0L;
    boolean atValid = false;
    RefreshTokenImpl refreshToken;
    boolean rtValid = false;
    long rtLifetime = 0L;

    public void fromMap(ColumnMap map, OA2TransactionKeys keys) {
        this.clientID = map.getIdentifier(keys.clientKey(new String[0]));
        this.transactionID = map.getIdentifier(keys.identifier(new String[0]));
        this.accessToken = map.containsKey((Object)keys.atJWT(new String[0])) && null != map.get((Object)keys.atJWT(new String[0])) ? new AccessTokenImpl(map.getString(keys.atJWT(new String[0])), map.getURI(keys.accessToken(new String[0]))) : new AccessTokenImpl(map.getURI(keys.accessToken(new String[0])));
        this.atValid = map.getBoolean(keys.accessTokenValid(new String[0]));
        this.atLifetime = map.getLong(keys.expiresIn(new String[0]));
        this.rtLifetime = map.getLong(keys.refreshTokenLifetime(new String[0]));
        this.rtValid = map.getBoolean(keys.refreshTokenValid(new String[0]));
        this.refreshToken = map.containsKey((Object)keys.rtJWT(new String[0])) && null != map.get((Object)keys.rtJWT(new String[0])) ? new RefreshTokenImpl(map.getString(keys.rtJWT(new String[0])), map.getURI(keys.refreshToken(new String[0]))) : new RefreshTokenImpl(map.getURI(keys.refreshToken(new String[0])));
    }

    public void fromTransaction(OA2ServiceTransaction t) {
        if (t == null) {
            return;
        }
        if (t.getClient() != null) {
            this.clientID = t.getOA2Client().getIdentifier();
        }
        this.transactionID = t.getIdentifier();
        if (t.getAccessToken() != null) {
            this.accessToken = (AccessTokenImpl)t.getAccessToken();
            this.atLifetime = t.getAccessTokenLifetime();
            this.atValid = t.isAccessTokenValid();
        }
        if (t.getRefreshToken() != null) {
            this.refreshToken = (RefreshTokenImpl)t.getRefreshToken();
            this.rtLifetime = t.getRefreshTokenLifetime();
            this.rtValid = t.isRefreshTokenValid();
        }
    }

    public JSONObject toJSON() {
        JSONObject tokens = new JSONObject();
        if (this.accessToken != null && this.accessToken.getJti() != null) {
            tokens.put((Object)"access_token", (Object)this.formatToken((TokenImpl)this.accessToken, this.atLifetime, this.atValid));
        }
        if (this.refreshToken != null && this.refreshToken.getJti() != null) {
            tokens.put((Object)"refresh_token", (Object)this.formatToken((TokenImpl)this.refreshToken, this.rtLifetime, this.rtValid));
        }
        return tokens;
    }

    protected JSONObject formatToken(TokenImpl token, long lifetime, boolean isValid) {
        JSONObject json = new JSONObject();
        json.put((Object)"jti", (Object)token.getJti().toString());
        if (token.isJWT()) {
            json.put((Object)"token", (Object)token.getToken());
        } else {
            json.put((Object)"token", (Object)TokenUtils.b32EncodeToken((Token)token));
        }
        json.put((Object)"lifetime", (Object)lifetime);
        json.put((Object)"issued_at", (Object)token.getIssuedAt());
        json.put((Object)"is_valid", (Object)isValid);
        return json;
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public void fromTXRecord(Identifier clientID, TXRecord txr) {
        if (txr == null) {
            return;
        }
        this.clientID = clientID;
        if (txr.getTokenType().equals("urn:ietf:params:oauth:token-type:access_token")) {
            this.accessToken = txr.getStoredToken() == null ? new AccessTokenImpl(URI.create(txr.getIdentifierString())) : new AccessTokenImpl(txr.getStoredToken(), URI.create(txr.getIdentifierString()));
            this.atLifetime = this.accessToken.getLifetime();
            this.atValid = txr.isValid();
        }
        if (txr.getTokenType().equals("urn:ietf:params:oauth:token-type:refresh_token")) {
            this.refreshToken = txr.getStoredToken() == null ? new RefreshTokenImpl(URI.create(txr.getIdentifierString())) : new RefreshTokenImpl(txr.getStoredToken(), URI.create(txr.getIdentifierString()));
            this.rtLifetime = this.refreshToken.getLifetime();
            this.rtValid = txr.isValid();
        }
        this.transactionID = txr.getParentID();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenInfoRecord)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        TokenInfoRecord tir = (TokenInfoRecord)obj;
        if (this.hasAccessToken()) {
            return this.accessToken.equals((Object)tir.accessToken);
        }
        if (this.hasRefreshToken()) {
            return this.refreshToken.equals((Object)tir.refreshToken);
        }
        return false;
    }
}

