/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecord;

public class TokenInfoRecordMap {
    Map<Identifier, List<TokenInfoRecord>> tMap = new HashMap<Identifier, List<TokenInfoRecord>>();
    Map<Identifier, List<TokenInfoRecord>> cMap = new HashMap<Identifier, List<TokenInfoRecord>>();

    public void put(TokenInfoRecord tir) {
        if (this.contains(tir)) {
            return;
        }
        this.put(this.tMap, tir, tir.transactionID);
        this.put(this.cMap, tir, tir.clientID);
    }

    protected void put(Map<Identifier, List<TokenInfoRecord>> map, TokenInfoRecord tir, Identifier identifier) {
        List<Object> list;
        if (!map.containsKey(identifier)) {
            list = new ArrayList();
            map.put(identifier, list);
        } else {
            list = map.get(identifier);
        }
        list.add(tir);
    }

    public List<TokenInfoRecord> getByTID(Identifier transactionID) {
        return this.tMap.get(transactionID);
    }

    public List<TokenInfoRecord> getByClientID(Identifier clientID) {
        return this.cMap.get(clientID);
    }

    public boolean contains(TokenInfoRecord tir) {
        if (!this.tMap.containsKey(tir.transactionID)) {
            return false;
        }
        List<TokenInfoRecord> list = this.tMap.get(tir.transactionID);
        for (TokenInfoRecord tokenInfoRecord : list) {
            if (tir.hasAccessToken() && tir.accessToken.equals((Object)tokenInfoRecord.accessToken)) {
                return true;
            }
            if (!tir.hasRefreshToken() || !tir.refreshToken.equals((Object)tokenInfoRecord.refreshToken)) continue;
            return true;
        }
        return false;
    }

    public boolean containsClient(Identifier clientID) {
        return this.cMap.containsKey(clientID);
    }

    public Set<Identifier> getClientIDs() {
        return this.cMap.keySet();
    }

    public Set<Identifier> getTransactionIDs() {
        return this.tMap.keySet();
    }

    public Identifier getClientID(Identifier tID) {
        List<TokenInfoRecord> tirs = this.tMap.get(tID);
        if (tirs == null || tirs.isEmpty()) {
            return null;
        }
        return tirs.get((int)0).clientID;
    }

    public void remove(Identifier clientID) {
        List<TokenInfoRecord> list = this.cMap.get(clientID);
        this.cMap.remove(clientID);
        for (TokenInfoRecord tir : list) {
            this.tMap.remove(tir.transactionID);
        }
    }

    public void reduceTo(Set<Identifier> clientIDs) {
        if (clientIDs == null || clientIDs.isEmpty()) {
            return;
        }
        for (Identifier id : clientIDs) {
            this.remove(id);
        }
    }

    public Map<Identifier, List<TokenInfoRecord>> sortByClientID(Identifier clientID) {
        List<TokenInfoRecord> r = this.cMap.get(clientID);
        HashMap<Identifier, List<TokenInfoRecord>> map = new HashMap<Identifier, List<TokenInfoRecord>>();
        for (TokenInfoRecord tir : r) {
            List<TokenInfoRecord> list;
            if (map.containsKey(tir.transactionID)) {
                list = (List)map.get(tir.transactionID);
            } else {
                list = new ArrayList();
                map.put(tir.transactionID, list);
            }
            list.add(tir);
        }
        return map;
    }
}

