/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.clients;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.json.MyJPathUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.server.OA2ClientScopes;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.claims.IDTokenClientConfig;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.tokens.AccessTokenConfig;
import org.oa4mp.server.loader.oauth2.tokens.RefreshTokenConfig;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;

public class OA2Client
extends Client
implements OA2ClientScopes {
    public static final long USE_SERVER_DEFAULT = -1L;
    public static final long DISABLE_REFRESH_TOKENS = 0L;
    long maxATLifetime = -1L;
    long maxRTLifetime = -1L;
    String comment;
    List<Identifier> prototypes = null;
    boolean ersatzClient = false;
    boolean extendsProvisioners = false;
    boolean skipServerScripts = false;
    protected boolean publicClient = false;
    boolean signTokens = true;
    String issuer = null;
    Collection<String> callbackURIs = new LinkedList<String>();
    long rtLifetime = -1L;
    long atLifetime = -1L;
    long idTokenLifetime = -1L;
    long maxIDTLifetime = -1L;
    Collection<String> audience;
    List<URI> resource;
    Collection<LDAPConfiguration> ldaps;
    String extendedAttributesEnabledKey = "extendedAttributesEnabled";
    protected String xoauth_attributes = "xoauth_attributes";
    protected String oa4mp_attributes = "oa4mp_attributes";
    protected String oidc_cm_attributes = "oidc-cm_attributes";
    protected String TOKENS_KEY = "/tokens";
    protected String ACCESS_TOKENS_KEY = "access";
    protected String REFRESH_TOKENS_KEY = "refresh";
    protected String ID_TOKENS_KEY = "identity";
    boolean strictScopes = true;
    public static String CLIENT_COMMENT_TAG = "comment";
    protected String config;
    protected JSONObject jsonConfig;
    protected JSONObject extended_attributes;
    long dfLifetime = -1L;
    long dfInterval = -1L;
    Collection<String> proxyClaimsList = new ArrayList<String>();
    Collection<String> proxyRequestScopes = new ArrayList<String>();
    boolean forwardScopesToProxy = false;
    long rtGracePeriod = OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT;
    boolean ersatzInheritIDToken = true;
    boolean allowPromptNone = false;

    public OA2Client clone() {
        OA2Client client = new OA2Client(this.getIdentifier());
        this.populateClone((BaseClient)client);
        return client;
    }

    public long getMaxATLifetime() {
        return this.maxATLifetime;
    }

    public void setMaxATLifetime(long maxATLifetime) {
        this.maxATLifetime = maxATLifetime;
    }

    public long getMaxRTLifetime() {
        return this.maxRTLifetime;
    }

    public void setMaxRTLifetime(long maxRTLifetime) {
        this.maxRTLifetime = maxRTLifetime;
    }

    protected void populateClone(BaseClient c) {
        OA2Client client = (OA2Client)c;
        super.populateClone((BaseClient)client);
        client.setAtLifetime(this.getAtLifetime());
        client.setAudience(this.getAudience());
        client.setCallbackURIs(this.getCallbackURIs());
        client.setConfig(this.getConfig());
        client.setDfInterval(this.getDfInterval());
        client.setDfLifetime(this.getDfLifetime());
        client.setExtendedAttributes(this.getExtendedAttributes());
        client.setErsatzClient(this.isErsatzClient());
        client.setErsatzInheritIDToken(this.isErsatzInheritIDToken());
        client.setExtendsProvisioners(this.isExtendsProvisioners());
        client.setForwardScopesToProxy(this.isForwardScopesToProxy());
        client.setIdTokenLifetime(this.getIdTokenLifetime());
        client.setIssuer(this.getIssuer());
        client.setLdaps(this.getLdaps());
        client.setMaxATLifetime(this.getMaxATLifetime());
        client.setMaxIDTLifetime(this.getMaxIDTLifetime());
        client.setMaxRTLifetime(this.getMaxRTLifetime());
        client.setPrototypes(this.getPrototypes());
        client.setProxyClaimsList(this.getProxyClaimsList());
        client.setProxyRequestScopes(this.getProxyRequestScopes());
        client.setPublicClient(this.isPublicClient());
        client.setRawConfig(this.getRawConfig());
        client.setResource(this.getResource());
        client.setRtGracePeriod(this.getRtGracePeriod());
        client.setRtLifetime(this.getRtLifetime());
        client.setScopes(this.getScopes());
        client.setSignTokens(this.isSignTokens());
        client.setSkipServerScripts(this.isSkipServerScripts());
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Identifier> getPrototypes() {
        if (this.prototypes == null) {
            this.prototypes = new ArrayList<Identifier>();
        }
        return this.prototypes;
    }

    public void setPrototypes(List<Identifier> prototypes) {
        this.prototypes = prototypes;
    }

    public boolean hasPrototypes() {
        return this.prototypes != null && !this.prototypes.isEmpty();
    }

    public boolean isErsatzClient() {
        return this.ersatzClient;
    }

    public void setErsatzClient(boolean ersatzClient) {
        this.ersatzClient = ersatzClient;
    }

    public boolean isExtendsProvisioners() {
        return this.extendsProvisioners;
    }

    public void setExtendsProvisioners(boolean extendsProvisioners) {
        this.extendsProvisioners = extendsProvisioners;
    }

    public boolean isSkipServerScripts() {
        return this.skipServerScripts;
    }

    public void setSkipServerScripts(boolean skipServerScripts) {
        this.skipServerScripts = skipServerScripts;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public boolean isOIDCClient() {
        return this.getScopes().contains("openid");
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public boolean isSignTokens() {
        return this.signTokens;
    }

    public void setSignTokens(boolean signTokens) {
        this.signTokens = signTokens;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OA2Client(Identifier identifier) {
        super(identifier);
    }

    public Collection<String> getCallbackURIs() {
        return this.callbackURIs;
    }

    public void setCallbackURIs(Collection<String> callbackURIs) {
        this.callbackURIs = callbackURIs;
    }

    public long getRtLifetime() {
        return this.rtLifetime;
    }

    public void setRtLifetime(long rtLifetime) {
        this.rtLifetime = rtLifetime;
    }

    public long getAtLifetime() {
        return this.atLifetime;
    }

    public void setAtLifetime(long atLifetime) {
        this.atLifetime = atLifetime;
    }

    public long getIdTokenLifetime() {
        return this.idTokenLifetime;
    }

    public void setIdTokenLifetime(long idTokenLifetime) {
        this.idTokenLifetime = idTokenLifetime;
    }

    public long getMaxIDTLifetime() {
        return this.maxIDTLifetime;
    }

    public void setMaxIDTLifetime(long maxIDTLifetime) {
        this.maxIDTLifetime = maxIDTLifetime;
    }

    public boolean isRTLifetimeEnabled() {
        return 0L != this.rtLifetime;
    }

    public boolean useServerDefaultRTLifetime() {
        return this.rtLifetime == -1L;
    }

    public Collection<String> getAudience() {
        return this.audience;
    }

    public void setAudience(Collection<String> audience) {
        this.audience = audience;
    }

    public List<URI> getResource() {
        return this.resource;
    }

    public void setResource(List<URI> resource) {
        this.resource = resource;
    }

    public Collection<LDAPConfiguration> getLdaps() {
        return this.ldaps;
    }

    public void setLdaps(Collection<LDAPConfiguration> ldaps) {
        this.ldaps = ldaps;
    }

    protected boolean hasPayloadConfig(String root, String path) {
        return MyJPathUtil.containsKey((JSON)this.getConfig(), (String)root, (String)path);
    }

    protected AbstractPayloadConfig setupPayloadConfig(AbstractPayloadConfig pc, String root, String path) {
        if (this.hasDriverConfig()) {
            OA2ClientUtils.setupDriverPayloadConfig(pc, this);
        }
        if (this.hasPayloadConfig(root, path)) {
            pc.fromJSON(MyJPathUtil.getJSONObject((JSON)this.getConfig(), (String)root, (String)path));
        }
        return pc;
    }

    protected void setPayloadConfig(AbstractPayloadConfig apc, String root, String path) {
        MyJPathUtil.set((JSON)apc.toJSON(), (String)root, (Object)path);
    }

    public boolean hasAccessTokenConfig() {
        return this.hasPayloadConfig(this.TOKENS_KEY, this.ACCESS_TOKENS_KEY) || this.hasDriverConfig();
    }

    public AccessTokenConfig getAccessTokensConfig() {
        AccessTokenConfig atConfig = new AccessTokenConfig();
        return (AccessTokenConfig)this.setupPayloadConfig(atConfig, this.TOKENS_KEY, this.ACCESS_TOKENS_KEY);
    }

    private Object setupDriverPayloadConfig(AccessTokenConfig atConfig, JSONObject config) {
        return null;
    }

    public boolean hasDriverConfig() {
        return this.getConfig().containsKey((Object)QDLRuntimeEngine.CONFIG_TAG);
    }

    public void setAccessTokenConfig(AccessTokenConfig cfg) {
        this.setPayloadConfig(cfg, this.TOKENS_KEY, this.ACCESS_TOKENS_KEY);
    }

    public void setRefreshTokensConfig(RefreshTokenConfig refreshTokenConfig) {
        this.setPayloadConfig(refreshTokenConfig, this.TOKENS_KEY, this.REFRESH_TOKENS_KEY);
    }

    public boolean hasRefreshTokenConfig() {
        return this.hasPayloadConfig(this.TOKENS_KEY, this.REFRESH_TOKENS_KEY) || this.hasDriverConfig();
    }

    public RefreshTokenConfig getRefreshTokensConfig() {
        RefreshTokenConfig refreshTokenClientConfig = new RefreshTokenConfig();
        return (RefreshTokenConfig)this.setupPayloadConfig(refreshTokenClientConfig, this.TOKENS_KEY, this.REFRESH_TOKENS_KEY);
    }

    public boolean hasIDTokenConfig() {
        return this.hasPayloadConfig(this.TOKENS_KEY, this.ID_TOKENS_KEY) || this.hasDriverConfig();
    }

    public IDTokenClientConfig getIDTokenConfig() {
        IDTokenClientConfig c = new IDTokenClientConfig();
        return (IDTokenClientConfig)this.setupPayloadConfig(c, this.TOKENS_KEY, this.ID_TOKENS_KEY);
    }

    public void setIDTokenConfig(IDTokenClientConfig idTokenClientConfig) {
        this.setPayloadConfig(idTokenClientConfig, this.TOKENS_KEY, this.ID_TOKENS_KEY);
    }

    protected JSONObject getNamedAttributes(String name) {
        if (this.getExtendedAttributes().containsKey((Object)name)) {
            return this.getExtendedAttributes().getJSONObject(name);
        }
        JSONObject jsonObject = new JSONObject();
        this.getExtendedAttributes().put((Object)name, (Object)jsonObject);
        return this.getExtendedAttributes().getJSONObject(name);
    }

    protected void setNamedAttributes(String name, JSONObject jsonObject) {
        this.getExtendedAttributes().put((Object)name, (Object)jsonObject);
    }

    public boolean hasOIDC_CM_Attributes() {
        return this.getNamedAttributes(this.oidc_cm_attributes) != null && !this.getNamedAttributes(this.oidc_cm_attributes).isEmpty();
    }

    public JSONObject getOIDC_CM_Attributes() {
        return this.getNamedAttributes(this.oidc_cm_attributes);
    }

    public void setOIDC_CM_attributes(JSONObject attr) {
        this.setNamedAttributes(this.oidc_cm_attributes, attr);
    }

    public void removeOIDC_CM_Attributes() {
        this.getExtendedAttributes().remove(this.oidc_cm_attributes);
    }

    protected JSONObject getOA4MPAttributes() {
        return this.getNamedAttributes(this.oa4mp_attributes);
    }

    protected JSONObject getXOAuthExtendedAttributes() {
        return this.getNamedAttributes(this.xoauth_attributes);
    }

    public boolean hasExtendedAttributeSupport() {
        Boolean b = (Boolean)this.getNamedProperty(this.oa4mp_attributes, this.extendedAttributesEnabledKey);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void setExtendedAttributeSupport(boolean b) {
        this.setNamedProperty(this.oa4mp_attributes, this.extendedAttributesEnabledKey, b);
    }

    public boolean useStrictScopes() {
        return this.strictScopes;
    }

    public void setStrictscopes(boolean newValue) {
        this.strictScopes = newValue;
    }

    protected Object getNamedProperty(String component, String key) {
        if (this.getNamedAttributes(component).containsKey((Object)key)) {
            return this.getNamedAttributes(component).get(key);
        }
        return null;
    }

    protected void setNamedProperty(String component, String key, Object property) {
        this.getNamedAttributes(component).put((Object)key, property);
    }

    protected List<String> getNamedList(String component, String key) {
        if (this.getNamedAttributes(component).containsKey((Object)key)) {
            return this.getNamedAttributes(component).getJSONArray(key);
        }
        return new JSONArray();
    }

    protected void setNamedList(String component, String key, List<String> list) {
        JSONArray ja = null;
        if (list instanceof JSONArray) {
            ja = (JSONArray)list;
        } else {
            ja = new JSONArray();
            ja.addAll(list);
        }
        this.getNamedAttributes(component).put((Object)key, (Object)ja);
    }

    public List<String> getGrantTypes() {
        return this.getNamedList(this.xoauth_attributes, "grant_type");
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.setNamedList(this.xoauth_attributes, "grant_type", grantTypes);
    }

    public void setComment(List<String> comments) {
        this.setNamedList(this.oa4mp_attributes, CLIENT_COMMENT_TAG, comments);
    }

    public List<String> getComment() {
        return this.getNamedList(this.oa4mp_attributes, CLIENT_COMMENT_TAG);
    }

    public List<String> getResponseTypes() {
        return this.getNamedList(this.xoauth_attributes, "response_type");
    }

    public void setResponseTypes(List<String> responseTypes) {
        this.setNamedList(this.xoauth_attributes, "response_type", responseTypes);
    }

    public JSONObject getConfig() {
        if (this.jsonConfig == null && !StringUtils.isTrivial((String)this.config)) {
            throw new IllegalStateException("JSON configuration was not initialized.");
        }
        return this.jsonConfig;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public void setConfig(JSONObject config) {
        this.jsonConfig = config;
    }

    public void setRawConfig(String rawConfig) {
        this.config = rawConfig;
    }

    public String getRawConfig() {
        return this.config;
    }

    public JSONObject getExtendedAttributes() {
        if (this.extended_attributes == null) {
            this.extended_attributes = new JSONObject();
        }
        return this.extended_attributes;
    }

    public void setExtendedAttributes(JSONObject eas) {
        this.extended_attributes = eas;
    }

    public boolean hasExtendedAttributes() {
        return this.extended_attributes != null;
    }

    public String toString() {
        Object x = super.toString();
        x = ((String)x).substring(0, ((String)x).lastIndexOf("]"));
        x = (String)x + "scopes=" + (this.getScopes() == null ? "[]" : this.getScopes().toString());
        x = (String)x + ",callbacks=" + (this.getCallbackURIs() == null ? "[]" : this.getCallbackURIs().toString());
        x = (String)x + ",issuer=" + this.getIssuer();
        x = (String)x + ",is public?=" + this.isPublicClient();
        x = (String)x + ",rt lifetime=" + this.getRtLifetime();
        x = (String)x + ",rt lifetime enabled?=" + this.isRTLifetimeEnabled();
        x = (String)x + ",sign ID tokens?=" + this.isSignTokens();
        return (String)x + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OA2Client)) {
            return false;
        }
        OA2Client c = (OA2Client)((Object)obj);
        if (this.getRtLifetime() != c.getRtLifetime()) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getIssuer(), (Object)c.getIssuer())) {
            return false;
        }
        if (this.getScopes().size() != c.getScopes().size()) {
            return false;
        }
        for (String x : this.getScopes()) {
            if (c.getScopes().contains(x)) continue;
            return false;
        }
        if (this.getCallbackURIs().size() != c.getCallbackURIs().size()) {
            return false;
        }
        for (String x : this.getCallbackURIs()) {
            if (c.getCallbackURIs().contains(x)) continue;
            return false;
        }
        if (this.isSignTokens() != c.isSignTokens()) {
            return false;
        }
        if (this.isPublicClient() != c.isPublicClient()) {
            return false;
        }
        return super.equals(obj);
    }

    public static void main(String[] args) {
        OA2Client client = new OA2Client(BasicIdentifier.randomID());
        client.setExtendedAttributeSupport(true);
        ArrayList<String> gt = new ArrayList<String>();
        gt.add("gt_foo");
        gt.add("gt_bar");
        client.setGrantTypes(gt);
        ArrayList<String> rst = new ArrayList<String>();
        rst.add("rst_1");
        rst.add("rst_2");
        client.setResponseTypes(rst);
        System.out.println(client.getExtendedAttributes().toString(2));
    }

    public boolean hasScript() {
        boolean rc = false;
        rc = rc || this.hasIDTokenConfig() && !this.getIDTokenConfig().getScriptSet().isEmpty();
        rc = rc || this.hasAccessTokenConfig() && !this.getAccessTokensConfig().getScriptSet().isEmpty();
        rc = rc || this.hasRefreshTokenConfig() && !this.getRefreshTokensConfig().getScriptSet().isEmpty();
        return rc;
    }

    public long getDfLifetime() {
        return this.dfLifetime;
    }

    public void setDfLifetime(long dfLifetime) {
        this.dfLifetime = dfLifetime;
    }

    public long getDfInterval() {
        return this.dfInterval;
    }

    public void setDfInterval(long dfInterval) {
        this.dfInterval = dfInterval;
    }

    public Collection<String> getProxyClaimsList() {
        return this.proxyClaimsList;
    }

    public void setProxyClaimsList(Collection<String> proxyClaimsList) {
        this.proxyClaimsList = proxyClaimsList;
    }

    public Collection<String> getProxyRequestScopes() {
        if (this.proxyRequestScopes == null) {
            this.proxyRequestScopes = new ArrayList<String>();
            this.proxyRequestScopes.add("*");
        }
        return this.proxyRequestScopes;
    }

    public void setProxyRequestScopes(Collection<String> proxyRequestScopes) {
        this.proxyRequestScopes = proxyRequestScopes;
    }

    public boolean hasRequestScopes() {
        return this.proxyRequestScopes != null && !this.proxyRequestScopes.isEmpty();
    }

    public boolean isForwardScopesToProxy() {
        return this.forwardScopesToProxy;
    }

    public void setForwardScopesToProxy(boolean forwardScopesToProxy) {
        this.forwardScopesToProxy = forwardScopesToProxy;
    }

    public long getRtGracePeriod() {
        return this.rtGracePeriod;
    }

    public void setRtGracePeriod(long rtGracePeriod) {
        this.rtGracePeriod = rtGracePeriod;
    }

    public boolean isErsatzInheritIDToken() {
        return this.ersatzInheritIDToken;
    }

    public void setErsatzInheritIDToken(boolean ersatzInheritIDToken) {
        this.ersatzInheritIDToken = ersatzInheritIDToken;
    }

    public boolean isAllowPromptNone() {
        return this.allowPromptNone;
    }

    public void setAllowPromptNone(boolean allowPromptNone) {
        this.allowPromptNone = allowPromptNone;
    }
}

