/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.clients;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.oa4mp.delegation.common.storage.clients.ClientConverter;
import org.oa4mp.delegation.common.storage.clients.ClientKeys;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;

public class OA2ClientConverter<V extends OA2Client>
extends ClientConverter<V> {
    LDAPConfigurationUtil ldapConfigurationUtil;

    public OA2ClientConverter(IdentifiableProvider<V> identifiableProvider) {
        this(new OA2ClientKeys(), identifiableProvider);
    }

    public OA2ClientConverter(OA2ClientKeys keys, IdentifiableProvider<V> identifiableProvider) {
        super((ClientKeys)keys, identifiableProvider);
    }

    public OA2ClientKeys getCK2() {
        return (OA2ClientKeys)this.keys;
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        String tempcfg;
        String rawCfg;
        String rawCfg2;
        JSON temp;
        OA2Client otherV = (OA2Client)super.fromMap(map, v);
        if (map.get((Object)this.getCK2().callbackUri(new String[0])) != null) {
            otherV.setCallbackURIs(this.jsonArrayToCollection(map, this.getCK2().callbackUri(new String[0])));
        }
        if (map.get((Object)this.getCK2().allowPromptNone(new String[0])) != null) {
            otherV.setAllowPromptNone(map.getBoolean((Object)this.getCK2().allowPromptNone(new String[0])));
        }
        if (map.get((Object)this.getCK2().strictScopes(new String[0])) != null) {
            otherV.setStrictscopes(map.getBoolean((Object)this.getCK2().strictScopes(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().forwardScopesToProxy(new String[0]))) {
            otherV.setForwardScopesToProxy(map.getBoolean((Object)this.getCK2().forwardScopesToProxy(new String[0])));
        }
        if (map.get((Object)this.getCK2().scopes(new String[0])) != null) {
            otherV.setScopes(this.jsonArrayToCollection(map, this.getCK2().scopes(new String[0])));
        }
        if (map.get((Object)this.getCK2().proxyClaimsList(new String[0])) != null) {
            otherV.setProxyClaimsList(this.jsonArrayToCollection(map, this.getCK2().proxyClaimsList(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().ersatzInheritIDToken(new String[0]))) {
            otherV.setErsatzInheritIDToken(map.getBoolean((Object)this.getCK2().ersatzInheritIDToken(new String[0])));
        }
        if (map.get((Object)this.getCK2().proxyRequestScopes(new String[0])) == null) {
            JSONArray array = new JSONArray();
            array.add((Object)"*");
            otherV.setProxyRequestScopes((Collection<String>)array);
        } else {
            otherV.setProxyRequestScopes(this.jsonArrayToCollection(map, this.getCK2().proxyRequestScopes(new String[0])));
        }
        if (map.get((Object)this.getCK2().audience(new String[0])) != null) {
            otherV.setAudience(this.jsonArrayToCollection(map, this.getCK2().audience(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().extendsProvisioners(new String[0]))) {
            otherV.setExtendsProvisioners(map.getBoolean((Object)this.getCK2().extendsProvisioners(new String[0])));
        }
        if (map.get((Object)this.getCK2().prototypes(new String[0])) != null) {
            JSONArray array;
            String raw = map.getString((Object)this.getCK2().prototypes(new String[0]));
            try {
                array = JSONArray.fromObject((Object)raw);
            }
            catch (Throwable t) {
                array = new JSONArray();
                array.add((Object)raw);
            }
            ArrayList ids = new ArrayList();
            for (Object obj : array) {
                if (obj instanceof Identifier) {
                    ids.add((Identifier)obj);
                    continue;
                }
                if (obj instanceof String) {
                    ids.add(BasicIdentifier.newID((String)((String)obj)));
                    continue;
                }
                throw new IllegalArgumentException("Expected string or identifier, got \"" + String.valueOf(obj) + "\" of type " + obj.getClass().getSimpleName());
            }
            otherV.setPrototypes(ids);
        }
        if (map.get((Object)this.getCK2().resource(new String[0])) != null) {
            Collection collection = this.jsonArrayToCollection(map, this.getCK2().resource(new String[0]));
            JSONArray jsonArray = new JSONArray();
            for (String x : collection) {
                jsonArray.add((Object)URI.create(x));
            }
            otherV.setAudience((Collection<String>)jsonArray);
        }
        if (map.get((Object)this.getCK2().publicClient(new String[0])) != null) {
            otherV.setPublicClient(map.getBoolean((Object)this.getCK2().publicClient(new String[0])));
        }
        if (map.get((Object)this.getCK2().ersatzClient(new String[0])) != null) {
            otherV.setErsatzClient(map.getBoolean((Object)this.getCK2().ersatzClient(new String[0])));
        }
        otherV.setRtLifetime(map.getLong((Object)this.getCK2().rtLifetime(new String[0])));
        otherV.setIdTokenLifetime(map.getLong((Object)this.getCK2().idtLifetime(new String[0])));
        otherV.setRtGracePeriod(map.getLong((Object)this.getCK2().rtGracePeriod(new String[0])));
        otherV.setDfLifetime(map.getLong((Object)this.getCK2().dfLifetime(new String[0])));
        otherV.setDfInterval(map.getLong((Object)this.getCK2().dfInterval(new String[0])));
        if (map.containsKey((Object)this.getCK2().maxATLifetime(new String[0])) && map.get((Object)this.getCK2().maxATLifetime(new String[0])) != null) {
            otherV.setMaxATLifetime(map.getLong((Object)this.getCK2().maxATLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().maxRTLifetime(new String[0])) && map.get((Object)this.getCK2().maxRTLifetime(new String[0])) != null) {
            otherV.setMaxRTLifetime(map.getLong((Object)this.getCK2().maxRTLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().maxIDTLifetime(new String[0])) && map.get((Object)this.getCK2().maxIDTLifetime(new String[0])) != null) {
            otherV.setMaxIDTLifetime(map.getLong((Object)this.getCK2().maxIDTLifetime(new String[0])));
        }
        otherV.setSkipServerScripts(map.getBoolean((Object)this.getCK2().skipServerScripts(new String[0])));
        if (map.containsKey((Object)this.getCK2().atLifetime(new String[0])) && map.get((Object)this.getCK2().atLifetime(new String[0])) != null) {
            otherV.setAtLifetime(map.getLong((Object)this.getCK2().atLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().issuer(new String[0]))) {
            otherV.setIssuer((String)map.get((Object)this.getCK2().issuer(new String[0])));
        }
        if (map.containsKey((Object)this.getCK2().signTokens(new String[0])) && map.get((Object)this.getCK2().signTokens(new String[0])) != null) {
            otherV.setSignTokens(map.getBoolean((Object)this.getCK2().signTokens(new String[0])));
        }
        JSONObject ldap = null;
        String zzz = map.getString((Object)this.getCK2().ldap(new String[0]));
        if (map.containsKey((Object)this.getCK2().ldap(new String[0])) && zzz != null && !zzz.isEmpty() && !(temp = JSONSerializer.toJSON((Object)map.get((Object)this.getCK2().ldap(new String[0])))).isEmpty()) {
            if (!temp.isArray()) {
                ldap = (JSONObject)temp;
            } else {
                JSONArray array = (JSONArray)temp;
                if (array.size() != 1) {
                    ServletDebugUtil.trace((Object)((Object)this), (String)("Got " + array.size() + " LDAP configurations. Using first one only..."));
                }
                ldap = (JSONObject)array.get(0);
            }
        }
        if (map.containsKey((Object)this.getCK2().ea(new String[0])) && !StringUtils.isTrivial((String)(rawCfg2 = map.getString((Object)this.getCK2().ea(new String[0]))))) {
            otherV.setExtendedAttributes(JSONObject.fromObject((Object)rawCfg2));
        }
        JSONObject cfg = null;
        if (map.containsKey((Object)this.getCK2().cfg(new String[0])) && (rawCfg = map.getString((Object)this.getCK2().cfg(new String[0]))) != null && !rawCfg.isEmpty() && !StringUtils.isTrivial((String)(tempcfg = map.getString((Object)this.getCK2().cfg(new String[0]))))) {
            StringReader stringReader = new StringReader(tempcfg);
            Config conf = ConfigFactory.parseReader((Reader)stringReader);
            String rawJSON = conf.root().render(ConfigRenderOptions.concise());
            cfg = JSONObject.fromObject((Object)rawJSON);
            otherV.setRawConfig(tempcfg);
        }
        if (ldap == null || ldap.isEmpty()) {
            if (cfg == null) {
                cfg = new JSONObject();
            }
        } else {
            JSONArray ldaps = new JSONArray();
            ldaps.add((Object)ldap);
            otherV.setLdaps(this.getLdapConfigurationUtil().fromJSON(ldaps));
        }
        if (cfg != null) {
            otherV.setConfig(cfg);
        }
        return (V)((Object)otherV);
    }

    public LDAPConfigurationUtil getLdapConfigurationUtil() {
        if (this.ldapConfigurationUtil == null) {
            this.ldapConfigurationUtil = new LDAPConfigurationUtil();
        }
        return this.ldapConfigurationUtil;
    }

    public void toMap(V client, ConversionMap<String, Object> map) {
        JSONArray jsonArray;
        super.toMap(client, map);
        map.put((Object)this.getCK2().allowPromptNone(new String[0]), (Object)((OA2Client)((Object)client)).isAllowPromptNone());
        map.put((Object)this.getCK2().rtLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getRtLifetime());
        map.put((Object)this.getCK2().rtGracePeriod(new String[0]), (Object)((OA2Client)((Object)client)).getRtGracePeriod());
        map.put((Object)this.getCK2().atLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getAtLifetime());
        map.put((Object)this.getCK2().idtLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getIdTokenLifetime());
        map.put((Object)this.getCK2().dfLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getDfLifetime());
        map.put((Object)this.getCK2().dfInterval(new String[0]), (Object)((OA2Client)((Object)client)).getDfInterval());
        map.put((Object)this.getCK2().maxATLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxATLifetime());
        map.put((Object)this.getCK2().maxRTLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxRTLifetime());
        map.put((Object)this.getCK2().maxIDTLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxIDTLifetime());
        map.put((Object)this.getCK2().skipServerScripts(new String[0]), (Object)((OA2Client)((Object)client)).isSkipServerScripts());
        map.put((Object)this.getCK2().forwardScopesToProxy(new String[0]), (Object)((OA2Client)((Object)client)).isForwardScopesToProxy());
        if (((OA2Client)((Object)client)).getCallbackURIs() == null) {
            return;
        }
        map.put((Object)this.getCK2().publicClient(new String[0]), (Object)((OA2Client)((Object)client)).isPublicClient());
        map.put((Object)this.getCK2().ersatzClient(new String[0]), (Object)((OA2Client)((Object)client)).isErsatzClient());
        map.put((Object)this.getCK2().extendsProvisioners(new String[0]), (Object)((OA2Client)((Object)client)).isExtendsProvisioners());
        if (((OA2Client)((Object)client)).hasPrototypes() && !((OA2Client)((Object)client)).getPrototypes().isEmpty()) {
            JSONArray array = new JSONArray();
            for (Identifier id : ((OA2Client)((Object)client)).getPrototypes()) {
                array.add((Object)id.toString());
            }
            map.put((Object)this.getCK2().prototypes(new String[0]), (Object)array.toString());
        }
        JSONArray callbacks = new JSONArray();
        for (String s : ((OA2Client)((Object)client)).getCallbackURIs()) {
            callbacks.add((Object)s);
        }
        map.put((Object)this.getCK2().callbackUri(new String[0]), (Object)callbacks.toString());
        if (((OA2Client)((Object)client)).getIssuer() != null) {
            map.put((Object)this.getCK2().issuer(new String[0]), (Object)((OA2Client)((Object)client)).getIssuer());
        }
        map.put((Object)this.getCK2().signTokens(new String[0]), (Object)((OA2Client)((Object)client)).isSignTokens());
        map.put((Object)this.getCK2().strictScopes(new String[0]), (Object)((OA2Client)((Object)client)).useStrictScopes());
        if (client.getScopes() != null) {
            JSONArray scopes = new JSONArray();
            for (String string : client.getScopes()) {
                scopes.add((Object)string);
            }
            map.put((Object)this.getCK2().scopes(new String[0]), (Object)scopes.toString());
        }
        if (((OA2Client)((Object)client)).getProxyClaimsList() != null) {
            jsonArray = new JSONArray();
            jsonArray.addAll(((OA2Client)((Object)client)).getProxyClaimsList());
            map.put((Object)this.getCK2().proxyClaimsList(new String[0]), (Object)jsonArray.toString());
        }
        if (((OA2Client)((Object)client)).getProxyRequestScopes() != null) {
            jsonArray = new JSONArray();
            jsonArray.addAll(((OA2Client)((Object)client)).getProxyRequestScopes());
            map.put((Object)this.getCK2().proxyRequestScopes(new String[0]), (Object)jsonArray.toString());
        } else {
            jsonArray = new JSONArray();
            jsonArray.add((Object)"*");
            map.put((Object)this.getCK2().proxyRequestScopes(new String[0]), (Object)jsonArray.toString());
        }
        if (((OA2Client)((Object)client)).getAudience() != null) {
            JSONArray aud = new JSONArray();
            for (String string : ((OA2Client)((Object)client)).getAudience()) {
                aud.add((Object)string);
            }
            map.put((Object)this.getCK2().audience(new String[0]), (Object)aud.toString());
        }
        if (((OA2Client)((Object)client)).getResource() != null) {
            JSONArray resources = new JSONArray();
            for (URI uRI : ((OA2Client)((Object)client)).getResource()) {
                resources.add((Object)uRI.toString());
            }
            map.put((Object)this.getCK2().audience(new String[0]), (Object)resources.toString());
        }
        if (((OA2Client)((Object)client)).getLdaps() != null && !((OA2Client)((Object)client)).getLdaps().isEmpty()) {
            map.put((Object)this.getCK2().ldap(new String[0]), (Object)this.getLdapConfigurationUtil().toJSON(((OA2Client)((Object)client)).getLdaps()).toString());
        }
        if (((OA2Client)((Object)client)).getConfig() != null && !((OA2Client)((Object)client)).getConfig().isEmpty()) {
            map.put((Object)this.getCK2().cfg(new String[0]), (Object)((OA2Client)((Object)client)).getConfig().toString());
        }
        if (((OA2Client)((Object)client)).getExtendedAttributes() != null && !((OA2Client)((Object)client)).getExtendedAttributes().isEmpty()) {
            map.put((Object)this.getCK2().ea(new String[0]), (Object)((OA2Client)((Object)client)).getExtendedAttributes().toString());
        }
        map.put((Object)this.getCK2().ersatzInheritIDToken(new String[0]), (Object)((OA2Client)((Object)client)).isErsatzInheritIDToken());
    }

    public V fromJSON(JSONObject json) {
        JSONObject config;
        JSON ldaps;
        JSON resources;
        JSON aud;
        JSON scopes;
        JSON cbs;
        OA2Client v = (OA2Client)super.fromJSON(json);
        v.setRtLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().rtLifetime(new String[0])));
        v.setRtGracePeriod(this.getJsonUtil().getJSONValueLong(json, this.getCK2().rtGracePeriod(new String[0])));
        if (json.containsKey((Object)this.getCK2().allowPromptNone(new String[0]))) {
            v.setAllowPromptNone(json.getBoolean(this.getCK2().allowPromptNone(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().atLifetime(new String[0]))) {
            v.setAtLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().atLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().idtLifetime(new String[0]))) {
            v.setIdTokenLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().idtLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().maxIDTLifetime(new String[0]))) {
            v.setMaxIDTLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().maxIDTLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().dfLifetime(new String[0]))) {
            v.setDfLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().dfLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().ersatzInheritIDToken(new String[0]))) {
            v.setErsatzInheritIDToken(this.getJsonUtil().getJSONValueBoolean(json, this.getCK2().ersatzInheritIDToken(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().dfInterval(new String[0]))) {
            v.setDfInterval(this.getJsonUtil().getJSONValueLong(json, this.getCK2().dfInterval(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().maxATLifetime(new String[0]))) {
            v.setMaxATLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().maxATLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().maxRTLifetime(new String[0]))) {
            v.setMaxRTLifetime(this.getJsonUtil().getJSONValueLong(json, this.getCK2().maxRTLifetime(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().forwardScopesToProxy(new String[0]))) {
            v.setForwardScopesToProxy(this.getJsonUtil().getJSONValueBoolean(json, this.getCK2().forwardScopesToProxy(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().proxyRequestScopes(new String[0]))) {
            v.setProxyRequestScopes((Collection<String>)this.getJsonUtil().getJSONArray(json, this.getCK2().proxyRequestScopes(new String[0])));
        }
        if (json.containsKey((Object)this.getCK2().prototypes(new String[0])) && !json.getJSONArray(this.getCK2().prototypes(new String[0])).isEmpty()) {
            JSONArray array = json.getJSONArray(this.getCK2().prototypes(new String[0]));
            ArrayList<Identifier> ids = new ArrayList<Identifier>();
            for (Object obj : array) {
                if (!(obj instanceof String)) continue;
                ids.add(BasicIdentifier.newID((String)((String)obj)));
            }
            v.setPrototypes(ids);
        }
        if (json.containsKey((Object)this.getCK2().extendsProvisioners(new String[0]))) {
            v.setExtendsProvisioners(json.getBoolean(this.getCK2().extendsProvisioners(new String[0])));
        }
        v.setIssuer(this.getJsonUtil().getJSONValueString(json, this.getCK2().issuer(new String[0])));
        v.setSignTokens(this.getJsonUtil().getJSONValueBoolean(json, this.getCK2().signTokens(new String[0])));
        v.setPublicClient(this.getJsonUtil().getJSONValueBoolean(json, this.getCK2().publicClient(new String[0])));
        if (json.containsKey((Object)this.getCK2().strictScopes(new String[0]))) {
            v.setStrictscopes(this.getJsonUtil().getJSONValueBoolean(json, this.getCK2().strictScopes(new String[0])));
        }
        if ((cbs = (JSON)this.getJsonUtil().getJSONValue(json, this.getCK2().callbackUri(new String[0]))) != null && cbs instanceof JSONArray) {
            JSONArray array = (JSONArray)json.getJSONObject(this.getJSONComponentName()).get(this.getCK2().callbackUri(new String[0]));
            Collection zzz = (Collection)JSONSerializer.toJava((JSON)array);
            v.setCallbackURIs(zzz);
        }
        if ((scopes = (JSON)this.getJsonUtil().getJSONValue(json, this.getCK2().scopes(new String[0]))) != null && scopes instanceof JSONArray) {
            JSONArray array = (JSONArray)json.getJSONObject(this.getJSONComponentName()).get(this.getCK2().scopes(new String[0]));
            Collection zzz = (Collection)JSONSerializer.toJava((JSON)array);
            v.setScopes(zzz);
        }
        if ((aud = (JSON)this.getJsonUtil().getJSONValue(json, this.getCK2().audience(new String[0]))) != null && aud instanceof JSONArray) {
            JSONArray array = (JSONArray)json.getJSONObject(this.getJSONComponentName()).get(this.getCK2().audience(new String[0]));
            Collection zzz = (Collection)JSONSerializer.toJava((JSON)array);
            v.setAudience(zzz);
        }
        if ((resources = (JSON)this.getJsonUtil().getJSONValue(json, this.getCK2().resource(new String[0]))) != null && !resources.isEmpty()) {
            JSONArray array = (JSONArray)json.getJSONObject(this.getJSONComponentName()).get(this.getCK2().resource(new String[0]));
            Collection zzz = (Collection)JSONSerializer.toJava((JSON)array);
            LinkedList<URI> x = new LinkedList<URI>();
            for (String s : zzz) {
                x.add(URI.create(s));
            }
            v.setResource(x);
        }
        if ((ldaps = (JSON)this.getJsonUtil().getJSONValue(json, this.getCK2().ldap(new String[0]))) != null) {
            v.setLdaps(this.getLdapConfigurationUtil().fromJSON(ldaps));
        }
        if ((config = (JSONObject)this.getJsonUtil().getJSONValue(json, this.getCK2().cfg(new String[0]))) != null) {
            v.setConfig(config);
            v.setRawConfig(config.toString());
        }
        v.setExtendedAttributes(json.getJSONObject(this.getCK2().ea(new String[0])));
        return (V)((Object)v);
    }

    public void toJSON(V client, JSONObject json) {
        super.toJSON(client, json);
        this.getJsonUtil().setJSONValue(json, this.getCK2().allowPromptNone(new String[0]), (Object)((OA2Client)((Object)client)).isAllowPromptNone());
        this.getJsonUtil().setJSONValue(json, this.getCK2().rtLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getRtLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().idtLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getIdTokenLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().rtGracePeriod(new String[0]), (Object)((OA2Client)((Object)client)).getRtGracePeriod());
        this.getJsonUtil().setJSONValue(json, this.getCK2().dfLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getDfLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().dfInterval(new String[0]), (Object)((OA2Client)((Object)client)).getDfInterval());
        this.getJsonUtil().setJSONValue(json, this.getCK2().maxATLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxATLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().maxRTLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxRTLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().maxIDTLifetime(new String[0]), (Object)((OA2Client)((Object)client)).getMaxIDTLifetime());
        this.getJsonUtil().setJSONValue(json, this.getCK2().forwardScopesToProxy(new String[0]), (Object)((OA2Client)((Object)client)).isForwardScopesToProxy());
        this.getJsonUtil().setJSONValue(json, this.getCK2().proxyRequestScopes(new String[0]), ((OA2Client)((Object)client)).getProxyRequestScopes());
        this.getJsonUtil().setJSONValue(json, this.getCK2().ersatzInheritIDToken(new String[0]), (Object)((OA2Client)((Object)client)).isErsatzInheritIDToken());
        JSONArray callbacks = new JSONArray();
        Collection<String> callbackList = ((OA2Client)((Object)client)).getCallbackURIs();
        for (String string : callbackList) {
            callbacks.add((Object)string);
        }
        this.getJsonUtil().setJSONValue(json, this.getCK2().extendsProvisioners(new String[0]), (Object)((OA2Client)((Object)client)).isExtendsProvisioners());
        if (((OA2Client)((Object)client)).hasRequestScopes()) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(((OA2Client)((Object)client)).getProxyRequestScopes());
            this.getJsonUtil().setJSONValue(json, this.getCK2().prototypes(new String[0]), (Object)jsonArray);
        }
        if (((OA2Client)((Object)client)).hasPrototypes()) {
            JSONArray array = new JSONArray();
            for (Identifier identifier : ((OA2Client)((Object)client)).getPrototypes()) {
                array.add((Object)identifier.toString());
            }
            this.getJsonUtil().setJSONValue(json, this.getCK2().prototypes(new String[0]), (Object)array);
        }
        if (callbacks.size() != 0) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().callbackUri(new String[0]), (Object)callbacks);
        }
        JSONArray aud = new JSONArray();
        Collection<String> collection = ((OA2Client)((Object)client)).getAudience();
        if (collection != null) {
            for (String x : collection) {
                aud.add((Object)x);
            }
        }
        if (aud.size() != 0) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().audience(new String[0]), (Object)aud);
        }
        JSONArray jSONArray = new JSONArray();
        List<URI> resources = ((OA2Client)((Object)client)).getResource();
        if (resources != null) {
            for (URI uri : resources) {
                jSONArray.add((Object)uri.toString());
            }
        }
        if (jSONArray.size() != 0) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().resource(new String[0]), (Object)jSONArray);
        }
        if (((OA2Client)((Object)client)).getConfig() != null && !((OA2Client)((Object)client)).getConfig().isEmpty()) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().cfg(new String[0]), (Object)((OA2Client)((Object)client)).getConfig());
        }
        if (((OA2Client)((Object)client)).getIssuer() != null) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().issuer(new String[0]), (Object)((OA2Client)((Object)client)).getIssuer());
        }
        this.getJsonUtil().setJSONValue(json, this.getCK2().signTokens(new String[0]), (Object)((OA2Client)((Object)client)).isSignTokens());
        this.getJsonUtil().setJSONValue(json, this.getCK2().publicClient(new String[0]), (Object)((OA2Client)((Object)client)).isPublicClient());
        this.getJsonUtil().setJSONValue(json, this.getCK2().strictScopes(new String[0]), (Object)((OA2Client)((Object)client)).useStrictScopes());
        JSONArray scopes = new JSONArray();
        Collection scopeList = client.getScopes();
        for (String x : scopeList) {
            scopes.add((Object)x);
        }
        if (scopes.size() != 0) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().scopes(new String[0]), (Object)scopes);
        }
        if (((OA2Client)((Object)client)).getLdaps() != null && !((OA2Client)((Object)client)).getLdaps().isEmpty()) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().ldap(new String[0]), (Object)this.getLdapConfigurationUtil().toJSON(((OA2Client)((Object)client)).getLdaps()));
        }
        if (((OA2Client)((Object)client)).getExtendedAttributes() != null && !((OA2Client)((Object)client)).getExtendedAttributes().isEmpty()) {
            this.getJsonUtil().setJSONValue(json, this.getCK2().ea(new String[0]), (Object)((OA2Client)((Object)client)).getExtendedAttributes());
        }
    }
}

