/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.server.api.admin.transactions.DSFSTransactionStore;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628State;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecord;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecordMap;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;

public class OA2FSTStore<V extends OA2ServiceTransaction>
extends DSFSTransactionStore<V>
implements OA2TStoreInterface<V> {
    public OA2FSTStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, idp, tokenForge, cp, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public V get(RefreshToken refreshToken) {
        return (V)((Object)((OA2ServiceTransaction)this.getIndexEntry(refreshToken.getJti().toString())));
    }

    @Override
    public V get(AccessTokenImpl accessToken, Identifier clientID) {
        return (V)((Object)((OA2ServiceTransaction)this.getIndexEntry(this.getSubIndexKey(accessToken.getJti().toString(), clientID))));
    }

    @Override
    public V get(RefreshTokenImpl refreshToken, Identifier clientID) {
        return (V)((Object)((OA2ServiceTransaction)this.getIndexEntry(this.getSubIndexKey(refreshToken.getJti().toString(), clientID))));
    }

    protected String getSubIndexKey(String token, Identifier clientID) {
        return DigestUtils.sha1Hex((String)(String.valueOf(clientID) + "#" + token));
    }

    public V realRemove(V thingie) {
        super.realRemove(thingie);
        if (thingie.getUsername() != null) {
            this.removeIndexEntry(thingie.getUsername());
        }
        if (((OA2ServiceTransaction)((Object)thingie)).getProxyId() != null) {
            this.removeIndexEntry(((OA2ServiceTransaction)((Object)thingie)).getProxyId());
        }
        if (thingie.hasAccessToken()) {
            this.removeIndexEntry(this.getSubIndexKey(thingie.getAccessToken().getJti().toString(), ((OA2ServiceTransaction)((Object)thingie)).getOA2Client().getIdentifier()));
        }
        if (((OA2ServiceTransaction)((Object)thingie)).hasRefreshToken()) {
            this.removeIndexEntry(this.getSubIndexKey(((OA2ServiceTransaction)((Object)thingie)).getRefreshToken().getJti().toString(), ((OA2ServiceTransaction)((Object)thingie)).getOA2Client().getIdentifier()));
        }
        return thingie;
    }

    public void realSave(boolean checkExists, V t) {
        super.realSave(checkExists, t);
        try {
            if (((OA2ServiceTransaction)((Object)t)).hasRefreshToken()) {
                this.createIndexEntry(((OA2ServiceTransaction)((Object)t)).getRefreshToken().getJti().toString(), t.getIdentifierString());
                this.createIndexEntry(this.getSubIndexKey(((OA2ServiceTransaction)((Object)t)).getRefreshToken().getJti().toString(), ((OA2ServiceTransaction)((Object)t)).getOA2Client().getIdentifier()), t.getIdentifierString());
            }
            if (t.getUsername() != null) {
                this.createIndexEntry(t.getUsername(), t.getIdentifierString());
            }
            if (((OA2ServiceTransaction)((Object)t)).getProxyId() != null) {
                this.createIndexEntry(((OA2ServiceTransaction)((Object)t)).getProxyId(), t.getIdentifierString());
            }
            if (t.hasAccessToken()) {
                this.createIndexEntry(this.getSubIndexKey(t.getAccessToken().getJti().toString(), ((OA2ServiceTransaction)((Object)t)).getOA2Client().getIdentifier()), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + String.valueOf(t) + "to file ", (Throwable)e);
        }
    }

    @Override
    public List<V> getByUsername(String username) {
        ArrayList<OA2ServiceTransaction> list = new ArrayList<OA2ServiceTransaction>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null) continue;
            list.add(transaction);
        }
        return list;
    }

    @Override
    public TokenInfoRecordMap getTokenInfo(String username) {
        TokenInfoRecordMap records = new TokenInfoRecordMap();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null) continue;
            TokenInfoRecord tir = new TokenInfoRecord();
            tir.fromTransaction(transaction);
            records.put(tir);
        }
        return records;
    }

    @Override
    public List<RFC8628State> getPending() {
        ArrayList<RFC8628State> pending = new ArrayList<RFC8628State>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null || !transaction.isRFC8628Request()) continue;
            pending.add(transaction.getRFC8628State());
        }
        return pending;
    }

    @Override
    public V getByUserCode(String userCode) {
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null || !userCode.equals(transaction.getUserCode())) continue;
            return (V)((Object)transaction);
        }
        return null;
    }

    @Override
    public List<Identifier> getByClientID(Identifier clientID) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null) continue;
            identifiers.add(transaction.getIdentifier());
        }
        return identifiers;
    }

    @Override
    public List<Identifier> getAllClientID() {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null) continue;
            identifiers.add(transaction.getClient().getIdentifier());
        }
        return identifiers;
    }

    @Override
    public V getByProxyID(Identifier proxyID) {
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null || !proxyID.toString().equals(transaction.getProxyId())) continue;
            return (V)((Object)transaction);
        }
        return null;
    }

    @Override
    public V getByIDTokenID(Identifier idTokenIdentifier) {
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.get(id);
            if (transaction == null || !idTokenIdentifier.equals(transaction.getIDTokenIdentifier())) continue;
            return (V)((Object)transaction);
        }
        return null;
    }

    @Override
    public boolean hasUserCode(String userCode) {
        return this.getByUserCode(userCode) != null;
    }
}

