/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.transactions.TransactionMemoryStore;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628State;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecord;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecordMap;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;

public class OA2MTStore<V extends OA2ServiceTransaction>
extends TransactionMemoryStore<V>
implements OA2TStoreInterface<V> {
    TransactionMemoryStore.TokenIndex rtIndex;
    TransactionMemoryStore.TokenIndex userIndex;

    public OA2MTStore(IdentifiableProvider identifiableProvider) {
        super(identifiableProvider);
    }

    public TransactionMemoryStore.TokenIndex getRTIndex() {
        if (this.rtIndex == null) {
            this.rtIndex = new TransactionMemoryStore.TokenIndex((TransactionMemoryStore)this);
        }
        return this.rtIndex;
    }

    @Override
    public V get(AccessTokenImpl accessToken, Identifier clientID) {
        return (V)((Object)((OA2ServiceTransaction)((Object)this.getAtIndex().get((Object)this.getSubIndexKey(accessToken.getJti().toString(), clientID)))));
    }

    @Override
    public V get(RefreshTokenImpl refreshToken, Identifier clientID) {
        return (V)((Object)((OA2ServiceTransaction)((Object)this.getRTIndex().get((Object)this.getSubIndexKey(refreshToken.getJti().toString(), clientID)))));
    }

    public TransactionMemoryStore.TokenIndex getUserIndex() {
        if (this.userIndex == null) {
            this.userIndex = new TransactionMemoryStore.TokenIndex((TransactionMemoryStore)this);
        }
        return this.userIndex;
    }

    protected void updateIndices(V v) {
        super.updateIndices(v);
        if (((OA2ServiceTransaction)((Object)v)).getRefreshToken() != null) {
            this.getRTIndex().put((Object)((OA2ServiceTransaction)((Object)v)).getRefreshToken().getToken(), v);
        }
        if (v.getUsername() != null) {
            this.getUserIndex().put((Object)v.getUsername(), v);
        }
        if (((OA2ServiceTransaction)((Object)v)).getProxyId() != null) {
            this.getProxyIDIndex().put((Object)((OA2ServiceTransaction)((Object)v)).getProxyId(), v);
        }
        if (v.getAccessToken() != null) {
            this.getAtIndex().put((Object)this.getSubIndexKey(v.getAccessToken().getJti().toString(), ((OA2ServiceTransaction)((Object)v)).getOA2Client().getIdentifier()), v);
        }
        if (((OA2ServiceTransaction)((Object)v)).getRefreshToken() != null) {
            this.getRTIndex().put((Object)this.getSubIndexKey(((OA2ServiceTransaction)((Object)v)).getRefreshToken().getJti().toString(), ((OA2ServiceTransaction)((Object)v)).getOA2Client().getIdentifier()), v);
        }
    }

    protected String getSubIndexKey(String token, Identifier clientID) {
        return DigestUtils.sha1Hex((String)(String.valueOf(clientID) + "#" + token));
    }

    protected void removeItem(V value) {
        super.removeItem(value);
        this.getRTIndex().remove((Object)((OA2ServiceTransaction)((Object)value)).getRefreshToken());
        this.getUserIndex().remove((Object)value.getUsername());
        this.getProxyIDIndex().remove((Object)((OA2ServiceTransaction)((Object)value)).getProxyId());
        if (value.hasAccessToken()) {
            this.getAtIndex().remove((Object)this.getSubIndexKey(value.getAccessToken().getJti().toString(), ((OA2ServiceTransaction)((Object)value)).getOA2Client().getIdentifier()));
        }
        if (((OA2ServiceTransaction)((Object)value)).hasRefreshToken()) {
            this.getAtIndex().remove((Object)this.getSubIndexKey(((OA2ServiceTransaction)((Object)value)).getRefreshToken().getJti().toString(), ((OA2ServiceTransaction)((Object)value)).getOA2Client().getIdentifier()));
        }
    }

    @Override
    public V get(RefreshToken refreshToken) {
        return (V)((Object)((OA2ServiceTransaction)((Object)this.getRTIndex().get((Object)refreshToken.getToken()))));
    }

    @Override
    public List<V> getByUsername(String username) {
        ArrayList<OA2ServiceTransaction> list = new ArrayList<OA2ServiceTransaction>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null) continue;
            list.add(transaction);
        }
        return list;
    }

    @Override
    public TokenInfoRecordMap getTokenInfo(String username) {
        TokenInfoRecordMap records = new TokenInfoRecordMap();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null) continue;
            TokenInfoRecord tir = new TokenInfoRecord();
            tir.fromTransaction(transaction);
            records.put(tir);
        }
        return records;
    }

    @Override
    public List<RFC8628State> getPending() {
        ArrayList<RFC8628State> pending = new ArrayList<RFC8628State>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null || !transaction.isRFC8628Request()) continue;
            pending.add(transaction.getRFC8628State());
        }
        return pending;
    }

    @Override
    public V getByUserCode(String userCode) {
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null || !userCode.equals(transaction.getUserCode())) continue;
            return (V)((Object)transaction);
        }
        return null;
    }

    @Override
    public List<Identifier> getByClientID(Identifier clientID) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null) continue;
            identifiers.add(transaction.getIdentifier());
        }
        return identifiers;
    }

    @Override
    public List<Identifier> getAllClientID() {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null) continue;
            identifiers.add(transaction.getClient().getIdentifier());
        }
        return identifiers;
    }

    @Override
    public V getByIDTokenID(Identifier idTokenIdentifier) {
        for (Identifier id : this.keySet()) {
            OA2ServiceTransaction transaction = (OA2ServiceTransaction)((Object)this.get(id));
            if (transaction == null || !idTokenIdentifier.equals(transaction.getIDTokenIdentifier())) continue;
            return (V)((Object)transaction);
        }
        return null;
    }

    @Override
    public boolean hasUserCode(String userCode) {
        return this.getByUserCode(userCode) != null;
    }
}

