/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.server.api.admin.transactions.DSSQLTransactionStore;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628State;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecord;
import org.oa4mp.server.loader.oauth2.storage.TokenInfoRecordMap;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionTable;

public class OA2SQLTStore<V extends OA2ServiceTransaction>
extends DSSQLTransactionStore<V>
implements OA2TStoreInterface<V> {
    public String getCreationTSField() {
        return ((OA2TransactionKeys)this.getMapConverter().getKeys()).authTime(new String[0]);
    }

    public OA2SQLTStore(TokenForge tokenForge, ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(tokenForge, connectionPool, table, idp, converter);
    }

    @Override
    public V get(RefreshToken refreshToken) {
        return this.getByRefreshToken(refreshToken);
    }

    public V getByRefreshToken(RefreshToken refreshToken) {
        String identifier = ((RefreshTokenImpl)refreshToken).getJti().toString();
        return (V)((Object)((OA2ServiceTransaction)this.getTransaction(identifier, ((OA2TransactionTable)this.getTransactionTable()).getByRefreshTokenStatement())));
    }

    @Override
    public V get(AccessTokenImpl accessToken, Identifier clientID) {
        if (accessToken == null) {
            throw new IllegalStateException("a null access token was supplied");
        }
        return this.get(accessToken.getJti().toString(), clientID.toString(), true);
    }

    @Override
    public V get(RefreshTokenImpl refreshToken, Identifier clientID) {
        if (refreshToken == null) {
            throw new IllegalStateException("a null access token was supplied");
        }
        return this.get(refreshToken.getJti().toString(), clientID.toString(), false);
    }

    protected V get(String token, String clientID, boolean isAccessToken) {
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        String statement = isAccessToken ? ((OA2TransactionTable)this.getTransactionTable()).getByAccessTokenAndClientStatement() : ((OA2TransactionTable)this.getTransactionTable()).getByRefreshTokenAndClientStatement();
        OA2ServiceTransaction t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, token);
            stmt.setString(2, clientID);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.releaseConnection(cr);
                return null;
            }
            ColumnMap map = OA2SQLTStore.rsToMap((ResultSet)rs);
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
            t = (OA2ServiceTransaction)this.create();
            this.populate(map, (Identifiable)t);
        }
        catch (SQLException e) {
            throw new GeneralException("could not get transaction with token \"" + token + "\" + and client id =" + clientID, (Throwable)e);
        }
        return (V)((Object)t);
    }

    @Override
    public List<Identifier> getByClientID(Identifier clientID) {
        String statement = ((OA2TransactionTable)this.getTransactionTable()).getByClientIDStatement();
        if (clientID == null) {
            throw new IllegalStateException("a null client identifier was supplied");
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        Object t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, clientID.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                list.add(BasicIdentifier.newID((String)rs.getString(1)));
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            throw new GeneralException("could not search for transactions with client id \"" + String.valueOf(clientID) + "\"", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<Identifier> getAllClientID() {
        String statement = ((OA2TransactionTable)this.getTransactionTable()).getAllClientIDsStatement();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        Object t = null;
        try {
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery(statement);
            while (rs.next()) {
                list.add(BasicIdentifier.newID((String)rs.getString(1)));
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            throw new GeneralException("could not search transactions for client ids", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<V> getByUsername(String username) {
        String statement = ((OA2TransactionTable)this.getTransactionTable()).getByUsernameStatement();
        if (username == null) {
            throw new IllegalStateException("a null identifier was supplied");
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        ArrayList<OA2ServiceTransaction> list = new ArrayList<OA2ServiceTransaction>();
        OA2ServiceTransaction t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, username);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ColumnMap map = OA2SQLTStore.rsToMap((ResultSet)rs);
                t = (OA2ServiceTransaction)this.create();
                this.populate(map, (Identifiable)t);
                list.add(t);
            }
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.releaseConnection(cr);
                throw new TransactionNotFoundException("No transaction found for username \"" + username + "\"");
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            throw new GeneralException("could not get transaction with username \"" + username + "\"", (Throwable)e);
        }
        return list;
    }

    @Override
    public TokenInfoRecordMap getTokenInfo(String username) {
        OA2TransactionTable table = (OA2TransactionTable)this.getTransactionTable();
        String statement = table.getTokenInfoStatement();
        if (username == null) {
            throw new IllegalStateException("a null identifier was supplied");
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        TokenInfoRecordMap records = new TokenInfoRecordMap();
        TokenInfoRecord tir = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, username);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ColumnMap map = OA2SQLTStore.rsToMap((ResultSet)rs);
                tir = new TokenInfoRecord();
                tir.fromMap(map, table.getOA2Keys());
                records.put(tir);
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            throw new GeneralException("could not get transaction with username \"" + username + "\"", (Throwable)e);
        }
        return records;
    }

    @Override
    public List<RFC8628State> getPending() {
        ArrayList<RFC8628State> pending = new ArrayList<RFC8628State>();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        OA2TransactionTable oa2TT = (OA2TransactionTable)this.getTable();
        try {
            PreparedStatement stmt = c.prepareStatement(oa2TT.getRFC8628());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String rawJSON = rs.getString(1);
                if (StringUtils.isTrivial((String)rawJSON)) continue;
                JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)rawJSON);
                JSONObject j = json.getJSONObject(OA2ServiceTransaction.RFC862_STATE_KEY);
                RFC8628State state = new RFC8628State();
                state.fromJSON(j);
                pending.add(state);
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("could not get database object", (Throwable)e);
        }
        return pending;
    }

    @Override
    public V getByProxyID(Identifier proxyID) {
        OA2TransactionTable oa2TT = (OA2TransactionTable)this.getTable();
        return this.getSingleValue(proxyID.toString(), oa2TT.getByProxyID());
    }

    @Override
    public V getByIDTokenID(Identifier idTokenIdentifier) {
        OA2TransactionTable oa2TT = (OA2TransactionTable)this.getTable();
        return this.getSingleValue(idTokenIdentifier.toString(), oa2TT.getByIDTokenID());
    }

    @Override
    public V getByUserCode(String userCode) {
        OA2TransactionTable oa2TT = (OA2TransactionTable)this.getTable();
        return this.getSingleValue(userCode, oa2TT.getByUserCode());
    }

    public V getSingleValue(String targetString, String preparedStatement) {
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        OA2TransactionTable oa2TT = (OA2TransactionTable)this.getTable();
        OA2ServiceTransaction result = null;
        try {
            PreparedStatement stmt = c.prepareStatement(preparedStatement);
            stmt.setString(1, targetString);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.releaseConnection(cr);
                return null;
            }
            ColumnMap map = OA2SQLTStore.rsToMap((ResultSet)rs);
            boolean tooManyresults = rs.next();
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
            if (tooManyresults) {
                throw new IllegalStateException("multiple transactions with \"" + targetString + "\" found.");
            }
            result = (OA2ServiceTransaction)this.create();
            this.populate(map, (Identifiable)result);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("could not get database object", (Throwable)e);
        }
        return (V)((Object)result);
    }

    @Override
    public boolean hasUserCode(String userCode) {
        return this.getByUserCode(userCode) != null;
    }
}

