/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.core.DateComparable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.jwt.FlowStates;
import org.oa4mp.delegation.server.server.OA2TransactionScopes;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.api.OA4MPServiceTransaction;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.flows.FlowStates2;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628State;
import org.oa4mp.server.loader.oauth2.state.ExtendedParameters;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.qdl.claims.ConfigtoCS;
import org.qdl_lang.variables.QDLStem;

public class OA2ServiceTransaction
extends OA4MPServiceTransaction
implements OA2TransactionScopes,
OIDCServiceTransactionInterface,
DateComparable {
    public String FLOW_STATE_KEY = "flow_state";
    public String CLAIMS_SOURCES_STATE_KEY = "claims_sources";
    public String CLAIMS_SOURCES_STATE_KEY2 = "claims_sources2";
    public String CREATED_CALLBACK_KEY = "created_callback";
    public String LOCAL_CONSENT_URI = "local_consent_uri";
    public String PROXY_ACCESS_TOKEN_COMPLETE = "has_proxy_at";
    public String CLAIMS_KEY = "claims";
    public String SCRIPT_STATE_KEY = "script_state";
    public String SCRIPT_STATE_SERIALZATION_VERSION_KEY = "serialization_version";
    public String AUDIENCE_KEY = "audience";
    public String USE_TEMPLATES_KEY = "useTemplates";
    public String RESOURCE_KEY = "resource";
    public String QUERIED_ACCESS_TOKEN_SCOPES_KEY = "queriedATScopes";
    public String RETURNED_ACCESS_TOKEN_JWT_KEY = "atJWT";
    public String RETURNED_REFRESH_TOKEN_JWT_KEY = "rtJWT";
    public static String RESPONSE_TYPE_KEY = "responseTypes";
    public String proxyId;
    String userCode;
    public static String RFC862_STATE_KEY = "rfc8628_state";
    static String PROXY_STATE_KEY = "proxy_state";
    long access_token_lifetime = 0L;
    long idTokenLifetime = 0L;
    public static final String AT_RETURNED_ORIGINAL_SCOPES = "at_returned_original_scopes";
    long refreshTokenExpiresAt = 0L;
    boolean isRFC8628 = false;
    long grantLifetime = 900000L;
    protected ConfigtoCS configtoCS;
    String AT_DATA_KEY = "at_data";
    String PROVISIONING_ADMIN_ID = "provisioning_admin_id";
    String PROVISIONING_CLIENT_ID = "provisioning_client_id";
    String RT_DATA_KEY = "rt_data";
    String RESPONSE_MODE_KEY = "response_mode";
    String MAX_AT_LIFETIME_KEY = "maxATLifetime";
    String MAX_IDT_LIFETIME_KEY = "maxIDLifetime";
    String REQUESTED_AT_LIFETIME_KEY = "requestedATLifetime";
    String REQUESTED_IDT_LIFETIME_KEY = "requestedIDTLifetime";
    String MAX_RT_LIFETIME_KEY = "maxRTLifetime";
    String REQUESTED_RT_LIFETIME_KEY = "requestedRTLifetime";
    RefreshToken refreshToken;
    long refreshTokenLifetime = 0L;
    String nonce;
    Date authTime = new Date();
    Collection<String> scopes = null;
    boolean refreshTokenValid = false;
    String requestState = null;
    Collection<String> validatedScopes;
    String atJWT = null;
    String rtJWT = null;
    String idTokenIdentifier = null;

    public boolean isProxyAccessTokenComplete() {
        if (!this.getState().containsKey((Object)this.PROXY_ACCESS_TOKEN_COMPLETE)) {
            return false;
        }
        return this.getState().getBoolean(this.PROXY_ACCESS_TOKEN_COMPLETE);
    }

    public void setProxyAccessTokenComplete(boolean proxyAccessTokenComplete) {
        this.getState().put((Object)this.PROXY_ACCESS_TOKEN_COMPLETE, (Object)proxyAccessTokenComplete);
    }

    public boolean hasCreatedCallback() {
        return this.getState().containsKey((Object)this.CREATED_CALLBACK_KEY);
    }

    public String getCreatedCallback() {
        return this.getState().getString(this.CREATED_CALLBACK_KEY);
    }

    public void setCreatedCallback(String createdCallback) {
        this.getState().put((Object)this.CREATED_CALLBACK_KEY, (Object)createdCallback);
    }

    public boolean hasLocalConsentUri() {
        return this.getState().containsKey((Object)this.LOCAL_CONSENT_URI);
    }

    public String getLocalConsentUri() {
        return this.getState().getString(this.LOCAL_CONSENT_URI);
    }

    public void setLocalConsentURI(String localConsentURI) {
        this.getState().put((Object)this.LOCAL_CONSENT_URI, (Object)localConsentURI);
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public Date getCreationTS() {
        return this.getAuthTime();
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public OA2ServiceTransaction(AuthorizationGrant ag) {
        super(ag);
    }

    public OA2ServiceTransaction(Identifier identifier) {
        super(identifier);
        AuthorizationGrantImpl ag = null;
        ag = identifier == null ? new AuthorizationGrantImpl(null) : new AuthorizationGrantImpl(identifier.getUri());
        this.authorizationGrant = ag;
    }

    public OA2Client getOA2Client() {
        return (OA2Client)this.getClient();
    }

    public FlowStates2 getFlowStates() {
        JSONObject fs = this.getState().getJSONObject(this.FLOW_STATE_KEY);
        FlowStates2 flowStates = new FlowStates2();
        if (fs == null) {
            return flowStates;
        }
        if (fs != null && !fs.isEmpty()) {
            flowStates.fromJSON(fs);
        }
        return flowStates;
    }

    public RFC8628State getRFC8628State() {
        JSONObject j = this.getState().getJSONObject(RFC862_STATE_KEY);
        RFC8628State state = new RFC8628State();
        if (j != null) {
            state.fromJSON(j);
        }
        return state;
    }

    public void setProxyState(JSONObject proxyState) {
        this.getState().put((Object)PROXY_STATE_KEY, (Object)proxyState);
    }

    public JSONObject getProxyState() {
        if (this.getState().containsKey((Object)PROXY_STATE_KEY)) {
            return this.getState().getJSONObject(PROXY_STATE_KEY);
        }
        return new JSONObject();
    }

    public void setRFC8628State(RFC8628State rfc8628State) {
        this.getState().put((Object)RFC862_STATE_KEY, (Object)rfc8628State.toJSON());
    }

    public long getAccessTokenLifetime() {
        return this.access_token_lifetime;
    }

    public void setAccessTokenLifetime(long access_token_lifetime) {
        this.access_token_lifetime = access_token_lifetime;
    }

    public long getIDTokenLifetime() {
        return this.idTokenLifetime;
    }

    public void setIDTokenLifetime(long idTokenLifetime) {
        this.idTokenLifetime = idTokenLifetime;
    }

    public List<String> getAudience() {
        if (this.getState().containsKey((Object)this.AUDIENCE_KEY)) {
            return this.getState().getJSONArray(this.AUDIENCE_KEY);
        }
        return null;
    }

    public void setAudience(List<String> audience) {
        this.getState().put((Object)this.AUDIENCE_KEY, audience);
    }

    public boolean hasAudience() {
        return this.getState().containsKey((Object)this.AUDIENCE_KEY) && this.getState().get(this.AUDIENCE_KEY) != null && !((List)this.getState().get(this.AUDIENCE_KEY)).isEmpty();
    }

    public List<String> getUseTemplates() {
        if (this.getState().containsKey((Object)this.USE_TEMPLATES_KEY)) {
            return this.getState().getJSONArray(this.USE_TEMPLATES_KEY);
        }
        return null;
    }

    public void setUseTemplates(List<String> templates) {
        this.getState().put((Object)this.USE_TEMPLATES_KEY, templates);
    }

    public boolean hasUseTemplates() {
        return this.getState().containsKey((Object)this.USE_TEMPLATES_KEY) || this.getState().get(this.USE_TEMPLATES_KEY) != null && !((List)this.getState().get(this.USE_TEMPLATES_KEY)).isEmpty();
    }

    public Collection<String> getATReturnedOriginalScopes() {
        if (this.getState().containsKey((Object)AT_RETURNED_ORIGINAL_SCOPES)) {
            return this.getState().getJSONArray(AT_RETURNED_ORIGINAL_SCOPES);
        }
        return null;
    }

    public void setATReturnedOriginalScopes(String s) {
        this.setATReturnedOriginalScopes(OA2Scopes.ScopeUtil.toScopes((String)s));
    }

    public void setATReturnedOriginalScopes(Collection<String> s) {
        this.getState().put((Object)AT_RETURNED_ORIGINAL_SCOPES, s);
    }

    public boolean hasATReturnedOriginalScopes() {
        return this.getState().containsKey((Object)AT_RETURNED_ORIGINAL_SCOPES);
    }

    public long getRefreshTokenExpiresAt() {
        return this.refreshTokenExpiresAt;
    }

    public void setRefreshTokenExpiresAt(long refreshTokenExpiresAt) {
        this.refreshTokenExpiresAt = refreshTokenExpiresAt;
    }

    public boolean isRFC8628Request() {
        return this.isRFC8628;
    }

    public void setRFC8628Request(boolean b) {
        this.isRFC8628 = b;
    }

    public List<String> getResource() {
        if (this.getState().containsKey((Object)this.RESOURCE_KEY)) {
            return this.getState().getJSONArray(this.RESOURCE_KEY);
        }
        return null;
    }

    public boolean hasResource() {
        return this.getState().containsKey((Object)this.RESOURCE_KEY) && this.getState().get(this.RESOURCE_KEY) != null;
    }

    public void setResource(List<String> r) {
        this.getState().put((Object)this.RESOURCE_KEY, r);
    }

    public JSONObject getExtendedAttributes() {
        if (!this.getState().containsKey((Object)ExtendedParameters.EXTENDED_ATTRIBUTES_KEY)) {
            return new JSONObject();
        }
        return this.getState().getJSONObject(ExtendedParameters.EXTENDED_ATTRIBUTES_KEY);
    }

    public long getAuthzGrantLifetime() {
        return this.grantLifetime;
    }

    public void setAuthGrantLifetime(long lifetime) {
        this.grantLifetime = lifetime;
    }

    public void setExtendedAttributes(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)ExtendedParameters.EXTENDED_ATTRIBUTES_KEY)) {
            this.getState().put((Object)ExtendedParameters.EXTENDED_ATTRIBUTES_KEY, (Object)jsonObject.getJSONObject(ExtendedParameters.EXTENDED_ATTRIBUTES_KEY));
        } else if (!jsonObject.isEmpty()) {
            this.getState().put((Object)ExtendedParameters.EXTENDED_ATTRIBUTES_KEY, (Object)jsonObject);
        }
    }

    public void setFlowStates(FlowStates flowStates) {
        this.getState().put((Object)this.FLOW_STATE_KEY, (Object)flowStates.toJSON());
    }

    public void setClaimsSources(List<ClaimSource> sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        this.newCSSerialize(sources);
        this.oldCSSerialize(sources);
    }

    protected void newCSSerialize(List<ClaimSource> sources) {
        JSONArray array = new JSONArray();
        for (ClaimSource claimSource : sources) {
            array.add((Object)claimSource.toQDL().toJSON());
        }
        this.getState().put((Object)this.CLAIMS_SOURCES_STATE_KEY2, (Object)array);
    }

    protected void oldCSSerialize(List<ClaimSource> sources) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(sources);
            out.flush();
            out.close();
            this.getState().put((Object)this.CLAIMS_SOURCES_STATE_KEY, (Object)Base64.encodeBase64URLSafeString((byte[])baos.toByteArray()));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("error serializing claims:" + t.getMessage(), t);
        }
    }

    public List<ClaimSource> getClaimSources(OA2SE oa2SE) {
        if (this.getState().containsKey((Object)this.CLAIMS_SOURCES_STATE_KEY2)) {
            try {
                return this.newCSDeserialize(oa2SE);
            }
            catch (Throwable t) {
                ServletDebugUtil.info((Object)((Object)this), (String)"could not deserialize claim sources new way, reverting to Java serialization");
            }
        }
        if (this.getState().containsKey((Object)this.CLAIMS_SOURCES_STATE_KEY)) {
            try {
                return this.oldCSDeserialize(oa2SE);
            }
            catch (Throwable tt) {
                if (ServletDebugUtil.isEnabled()) {
                    ServletDebugUtil.info((Object)((Object)this), (String)("could not deserialize claim sources in any way:" + tt.getMessage()));
                    tt.printStackTrace();
                }
                if (tt instanceof RuntimeException) {
                    throw (RuntimeException)tt;
                }
                throw new GeneralException("Error deserializing claim source:" + tt.getMessage(), tt);
            }
        }
        return new ArrayList<ClaimSource>();
    }

    public ConfigtoCS getConfigToCS() {
        if (this.configtoCS == null) {
            this.configtoCS = new ConfigtoCS();
        }
        return this.configtoCS;
    }

    protected List<ClaimSource> newCSDeserialize(OA2SE oa2SE) throws Throwable {
        JSONArray array = this.getState().getJSONArray(this.CLAIMS_SOURCES_STATE_KEY2);
        ArrayList<ClaimSource> claimSources = new ArrayList<ClaimSource>();
        for (int i = 0; i < array.size(); ++i) {
            QDLStem stem = new QDLStem();
            claimSources.add(this.getConfigToCS().convert(stem.fromJSON(array.getJSONObject(0)), oa2SE));
        }
        return claimSources;
    }

    protected List<ClaimSource> oldCSDeserialize(OA2SE oa2SE) throws Throwable {
        byte[] bytes = Base64.decodeBase64((String)this.getState().getString(this.CLAIMS_SOURCES_STATE_KEY));
        ByteArrayInputStream baos = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(baos);
        Object object = in.readObject();
        List sources = (List)object;
        for (ClaimSource source : sources) {
            if (!(source instanceof BasicClaimsSourceImpl)) continue;
            ((BasicClaimsSourceImpl)source).setOa2SE(oa2SE);
        }
        in.close();
        return sources;
    }

    public void setScriptState(String scriptState) {
        if (scriptState != null && !scriptState.isEmpty()) {
            this.getState().put((Object)this.SCRIPT_STATE_KEY, (Object)scriptState);
        }
    }

    public boolean hasScriptStateSerializationVersion() {
        return this.getState().containsKey((Object)this.SCRIPT_STATE_SERIALZATION_VERSION_KEY);
    }

    public String getScriptStateSerializationVersion() {
        return this.getState().getString(this.SCRIPT_STATE_SERIALZATION_VERSION_KEY);
    }

    public void setScriptStateSerialzationVersion(String version) {
        this.getState().put((Object)this.SCRIPT_STATE_SERIALZATION_VERSION_KEY, (Object)version);
    }

    public boolean hasScriptState() {
        return this.getState().containsKey((Object)this.SCRIPT_STATE_KEY);
    }

    public String getScriptState() {
        if (this.getState().containsKey((Object)this.SCRIPT_STATE_KEY)) {
            return this.getState().getString(this.SCRIPT_STATE_KEY);
        }
        return "";
    }

    public JSONObject getUserMetaData() {
        if (!this.getState().containsKey((Object)this.CLAIMS_KEY)) {
            return new JSONObject();
        }
        return this.getState().getJSONObject(this.CLAIMS_KEY);
    }

    public void setUserMetaData(JSONObject claims) {
        this.getState().put((Object)this.CLAIMS_KEY, (Object)claims);
    }

    public JSONObject getATData() {
        if (!this.getState().containsKey((Object)this.AT_DATA_KEY)) {
            return new JSONObject();
        }
        return this.getState().getJSONObject(this.AT_DATA_KEY);
    }

    public void setATData(JSONObject atData) {
        this.getState().put((Object)this.AT_DATA_KEY, (Object)atData);
    }

    public Identifier getProvisioningAdminID() {
        if (!this.getState().containsKey((Object)this.PROVISIONING_ADMIN_ID)) {
            return null;
        }
        return BasicIdentifier.newID((String)this.getState().getString(this.PROVISIONING_ADMIN_ID));
    }

    public void setProvisioningAdminID(Identifier provisioningAdminID) {
        this.getState().put((Object)this.PROVISIONING_ADMIN_ID, (Object)(provisioningAdminID == null ? null : provisioningAdminID.toString()));
    }

    public Identifier getProvisioningClientID() {
        if (!this.getState().containsKey((Object)this.PROVISIONING_CLIENT_ID)) {
            return null;
        }
        return BasicIdentifier.newID((String)this.getState().getString(this.PROVISIONING_CLIENT_ID));
    }

    public void setProvisioningClientID(Identifier provisioningClientID) {
        this.getState().put((Object)this.PROVISIONING_CLIENT_ID, (Object)provisioningClientID.toString());
    }

    public void setRTData(JSONObject rtData) {
        this.getState().put((Object)this.RT_DATA_KEY, (Object)rtData);
    }

    public JSONObject getRTData() {
        if (!this.getState().containsKey((Object)this.RT_DATA_KEY)) {
            return new JSONObject();
        }
        return this.getState().getJSONObject(this.RT_DATA_KEY);
    }

    public String getResponseMode() {
        return this.getState().getString(this.RESPONSE_MODE_KEY);
    }

    public void setResponseMode(String mode) {
        this.getState().put((Object)this.RESPONSE_MODE_KEY, (Object)mode);
    }

    public boolean hasResponseMode() {
        return this.getState().containsKey((Object)this.RESPONSE_MODE_KEY);
    }

    public long getRequestedATLifetime() {
        if (this.hasRequestedATLifetime()) {
            return this.getState().getLong(this.REQUESTED_AT_LIFETIME_KEY);
        }
        return -1L;
    }

    public long getRequestedIDTLifetime() {
        if (this.hasRequestedIDTLifetime()) {
            return this.getState().getLong(this.REQUESTED_IDT_LIFETIME_KEY);
        }
        return -1L;
    }

    public void setRequestedIDTLifetime(long idtLifetime) {
        this.getState().put((Object)this.REQUESTED_IDT_LIFETIME_KEY, (Object)idtLifetime);
    }

    public boolean hasRequestedATLifetime() {
        return this.getState().containsKey((Object)this.REQUESTED_AT_LIFETIME_KEY);
    }

    public boolean hasRequestedIDTLifetime() {
        return this.getState().containsKey((Object)this.REQUESTED_IDT_LIFETIME_KEY);
    }

    public void setRequestedATLifetime(long atLifetime) {
        this.getState().put((Object)this.REQUESTED_AT_LIFETIME_KEY, (Object)atLifetime);
    }

    public long getRequestedRTLifetime() {
        if (this.hasRequestedRTLifetime()) {
            return this.getState().getLong(this.REQUESTED_RT_LIFETIME_KEY);
        }
        return -1L;
    }

    public void setRequestedRTLifetime(long rtLifetime) {
        this.getState().put((Object)this.REQUESTED_RT_LIFETIME_KEY, (Object)rtLifetime);
    }

    public boolean hasRequestedRTLifetime() {
        return this.getState().containsKey((Object)this.REQUESTED_RT_LIFETIME_KEY);
    }

    public long getMaxAtLifetime() {
        if (this.hasMaxATLifetime()) {
            return this.getState().getLong(this.MAX_AT_LIFETIME_KEY);
        }
        return -1L;
    }

    public void setMaxATLifetime(long max) {
        Long ll = new Long(max);
        this.getState().put((Object)this.MAX_AT_LIFETIME_KEY, (Object)ll);
    }

    public long getMaxIDTLifetime() {
        if (this.hasMaxIDTLifetime()) {
            return this.getState().getLong(this.MAX_IDT_LIFETIME_KEY);
        }
        return -1L;
    }

    public void setMaxIDTLifetime(long max) {
        Long ll = new Long(max);
        this.getState().put((Object)this.MAX_IDT_LIFETIME_KEY, (Object)ll);
    }

    public boolean hasMaxATLifetime() {
        return this.getState().containsKey((Object)this.MAX_AT_LIFETIME_KEY);
    }

    public boolean hasMaxIDTLifetime() {
        return this.getState().containsKey((Object)this.MAX_IDT_LIFETIME_KEY);
    }

    public long getMaxRtLifetime() {
        if (this.hasMaxATLifetime()) {
            if (this.getState().containsKey((Object)this.MAX_RT_LIFETIME_KEY)) {
                return this.getState().getLong(this.MAX_RT_LIFETIME_KEY);
            }
            throw new IllegalStateException(this.MAX_RT_LIFETIME_KEY + " not set for this transaction");
        }
        return -1L;
    }

    public void setMaxRTLifetime(long max) {
        this.getState().put((Object)this.MAX_RT_LIFETIME_KEY, (Object)max);
    }

    public boolean hasMaxRTLifetime() {
        return this.getState().containsKey((Object)this.MAX_RT_LIFETIME_KEY);
    }

    public boolean hasCodeChallenge() {
        return this.getState().containsKey((Object)"code_challenge");
    }

    public String getCodeChallenge() {
        return this.getState().getString("code_challenge");
    }

    public void setCodeChallenge(String codeChallenge) {
        this.getState().put((Object)"code_challenge", (Object)codeChallenge);
    }

    public String getCodeChallengeMethod() {
        return this.getState().getString("code_challenge_method");
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.getState().put((Object)"code_challenge_method", (Object)codeChallengeMethod);
    }

    public boolean hasAuthTime() {
        return this.authTime != null;
    }

    public Date getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(Date authTime) {
        this.authTime = authTime;
    }

    public Collection<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        return this.scopes;
    }

    public void setScopes(Collection<String> scopes) {
        ArrayList<String> newScopes = new ArrayList<String>(scopes.size());
        for (String scope : scopes) {
            if (newScopes.contains(scope)) continue;
            newScopes.add(scope);
        }
        this.scopes = newScopes;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public boolean isRefreshTokenValid() {
        return this.refreshTokenValid;
    }

    public void setRefreshTokenValid(boolean refreshTokenValid) {
        this.refreshTokenValid = refreshTokenValid;
    }

    public long getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public String getRequestState() {
        return this.requestState;
    }

    public void setRequestState(String requestState) {
        this.requestState = requestState;
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    protected String formatToString() {
        return super.formatToString() + ", nonce=" + this.getNonce() + ", scopes=" + String.valueOf(this.getScopes()) + ", refresh token lifetime=" + this.getRefreshTokenLifetime();
    }

    public String toString() {
        Object x = super.toString();
        x = ((String)x).substring(0, ((String)x).length() - 1);
        x = (String)x + ",refresh token=" + String.valueOf(this.getRefreshToken()) + "]";
        return x;
    }

    public boolean equals(Object obj) {
        boolean rc = super.equals(obj);
        if (!rc) {
            return false;
        }
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)((Object)obj);
        if (this.getRefreshTokenLifetime() != st2.getRefreshTokenLifetime()) {
            return false;
        }
        if (this.getRefreshToken() == null ? st2.getRefreshToken() != null : !this.getRefreshToken().equals(st2.getRefreshToken())) {
            return false;
        }
        return this.isRefreshTokenValid() == st2.isRefreshTokenValid();
    }

    public Collection<String> getValidatedScopes() {
        if (this.validatedScopes == null) {
            this.validatedScopes = new HashSet<String>();
        }
        return this.validatedScopes;
    }

    public void setValidatedScopes(Collection<String> validatedScopes) {
        this.validatedScopes = validatedScopes;
    }

    public Collection<String> getQueriedATScopes() {
        if (!this.getState().containsKey((Object)this.QUERIED_ACCESS_TOKEN_SCOPES_KEY)) {
            return null;
        }
        return this.getState().getJSONArray(this.QUERIED_ACCESS_TOKEN_SCOPES_KEY);
    }

    public void setQueriedATScopes(Collection<String> queriedATScopes) {
        this.getState().put((Object)this.QUERIED_ACCESS_TOKEN_SCOPES_KEY, queriedATScopes);
    }

    public String getATJWT() {
        return this.atJWT;
    }

    public void setATJWT(String atJWT) {
        this.atJWT = atJWT;
    }

    public String getRTJWT() {
        return this.rtJWT;
    }

    public void setRTJWT(String rtJWT) {
        this.rtJWT = rtJWT;
    }

    protected String firstSix(URI id) {
        String agID = id.getPath();
        if (agID == null) {
            return id.toString();
        }
        if (6 < (agID = agID.substring(agID.lastIndexOf("/") + 1)).length()) {
            int l = agID.length();
            return agID.substring(l - 6);
        }
        return id.toString();
    }

    public String getIDTokenIdentifier() {
        return this.idTokenIdentifier;
    }

    public void setIDTokenIdentifier(String idTokenIdentifier) {
        this.idTokenIdentifier = idTokenIdentifier;
    }

    public String summary() {
        String out = "Transaction[id=" + this.firstSix(this.getIdentifier().getUri());
        if (this.hasAccessToken()) {
            out = out + ", at=" + this.firstSix(this.getAccessToken().getJti());
        }
        if (this.hasRefreshToken()) {
            out = out + ", rt=" + this.firstSix(this.getRefreshToken().getJti());
        }
        out = out + ", client=" + this.firstSix(this.getClient().getIdentifier().getUri());
        return out + "]";
    }

    public List<String> getResponseTypes() {
        if (this.getState().containsKey((Object)RESPONSE_TYPE_KEY)) {
            return this.getState().getJSONArray(RESPONSE_TYPE_KEY);
        }
        return new ArrayList<String>();
    }

    public void setResponseTypes(List<String> responseTypes) {
        JSONArray r;
        if (responseTypes instanceof JSONArray) {
            r = (JSONArray)responseTypes;
        } else {
            r = new JSONArray();
            r.addAll(responseTypes);
        }
        this.getState().put((Object)RESPONSE_TYPE_KEY, (Object)r);
    }
}

