/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.util.Collection;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.transactions.TransactionConverter;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;

public class OA2TConverter<V extends OA2ServiceTransaction>
extends TransactionConverter<V> {
    public OA2TConverter(OA2TransactionKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge, ClientStore<? extends Client> cs) {
        super((SerializationKeys)keys, identifiableProvider, tokenForge, cs);
    }

    protected OA2TransactionKeys getTCK() {
        return (OA2TransactionKeys)this.keys;
    }

    protected OA2TokenForge getTF2() {
        return (OA2TokenForge)this.getTokenForge();
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        Collection zzz;
        JSONArray json;
        AuthorizationGrantImpl ag;
        OA2ServiceTransaction st = (OA2ServiceTransaction)super.fromMap(map, v);
        Object refreshToken = map.get((Object)this.getTCK().refreshToken(new String[0]));
        if (refreshToken == null) {
            st.setRefreshToken(null);
        } else if (refreshToken instanceof RefreshToken) {
            st.setRefreshToken((RefreshToken)refreshToken);
        } else {
            RefreshTokenImpl rt = TokenFactory.createRT((String)refreshToken.toString());
            st.setRefreshToken((RefreshToken)rt);
        }
        Object rawAG = map.get((Object)this.getTCK().authGrant(new String[0]));
        if (rawAG == null) {
            if (st.getIdentifier() != null) {
                ag = TokenFactory.createAG((String)st.getIdentifierString());
                st.setAuthorizationGrant((AuthorizationGrant)ag);
            }
        } else if (rawAG instanceof AuthorizationGrant) {
            st.setAuthorizationGrant((AuthorizationGrant)rawAG);
        } else {
            ag = TokenFactory.createAG((String)rawAG.toString());
            st.setAuthorizationGrant((AuthorizationGrant)ag);
        }
        if (map.containsKey((Object)this.getTCK().consentPageOK(new String[0]))) {
            st.setConsentPageOK(map.getBoolean((Object)this.getTCK().consentPageOK(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().atJWT(new String[0]))) {
            st.setATJWT(map.getString((Object)this.getTCK().atJWT(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().rtJWT(new String[0]))) {
            st.setRTJWT(map.getString((Object)this.getTCK().rtJWT(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().userCode(new String[0]))) {
            st.setUserCode(map.getString((Object)this.getTCK().userCode(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().isRFC8628(new String[0]))) {
            st.setRFC8628Request(map.getBoolean((Object)this.getTCK().isRFC8628(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().idTokenIdentifier(new String[0]))) {
            st.setIDTokenIdentifier(map.getString((Object)this.getTCK().idTokenIdentifier(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().proxyID(new String[0]))) {
            st.setProxyId(map.getString((Object)this.getTCK().proxyID(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().authzGrantLifetime(new String[0]))) {
            st.setAuthGrantLifetime(map.getLong((Object)this.getTCK().authzGrantLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().refreshTokenValid(new String[0]))) {
            st.setRefreshTokenValid(map.getBoolean((Object)this.getTCK().refreshTokenValid(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().refreshTokenLifetime(new String[0]))) {
            st.setRefreshTokenLifetime(map.getLong((Object)this.getTCK().refreshTokenLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().refreshTokenExpiresAt(new String[0]))) {
            st.setRefreshTokenExpiresAt(map.getLong((Object)this.getTCK().refreshTokenExpiresAt(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().idTokenLifetime(new String[0]))) {
            st.setIDTokenLifetime(map.getLong((Object)this.getTCK().idTokenLifetime(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().expiresIn(new String[0]))) {
            st.setAccessTokenLifetime(map.getLong((Object)this.getTCK().expiresIn(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().callbackUri(new String[0]))) {
            st.setCallback(map.getURI((Object)this.getTCK().callbackUri(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().nonce(new String[0]))) {
            st.setNonce(map.getString((Object)this.getTCK().nonce(new String[0])));
        }
        if (map.containsKey((Object)this.getTCK().reqState(new String[0]))) {
            st.setRequestState(map.getString((Object)this.getTCK().reqState(new String[0])));
        }
        if (map.get((Object)this.getTCK().validatedScopes(new String[0])) != null) {
            json = (JSONArray)JSONSerializer.toJSON((Object)map.get((Object)this.getTCK().validatedScopes(new String[0])));
            zzz = (Collection)JSONSerializer.toJava((JSON)json);
            st.setValidatedScopes(zzz);
        }
        if (map.get((Object)this.getTCK().scopes(new String[0])) != null) {
            json = (JSONArray)JSONSerializer.toJSON((Object)map.get((Object)this.getTCK().scopes(new String[0])));
            zzz = (Collection)JSONSerializer.toJava((JSON)json);
            st.setScopes(zzz);
        }
        if (map.get((Object)this.getTCK().authTime(new String[0])) != null) {
            st.setAuthTime(map.getDate((Object)this.getTCK().authTime));
        }
        if (map.get((Object)this.getTCK().states(new String[0])) != null) {
            st.setState((JSONObject)JSONSerializer.toJSON((Object)map.get((Object)this.getTCK().states(new String[0]))));
        } else {
            st.setState(new JSONObject());
        }
        if (st.hasAccessToken()) {
            AccessTokenImpl accessToken = (AccessTokenImpl)st.getAccessToken();
            JSONObject atData = st.getATData();
            if (atData != null && !atData.isEmpty() && atData.containsKey((Object)"iat")) {
                accessToken.setIssuedAt(1000L * atData.getLong("iat"));
                if (atData.containsKey((Object)"exp")) {
                    accessToken.setLifetime(1000L * (atData.getLong("exp") - atData.getLong("iat")));
                }
            }
        }
        if (st.hasRefreshToken()) {
            RefreshTokenImpl rt = (RefreshTokenImpl)st.getRefreshToken();
            JSONObject rtData = st.getRTData();
            if (rtData != null && !rtData.isEmpty() && rtData.containsKey((Object)"iat")) {
                rt.setIssuedAt(1000L * rtData.getLong("iat"));
                if (rtData.containsKey((Object)"exp")) {
                    rt.setLifetime(1000L * (rtData.getLong("exp") - rtData.getLong("iat")));
                }
            }
        }
        return (V)((Object)st);
    }

    public void toMap(V t, ConversionMap<String, Object> map) {
        JSONArray jsonArray;
        super.toMap(t, map);
        if (((OA2ServiceTransaction)((Object)t)).getRefreshToken() != null) {
            map.put((Object)this.getTCK().refreshToken(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRefreshToken().getJti().toString());
        }
        if (t.getAuthorizationGrant() == null) {
            AuthorizationGrantImpl ag = new AuthorizationGrantImpl(t.getIdentifier().getUri());
            map.put((Object)this.getTCK().authGrant(new String[0]), (Object)ag);
        } else {
            map.put((Object)this.getTCK().authGrant(new String[0]), (Object)t.getAuthorizationGrant().getToken());
        }
        map.put((Object)this.getTCK().refreshTokenValid(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).isRefreshTokenValid());
        if (t.getCallback() != null) {
            map.put((Object)this.getTCK().callbackUri(new String[0]), (Object)t.getCallback().toString());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getATJWT())) {
            map.put((Object)this.getTCK().atJWT(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getATJWT());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getRTJWT())) {
            map.put((Object)this.getTCK().rtJWT(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRTJWT());
        }
        map.put((Object)this.getTCK().authzGrantLifetime(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getAuthzGrantLifetime());
        map.put((Object)this.getTCK().consentPageOK(new String[0]), (Object)t.isConsentPageOK());
        map.put((Object)this.getTCK().expiresIn(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getAccessTokenLifetime());
        map.put((Object)this.getTCK().refreshTokenLifetime(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRefreshTokenLifetime());
        map.put((Object)this.getTCK().refreshTokenExpiresAt(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRefreshTokenExpiresAt());
        map.put((Object)this.getTCK().idTokenLifetime(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getIDTokenLifetime());
        map.put((Object)this.getTCK().isRFC8628(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).isRFC8628Request());
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getIDTokenIdentifier())) {
            map.put((Object)this.getTCK().idTokenIdentifier(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getIDTokenIdentifier());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getProxyId())) {
            map.put((Object)this.getTCK().proxyID(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getProxyId());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getUserCode())) {
            map.put((Object)this.getTCK().userCode(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getUserCode());
        }
        if (!((OA2ServiceTransaction)((Object)t)).getValidatedScopes().isEmpty()) {
            jsonArray = new JSONArray();
            jsonArray.addAll(((OA2ServiceTransaction)((Object)t)).getValidatedScopes());
            map.put((Object)this.getTCK().validatedScopes(new String[0]), (Object)jsonArray.toString());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getNonce())) {
            map.put((Object)this.getTCK().nonce(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getNonce());
        }
        if (!StringUtils.isTrivial((String)((OA2ServiceTransaction)((Object)t)).getRequestState())) {
            map.put((Object)this.getTCK().reqState(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRequestState());
        }
        jsonArray = new JSONArray();
        for (String s : ((OA2ServiceTransaction)((Object)t)).getScopes()) {
            if (DebugUtil.isEnabled() && !(s instanceof String)) {
                DebugUtil.trace((Object)((Object)this), (String)("Erasure error. A String was expected, but an object of class " + s.getClass().getCanonicalName() + " was found instead."));
                DebugUtil.trace((Object)((Object)this), (String)("Value of the class=\"" + String.valueOf(s) + "\""));
            }
            jsonArray.add((Object)s.toString());
        }
        map.put((Object)this.getTCK().scopes(new String[0]), (Object)jsonArray.toString());
        if (((OA2ServiceTransaction)((Object)t)).hasAuthTime()) {
            map.put((Object)this.getTCK().authTime(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getAuthTime());
        }
        map.put((Object)this.getTCK().states(new String[0]), (Object)t.getState().toString());
    }
}

