/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.transactions;

import edu.uiuc.ncsa.security.storage.data.DataDescriptorEntry;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptorEntry;
import org.oa4mp.server.api.admin.transactions.DSTransactionKeys;
import org.oa4mp.server.api.admin.transactions.DSTransactionTable;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;

public class OA2TransactionTable
extends DSTransactionTable {
    public OA2TransactionTable(OA2TransactionKeys keys, String schema, String tablenamePrefix, String tablename) {
        super((DSTransactionKeys)keys, schema, tablenamePrefix, tablename);
    }

    protected OA2TransactionKeys getOA2Keys() {
        return (OA2TransactionKeys)this.keys;
    }

    public void createColumnDescriptors() {
        super.createColumnDescriptors();
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().atJWT(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().authTime(new String[0]), 93));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().authzGrantLifetime(new String[0]), -5));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().consentPageOK(new String[0]), 16));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().expiresIn(new String[0]), -5));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().idTokenIdentifier(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().idTokenLifetime(new String[0]), -5));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().isRFC8628(new String[0]), 16));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().nonce(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().proxyID(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().refreshToken(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().refreshTokenExpiresAt(new String[0]), -5));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().refreshTokenLifetime(new String[0]), -5));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().refreshTokenValid(new String[0]), 16));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().reqState(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().rtJWT(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().scopes(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().states(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().userCode(new String[0]), -1));
        this.getColumnDescriptor().add((DataDescriptorEntry)new ColumnDescriptorEntry(this.getOA2Keys().validatedScopes(new String[0]), -1));
    }

    public String getByRefreshTokenStatement() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().refreshToken(new String[0]) + "=?";
    }

    public String getByUsernameStatement() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().username(new String[0]) + "=?";
    }

    public String getByClientIDStatement() {
        return "SELECT " + this.getOA2Keys().identifier(new String[0]) + " FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().clientKey(new String[0]) + "=?";
    }

    public String getAllClientIDsStatement() {
        return "SELECT " + this.getOA2Keys().clientKey(new String[0]) + " FROM " + this.getFQTablename();
    }

    public String getTokenInfoStatement() {
        return "SELECT " + this.getOA2Keys().identifier(new String[0]) + ", " + this.getOA2Keys().atJWT(new String[0]) + ", " + this.getOA2Keys().rtJWT(new String[0]) + ", " + this.getOA2Keys().clientKey(new String[0]) + ", " + this.getOA2Keys().accessToken(new String[0]) + ", " + this.getOA2Keys().accessTokenValid(new String[0]) + ", " + this.getOA2Keys().expiresIn(new String[0]) + ", " + this.getOA2Keys().refreshToken(new String[0]) + ", " + this.getOA2Keys().refreshTokenValid(new String[0]) + ", " + this.getOA2Keys().refreshTokenLifetime(new String[0]) + " FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().username(new String[0]) + "=?";
    }

    public String getRFC8628() {
        return "SELECT " + this.getOA2Keys().states(new String[0]) + " FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().isRFC8628(new String[0]) + "= true";
    }

    public String getByUserCode() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().userCode(new String[0]) + "= ?";
    }

    public String CheckUserCodeExists() {
        return "select exists(select * from " + this.getFQTablename() + " WHERE " + this.getOA2Keys().userCode(new String[0]) + "= ?)";
    }

    public String getByProxyID() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().proxyID(new String[0]) + "= ?";
    }

    public String getByAccessTokenAndClientStatement() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().accessToken(new String[0]) + "=? AND " + this.getOA2Keys().clientKey(new String[0]) + "=?";
    }

    public String getByRefreshTokenAndClientStatement() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().refreshToken(new String[0]) + "=? AND " + this.getOA2Keys().clientKey(new String[0]) + "=?";
    }

    public String getByIDTokenID() {
        return "SELECT * FROM " + this.getFQTablename() + " WHERE " + this.getOA2Keys().idTokenIdentifier(new String[0]) + "= ?";
    }
}

