/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.tx;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordConverter;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordSerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordTable;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class SQLTXRecordStore<V extends TXRecord>
extends SQLStore<V>
implements TXStore<V> {
    public SQLTXRecordStore(ConnectionPool connectionPool, TXRecordTable table, Provider<V> identifiableProvider, TXRecordConverter<V> converter) {
        super(connectionPool, (Table)table, identifiableProvider, converter);
    }

    protected TXRecordTable getTXRTable() {
        return (TXRecordTable)this.getTable();
    }

    @Override
    public List<Identifier> getIDsByParentID(Identifier parentID) {
        ArrayList<Identifier> values = new ArrayList<Identifier>();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        Object t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTXRTable().getByParentIDsStatement());
            stmt.setString(1, parentID.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                values.add(BasicIdentifier.newID((String)rs.getString(1)));
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error getting TX records that have parent \"" + String.valueOf(parentID) + "\"", (Throwable)e);
        }
        return values;
    }

    @Override
    public List<V> getByParentID(Identifier parentID) {
        ArrayList<TXRecord> values = new ArrayList<TXRecord>();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        TXRecord t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTXRTable().getSearchByParentIDStatement());
            stmt.setString(1, parentID.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ColumnMap map = SQLTXRecordStore.rsToMap((ResultSet)rs);
                t = (TXRecord)this.create();
                this.populate(map, t);
                values.add(t);
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error getting TX records that have parent \"" + String.valueOf(parentID) + "\"", (Throwable)e);
        }
        return values;
    }

    @Override
    public int getCountByParent(Identifier parentID) {
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        int rowCount = 0;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTXRTable().getCountByParentIDStatement());
            stmt.setString(1, parentID.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            if (DebugUtil.isEnabled()) {
                DebugUtil.trace((Object)this, (String)"caught SQL exception", (Throwable)e);
            }
            this.destroyConnection(cr);
            throw new GeneralException("Error getting the number of tx records for a parent id", (Throwable)e);
        }
        catch (Throwable t) {
            if (DebugUtil.isEnabled()) {
                DebugUtil.trace((Object)this, (String)"caught exception", (Throwable)t);
            }
            throw t;
        }
        return rowCount;
    }

    public String getCreationTSField() {
        return ((TXRecordSerializationKeys)this.getMapConverter().getKeys()).issuedAt(new String[0]);
    }
}

