/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.tx;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class TXFileStore<V extends TXRecord>
extends FileStore<V>
implements TXStore<V> {
    public TXFileStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> identifiableProvider, MapConverter<V> converter, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter, removeEmptyFiles, removeFailedFiles);
    }

    public TXFileStore(File directory, IdentifiableProvider<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(directory, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public MapConverter<V> getMapConverter() {
        return this.converter;
    }

    @Override
    public List<V> getByParentID(Identifier parentID) {
        ArrayList<TXRecord> kids = new ArrayList<TXRecord>();
        for (TXRecord tx : this.values()) {
            if (!tx.parentID.equals(parentID)) continue;
            kids.add(tx);
        }
        return kids;
    }

    @Override
    public List<Identifier> getIDsByParentID(Identifier parentID) {
        ArrayList<Identifier> kids = new ArrayList<Identifier>();
        for (TXRecord tx : this.values()) {
            if (!tx.parentID.equals(parentID)) continue;
            kids.add(tx.getIdentifier());
        }
        return kids;
    }

    @Override
    public int getCountByParent(Identifier parentID) {
        return this.getByParentID(parentID).size();
    }

    public List<V> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

